/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.CombinatoricsUtils;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.bodies.CelestialBody;
import org.orekit.propagation.semianalytical.dsst.forces.FieldForceModelContext;
import org.orekit.propagation.semianalytical.dsst.utilities.CoefficientsFactory;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.UpperBounds;

class FieldDSSTThirdBodyContext<T extends RealFieldElement<T>>
extends FieldForceModelContext<T> {
    private static final int MAX_POWER = 22;
    private static final double BIG_TRUNCATION_TOLERANCE = 0.1;
    private static final double SMALL_TRUNCATION_TOLERANCE = 1.9E-6;
    private static final int MAX_ECCPOWER_SP = 4;
    private int maxAR3Pow;
    private int maxEccPow;
    private T[] aoR3Pow;
    private int maxEccPowShort;
    private int maxFreqF;
    private T[][] Qns;
    private final T gm;
    private T R3;
    private final T A;
    private final T alpha;
    private final T beta;
    private final T gamma;
    private final T BB;
    private final T BBB;
    private final T X;
    private final T XX;
    private final T XXX;
    private final T m2aoA;
    private final T BoA;
    private final T ooAB;
    private final T mCo2AB;
    private final T BoABpo;
    private final T muoR3;
    private final T b;
    private final T hXXX;
    private final T kXXX;
    private final T motion;

    FieldDSSTThirdBodyContext(FieldAuxiliaryElements<T> auxiliaryElements, CelestialBody thirdBody, T[] parameters) {
        super(auxiliaryElements);
        Field<T> field = auxiliaryElements.getDate().getField();
        RealFieldElement zero = (RealFieldElement)field.getZero();
        T mu = parameters[1];
        this.A = FastMath.sqrt((RealFieldElement)mu.multiply(auxiliaryElements.getSma()));
        this.gm = parameters[0];
        T absA = FastMath.abs(auxiliaryElements.getSma());
        this.motion = (RealFieldElement)FastMath.sqrt((RealFieldElement)mu.divide(absA)).divide(absA);
        FieldVector3D bodyPos = thirdBody.getPVCoordinates(auxiliaryElements.getDate(), auxiliaryElements.getFrame()).getPosition();
        this.R3 = bodyPos.getNorm();
        FieldVector3D<T> bodyDir = bodyPos.normalize();
        this.alpha = bodyDir.dotProduct(auxiliaryElements.getVectorF());
        this.beta = bodyDir.dotProduct(auxiliaryElements.getVectorG());
        this.gamma = bodyDir.dotProduct(auxiliaryElements.getVectorW());
        this.BB = (RealFieldElement)auxiliaryElements.getB().multiply(auxiliaryElements.getB());
        this.BBB = (RealFieldElement)this.BB.multiply(auxiliaryElements.getB());
        this.b = (RealFieldElement)((RealFieldElement)auxiliaryElements.getB().add(1.0)).reciprocal();
        this.X = (RealFieldElement)auxiliaryElements.getB().reciprocal();
        this.XX = (RealFieldElement)this.X.multiply(this.X);
        this.XXX = (RealFieldElement)this.X.multiply(this.XX);
        this.m2aoA = (RealFieldElement)((RealFieldElement)auxiliaryElements.getSma().multiply(-2.0)).divide(this.A);
        this.BoA = (RealFieldElement)auxiliaryElements.getB().divide(this.A);
        this.ooAB = (RealFieldElement)((RealFieldElement)this.A.multiply(auxiliaryElements.getB())).reciprocal();
        this.mCo2AB = (RealFieldElement)((RealFieldElement)((RealFieldElement)auxiliaryElements.getC().multiply(this.ooAB)).divide(2.0)).negate();
        this.BoABpo = (RealFieldElement)this.BoA.divide(auxiliaryElements.getB().add(1.0));
        this.muoR3 = (RealFieldElement)((RealFieldElement)this.R3.divide(this.gm)).reciprocal();
        this.hXXX = (RealFieldElement)this.XXX.multiply(auxiliaryElements.getH());
        this.kXXX = (RealFieldElement)this.XXX.multiply(auxiliaryElements.getK());
        RealFieldElement aoR3 = (RealFieldElement)auxiliaryElements.getSma().divide(this.R3);
        double tol = aoR3.getReal() > 0.3 || aoR3.getReal() > 0.15 && auxiliaryElements.getEcc().getReal() > 0.25 ? 0.1 : 1.9E-6;
        RealFieldElement eo2 = FastMath.max((RealFieldElement)zero.add(0.0025), (RealFieldElement)auxiliaryElements.getEcc().divide(2.0));
        RealFieldElement x2o2 = (RealFieldElement)this.XX.divide(2.0);
        RealFieldElement[] eccPwr = (RealFieldElement[])MathArrays.buildArray(field, 22);
        RealFieldElement[] chiPwr = (RealFieldElement[])MathArrays.buildArray(field, 22);
        eccPwr[0] = (RealFieldElement)zero.add(1.0);
        chiPwr[0] = this.X;
        for (int i = 1; i < 22; ++i) {
            eccPwr[i] = eccPwr[i - 1].multiply(eo2);
            chiPwr[i] = chiPwr[i - 1].multiply(x2o2);
        }
        RealFieldElement ao2rxx = (RealFieldElement)aoR3.divide(this.XX.multiply(2.0));
        RealFieldElement xmuarn = (RealFieldElement)((RealFieldElement)ao2rxx.multiply(ao2rxx).multiply(this.gm)).divide(this.X.multiply(this.R3));
        RealFieldElement term = zero;
        this.maxAR3Pow = 2;
        this.maxEccPow = 0;
        int n = 2;
        int m = 2;
        int nsmd2 = 0;
        do {
            if ((term = ((RealFieldElement)xmuarn.multiply(CombinatoricsUtils.factorialDouble(n + m) / (CombinatoricsUtils.factorialDouble(nsmd2) * CombinatoricsUtils.factorialDouble(nsmd2 + m)) * (CombinatoricsUtils.factorialDouble(n + m + 1) / (CombinatoricsUtils.factorialDouble(m) * CombinatoricsUtils.factorialDouble(n + 1))) * (CombinatoricsUtils.factorialDouble(n - m + 1) / CombinatoricsUtils.factorialDouble(n + 1)))).multiply(eccPwr[m]).multiply(UpperBounds.getDnl(this.XX, chiPwr[m], n + 2, m))).getReal() < tol) {
                if (m == 0) break;
                if (m < 2) {
                    xmuarn = xmuarn.multiply(ao2rxx);
                    m = 0;
                    ++n;
                    ++nsmd2;
                    continue;
                }
                m -= 2;
                ++nsmd2;
                continue;
            }
            this.maxAR3Pow = n++;
            this.maxEccPow = FastMath.max(m, this.maxEccPow);
            xmuarn = xmuarn.multiply(ao2rxx);
            ++m;
        } while (n < 22);
        this.maxEccPow = FastMath.min(this.maxAR3Pow, this.maxEccPow);
        this.aoR3Pow = (RealFieldElement[])MathArrays.buildArray(field, this.maxAR3Pow + 1);
        this.aoR3Pow[0] = (RealFieldElement)field.getOne();
        for (int i = 1; i <= this.maxAR3Pow; ++i) {
            this.aoR3Pow[i] = (RealFieldElement)aoR3.multiply(this.aoR3Pow[i - 1]);
        }
        this.maxFreqF = this.maxAR3Pow + 1;
        this.maxEccPowShort = 4;
        this.Qns = CoefficientsFactory.computeQns(this.gamma, (int)this.maxAR3Pow, (int)FastMath.max(this.maxEccPow, this.maxEccPowShort));
    }

    public T getA() {
        return this.A;
    }

    public T getAlpha() {
        return this.alpha;
    }

    public T getBeta() {
        return this.beta;
    }

    public T getGamma() {
        return this.gamma;
    }

    public T getBB() {
        return this.BB;
    }

    public T getBBB() {
        return this.BBB;
    }

    public T getb() {
        return this.b;
    }

    public T getX() {
        return this.X;
    }

    public T getM2aoA() {
        return this.m2aoA;
    }

    public T getBoA() {
        return this.BoA;
    }

    public T getOoAB() {
        return this.ooAB;
    }

    public T getMCo2AB() {
        return this.mCo2AB;
    }

    public T getBoABpo() {
        return this.BoABpo;
    }

    public T getMuoR3() {
        return this.muoR3;
    }

    public T getHXXX() {
        return this.hXXX;
    }

    public T getKXXX() {
        return this.kXXX;
    }

    public int getMaxAR3Pow() {
        return this.maxAR3Pow;
    }

    public int getMaxEccPow() {
        return this.maxEccPow;
    }

    public T[] getAoR3Pow() {
        return this.aoR3Pow;
    }

    public int getMaxFreqF() {
        return this.maxFreqF;
    }

    public T getMeanMotion() {
        return this.motion;
    }

    public T[][] getQns() {
        return this.Qns;
    }
}

