/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.hipparchus.RealFieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.propagation.semianalytical.dsst.forces.FieldForceModelContext;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;

class FieldDSSTZonalContext<T extends RealFieldElement<T>>
extends FieldForceModelContext<T> {
    private final T A;
    private T X;
    private T XX;
    private T XXX;
    private T ooAB;
    private T BoA;
    private T BoABpo;
    private T mCo2AB;
    private T m2aoA;
    private T muoa;
    private T roa;
    private final T n;
    private T hk;
    private T k2mh2;
    private T k2mh2o2;
    private T oon2a2;
    private T oon2a;
    private T x3on2a;
    private T xon2a2;
    private T cxo2n2a2;
    private T x2on2a2xp1;
    private T BB;

    FieldDSSTZonalContext(FieldAuxiliaryElements<T> auxiliaryElements, UnnormalizedSphericalHarmonicsProvider provider, T[] parameters) {
        super(auxiliaryElements);
        T mu = parameters[0];
        T absA = FastMath.abs(auxiliaryElements.getSma());
        this.n = (RealFieldElement)FastMath.sqrt((RealFieldElement)mu.divide(absA)).divide(absA);
        this.A = FastMath.sqrt((RealFieldElement)mu.multiply(auxiliaryElements.getSma()));
        this.X = (RealFieldElement)auxiliaryElements.getB().reciprocal();
        this.XX = (RealFieldElement)this.X.multiply(this.X);
        this.XXX = (RealFieldElement)this.X.multiply(this.XX);
        this.ooAB = (RealFieldElement)((RealFieldElement)this.A.multiply(auxiliaryElements.getB())).reciprocal();
        this.BoA = (RealFieldElement)auxiliaryElements.getB().divide(this.A);
        this.mCo2AB = (RealFieldElement)((RealFieldElement)((RealFieldElement)auxiliaryElements.getC().multiply(this.ooAB)).divide(2.0)).negate();
        this.BoABpo = (RealFieldElement)this.BoA.divide(auxiliaryElements.getB().add(1.0));
        this.m2aoA = (RealFieldElement)((RealFieldElement)((RealFieldElement)auxiliaryElements.getSma().divide(this.A)).multiply(2.0)).negate();
        this.muoa = (RealFieldElement)mu.divide(auxiliaryElements.getSma());
        this.roa = (RealFieldElement)((RealFieldElement)auxiliaryElements.getSma().divide(provider.getAe())).reciprocal();
        this.hk = (RealFieldElement)auxiliaryElements.getH().multiply(auxiliaryElements.getK());
        this.k2mh2 = (RealFieldElement)((RealFieldElement)auxiliaryElements.getK().multiply(auxiliaryElements.getK())).subtract(auxiliaryElements.getH().multiply(auxiliaryElements.getH()));
        this.k2mh2o2 = (RealFieldElement)this.k2mh2.divide(2.0);
        this.oon2a2 = (RealFieldElement)((RealFieldElement)this.A.multiply(this.n)).reciprocal();
        this.oon2a = (RealFieldElement)auxiliaryElements.getSma().multiply(this.oon2a2);
        this.x3on2a = (RealFieldElement)this.XXX.multiply(this.oon2a);
        this.xon2a2 = (RealFieldElement)this.X.multiply(this.oon2a2);
        this.cxo2n2a2 = (RealFieldElement)((RealFieldElement)this.xon2a2.multiply(auxiliaryElements.getC())).divide(2.0);
        this.x2on2a2xp1 = (RealFieldElement)((RealFieldElement)this.xon2a2.multiply(this.X)).divide(this.X.add(1.0));
        this.BB = (RealFieldElement)auxiliaryElements.getB().multiply(auxiliaryElements.getB());
    }

    public T getX() {
        return this.X;
    }

    public T getXX() {
        return this.XX;
    }

    public T getXXX() {
        return this.XXX;
    }

    public T getM2aoA() {
        return this.m2aoA;
    }

    public T getBoA() {
        return this.BoA;
    }

    public T getOoAB() {
        return this.ooAB;
    }

    public T getMCo2AB() {
        return this.mCo2AB;
    }

    public T getBoABpo() {
        return this.BoABpo;
    }

    public T getMuoa() {
        return this.muoa;
    }

    public T getRoa() {
        return this.roa;
    }

    public T getMeanMotion() {
        return this.n;
    }

    public T getHK() {
        return this.hk;
    }

    public T getK2MH2() {
        return this.k2mh2;
    }

    public T getK2MH2O2() {
        return this.k2mh2o2;
    }

    public T getOON2A2() {
        return this.oon2a2;
    }

    public T getX3ON2A() {
        return this.x3on2a;
    }

    public T getXON2A2() {
        return this.xon2a2;
    }

    public T getCXO2N2A2() {
        return this.cxo2n2a2;
    }

    public T getX2ON2A2XP1() {
        return this.x2on2a2xp1;
    }

    public T getBB() {
        return this.BB;
    }
}

