/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import java.util.Arrays;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.fraction.BigFraction;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.propagation.semianalytical.dsst.utilities.GammaMnsFunction;

public class FieldGammaMnsFunction<T extends RealFieldElement<T>> {
    private static double[] PRECOMPUTED_RATIOS;
    private final Field<T> field;
    private final double[] ratios;
    private final T[] values;
    private final T opIg;
    private final int I;

    public FieldGammaMnsFunction(int nMax, T gamma, int I, Field<T> field) {
        this.field = field;
        RealFieldElement zero = (RealFieldElement)field.getZero();
        int size = (nMax + 1) * (nMax + 2) * (4 * nMax + 3) / 6;
        this.values = (RealFieldElement[])MathArrays.buildArray(field, size);
        this.ratios = FieldGammaMnsFunction.getRatios(nMax, size);
        Arrays.fill(this.values, zero.add(Double.NaN));
        this.opIg = (RealFieldElement)((RealFieldElement)gamma.multiply((int)I)).add(1.0);
        this.I = I;
    }

    private static int index(int m, int n, int s) {
        return n * (n + 1) * (4 * n - 1) / 6 + m * (2 * n + 1) + s + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static double[] getRatios(int nMax, int size) {
        Class<GammaMnsFunction> clazz = GammaMnsFunction.class;
        synchronized (GammaMnsFunction.class) {
            if (PRECOMPUTED_RATIOS == null || PRECOMPUTED_RATIOS.length < size) {
                BigFraction[] bF = new BigFraction[size];
                for (int n = 0; n <= nMax; ++n) {
                    bF[FieldGammaMnsFunction.index((int)0, (int)n, (int)0)] = BigFraction.ONE;
                    for (int m = 1; m <= n; ++m) {
                        bF[FieldGammaMnsFunction.index((int)m, (int)n, (int)0)] = bF[FieldGammaMnsFunction.index(m - 1, n, 0)].multiply(n + m).divide(n - (m - 1));
                    }
                    for (int absS = 1; absS <= n; ++absS) {
                        for (int m = 0; m <= n; ++m) {
                            bF[FieldGammaMnsFunction.index((int)m, (int)n, (int)absS)] = bF[FieldGammaMnsFunction.index(m, n, absS - 1)].divide(n + absS).multiply(n - (absS - 1));
                            bF[FieldGammaMnsFunction.index((int)m, (int)n, (int)(-absS))] = bF[FieldGammaMnsFunction.index(m, n, absS)];
                        }
                    }
                }
                PRECOMPUTED_RATIOS = new double[size];
                for (int i = 0; i < bF.length; ++i) {
                    FieldGammaMnsFunction.PRECOMPUTED_RATIOS[i] = bF[i].doubleValue();
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return PRECOMPUTED_RATIOS;
        }
    }

    public T getValue(int m, int n, int s) {
        int i = FieldGammaMnsFunction.index(m, n, s);
        if (Double.isNaN(this.values[i].getReal())) {
            this.values[i] = s <= -m ? (RealFieldElement)FastMath.scalb(FastMath.pow(this.opIg, -this.I * m), s).multiply((int)((m - s & 1) == 0 ? 1 : -1)) : (s <= m ? (RealFieldElement)((RealFieldElement)FastMath.scalb(FastMath.pow(this.opIg, this.I * s), -m).multiply(this.ratios[i])).multiply((m - s & 1) == 0 ? 1 : -1) : FastMath.scalb(FastMath.pow(this.opIg, this.I * m), -s));
        }
        return this.values[i];
    }

    public T getDerivative(int m, int n, int s) {
        RealFieldElement zero;
        RealFieldElement res = zero = (RealFieldElement)this.field.getZero();
        res = s <= -m ? (RealFieldElement)((RealFieldElement)((RealFieldElement)this.getValue(m, n, s).multiply((int)this.I)).multiply(-m)).divide(this.opIg) : (s >= m ? (RealFieldElement)((RealFieldElement)((RealFieldElement)this.getValue(m, n, s).multiply((int)this.I)).multiply(m)).divide(this.opIg) : (RealFieldElement)((RealFieldElement)((RealFieldElement)this.getValue(m, n, s).multiply((int)this.I)).multiply(s)).divide(this.opIg));
        return (T)res;
    }
}

