/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldInterpolationGrid;

public class FieldMaxGapInterpolationGrid<T extends RealFieldElement<T>>
implements FieldInterpolationGrid<T> {
    private final T maxGap;
    private final Field<T> field;

    public FieldMaxGapInterpolationGrid(Field<T> field, T maxGap) {
        this.field = field;
        this.maxGap = maxGap;
    }

    @Override
    public T[] getGridPoints(T stepStart, T stepEnd) {
        int pointsPerStep = FastMath.max(2, (int)FastMath.ceil(FastMath.abs(stepEnd.getReal() - stepStart.getReal()) / this.maxGap.getReal()));
        RealFieldElement[] grid = (RealFieldElement[])MathArrays.buildArray(this.field, pointsPerStep);
        RealFieldElement stepSize = (RealFieldElement)((RealFieldElement)stepEnd.subtract(stepStart)).divide((double)pointsPerStep - 1.0);
        for (int i = 0; i < pointsPerStep; ++i) {
            grid[i] = (RealFieldElement)((RealFieldElement)stepSize.multiply(i)).add(stepStart);
        }
        return grid;
    }
}

