/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import org.hipparchus.util.FastMath;
import org.orekit.propagation.semianalytical.dsst.utilities.CjSjCoefficient;

public class GHmsjPolynomials {
    private final CjSjCoefficient cjsjKH;
    private final CjSjCoefficient cjsjAB;
    private int I;

    public GHmsjPolynomials(double k, double h, double alpha, double beta, int retroFactor) {
        this.cjsjKH = new CjSjCoefficient(k, h);
        this.cjsjAB = new CjSjCoefficient(alpha, beta);
        this.I = retroFactor;
    }

    public double getGmsj(int m, int s, int j) {
        int sMj = FastMath.abs(s - j);
        double gms = 0.0;
        if (FastMath.abs(s) <= m) {
            int mMis = m - this.I * s;
            gms = this.cjsjKH.getCj(sMj) * this.cjsjAB.getCj(mMis) - (double)(this.I * this.sgn(s - j)) * this.cjsjKH.getSj(sMj) * this.cjsjAB.getSj(mMis);
        } else {
            int sMim = FastMath.abs(s - this.I * m);
            gms = this.cjsjKH.getCj(sMj) * this.cjsjAB.getCj(sMim) + (double)(this.sgn(s - j) * this.sgn(s - m)) * this.cjsjKH.getSj(sMj) * this.cjsjAB.getSj(sMim);
        }
        return gms;
    }

    public double getHmsj(int m, int s, int j) {
        int sMj = FastMath.abs(s - j);
        double hms = 0.0;
        if (FastMath.abs(s) <= m) {
            int mMis = m - this.I * s;
            hms = (double)this.I * this.cjsjKH.getCj(sMj) * this.cjsjAB.getSj(mMis) + (double)this.sgn(s - j) * this.cjsjKH.getSj(sMj) * this.cjsjAB.getCj(mMis);
        } else {
            int sMim = FastMath.abs(s - this.I * m);
            hms = (double)(-this.sgn(s - m)) * this.cjsjKH.getCj(sMj) * this.cjsjAB.getSj(sMim) + (double)this.sgn(s - j) * this.cjsjKH.getSj(sMj) * this.cjsjAB.getCj(sMim);
        }
        return hms;
    }

    public double getdGmsdk(int m, int s, int j) {
        int sMj = FastMath.abs(s - j);
        double dGmsdk = 0.0;
        if (FastMath.abs(s) <= m) {
            int mMis = m - this.I * s;
            dGmsdk = this.cjsjKH.getDcjDk(sMj) * this.cjsjAB.getCj(mMis) - (double)(this.I * this.sgn(s - j)) * this.cjsjKH.getDsjDk(sMj) * this.cjsjAB.getSj(mMis);
        } else {
            int sMim = FastMath.abs(s - this.I * m);
            dGmsdk = this.cjsjKH.getDcjDk(sMj) * this.cjsjAB.getCj(sMim) + (double)(this.sgn(s - j) * this.sgn(s - m)) * this.cjsjKH.getDsjDk(sMj) * this.cjsjAB.getSj(sMim);
        }
        return dGmsdk;
    }

    public double getdGmsdh(int m, int s, int j) {
        int sMj = FastMath.abs(s - j);
        double dGmsdh = 0.0;
        if (FastMath.abs(s) <= m) {
            int mMis = m - this.I * s;
            dGmsdh = this.cjsjKH.getDcjDh(sMj) * this.cjsjAB.getCj(mMis) - (double)(this.I * this.sgn(s - j)) * this.cjsjKH.getDsjDh(sMj) * this.cjsjAB.getSj(mMis);
        } else {
            int sMim = FastMath.abs(s - this.I * m);
            dGmsdh = this.cjsjKH.getDcjDh(sMj) * this.cjsjAB.getCj(sMim) + (double)(this.sgn(s - j) * this.sgn(s - m)) * this.cjsjKH.getDsjDh(sMj) * this.cjsjAB.getSj(sMim);
        }
        return dGmsdh;
    }

    public double getdGmsdAlpha(int m, int s, int j) {
        int sMj = FastMath.abs(s - j);
        double dGmsdAl = 0.0;
        if (FastMath.abs(s) <= m) {
            int mMis = m - this.I * s;
            dGmsdAl = this.cjsjKH.getCj(sMj) * this.cjsjAB.getDcjDk(mMis) - (double)(this.I * this.sgn(s - j)) * this.cjsjKH.getSj(sMj) * this.cjsjAB.getDsjDk(mMis);
        } else {
            int sMim = FastMath.abs(s - this.I * m);
            dGmsdAl = this.cjsjKH.getCj(sMj) * this.cjsjAB.getDcjDk(sMim) + (double)(this.sgn(s - j) * this.sgn(s - m)) * this.cjsjKH.getSj(sMj) * this.cjsjAB.getDsjDk(sMim);
        }
        return dGmsdAl;
    }

    public double getdGmsdBeta(int m, int s, int j) {
        int sMj = FastMath.abs(s - j);
        double dGmsdBe = 0.0;
        if (FastMath.abs(s) <= m) {
            int mMis = m - this.I * s;
            dGmsdBe = this.cjsjKH.getCj(sMj) * this.cjsjAB.getDcjDh(mMis) - (double)(this.I * this.sgn(s - j)) * this.cjsjKH.getSj(sMj) * this.cjsjAB.getDsjDh(mMis);
        } else {
            int sMim = FastMath.abs(s - this.I * m);
            dGmsdBe = this.cjsjKH.getCj(sMj) * this.cjsjAB.getDcjDh(sMim) + (double)(this.sgn(s - j) * this.sgn(s - m)) * this.cjsjKH.getSj(sMj) * this.cjsjAB.getDsjDh(sMim);
        }
        return dGmsdBe;
    }

    public double getdHmsdk(int m, int s, int j) {
        int sMj = FastMath.abs(s - j);
        double dHmsdk = 0.0;
        if (FastMath.abs(s) <= m) {
            int mMis = m - this.I * s;
            dHmsdk = (double)this.I * this.cjsjKH.getDcjDk(sMj) * this.cjsjAB.getSj(mMis) + (double)this.sgn(s - j) * this.cjsjKH.getDsjDk(sMj) * this.cjsjAB.getCj(mMis);
        } else {
            int sMim = FastMath.abs(s - this.I * m);
            dHmsdk = (double)(-this.sgn(s - m)) * this.cjsjKH.getDcjDk(sMj) * this.cjsjAB.getSj(sMim) + (double)this.sgn(s - j) * this.cjsjKH.getDsjDk(sMj) * this.cjsjAB.getCj(sMim);
        }
        return dHmsdk;
    }

    public double getdHmsdh(int m, int s, int j) {
        int sMj = FastMath.abs(s - j);
        double dHmsdh = 0.0;
        if (FastMath.abs(s) <= m) {
            int mMis = m - this.I * s;
            dHmsdh = (double)this.I * this.cjsjKH.getDcjDh(sMj) * this.cjsjAB.getSj(mMis) + (double)this.sgn(s - j) * this.cjsjKH.getDsjDh(sMj) * this.cjsjAB.getCj(mMis);
        } else {
            int sMim = FastMath.abs(s - this.I * m);
            dHmsdh = (double)(-this.sgn(s - m)) * this.cjsjKH.getDcjDh(sMj) * this.cjsjAB.getSj(sMim) + (double)this.sgn(s - j) * this.cjsjKH.getDsjDh(sMj) * this.cjsjAB.getCj(sMim);
        }
        return dHmsdh;
    }

    public double getdHmsdAlpha(int m, int s, int j) {
        int sMj = FastMath.abs(s - j);
        double dHmsdAl = 0.0;
        if (FastMath.abs(s) <= m) {
            int mMis = m - this.I * s;
            dHmsdAl = (double)this.I * this.cjsjKH.getCj(sMj) * this.cjsjAB.getDsjDk(mMis) + (double)this.sgn(s - j) * this.cjsjKH.getSj(sMj) * this.cjsjAB.getDcjDk(mMis);
        } else {
            int sMim = FastMath.abs(s - this.I * m);
            dHmsdAl = (double)(-this.sgn(s - m)) * this.cjsjKH.getCj(sMj) * this.cjsjAB.getDsjDk(sMim) + (double)this.sgn(s - j) * this.cjsjKH.getSj(sMj) * this.cjsjAB.getDcjDk(sMim);
        }
        return dHmsdAl;
    }

    public double getdHmsdBeta(int m, int s, int j) {
        int sMj = FastMath.abs(s - j);
        double dHmsdBe = 0.0;
        if (FastMath.abs(s) <= m) {
            int mMis = m - this.I * s;
            dHmsdBe = (double)this.I * this.cjsjKH.getCj(sMj) * this.cjsjAB.getDsjDh(mMis) + (double)this.sgn(s - j) * this.cjsjKH.getSj(sMj) * this.cjsjAB.getDcjDh(mMis);
        } else {
            int sMim = FastMath.abs(s - this.I * m);
            dHmsdBe = (double)(-this.sgn(s - m)) * this.cjsjKH.getCj(sMj) * this.cjsjAB.getDsjDh(sMim) + (double)this.sgn(s - j) * this.cjsjKH.getSj(sMj) * this.cjsjAB.getDcjDh(sMim);
        }
        return dHmsdBe;
    }

    private int sgn(int i) {
        return i < 0 ? -1 : 1;
    }
}

