/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.EOPEntry;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.time.TimeStamped;
import org.orekit.time.UT1Scale;
import org.orekit.utils.IERSConventions;

public class GNSSDate
implements Serializable,
TimeStamped {
    private static final long serialVersionUID = 201902141L;
    private static final int WEEK_D = 7;
    private static final double WEEK_S = 604800.0;
    private static final double S_TO_MS = 1000.0;
    private static AtomicReference<DateComponents> rolloverReference = new AtomicReference<Object>(null);
    private final int weekNumber;
    private final double milliInWeek;
    private final SatelliteSystem system;
    private final transient AbsoluteDate date;

    public GNSSDate(int weekNumber, double milliInWeek, SatelliteSystem system) {
        int day = (int)FastMath.floor(milliInWeek / 8.64E7);
        double secondsInDay = milliInWeek / 1000.0 - (double)day * 86400.0;
        int w = weekNumber;
        DateComponents dc = new DateComponents(this.getWeekReferenceDateComponents(system), weekNumber * 7 + day);
        int cycleW = GNSSDateType.getRollOverWeek(system);
        if (weekNumber < cycleW) {
            DateComponents reference = rolloverReference.get();
            if (reference == null) {
                UT1Scale ut1 = TimeScalesFactory.getUT1(IERSConventions.IERS_2010, true);
                List<EOPEntry> eop = ut1.getEOPHistory().getEntries();
                int lastMJD = eop.get(eop.size() - 1).getMjd();
                reference = new DateComponents(DateComponents.MODIFIED_JULIAN_EPOCH, lastMJD);
                rolloverReference.compareAndSet(null, reference);
            }
            int cycleD = 7 * cycleW;
            while (dc.getJ2000Day() < reference.getJ2000Day() - cycleD / 2) {
                dc = new DateComponents(dc, cycleD);
                w += cycleW;
            }
        }
        this.weekNumber = w;
        this.milliInWeek = milliInWeek;
        this.system = system;
        this.date = new AbsoluteDate(dc, new TimeComponents(secondsInDay), this.getTimeScale(system));
    }

    public GNSSDate(AbsoluteDate date, SatelliteSystem system) {
        this.system = system;
        AbsoluteDate epoch = this.getWeekReferenceAbsoluteDate(system);
        this.weekNumber = (int)FastMath.floor(date.durationFrom(epoch) / 604800.0);
        AbsoluteDate weekStart = new AbsoluteDate(epoch, 604800.0 * (double)this.weekNumber);
        this.milliInWeek = date.durationFrom(weekStart) * 1000.0;
        this.date = date;
    }

    public static void setRolloverReference(DateComponents reference) {
        rolloverReference.set(reference);
    }

    public static DateComponents getRolloverReference() {
        return rolloverReference.get();
    }

    public int getWeekNumber() {
        return this.weekNumber;
    }

    public double getMilliInWeek() {
        return this.milliInWeek;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.date;
    }

    private TimeScale getTimeScale(SatelliteSystem satellite) {
        switch (satellite) {
            case GPS: {
                return TimeScalesFactory.getGPS();
            }
            case GALILEO: {
                return TimeScalesFactory.getGST();
            }
            case QZSS: {
                return TimeScalesFactory.getQZSS();
            }
            case BEIDOU: {
                return TimeScalesFactory.getBDT();
            }
        }
        throw new OrekitException((Localizable)OrekitMessages.INVALID_SATELLITE_SYSTEM, new Object[]{satellite});
    }

    private AbsoluteDate getWeekReferenceAbsoluteDate(SatelliteSystem satellite) {
        switch (satellite) {
            case GPS: {
                return AbsoluteDate.GPS_EPOCH;
            }
            case GALILEO: {
                return AbsoluteDate.GALILEO_EPOCH;
            }
            case QZSS: {
                return AbsoluteDate.QZSS_EPOCH;
            }
            case BEIDOU: {
                return AbsoluteDate.BEIDOU_EPOCH;
            }
        }
        throw new OrekitException((Localizable)OrekitMessages.INVALID_SATELLITE_SYSTEM, new Object[]{satellite});
    }

    private DateComponents getWeekReferenceDateComponents(SatelliteSystem satellite) {
        switch (satellite) {
            case GPS: {
                return DateComponents.GPS_EPOCH;
            }
            case GALILEO: {
                return DateComponents.GALILEO_EPOCH;
            }
            case QZSS: {
                return DateComponents.QZSS_EPOCH;
            }
            case BEIDOU: {
                return DateComponents.BEIDOU_EPOCH;
            }
        }
        throw new OrekitException((Localizable)OrekitMessages.INVALID_SATELLITE_SYSTEM, new Object[]{satellite});
    }

    private Object writeReplace() {
        return new DataTransferObject(this.weekNumber, this.milliInWeek, this.system);
    }

    private static enum GNSSDateType {
        GPS(SatelliteSystem.GPS, 1024),
        GALILEO(SatelliteSystem.GALILEO, 4096),
        QZSS(SatelliteSystem.QZSS, 1024),
        BEIDOU(SatelliteSystem.BEIDOU, 8192);

        private static final Map<SatelliteSystem, Integer> CYCLE_MAP;
        private final int numberOfWeek;
        private final SatelliteSystem satelliteSystem;

        private GNSSDateType(SatelliteSystem system, int rollover) {
            this.satelliteSystem = system;
            this.numberOfWeek = rollover;
        }

        private int getRollOverCycle() {
            return this.numberOfWeek;
        }

        private SatelliteSystem getSatelliteSystem() {
            return this.satelliteSystem;
        }

        private static int getRollOverWeek(SatelliteSystem satellite) {
            return CYCLE_MAP.get((Object)satellite);
        }

        static {
            CYCLE_MAP = new HashMap<SatelliteSystem, Integer>();
            for (GNSSDateType type : GNSSDateType.values()) {
                int val = type.getRollOverCycle();
                SatelliteSystem satellite = type.getSatelliteSystem();
                CYCLE_MAP.put(satellite, val);
            }
        }
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 201902141L;
        private final int weekNumber;
        private final double milliInWeek;
        private final SatelliteSystem system;

        DataTransferObject(int weekNumber, double milliInWeek, SatelliteSystem system) {
            this.weekNumber = weekNumber;
            this.milliInWeek = milliInWeek;
            this.system = system;
        }

        private Object readResolve() {
            return new GNSSDate(this.weekNumber, this.milliInWeek, this.system);
        }
    }
}

