/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import org.hipparchus.RealFieldElement;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TDBScale;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;

public class TCBScale
implements TimeScale {
    private static final long serialVersionUID = 20131209L;
    private static final double LB_RATE = 1.550519768E-8;
    private static final AbsoluteDate REFERENCE_DATE = new AbsoluteDate(1977, 1, 1, (TimeScale)TimeScalesFactory.getTAI());
    private final TDBScale tdb;

    TCBScale(TDBScale tdb) {
        this.tdb = tdb;
    }

    @Override
    public double offsetFromTAI(AbsoluteDate date) {
        return this.tdb.offsetFromTAI(date) + 1.550519768E-8 * date.durationFrom(REFERENCE_DATE);
    }

    @Override
    public <T extends RealFieldElement<T>> T offsetFromTAI(FieldAbsoluteDate<T> date) {
        return (T)((RealFieldElement)this.tdb.offsetFromTAI(date).add(date.durationFrom(REFERENCE_DATE).multiply(1.550519768E-8)));
    }

    @Override
    public String getName() {
        return "TCB";
    }

    public String toString() {
        return this.getName();
    }
}

