/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.io.Serializable;
import org.hipparchus.RealFieldElement;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.time.TimeStamped;

class UTCTAIOffset
implements TimeStamped,
Serializable {
    private static final long serialVersionUID = 4742190573136348054L;
    private final AbsoluteDate leapDate;
    private final int leapDateMJD;
    private final AbsoluteDate validityStart;
    private final int mjdRef;
    private final AbsoluteDate reference;
    private final double leap;
    private final double offset;
    private final double slopeUTC;
    private final double slopeTAI;

    UTCTAIOffset(AbsoluteDate leapDate, int leapDateMJD, double leap, double offset) {
        this(leapDate, leapDateMJD, leap, offset, 0, 0.0);
    }

    UTCTAIOffset(AbsoluteDate leapDate, int leapDateMJD, double leap, double offset, int mjdRef, double slope) {
        this.leapDate = leapDate;
        this.leapDateMJD = leapDateMJD;
        this.validityStart = leapDate.shiftedBy(leap);
        this.mjdRef = mjdRef;
        this.reference = new AbsoluteDate(new DateComponents(DateComponents.MODIFIED_JULIAN_EPOCH, mjdRef), (TimeScale)TimeScalesFactory.getTAI()).shiftedBy(offset);
        this.leap = leap;
        this.offset = offset;
        this.slopeUTC = slope;
        this.slopeTAI = slope / (1.0 + slope);
    }

    @Override
    public AbsoluteDate getDate() {
        return this.leapDate;
    }

    public int getMJD() {
        return this.leapDateMJD;
    }

    public AbsoluteDate getValidityStart() {
        return this.validityStart;
    }

    public double getLeap() {
        return this.leap;
    }

    public double getOffset(AbsoluteDate date) {
        if (this.slopeTAI == 0.0) {
            return this.offset;
        }
        return this.offset + date.durationFrom(this.reference) * this.slopeTAI;
    }

    public <T extends RealFieldElement<T>> T getOffset(FieldAbsoluteDate<T> date) {
        if (this.slopeTAI == 0.0) {
            return (T)((RealFieldElement)((RealFieldElement)date.getField().getZero()).add(this.offset));
        }
        return (T)((RealFieldElement)((RealFieldElement)date.durationFrom(this.reference).multiply(this.slopeTAI)).add(this.offset));
    }

    public double getOffset(DateComponents date, TimeComponents time) {
        int days = date.getMJD() - this.mjdRef;
        double fraction = time.getSecondsInUTCDay();
        return this.offset + (double)days * (this.slopeUTC * 86400.0) + fraction * this.slopeUTC;
    }
}

