/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import org.hipparchus.util.MathUtils;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;

public class ElevationMask
implements Serializable {
    private static final long serialVersionUID = 20131118L;
    private final double[][] azelmask;

    public ElevationMask(double[][] mask) {
        this.azelmask = ElevationMask.checkMask(mask);
    }

    public double getElevation(double azimuth) {
        double elevation = 0.0;
        boolean fin = false;
        int i = 1;
        while (i < this.azelmask.length & !fin) {
            if (azimuth <= this.azelmask[i][0]) {
                fin = true;
                double azd = this.azelmask[i - 1][0];
                double azf = this.azelmask[i][0];
                double eld = this.azelmask[i - 1][1];
                double elf = this.azelmask[i][1];
                elevation = eld + (azimuth - azd) * (elf - eld) / (azf - azd);
            }
            ++i;
        }
        return elevation;
    }

    private static double[][] checkMask(double[][] azimelev) {
        int i;
        double[][] mask = new double[azimelev.length + 2][azimelev[0].length];
        for (i = 0; i < azimelev.length; ++i) {
            System.arraycopy(azimelev[i], 0, mask[i + 1], 0, azimelev[i].length);
            mask[i + 1][0] = MathUtils.normalizeAngle(mask[i + 1][0], Math.PI);
        }
        Arrays.sort(mask, 1, mask.length - 1, new Comparator<double[]>(){

            @Override
            public int compare(double[] d1, double[] d2) {
                return Double.compare(d1[0], d2[0]);
            }
        });
        mask[0][0] = mask[mask.length - 2][0] - Math.PI * 2;
        mask[0][1] = mask[mask.length - 2][1];
        mask[mask.length - 1][0] = mask[1][0] + Math.PI * 2;
        mask[mask.length - 1][1] = mask[1][1];
        for (i = 1; i < mask.length; ++i) {
            if (Double.compare(mask[i - 1][0], mask[i][0]) != 0 || Double.compare(mask[i - 1][1], mask[i][1]) == 0) continue;
            throw new OrekitIllegalArgumentException(OrekitMessages.UNEXPECTED_TWO_ELEVATION_VALUES_FOR_ONE_AZIMUTH, mask[i - 1][1], mask[i][1], mask[i][0]);
        }
        return mask;
    }
}

