/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.stream.Stream;
import org.hipparchus.FieldElement;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.analysis.interpolation.FieldHermiteInterpolator;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeInterpolable;
import org.orekit.time.FieldTimeStamped;
import org.orekit.utils.AbsolutePVCoordinates;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldAbsolutePVCoordinates<T extends RealFieldElement<T>>
extends TimeStampedFieldPVCoordinates<T>
implements FieldTimeStamped<T>,
FieldTimeInterpolable<FieldAbsolutePVCoordinates<T>, T>,
FieldPVCoordinatesProvider<T> {
    private final Frame frame;

    public FieldAbsolutePVCoordinates(Frame frame, FieldAbsoluteDate<T> date, FieldVector3D<T> position, FieldVector3D<T> velocity, FieldVector3D<T> acceleration) {
        super(date, position, velocity, acceleration);
        this.frame = frame;
    }

    public FieldAbsolutePVCoordinates(Frame frame, FieldAbsoluteDate<T> date, FieldVector3D<T> position, FieldVector3D<T> velocity) {
        this(frame, date, position, velocity, FieldVector3D.getZero(date.getField()));
    }

    public FieldAbsolutePVCoordinates(Frame frame, FieldAbsoluteDate<T> date, FieldPVCoordinates<T> pva) {
        super(date, pva);
        this.frame = frame;
    }

    public FieldAbsolutePVCoordinates(Frame frame, TimeStampedFieldPVCoordinates<T> pva) {
        super(pva.getDate(), pva);
        this.frame = frame;
    }

    public FieldAbsolutePVCoordinates(FieldAbsoluteDate<T> date, T a, FieldAbsolutePVCoordinates<T> AbsPva) {
        super(date, a, AbsPva);
        this.frame = AbsPva.frame;
    }

    public FieldAbsolutePVCoordinates(FieldAbsoluteDate<T> date, FieldAbsolutePVCoordinates<T> start, FieldAbsolutePVCoordinates<T> end) {
        super(date, start, end);
        FieldAbsolutePVCoordinates.ensureIdenticalFrames(start, end);
        this.frame = start.frame;
    }

    public FieldAbsolutePVCoordinates(FieldAbsoluteDate<T> date, T a1, FieldAbsolutePVCoordinates<T> absPv1, T a2, FieldAbsolutePVCoordinates<T> absPv2) {
        super(date, a1, absPv1.getPVCoordinates(), a2, absPv2.getPVCoordinates());
        FieldAbsolutePVCoordinates.ensureIdenticalFrames(absPv1, absPv2);
        this.frame = absPv1.getFrame();
    }

    public FieldAbsolutePVCoordinates(FieldAbsoluteDate<T> date, T a1, FieldAbsolutePVCoordinates<T> absPv1, T a2, FieldAbsolutePVCoordinates<T> absPv2, T a3, FieldAbsolutePVCoordinates<T> absPv3) {
        super(date, a1, absPv1.getPVCoordinates(), a2, absPv2.getPVCoordinates(), a3, absPv3.getPVCoordinates());
        FieldAbsolutePVCoordinates.ensureIdenticalFrames(absPv1, absPv2);
        FieldAbsolutePVCoordinates.ensureIdenticalFrames(absPv1, absPv3);
        this.frame = absPv1.getFrame();
    }

    public FieldAbsolutePVCoordinates(FieldAbsoluteDate<T> date, T a1, FieldAbsolutePVCoordinates<T> absPv1, T a2, FieldAbsolutePVCoordinates<T> absPv2, T a3, FieldAbsolutePVCoordinates<T> absPv3, T a4, FieldAbsolutePVCoordinates<T> absPv4) {
        super(date, a1, absPv1.getPVCoordinates(), a2, absPv2.getPVCoordinates(), a3, absPv3.getPVCoordinates(), a4, absPv4.getPVCoordinates());
        FieldAbsolutePVCoordinates.ensureIdenticalFrames(absPv1, absPv2);
        FieldAbsolutePVCoordinates.ensureIdenticalFrames(absPv1, absPv3);
        FieldAbsolutePVCoordinates.ensureIdenticalFrames(absPv1, absPv4);
        this.frame = absPv1.getFrame();
    }

    public FieldAbsolutePVCoordinates(Frame frame, FieldAbsoluteDate<T> date, FieldVector3D<FieldDerivativeStructure<T>> p) {
        super(date, p);
        this.frame = frame;
    }

    private static <T extends RealFieldElement<T>> void ensureIdenticalFrames(FieldAbsolutePVCoordinates<T> absPv1, FieldAbsolutePVCoordinates<T> absPv2) throws OrekitIllegalArgumentException {
        if (!absPv1.frame.equals(absPv2.frame)) {
            throw new OrekitIllegalArgumentException(OrekitMessages.INCOMPATIBLE_FRAMES, absPv1.frame.getName(), absPv2.frame.getName());
        }
    }

    @Override
    public FieldAbsolutePVCoordinates<T> shiftedBy(T dt) {
        FieldPVCoordinates spv = super.shiftedBy((RealFieldElement)dt);
        return new FieldAbsolutePVCoordinates<T>(this.frame, spv);
    }

    @Override
    public FieldAbsolutePVCoordinates<T> shiftedBy(double dt) {
        FieldPVCoordinates spv = super.shiftedBy(dt);
        return new FieldAbsolutePVCoordinates<T>(this.frame, spv);
    }

    public FieldPVCoordinatesProvider<T> toTaylorProvider() {
        return new FieldPVCoordinatesProvider<T>(){

            @Override
            public TimeStampedFieldPVCoordinates<T> getPVCoordinates(FieldAbsoluteDate<T> d, Frame f) {
                TimeStampedFieldPVCoordinates shifted = FieldAbsolutePVCoordinates.this.shiftedBy((RealFieldElement)d.durationFrom(FieldAbsolutePVCoordinates.this.getDate()));
                FieldTransform transform = FieldAbsolutePVCoordinates.this.frame.getTransformTo(f, d);
                return transform.transformPVCoordinates(shifted);
            }
        };
    }

    public Frame getFrame() {
        return this.frame;
    }

    public TimeStampedFieldPVCoordinates<T> getPVCoordinates() {
        return this;
    }

    public TimeStampedFieldPVCoordinates<T> getPVCoordinates(Frame outputFrame) {
        if (outputFrame == this.frame) {
            return this.getPVCoordinates();
        }
        FieldTransform<T> t = this.frame.getTransformTo(outputFrame, this.getDate());
        return t.transformPVCoordinates(this.getPVCoordinates());
    }

    @Override
    public TimeStampedFieldPVCoordinates<T> getPVCoordinates(FieldAbsoluteDate<T> otherDate, Frame outputFrame) {
        return ((FieldAbsolutePVCoordinates)this.shiftedBy((RealFieldElement)otherDate.durationFrom(this.getDate()))).getPVCoordinates(outputFrame);
    }

    @Override
    public FieldAbsolutePVCoordinates<T> interpolate(FieldAbsoluteDate<T> date, Stream<FieldAbsolutePVCoordinates<T>> sample) {
        return FieldAbsolutePVCoordinates.interpolate(this.getFrame(), date, CartesianDerivativesFilter.USE_PVA, sample);
    }

    public static <T extends RealFieldElement<T>> FieldAbsolutePVCoordinates<T> interpolate(Frame frame, FieldAbsoluteDate<T> date, CartesianDerivativesFilter filter, Stream<FieldAbsolutePVCoordinates<T>> sample) {
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        switch (filter) {
            case USE_P: {
                sample.forEach(pv -> {
                    FieldVector3D position = pv.getPosition();
                    interpolator.addSamplePoint((FieldElement)pv.getDate().durationFrom(date), new RealFieldElement[][]{position.toArray()});
                });
                break;
            }
            case USE_PV: {
                sample.forEach(pv -> {
                    FieldVector3D position = pv.getPosition();
                    FieldVector3D velocity = pv.getVelocity();
                    interpolator.addSamplePoint((FieldElement)pv.getDate().durationFrom(date), new RealFieldElement[][]{position.toArray(), velocity.toArray()});
                });
                break;
            }
            case USE_PVA: {
                sample.forEach(pv -> {
                    FieldVector3D position = pv.getPosition();
                    FieldVector3D velocity = pv.getVelocity();
                    FieldVector3D acceleration = pv.getAcceleration();
                    interpolator.addSamplePoint((FieldElement)pv.getDate().durationFrom(date), new RealFieldElement[][]{position.toArray(), velocity.toArray(), acceleration.toArray()});
                });
                break;
            }
            default: {
                throw new OrekitInternalError(null);
            }
        }
        RealFieldElement[][] p = (RealFieldElement[][])interpolator.derivatives((FieldElement)date.getField().getZero(), 2);
        return new FieldAbsolutePVCoordinates<T>(frame, date, new FieldVector3D(p[0]), new FieldVector3D(p[1]), new FieldVector3D(p[2]));
    }

    public AbsolutePVCoordinates toAbsolutePVCoordinates() {
        return new AbsolutePVCoordinates(this.frame, this.getDate().toAbsoluteDate(), this.getPVCoordinates().toPVCoordinates());
    }
}

