/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import org.orekit.data.DataLoader;

public class InterpolationTableLoader
implements DataLoader {
    private double[] xArr;
    private double[] yArr;
    private double[][] fArr;

    public double[] getAbscissaGrid() {
        return (double[])this.xArr.clone();
    }

    public double[] getOrdinateGrid() {
        return (double[])this.yArr.clone();
    }

    public double[][] getValuesSamples() {
        return (double[][])this.fArr.clone();
    }

    @Override
    public boolean stillAcceptsData() {
        return this.xArr == null;
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException {
        LinkedList<Double> xValues = new LinkedList<Double>();
        LinkedList<Double> yValues = new LinkedList<Double>();
        LinkedList cellValues = new LinkedList();
        StreamTokenizer tokenizer = new StreamTokenizer(new BufferedReader(new InputStreamReader(input, "UTF-8")));
        tokenizer.commentChar(35);
        tokenizer.eolIsSignificant(true);
        int tokenCount = 0;
        boolean headerRow = false;
        boolean done = false;
        do {
            switch (tokenizer.nextToken()) {
                case -1: {
                    done = true;
                    break;
                }
                case 10: {
                    if (yValues.size() > 0) {
                        headerRow = false;
                    }
                    tokenCount = 0;
                    break;
                }
                case -2: {
                    if (headerRow) {
                        yValues.add(tokenizer.nval);
                    } else if (tokenCount == 0) {
                        xValues.add(tokenizer.nval);
                        cellValues.add(new LinkedList());
                    } else {
                        ((List)cellValues.getLast()).add(tokenizer.nval);
                    }
                    ++tokenCount;
                    break;
                }
                case -3: {
                    if (!tokenizer.sval.startsWith("Table")) break;
                    headerRow = true;
                    break;
                }
            }
        } while (!done);
        this.xArr = this.toPrimitiveArray(xValues);
        this.yArr = this.toPrimitiveArray(yValues);
        this.fArr = new double[cellValues.size()][];
        int idx = 0;
        for (List list : cellValues) {
            this.fArr[idx++] = this.toPrimitiveArray(list);
        }
    }

    private double[] toPrimitiveArray(List<Double> list) {
        double[] result = new double[list.size()];
        int idx = 0;
        for (Double element : list) {
            result[idx++] = element;
        }
        return result;
    }
}

