/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterObserver;

public class ParameterDriver {
    private String name;
    private double referenceValue;
    private double scale;
    private double minValue;
    private double maxValue;
    private AbsoluteDate referenceDate;
    private double value;
    private boolean selected;
    private final List<ParameterObserver> observers;

    public ParameterDriver(String name, double referenceValue, double scale, double minValue, double maxValue) {
        if (FastMath.abs(scale) <= Precision.SAFE_MIN) {
            throw new OrekitException((Localizable)OrekitMessages.TOO_SMALL_SCALE_FOR_PARAMETER, name, scale);
        }
        this.name = name;
        this.referenceValue = referenceValue;
        this.scale = scale;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.referenceDate = null;
        this.value = referenceValue;
        this.selected = false;
        this.observers = new ArrayList<ParameterObserver>();
    }

    public void addObserver(ParameterObserver observer) {
        this.observers.add(observer);
        observer.valueChanged(this.getValue(), this);
    }

    public void removeObserver(ParameterObserver observer) {
        Iterator<ParameterObserver> iterator = this.observers.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != observer) continue;
            iterator.remove();
            return;
        }
    }

    public List<ParameterObserver> getObservers() {
        return Collections.unmodifiableList(this.observers);
    }

    public void setName(String name) {
        String previousName = this.name;
        this.name = name;
        for (ParameterObserver observer : this.observers) {
            observer.nameChanged(previousName, this);
        }
    }

    public String getName() {
        return this.name;
    }

    public double getReferenceValue() {
        return this.referenceValue;
    }

    public void setReferenceValue(double referenceValue) {
        double previousReferenceValue = this.referenceValue;
        this.referenceValue = referenceValue;
        for (ParameterObserver observer : this.observers) {
            observer.referenceValueChanged(previousReferenceValue, this);
        }
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        double previousMinValue = this.minValue;
        this.minValue = minValue;
        for (ParameterObserver observer : this.observers) {
            observer.minValueChanged(previousMinValue, this);
        }
        this.setValue(this.value);
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        double previousMaxValue = this.maxValue;
        this.maxValue = maxValue;
        for (ParameterObserver observer : this.observers) {
            observer.maxValueChanged(previousMaxValue, this);
        }
        this.setValue(this.value);
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        double previousScale = this.scale;
        this.scale = scale;
        for (ParameterObserver observer : this.observers) {
            observer.scaleChanged(previousScale, this);
        }
    }

    public double getNormalizedValue() {
        return (this.value - this.referenceValue) / this.scale;
    }

    public void setNormalizedValue(double normalized) {
        this.setValue(this.referenceValue + this.scale * normalized);
    }

    public AbsoluteDate getReferenceDate() {
        return this.referenceDate;
    }

    public void setReferenceDate(AbsoluteDate newReferenceDate) {
        AbsoluteDate previousReferenceDate = this.getReferenceDate();
        this.referenceDate = newReferenceDate;
        for (ParameterObserver observer : this.observers) {
            observer.referenceDateChanged(previousReferenceDate, this);
        }
    }

    public double getValue() {
        return this.value;
    }

    public DerivativeStructure getValue(DSFactory factory, Map<String, Integer> indices) {
        Integer index = indices.get(this.name);
        return index == null ? factory.constant(this.value) : factory.variable(index, this.value);
    }

    public void setValue(double newValue) {
        double previousValue = this.getValue();
        this.value = FastMath.max(this.minValue, FastMath.min(this.maxValue, newValue));
        for (ParameterObserver observer : this.observers) {
            observer.valueChanged(previousValue, this);
        }
    }

    public void setSelected(boolean selected) {
        boolean previousSelection = this.isSelected();
        this.selected = selected;
        for (ParameterObserver observer : this.observers) {
            observer.selectionChanged(previousSelection, this);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public String toString() {
        return this.name + " = " + this.value;
    }
}

