"""
This type stub file was generated by pyright.
"""

from typing import Any, Callable, Tuple, TypeAlias, TypeVar

from numpy import NDArray

__all__ = ["CaChannelException", "CaChannel"]
T = TypeVar("T")

class CaChannelException(Exception):
    def __init__(self, status) -> None: ...
    def __int__(self) -> int: ...
    def __str__(self) -> str: ...

PVBaseValue: TypeAlias = bool | int | float | str
PVValue: TypeAlias = PVBaseValue | list[PVBaseValue] | NDArray | None

class CaChannel:
    """CaChannel: A Python class with identical API as of caPython/CaChannel.

    This class implements the methods to operate on channel access so that you can find
    their  C library counterparts ,
    http://www.aps.anl.gov/epics/base/R3-14/12-docs/CAref.html#Function.
    Therefore an understanding of C API helps much.

    To get started easily, convenient methods are created for often used operations,

    ==========    ======
    Operation     Method
    ==========    ======
    connect       :meth:`searchw`
    read          :meth:`getw`
    write         :meth:`putw`
    ==========    ======

    They have shorter names and default arguments. It is recommended to start with these methods.
    Study the other C alike methods when necessary.

    >>> chan = CaChannel('catest')
    >>> chan.searchw()
    >>> chan.putw(12.5)
    >>> chan.getw()
    12.5
    >>> chan.searchw('cabo')
    >>> chan.putw('Done')
    >>> chan.getw(ca.DBR_STRING)
    'Done'
    """

    __context = ...
    __callbacks = ...
    __context_lock = ...
    __context_dict = ...
    ca_timeout = ...
    last_value: PVValue = ...
    @staticmethod
    def get_thread_id(thread) -> str:  # -> str:
        ...
    @staticmethod
    def create_context(): ...
    def attach_ca_context(func):  # -> _Wrapped[Callable[..., Any], Any, Callable[..., Any], Any]:
        ...
    def __init__(self, pvName=...) -> None: ...
    def __del__(self) -> None: ...
    @staticmethod
    def version(): ...
    def setTimeout(self, timeout: float) -> None:
        """Set the timeout for this channel object. It overrides the class timeout.

        :param float timeout:  timeout in seconds

        >>> chan = CaChannel()
        >>> chan.setTimeout(10.)
        >>> chan.getTimeout()
        10.0
        """
        ...

    def getTimeout(self) -> float:
        """Retrieve the timeout set for this channel object.

        :return: timeout in seconds for this channel instance
        :rtype: float

        >>> chan = CaChannel()
        >>> chan.getTimeout() == CaChannel.ca_timeout
        True
        """
        ...

    @classmethod
    @attach_ca_context
    def replace_printf_handler(
        cls,
        callback: Callable[[str, Tuple[T, ...]], None] = ...,
        user_args: Tuple[T, ...] | None = ...,
    ) -> None:
        """
        Install or replace the callback used for formatted CA diagnostic message output.
        The default is to send to stderr.

        :param callable callback: function called.
        :param user_args: user provided arguments that are passed to callback when it is invoked.

        >>> chan = CaChannel('catest')
        >>> chan.searchw()
        >>> def printfCB(message, _):
        ...     print('CA message:', message)
        >>> chan.replace_printf_handler(printfCB)  # add callback # doctest: +SKIP
        >>> chan.replace_printf_handler() # clear the callback # doctest: +SKIP

        .. versionadded:: 3.1
        """
        ...

    @classmethod
    @attach_ca_context
    def add_exception_event(cls, callback=..., user_args=...):  # -> None:
        """
        Install or replace the currently installed CA context global exception handler callback.

        When an error occurs in the server asynchronous to the clients thread then information
        about this type of error is passed from the server to the client in an exception message.
        When the client receives this exception message an exception handler callback is called.
        The default exception handler prints a diagnostic message on the client's standard out and
        terminates execution if the error condition is severe.

        Note that certain fields returned in the callback args are not applicable in the context of
        some error messages. For instance, a failed get will supply the address in the client task
        where the returned value was requested to be written. For other failed operations the value
        of the addr field should not be used.

        :param callable callback: function called.
        :param user_args: user provided arguments that are passed to callback when it is invoked.

        The possible fields available are as defined in the C "struct exception_handler_args"
        and are: chid, type, count, state, op, ctx, file, lineNo

        >>> chan = CaChannel('catest')
        >>> chan.searchw()
        >>> def exceptionCB(epicsArgs, _):
        ...     print('op:', epicsArgs['op'], 'file:', epicsArgs['file'], 'line:', epicsArgs['lineNo'])
        >>> chan.add_exception_event(exceptionCB) # add callback # doctest: +SKIP
        >>> chan.add_exception_event() # clear the callback # doctest: +SKIP

        .. versionadded:: 3.1
        """
        ...

    def replace_access_rights_event(self, callback=..., user_args=...):  # -> None:
        """
        Install or replace the access rights state change callback handler for the specified channel.

        The callback handler is called in the following situations.

            - whenever CA connects the channel immediately before the channel's connection handler is called
            - whenever CA disconnects the channel immediately after the channel's disconnect callback is called
            - once immediately after installation if the channel is connected
            - whenever the access rights state of a connected channel changes

        When a channel is created no access rights handler is installed.

        :param callable callback: function called when access rights change. If None is given,
                                  remove the access rights event callback.
        :param user_args: user provided arguments that are passed to callback when it is invoked.

        >>> chan = CaChannel('catest')
        >>> chan.searchw()
        >>> def accessCB(epicsArgs, _):
        ...     print('read:', epicsArgs['read_access'], 'write:', epicsArgs['write_access'])
        >>> chan.replace_access_rights_event(accessCB)
        read: True write: True
        >>> chan.replace_access_rights_event() # clear the callback

        .. versionadded:: 3.0
        """
        ...

    @attach_ca_context
    def search_and_connect(self, pvName, callback, *user_args):  # -> None:
        """Attempt to establish a connection to a process variable.

        :param pvName:     process variable name
        :param callback:   function called when connection completes and connection status changes later on.
        :param user_args:  user provided arguments that are passed to callback when it is invoked.
        :type pvName:   bytes, str
        :type callback: callable
        :raises CaChannelException: if error happens

        The user arguments are returned to the user in a tuple in the callback function.
        The order of the arguments is preserved.

        Each Python callback function is required to have two arguments.
        The first argument is a tuple containing the results of the action.
        The second argument is a tuple containing any user arguments specified by *user_args*.
        If no arguments were specified then the tuple is empty.


        .. note:: All remote operation requests such as the above are accumulated (buffered) and not forwarded to
           the IOC until one of execution methods (:meth:`pend_io`, :meth:`poll`, :meth:`pend_event`, :meth:`flush_io`)
           is called. This allows several requests to be efficiently sent over the network in one message.

        >>> chan = CaChannel('catest')
        >>> def connCB(epicsArgs, _):
        ...     chid = epicsArgs[0]
        ...     connection_state = epicsArgs[1]
        ...     if connection_state == ca.CA_OP_CONN_UP:
        ...         print(ca.name(chid), "is connected")
        >>> chan.search_and_connect(None, connCB, chan)
        >>> status = chan.pend_event(3) # doctest: +SKIP
        catest is connected
        >>> chan.search_and_connect('cabo', connCB, chan)
        >>> status = chan.pend_event(3) # doctest: +SKIP
        cabo is connected
        >>> chan.clear_channel()
        """
        ...

    @attach_ca_context
    def search(self, pvName=...):  # -> None:
        """Attempt to establish a connection to a process variable.

        :param pvName: process variable name
        :type pvName: bytes, str
        :raises CaChannelException: if error happens

        .. note:: All remote operation requests such as the above are accumulated (buffered) and not forwarded to
           the IOC until one of execution methods (:meth:`pend_io`, :meth:`poll`, :meth:`pend_event`, :meth:`flush_io`)
           is called. This allows several requests to be efficiently sent over the network in one message.

        >>> chan = CaChannel()
        >>> chan.search('catest')
        >>> status = chan.pend_io()
        >>> chan.state()
        <ChannelState.CONN: 2>
        """
        ...

    def clear_channel(self):  # -> None:
        """Close a channel created by one of the search functions.

        Clearing a channel does not cause its connection handler to be called.
        Clearing a channel does remove any monitors registered for that channel.
        If the channel is currently connected then resources are freed only some
        time after this request is flushed out to the server.

        .. note:: All remote operation requests such as the above are accumulated (buffered) and not forwarded to
           the IOC until one of execution methods (:meth:`pend_io`, :meth:`poll`, :meth:`pend_event`, :meth:`flush_io`)
           is called. This allows several requests to be efficiently sent over the network in one message.

        """
        ...

    def change_connection_event(self, callback, *user_args):  # -> None:
        """Change the connection callback function

        :param callback:   function called when connection completes and connection status changes later on.
                           The previous connection callback will be replaced. If an invalid callback is given,
                           no connection callback will be used.
        :param user_args:  user provided arguments that are passed to callback when it is invoked.
        :type callback:    callable

        >>> chan = CaChannel('catest')
        >>> chan.search() # connect without callback
        >>> def connCB(epicsArgs, _):
        ...     chid = epicsArgs[0]
        ...     connection_state = epicsArgs[1]
        ...     if connection_state == ca.CA_OP_CONN_UP:
        ...         print(ca.name(chid), "is connected")
        >>> chan.change_connection_event(connCB) # install connection callback
        >>> status = chan.pend_event(3) # doctest: +SKIP
        catest is connected
        >>> chan.change_connection_event(None) # remove connection callback

        """
        ...

    def array_put(self, value, req_type=..., count=...):  # -> None:
        """Write a value or array of values to a channel

        :param value:    data to be written. For multiple values use a list or tuple
        :param req_type: database request type (``ca.DBR_XXXX``). Defaults to be the native data type.
        :param count:    number of data values to write. Defaults to be the native count.
        :type value: int, float, bytes, str, list, tuple, array
        :type req_type: int, None
        :type count: int, None

        .. note:: All remote operation requests such as the above are accumulated (buffered) and not forwarded to
           the IOC until one of execution methods (:meth:`pend_io`, :meth:`poll`, :meth:`pend_event`, :meth:`flush_io`)
           is called. This allows several requests to be efficiently sent over the network in one message.

        >>> chan = CaChannel('catest')
        >>> chan.searchw()
        >>> chan.array_put(123)
        >>> chan.flush_io()
        >>> chan.getw()
        123.0
        >>> chan = CaChannel('cabo')
        >>> chan.searchw()
        >>> chan.array_put('Busy', ca.DBR_STRING)
        >>> chan.flush_io()
        >>> chan.getw()
        1
        >>> chan = CaChannel('cawavec')
        >>> chan.searchw()
        >>> chan.array_put([1,2,3])
        >>> chan.flush_io()
        >>> chan.getw()
        [1, 2, 3, 0, 0]
        >>> chan.getw(count=3, use_numpy=True)
        array([1, 2, 3], dtype=uint8)
        >>> chan = CaChannel('cawavec')
        >>> chan.searchw()
        >>> chan.array_put('1234',count=3)
        >>> chan.flush_io()
        >>> chan.getw(count=4)
        [49, 50, 51, 0]
        """
        ...

    def array_put_callback(self, value, req_type, count, callback, *user_args):  # -> None:
        """Write a value or array of values to a channel and execute the user
        supplied callback after the put has completed.

        :param value:           data to be written. For multiple values use a list or tuple.
        :param req_type:        database request type (``ca.DBR_XXXX``). Defaults to be the native data type.
        :param count:           number of data values to write, Defaults to be the native count.
        :param callback:        function called when the write is completed.
        :param user_args:       user provided arguments that are passed to callback when it is invoked.
        :type value: int, float, bytes, str, list, tuple, array
        :type req_type: int, None
        :type count: int, None
        :type callback: callable
        :raises CaChannelException: if error happens

        Each Python callback function is required to have two arguments.
        The first argument is a dictionary containing the results of the action.

        =======  =======    =======
        field    type       comment
        =======  =======    =======
        chid     capsule    channels id structure
        type     int        database request type (ca.DBR_XXXX)
        count    int        number of values to transfered
        status   int        CA status return code (ca.ECA_XXXX)
        =======  =======    =======

        The second argument is a tuple containing any user arguments specified by *user_args*.
        If no arguments were specified then the tuple is empty.

        .. note:: All remote operation requests such as the above are accumulated (buffered) and not forwarded to
           the IOC until one of execution methods (:meth:`pend_io`, :meth:`poll`, :meth:`pend_event`, :meth:`flush_io`)
           is called. This allows several requests to be efficiently sent over the network in one message.

        >>> def putCB(epicsArgs, _):
        ...     print(ca.name(epicsArgs['chid']), 'put completed')
        >>> chan = CaChannel('catest')
        >>> chan.searchw()
        >>> chan.array_put_callback(145, None, None, putCB)
        >>> status = chan.pend_event(1)
        catest put completed
        >>> chan = CaChannel('cabo')
        >>> chan.searchw()
        >>> chan.array_put_callback('Busy', ca.DBR_STRING, None, putCB)
        >>> status = chan.pend_event(1)
        cabo put completed
        >>> chan = CaChannel('cawave')
        >>> chan.searchw()
        >>> chan.array_put_callback([1,2,3], None, None, putCB)
        >>> status = chan.pend_event(1)
        cawave put completed
        >>> chan = CaChannel('cawavec')
        >>> chan.searchw()
        >>> chan.array_put_callback('123', None, None, putCB)
        >>> status = chan.pend_event(1)
        cawavec put completed
        """
        ...

    def getValue(self):  # -> dict[Any, Any] | None:
        """
        Return the value(s) after :meth:`array_get` has completed.

        :return: the value returned from the last array_get
        :rtype: int, float, str, list, array, dict

        If the *req_type* was not a plain type, the returned value is of dict type. It contains the same keys as in :meth:`array_get_callback`.

        .. seealso:: :meth:`array_get`

        >>> chan = CaChannel('cabo')
        >>> chan.searchw()
        >>> chan.putw(1)
        >>> chan.array_get(req_type=ca.DBR_CTRL_ENUM)
        >>> chan.pend_io()
        >>> for k,v in sorted(chan.getValue().items()):
        ...    if k in ['pv_severity', 'pv_status']:
        ...        print(k, v.name)
        ...    else:
        ...        print(k, v)
        pv_nostrings 2
        pv_severity Minor
        pv_statestrings ('Done', 'Busy')
        pv_status State
        pv_value 1
        """
        ...

    def array_get(self, req_type=..., count=..., **keywords):  # -> None:
        """Read a value or array of values from a channel.

        The new value is not available until a subsequent :meth:`pend_io` returns :data:`ca.ECA_NORMAL`.
        Then it can be retrieved by a call to :meth:`getValue`.

        :param req_type:    database request type (:data:`ca.DBR_XXXX`). Defaults to be the native data type.
        :param count:       number of data values to read, Defaults to be the native count.
        :param keywords:    optional arguments assigned by keywords

                            ===========   ===================================================
                            keyword       value
                            ===========   ===================================================
                            use_numpy     True if waveform should be returned as numpy array.
                                          Default :data:`CaChannel.USE_NUMPY`.
                            ===========   ===================================================
        :type req_type: int, None
        :type count: int, None
        :raises CaChannelException: if error happens

        .. note:: All remote operation requests such as the above are accumulated (buffered) and not forwarded to
           the IOC until one of execution methods (:meth:`pend_io`, :meth:`poll`, :meth:`pend_event`, :meth:`flush_io`)
           is called. This allows several requests to be efficiently sent over the network in one message.

        .. seealso:: :meth:`getValue`

        >>> chan = CaChannel('catest')
        >>> chan.searchw()
        >>> chan.putw(123)
        >>> chan.array_get()
        >>> chan.pend_io()
        >>> chan.getValue()
        123.0
        """
        ...

    def array_get_callback(self, req_type, count, callback, *user_args, **keywords):  # -> None:
        """Read a value or array of values from a channel and execute the user
        supplied callback after the get has completed.

        :param req_type:    database request type (``ca.DBR_XXXX``). Defaults to be the native data type.
        :param count:       number of data values to read, Defaults to be the native count.
        :param callback:    function called when the get is completed.
        :param user_args:   user provided arguments that are passed to callback when it is invoked.
        :param keywords:    optional arguments assigned by keywords

                            ===========   ===================================================
                            keyword       value
                            ===========   ===================================================
                            use_numpy     True if waveform should be returned as numpy array.
                                          Default :data:`CaChannel.USE_NUMPY`.
                            ===========   ===================================================
        :type req_type:     int, None
        :type count:        int, None
        :type callback:     callable

        :raises CaChannelException: if error happens

        Each Python callback function is required to have two arguments.
        The first argument is a dictionary containing the results of the action.

        +-----------------+---------------+------------------------------------+-------------------------+---------------+-------------+---------------+
        | field           |  type         |  comment                           |       request type                                                    |
        |                 |               |                                    +----------+--------------+---------------+-------------+---------------+
        |                 |               |                                    | DBR_XXXX | DBR_STS_XXXX | DBR_TIME_XXXX | DBR_GR_XXXX | DBR_CTRL_XXXX |
        +=================+===============+====================================+==========+==============+===============+=============+===============+
        | chid            |   int         |   channels id number               |    X     |       X      |     X         |   X         | X             |
        +-----------------+---------------+------------------------------------+----------+--------------+---------------+-------------+---------------+
        | type            |   int         |   database request type            |    X     |       X      |     X         |   X         | X             |
        |                 |               |   (ca.DBR_XXXX)                    |          |              |               |             |               |
        +-----------------+---------------+------------------------------------+----------+--------------+---------------+-------------+---------------+
        | count           |   int         |   number of values to transfered   |    X     |       X      |     X         |   X         | X             |
        +-----------------+---------------+------------------------------------+----------+--------------+---------------+-------------+---------------+
        | status          |   int         |   CA status return code            |    X     |       X      |     X         |   X         | X             |
        |                 |               |   (ca.ECA_XXXX)                    |          |              |               |             |               |
        +-----------------+---------------+------------------------------------+----------+--------------+---------------+-------------+---------------+
        | pv_value        |               |   PV value                         |    X     |       X      |     X         |   X         | X             |
        +-----------------+---------------+------------------------------------+----------+--------------+---------------+-------------+---------------+
        | pv_status       |   int         |   PV alarm status                  |          |       X      |     X         |   X         | X             |
        +-----------------+---------------+------------------------------------+----------+--------------+---------------+-------------+---------------+
        | pv_severity     |   int         |   PV alarm severity                |          |       X      |     X         |   X         | X             |
        +-----------------+---------------+------------------------------------+----------+--------------+---------------+-------------+---------------+
        | pv_seconds      |   int         |   seconds part of timestamp        |          |              |     X         |             |               |
        +-----------------+---------------+------------------------------------+----------+--------------+---------------+-------------+---------------+
        | pv_nseconds     |   int         |   nanoseconds part of timestamp    |          |              |     X         |             |               |
        +-----------------+---------------+------------------------------------+----------+--------------+---------------+-------------+---------------+
        | pv_nostrings    |   int         |   ENUM PV's number of states       |          |              |               |   X         | X             |
        +-----------------+---------------+------------------------------------+----------+--------------+---------------+-------------+---------------+
        | pv_statestrings |   string list |   ENUM PV's states string          |          |              |               |   X         | X             |
        +-----------------+---------------+------------------------------------+----------+--------------+---------------+-------------+---------------+
        | pv_units        |   string      |   units                            |          |              |               |   X         | X             |
        +-----------------+---------------+------------------------------------+----------+--------------+---------------+-------------+---------------+
        | pv_precision    |   int         |   precision                        |          |              |               |   X         | X             |
        +-----------------+---------------+------------------------------------+----------+--------------+---------------+-------------+---------------+
        | pv_updislim     |   float       |   upper display limit              |          |              |               |   X         | X             |
        +-----------------+---------------+------------------------------------+----------+--------------+---------------+-------------+---------------+
        | pv_lodislim     |   float       |   lower display limit              |          |              |               |   X         | X             |
        +-----------------+---------------+------------------------------------+----------+--------------+---------------+-------------+---------------+
        | pv_upalarmlim   |   float       |   upper alarm limit                |          |              |               |   X         | X             |
        +-----------------+---------------+------------------------------------+----------+--------------+---------------+-------------+---------------+
        | pv_upwarnlim    |   float       |   upper warning limit              |          |              |               |   X         | X             |
        +-----------------+---------------+------------------------------------+----------+--------------+---------------+-------------+---------------+
        | pv_loalarmlim   |   float       |   lower alarm limit                |          |              |               |   X         | X             |
        +-----------------+---------------+------------------------------------+----------+--------------+---------------+-------------+---------------+
        | pv_lowarnlim    |   float       |   lower warning limit              |          |              |               |   X         | X             |
        +-----------------+---------------+------------------------------------+----------+--------------+---------------+-------------+---------------+
        | pv_upctrllim    |   float       |   upper control limit              |          |              |               |             | X             |
        +-----------------+---------------+------------------------------------+----------+--------------+---------------+-------------+---------------+
        | pv_loctrllim    |   float       |   lower control limit              |          |              |               |             | X             |
        +-----------------+---------------+------------------------------------+----------+--------------+---------------+-------------+---------------+

        The second argument is a tuple containing any user arguments specified by *user_args*.
        If no arguments were specified then the tuple is empty.

        .. note:: All remote operation requests such as the above are accumulated (buffered)
           and not forwarded to the IOC until one of execution methods (:meth:`pend_io`, :meth:`poll`, :meth:`pend_event`, :meth:`flush_io`)
           is called. This allows several requests to be efficiently sent over the network in one message.

        >>> def getCB(epicsArgs, _):
        ...     for item in sorted(epicsArgs.keys()):
        ...         if item in ['pv_severity', 'pv_status']:
        ...             print(item,epicsArgs[item].name)
        ...         elif item.startswith('pv_'):
        ...             print(item,epicsArgs[item])
        >>> chan = CaChannel('catest')
        >>> chan.searchw()
        >>> chan.putw(145)
        >>> chan.array_get_callback(ca.DBR_CTRL_DOUBLE, 1, getCB)
        >>> status = chan.pend_event(1)
        pv_loalarmlim -20.0
        pv_loctrllim 0.0
        pv_lodislim -20.0
        pv_lowarnlim -10.0
        pv_precision 4
        pv_severity Major
        pv_status HiHi
        pv_units mm
        pv_upalarmlim 20.0
        pv_upctrllim 0.0
        pv_updislim 20.0
        pv_upwarnlim 10.0
        pv_value 145.0
        >>> chan = CaChannel('cabo')
        >>> chan.searchw()
        >>> chan.putw(0)
        >>> chan.array_get_callback(ca.DBR_CTRL_ENUM, 1, getCB)
        >>> status = chan.pend_event(1)
        pv_nostrings 2
        pv_severity No
        pv_statestrings ('Done', 'Busy')
        pv_status No
        pv_value 0
        """
        ...

    def add_masked_array_event(
        self, req_type, count, mask, callback, *user_args, **keywords
    ):  # -> None:
        """Specify a callback function to be executed whenever changes occur to a PV.

        Creates a new event id and stores it on self.__evid.  Only one event registered per CaChannel object.
        If an event is already registered the event is cleared before registering a new event.

        :param req_type:    database request type (``ca.DBR_XXXX``). Defaults to be the native data type.
        :param count:       number of data values to read, Defaults to be the native count.
        :param mask:        logical or of ``ca.DBE_VALUE``, ``ca.DBE_LOG``, ``ca.DBE_ALARM``.
                            Defaults to be ``ca.DBE_VALUE|ca.DBE_ALARM``.
        :param callback:    function called when the get is completed.
        :param user_args:   user provided arguments that are passed to callback when it is invoked.
        :param keywords:    optional arguments assigned by keywords

                            ===========   ===================================================
                            keyword       value
                            ===========   ===================================================
                            use_numpy     True if waveform should be returned as numpy array.
                                          Default :data:`CaChannel.USE_NUMPY`.
                            ===========   ===================================================
        :type req_type: int, None
        :type count: int, None
        :type mask: int, None
        :type callback: callable

        :raises CaChannelException: if error happens

        .. note:: All remote operation requests such as the above are accumulated (buffered) and not forwarded to
           the IOC until one of execution methods (:meth:`pend_io`, :meth:`poll`, :meth:`pend_event`, :meth:`flush_io`)
           is called. This allows several requests to be efficiently sent over the network in one message.

        >>> def eventCB(epicsArgs, _):
        ...     print('pv_value', epicsArgs['pv_value'])
        ...     print('pv_status', epicsArgs['pv_status'].name)
        ...     print('pv_severity', epicsArgs['pv_severity'].name)
        >>> chan = CaChannel('cabo')
        >>> chan.searchw()
        >>> chan.putw(1)
        >>> chan.add_masked_array_event(ca.DBR_STS_ENUM, None, None, eventCB)
        >>> status = chan.pend_event(1)
        pv_value 1
        pv_status State
        pv_severity Minor
        >>> chan.add_masked_array_event(ca.DBR_STS_STRING, None, None, eventCB)
        >>> status = chan.pend_event(1)
        pv_value Busy
        pv_status State
        pv_severity Minor
        >>> chan.clear_event()
        """
        ...

    def clear_event(self):  # -> None:
        """Remove previously installed callback function.

        .. note:: All remote operation requests such as the above are accumulated (buffered) and not forwarded to
           the IOC until one of execution methods (:meth:`pend_io`, :meth:`poll`, :meth:`pend_event`, :meth:`flush_io`)
           is called. This allows several requests to be efficiently sent over the network in one message.
        """
        ...

    @attach_ca_context
    def pend_io(self, timeout=...):  # -> None:
        """
        Flush the send buffer and wait until outstanding queries (:meth:`search`, :meth:`array_get`) complete
        or the specified timeout expires.

        :param float timeout: seconds to wait
        :raises CaChannelException: if timeout or other error happens

        """
        ...

    @attach_ca_context
    def pend_event(self, timeout=...):
        """Flush the send buffer and process background activity (connect/get/put/monitor callbacks) for ``timeout`` seconds.

        It will not return before the specified timeout expires and all unfinished channel access labor has been processed.

        :param float timeout: seconds to wait
        :return: :data:`ca.ECA_TIMEOUT`
        """
        ...

    @attach_ca_context
    def poll(self):
        """Flush the send buffer and execute any outstanding background activity.

        :return: :data:`ca.ECA_TIMEOUT`

        .. note:: It is an alias to ``pend_event(1e-12)``.
        """
        ...

    @attach_ca_context
    def flush_io(self):  # -> None:
        """
        Flush the send buffer and does not execute outstanding background activity.

        :raises CaChannelException: if error happens
        """
        ...

    def field_type(self):
        """
        Native type of the PV in the server, :data:`ca.DBF_XXXX`.

        >>> chan = CaChannel('catest')
        >>> chan.searchw()
        >>> ftype = chan.field_type()
        >>> ftype
        <DBF.DOUBLE: 6>
        >>> ca.dbf_text(ftype)
        'DBF_DOUBLE'
        >>> ca.DBF_DOUBLE == ftype
        True
        """
        ...

    def element_count(self):
        """
        Maximum array element count of the PV in the server.

        >>> chan = CaChannel('catest')
        >>> chan.searchw()
        >>> chan.element_count()
        1
        """
        ...

    def name(self):
        """
        Channel name specified when the channel was created.

        >>> chan = CaChannel('catest')
        >>> chan.searchw()
        >>> chan.name()
        'catest'
        """
        ...

    def state(self):
        """
        Current state of the CA connection.

            ==================  =====  =============
            States              Value  Meaning
            ==================  =====  =============
            ca.cs_never_conn    0      PV not found
            ca.cs_prev_conn     1      PV was found but unavailable
            ca.cs_conn          2      PV was found and available
            ca.cs_closed        3      PV not closed
            ca.cs_never_search  4      PV not searched yet
            ==================  =====  =============

        >>> chan = CaChannel('catest')
        >>> chan.state()
        <ChannelState.NEVER_SEARCH: 4>
        >>> chan.searchw()
        >>> chan.state()
        <ChannelState.CONN: 2>
        """
        ...

    def host_name(self):
        """
        Host name that hosts the process variable.

        >>> chan = CaChannel('catest')
        >>> chan.searchw()
        >>> host_name = chan.host_name()

        """
        ...

    def read_access(self):
        """Access right to read the channel.

        :return: True if the channel can be read, False otherwise.

        >>> chan = CaChannel('catest')
        >>> chan.searchw()
        >>> chan.read_access()
        True
        """
        ...

    def write_access(self):
        """Access right to write the channel.

        :return: True if the channel can be written, False otherwise.

        >>> chan = CaChannel('catest')
        >>> chan.searchw()
        >>> chan.write_access()
        True
        """
        ...

    def searchw(self, pvName=...):  # -> None:
        """
        Attempt to establish a connection to a process variable.

        :param pvName: process variable name
        :type pvName: str, None
        :raises CaChannelException: if timeout or error happens

        .. note:: This method waits for connection to be established or fail with exception.

        >>> chan = CaChannel('non-exist-channel')
        >>> chan.searchw() # doctest: +IGNORE_EXCEPTION_DETAIL
        Traceback (most recent call last):
            ...
        CaChannelException: User specified timeout on IO operation expired
        """
        ...

    def putw(self, value, req_type=...):  # -> None:
        """
        Write a value or array of values to a channel.

        If the request type is omitted the data is written as the Python type corresponding to the native format.
        Multi-element data is specified as a tuple or a list.
        Internally the sequence is converted to a list before inserting the values into a C array.
        Access using non-numerical types is restricted to the first element in the data field.
        Mixing character types with numerical types writes bogus results but is not prohibited at this time.
        :data:`ca.DBF_ENUM` fields can be written using :data:`ca.DBR_ENUM` and :data:`ca.DBR_STRING` types.
        :data:`ca.DBR_STRING` writes of a field of type :data:`ca.DBF_ENUM` must be accompanied by a valid string
        out of the possible enumerated values.

        :param value:    data to be written. For multiple values use a list or tuple
        :param req_type: database request type (:data:`ca.DBR_XXXX`). Defaults to be the native data type.
        :type value:     int, float, bytes, str, tuple, list, array
        :type req_type:  int, None
        :raises CaChannelException: if timeout or error happens

        .. note:: This method does flush the request to the channel access server.

        >>> chan = CaChannel('catest')
        >>> chan.searchw()
        >>> chan.putw(145)
        >>> chan.getw()
        145.0
        >>> chan = CaChannel('cabo')
        >>> chan.searchw()
        >>> chan.putw('Busy', ca.DBR_STRING)
        >>> chan.getw()
        1
        >>> chan.getw(ca.DBR_STRING)
        'Busy'
        >>> chan = CaChannel('cawave')
        >>> chan.searchw()
        >>> chan.putw([1,2,3])
        >>> chan.getw(req_type=ca.DBR_LONG,count=4)
        [1, 2, 3, 0]
        >>> chan = CaChannel('cawavec')
        >>> chan.searchw()
        >>> chan.putw('123')
        >>> chan.getw(count=4)
        [49, 50, 51, 0]
        >>> chan.getw(req_type=ca.DBR_STRING)
        '123'
        >>> chan = CaChannel('cawaves')
        >>> chan.searchw()
        >>> chan.putw(['string 1','string 2'])
        >>> chan.getw()
        ['string 1', 'string 2', '']
        """
        ...

    def getw(self, req_type=..., count=..., **keywords) -> dict[Any, Any] | PVValue:
        """Read the value from a channel.

        If the request type is omitted the data is returned to the user as the Python type corresponding to the native format.
        Multi-element data has all the elements returned as items in a list and must be accessed using a numerical type.
        Access using non-numerical types is restricted to the first element in the data field.

        :data:`ca.DBF_ENUM` fields can be read using :data:`ca.DBR_ENUM` and :data:`ca.DBR_STRING` types.
        :data:`ca.DBR_STRING` reads of a field of type :data:`ca.DBF_ENUM` returns the string corresponding
        to the current enumerated value.

        :data:`ca.DBF_CHAR` fields can be read using :data:`ca.DBR_CHAR` and :data:`ca.DBR_STRING` types.
        :data:`ca.DBR_CHAR` returns a scalar or a sequnece of integers. :data:`ca.DBR_STRING` assumes each integer as a
        character and assemble a string.

        :param req_type:    database request type. Defaults to be the native data type.
        :param count:       number of data values to read, Defaults to be the native count.
        :param keywords:    optional arguments assigned by keywords

                            ===========   ===================================================
                            keyword       value
                            ===========   ===================================================
                            use_numpy     True if waveform should be returned as numpy array.
                                          Default :data:`CaChannel.USE_NUMPY`.
                            ===========   ===================================================
        :type req_type:     int, None
        :type count:        int, None
        :return:            If *req_type* is plain request type, only the value is returned.
                            Otherwise a dict returns with information depending on the request type,
                            same as the first argument passed to user's callback by :meth:`array_get_callback`.

        :raises CaChannelException: if timeout error happens

        >>> chan = CaChannel('catest')
        >>> chan.searchw()
        >>> chan.putw(0)
        >>> value = chan.getw(ca.DBR_TIME_DOUBLE)
        >>> for k,v in sorted(value.items()): # doctest: +ELLIPSIS
        ...    if k in ['pv_severity', 'pv_status']:
        ...        print(k, v.name)
        ...    else:
        ...        print(k, v)
        pv_nseconds ...
        pv_seconds ...
        pv_severity No
        pv_status No
        pv_value 0.0

        .. versionchanged:: 3.0
           If *req_type* is DBR_XXX_STRING for a char type PV, a string will be returned from composing
           each element as a character.

        """
        ...

if __name__ == "__main__": ...
