"""Default values for terraform-docs content."""
terraform_docs_content_resources = """formatter: "markdown table" # this is required

version: ""

header-from: main.tf
footer-from: ""

sections:
  hide: []
  show: 
    - header
    - requirements
    - data-sources
    - providers
    - modules
    - inputs
    - outputs
    - footer

content: |-

  {{ .Header }}

  ## Code Dependencies Graph
  <center>

     ![Graph](./graph.svg)

    ##### **Dependency Graph**

  </center>
  
  ---

  ## Example parameter options for each environment

  ```hcl

   {{ include "./parameters.tf" }}

  ```
  {{ .Requirements }}

  {{ .Providers }}
  
  {{ .Modules }}
  
  {{ .Resources }}

  {{ .Inputs }}
  
  {{ .Outputs }}

  {{ .Footer }}
  
output:
  file: "README.md"
  mode: replace
  template: |-
    <!-- BEGIN_TF_DOCS -->
    {{ .Content }}
    <!-- END_TF_DOCS -->

output-values:
  enabled: false
  from: ""

sort:
  enabled: true
  by: name

settings:
  anchor: true
  color: true
  default: true
  description: false
  escape: true
  hide-empty: false
  html: true
  indent: 2
  lockfile: true
  required: true
  sensitive: true
  type: true
  show: requirements
  """

terraform_docs_content_modules = """formatter: "markdown table" # this is required
version: ""

header-from: "main.tf"
#footer-from: "docs/footer.md"
footer-from: ""

sections:
  show:
    - header
    - requirements
    - data-sources
    - providers
    - modules
    - inputs
    - outputs
    - footer

content: |-
  
  {{ .Header }}
  
  ## Example
  ```hcl
  {{ include "examples/complete/main.tf" }}
  ```
  {{ .Requirements }}

  {{ .Providers }}

  {{ .Modules }}
  
  {{ .Resources }}

  {{ .Inputs }}

  {{ .Outputs }}

  {{ .Footer }}

output:
  file: "README.md"
  mode: inject
  template: |-
    <!-- BEGIN_TF_DOCS -->
    <!--
    ** DO NOT EDIT THIS FILE
    ** This file was automatically generated by using Terraform Docs
    ** 1) Make all changes on files under docs/*.md
    ** 2) Run `terraform-docs .` to rebuild this file
    **
    ** By following this practice we ensure standard and high-quality across multiple projects.
    ** DO NOT EDIT THIS FILE
    -->
    {{ .Content }}
    <!-- END_TF_DOCS -->

output-values:
  enabled: false
  from: ""

sort:
  enabled: true
  by: required
"""
