# coding: utf-8

"""
    Pluxbox Radiomanager Client

    Pluxbox RadioManager gives you the power, flexibility and speed you always wanted in a lightweight and easy-to-use web-based radio solution. With Pluxbox RadioManager you can organise your radio workflow and automate your omnichannel communication with your listeners. We offer wide range specialised services for the radio and connections like Hybrid Radio, Visual Radio, your website and social media without losing focus on your broadcast. For more information visit https://pluxbox.com

    OpenAPI spec version: 2.0
    Contact: support@pluxbox.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class Campaign(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'model_type_id': 'int',
        'field_values': 'list[object]',
        'title': 'str',
        'start': 'datetime',
        'stop': 'datetime',
        'recommended': 'bool',
        'description': 'str'
    }

    attribute_map = {
        'model_type_id': 'model_type_id',
        'field_values': 'field_values',
        'title': 'title',
        'start': 'start',
        'stop': 'stop',
        'recommended': 'recommended',
        'description': 'description'
    }

    def __init__(self, model_type_id=None, field_values=None, title=None, start=None, stop=None, recommended=None, description=None):
        """
        Campaign - a model defined in Swagger
        """

        self._model_type_id = None
        self._field_values = None
        self._title = None
        self._start = None
        self._stop = None
        self._recommended = None
        self._description = None

        self.model_type_id = model_type_id
        if field_values is not None:
          self.field_values = field_values
        if title is not None:
          self.title = title
        self.start = start
        self.stop = stop
        if recommended is not None:
          self.recommended = recommended
        if description is not None:
          self.description = description

    @property
    def model_type_id(self):
        """
        Gets the model_type_id of this Campaign.

        :return: The model_type_id of this Campaign.
        :rtype: int
        """
        return self._model_type_id

    @model_type_id.setter
    def model_type_id(self, model_type_id):
        """
        Sets the model_type_id of this Campaign.

        :param model_type_id: The model_type_id of this Campaign.
        :type: int
        """
        if model_type_id is None:
            raise ValueError("Invalid value for `model_type_id`, must not be `None`")

        self._model_type_id = model_type_id

    @property
    def field_values(self):
        """
        Gets the field_values of this Campaign.

        :return: The field_values of this Campaign.
        :rtype: list[object]
        """
        return self._field_values

    @field_values.setter
    def field_values(self, field_values):
        """
        Sets the field_values of this Campaign.

        :param field_values: The field_values of this Campaign.
        :type: list[object]
        """

        self._field_values = field_values

    @property
    def title(self):
        """
        Gets the title of this Campaign.

        :return: The title of this Campaign.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this Campaign.

        :param title: The title of this Campaign.
        :type: str
        """

        self._title = title

    @property
    def start(self):
        """
        Gets the start of this Campaign.

        :return: The start of this Campaign.
        :rtype: datetime
        """
        return self._start

    @start.setter
    def start(self, start):
        """
        Sets the start of this Campaign.

        :param start: The start of this Campaign.
        :type: datetime
        """
        if start is None:
            raise ValueError("Invalid value for `start`, must not be `None`")

        self._start = start

    @property
    def stop(self):
        """
        Gets the stop of this Campaign.

        :return: The stop of this Campaign.
        :rtype: datetime
        """
        return self._stop

    @stop.setter
    def stop(self, stop):
        """
        Sets the stop of this Campaign.

        :param stop: The stop of this Campaign.
        :type: datetime
        """
        if stop is None:
            raise ValueError("Invalid value for `stop`, must not be `None`")

        self._stop = stop

    @property
    def recommended(self):
        """
        Gets the recommended of this Campaign.

        :return: The recommended of this Campaign.
        :rtype: bool
        """
        return self._recommended

    @recommended.setter
    def recommended(self, recommended):
        """
        Sets the recommended of this Campaign.

        :param recommended: The recommended of this Campaign.
        :type: bool
        """

        self._recommended = recommended

    @property
    def description(self):
        """
        Gets the description of this Campaign.

        :return: The description of this Campaign.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Campaign.

        :param description: The description of this Campaign.
        :type: str
        """

        self._description = description

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Campaign):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
