# coding: utf-8

"""
    Pluxbox Radiomanager Client

    Pluxbox RadioManager gives you the power, flexibility and speed you always wanted in a lightweight and easy-to-use web-based radio solution. With Pluxbox RadioManager you can organise your radio workflow and automate your omnichannel communication with your listeners. We offer wide range specialised services for the radio and connections like Hybrid Radio, Visual Radio, your website and social media without losing focus on your broadcast. For more information visit https://pluxbox.com

    OpenAPI spec version: 2.0
    Contact: support@pluxbox.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ExternalMessageQueueData(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'message': 'str',
        'message_id': 'int',
        'message_date': 'datetime',
        'sender_name': 'str',
        'sender_id': 'int',
        'avatar_url': 'str',
        'model_type_id': 'int'
    }

    attribute_map = {
        'message': 'message',
        'message_id': 'message_id',
        'message_date': 'message_date',
        'sender_name': 'sender_name',
        'sender_id': 'sender_id',
        'avatar_url': 'avatar_url',
        'model_type_id': 'model_type_id'
    }

    def __init__(self, message='', message_id=None, message_date=None, sender_name='', sender_id=None, avatar_url=None, model_type_id=None):
        """
        ExternalMessageQueueData - a model defined in Swagger
        """

        self._message = None
        self._message_id = None
        self._message_date = None
        self._sender_name = None
        self._sender_id = None
        self._avatar_url = None
        self._model_type_id = None

        if message is not None:
          self.message = message
        if message_id is not None:
          self.message_id = message_id
        if message_date is not None:
          self.message_date = message_date
        if sender_name is not None:
          self.sender_name = sender_name
        if sender_id is not None:
          self.sender_id = sender_id
        if avatar_url is not None:
          self.avatar_url = avatar_url
        if model_type_id is not None:
          self.model_type_id = model_type_id

    @property
    def message(self):
        """
        Gets the message of this ExternalMessageQueueData.
        Message **(Required)**

        :return: The message of this ExternalMessageQueueData.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this ExternalMessageQueueData.
        Message **(Required)**

        :param message: The message of this ExternalMessageQueueData.
        :type: str
        """
        if message is not None and len(message) > 600:
            raise ValueError("Invalid value for `message`, length must be less than or equal to `600`")

        self._message = message

    @property
    def message_id(self):
        """
        Gets the message_id of this ExternalMessageQueueData.
        ID of Message **(Required)**

        :return: The message_id of this ExternalMessageQueueData.
        :rtype: int
        """
        return self._message_id

    @message_id.setter
    def message_id(self, message_id):
        """
        Sets the message_id of this ExternalMessageQueueData.
        ID of Message **(Required)**

        :param message_id: The message_id of this ExternalMessageQueueData.
        :type: int
        """
        if message_id is not None and message_id < 0:
            raise ValueError("Invalid value for `message_id`, must be a value greater than or equal to `0`")

        self._message_id = message_id

    @property
    def message_date(self):
        """
        Gets the message_date of this ExternalMessageQueueData.
        Message Date *(Optional)*

        :return: The message_date of this ExternalMessageQueueData.
        :rtype: datetime
        """
        return self._message_date

    @message_date.setter
    def message_date(self, message_date):
        """
        Sets the message_date of this ExternalMessageQueueData.
        Message Date *(Optional)*

        :param message_date: The message_date of this ExternalMessageQueueData.
        :type: datetime
        """

        self._message_date = message_date

    @property
    def sender_name(self):
        """
        Gets the sender_name of this ExternalMessageQueueData.
        Sender **(Required)**

        :return: The sender_name of this ExternalMessageQueueData.
        :rtype: str
        """
        return self._sender_name

    @sender_name.setter
    def sender_name(self, sender_name):
        """
        Sets the sender_name of this ExternalMessageQueueData.
        Sender **(Required)**

        :param sender_name: The sender_name of this ExternalMessageQueueData.
        :type: str
        """
        if sender_name is not None and len(sender_name) > 60:
            raise ValueError("Invalid value for `sender_name`, length must be less than or equal to `60`")

        self._sender_name = sender_name

    @property
    def sender_id(self):
        """
        Gets the sender_id of this ExternalMessageQueueData.
        ID of Sender *(Optional)*

        :return: The sender_id of this ExternalMessageQueueData.
        :rtype: int
        """
        return self._sender_id

    @sender_id.setter
    def sender_id(self, sender_id):
        """
        Sets the sender_id of this ExternalMessageQueueData.
        ID of Sender *(Optional)*

        :param sender_id: The sender_id of this ExternalMessageQueueData.
        :type: int
        """
        if sender_id is not None and sender_id < 0:
            raise ValueError("Invalid value for `sender_id`, must be a value greater than or equal to `0`")

        self._sender_id = sender_id

    @property
    def avatar_url(self):
        """
        Gets the avatar_url of this ExternalMessageQueueData.
        URL of Avatar *(Optional)*

        :return: The avatar_url of this ExternalMessageQueueData.
        :rtype: str
        """
        return self._avatar_url

    @avatar_url.setter
    def avatar_url(self, avatar_url):
        """
        Sets the avatar_url of this ExternalMessageQueueData.
        URL of Avatar *(Optional)*

        :param avatar_url: The avatar_url of this ExternalMessageQueueData.
        :type: str
        """

        self._avatar_url = avatar_url

    @property
    def model_type_id(self):
        """
        Gets the model_type_id of this ExternalMessageQueueData.
        Assigned Model Type ID **(Required)**

        :return: The model_type_id of this ExternalMessageQueueData.
        :rtype: int
        """
        return self._model_type_id

    @model_type_id.setter
    def model_type_id(self, model_type_id):
        """
        Sets the model_type_id of this ExternalMessageQueueData.
        Assigned Model Type ID **(Required)**

        :param model_type_id: The model_type_id of this ExternalMessageQueueData.
        :type: int
        """
        if model_type_id is not None and model_type_id < 0:
            raise ValueError("Invalid value for `model_type_id`, must be a value greater than or equal to `0`")

        self._model_type_id = model_type_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ExternalMessageQueueData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
