# coding: utf-8

"""
    Pluxbox Radiomanager Client

    Pluxbox RadioManager gives you the power, flexibility and speed you always wanted in a lightweight and easy-to-use web-based radio solution. With Pluxbox RadioManager you can organise your radio workflow and automate your omnichannel communication with your listeners. We offer wide range specialised services for the radio and connections like Hybrid Radio, Visual Radio, your website and social media without losing focus on your broadcast. For more information visit https://pluxbox.com

    OpenAPI spec version: 2.0
    Contact: support@pluxbox.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class TagResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'int',
        'created_at': 'datetime',
        'updated_at': 'datetime',
        'deleted_at': 'datetime',
        'external_station_id': 'int',
        'name': 'str',
        'broadcasts': 'TagRelationsBroadcasts',
        'programs': 'TagRelationsPrograms',
        'contacts': 'TagRelationsContacts',
        'items': 'TagRelationsItems'
    }

    attribute_map = {
        'id': 'id',
        'created_at': 'created_at',
        'updated_at': 'updated_at',
        'deleted_at': 'deleted_at',
        'external_station_id': '_external_station_id',
        'name': 'name',
        'broadcasts': 'broadcasts',
        'programs': 'programs',
        'contacts': 'contacts',
        'items': 'items'
    }

    def __init__(self, id=None, created_at=None, updated_at=None, deleted_at=None, external_station_id=None, name=None, broadcasts=None, programs=None, contacts=None, items=None):
        """
        TagResult - a model defined in Swagger
        """

        self._id = None
        self._created_at = None
        self._updated_at = None
        self._deleted_at = None
        self._external_station_id = None
        self._name = None
        self._broadcasts = None
        self._programs = None
        self._contacts = None
        self._items = None

        self.id = id
        if created_at is not None:
          self.created_at = created_at
        if updated_at is not None:
          self.updated_at = updated_at
        if deleted_at is not None:
          self.deleted_at = deleted_at
        if external_station_id is not None:
          self.external_station_id = external_station_id
        self.name = name
        if broadcasts is not None:
          self.broadcasts = broadcasts
        if programs is not None:
          self.programs = programs
        if contacts is not None:
          self.contacts = contacts
        if items is not None:
          self.items = items

    @property
    def id(self):
        """
        Gets the id of this TagResult.

        :return: The id of this TagResult.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this TagResult.

        :param id: The id of this TagResult.
        :type: int
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")

        self._id = id

    @property
    def created_at(self):
        """
        Gets the created_at of this TagResult.

        :return: The created_at of this TagResult.
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """
        Sets the created_at of this TagResult.

        :param created_at: The created_at of this TagResult.
        :type: datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """
        Gets the updated_at of this TagResult.

        :return: The updated_at of this TagResult.
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """
        Sets the updated_at of this TagResult.

        :param updated_at: The updated_at of this TagResult.
        :type: datetime
        """

        self._updated_at = updated_at

    @property
    def deleted_at(self):
        """
        Gets the deleted_at of this TagResult.

        :return: The deleted_at of this TagResult.
        :rtype: datetime
        """
        return self._deleted_at

    @deleted_at.setter
    def deleted_at(self, deleted_at):
        """
        Sets the deleted_at of this TagResult.

        :param deleted_at: The deleted_at of this TagResult.
        :type: datetime
        """

        self._deleted_at = deleted_at

    @property
    def external_station_id(self):
        """
        Gets the external_station_id of this TagResult.

        :return: The external_station_id of this TagResult.
        :rtype: int
        """
        return self._external_station_id

    @external_station_id.setter
    def external_station_id(self, external_station_id):
        """
        Sets the external_station_id of this TagResult.

        :param external_station_id: The external_station_id of this TagResult.
        :type: int
        """

        self._external_station_id = external_station_id

    @property
    def name(self):
        """
        Gets the name of this TagResult.

        :return: The name of this TagResult.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this TagResult.

        :param name: The name of this TagResult.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")

        self._name = name

    @property
    def broadcasts(self):
        """
        Gets the broadcasts of this TagResult.

        :return: The broadcasts of this TagResult.
        :rtype: TagRelationsBroadcasts
        """
        return self._broadcasts

    @broadcasts.setter
    def broadcasts(self, broadcasts):
        """
        Sets the broadcasts of this TagResult.

        :param broadcasts: The broadcasts of this TagResult.
        :type: TagRelationsBroadcasts
        """

        self._broadcasts = broadcasts

    @property
    def programs(self):
        """
        Gets the programs of this TagResult.

        :return: The programs of this TagResult.
        :rtype: TagRelationsPrograms
        """
        return self._programs

    @programs.setter
    def programs(self, programs):
        """
        Sets the programs of this TagResult.

        :param programs: The programs of this TagResult.
        :type: TagRelationsPrograms
        """

        self._programs = programs

    @property
    def contacts(self):
        """
        Gets the contacts of this TagResult.

        :return: The contacts of this TagResult.
        :rtype: TagRelationsContacts
        """
        return self._contacts

    @contacts.setter
    def contacts(self, contacts):
        """
        Sets the contacts of this TagResult.

        :param contacts: The contacts of this TagResult.
        :type: TagRelationsContacts
        """

        self._contacts = contacts

    @property
    def items(self):
        """
        Gets the items of this TagResult.

        :return: The items of this TagResult.
        :rtype: TagRelationsItems
        """
        return self._items

    @items.setter
    def items(self, items):
        """
        Sets the items of this TagResult.

        :param items: The items of this TagResult.
        :type: TagRelationsItems
        """

        self._items = items

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, TagResult):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
