# coding: utf-8

"""
    Pluxbox Radiomanager Client

    Pluxbox RadioManager gives you the power, flexibility and speed you always wanted in a lightweight and easy-to-use web-based radio solution. With Pluxbox RadioManager you can organise your radio workflow and automate your omnichannel communication with your listeners. We offer wide range specialised services for the radio and connections like Hybrid Radio, Visual Radio, your website and social media without losing focus on your broadcast. For more information visit https://pluxbox.com

    OpenAPI spec version: 2.0
    Contact: support@pluxbox.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class UserResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'int',
        'email': 'str',
        'firstname': 'str',
        'lastname': 'str',
        'phone': 'str',
        'created_at': 'datetime',
        'updated_at': 'datetime',
        'active': 'bool',
        'settings': 'UserResultSettings',
        'language': 'bool',
        'active_external_station_id': 'int',
        'role_id': 'int'
    }

    attribute_map = {
        'id': 'id',
        'email': 'email',
        'firstname': 'firstname',
        'lastname': 'lastname',
        'phone': 'phone',
        'created_at': 'created_at',
        'updated_at': 'updated_at',
        'active': 'active',
        'settings': 'settings',
        'language': 'language',
        'active_external_station_id': 'active_external_station_id',
        'role_id': 'role_id'
    }

    def __init__(self, id=None, email=None, firstname=None, lastname=None, phone=None, created_at=None, updated_at=None, active=None, settings=None, language=None, active_external_station_id=None, role_id=None):
        """
        UserResult - a model defined in Swagger
        """

        self._id = None
        self._email = None
        self._firstname = None
        self._lastname = None
        self._phone = None
        self._created_at = None
        self._updated_at = None
        self._active = None
        self._settings = None
        self._language = None
        self._active_external_station_id = None
        self._role_id = None

        self.id = id
        self.email = email
        self.firstname = firstname
        self.lastname = lastname
        if phone is not None:
          self.phone = phone
        if created_at is not None:
          self.created_at = created_at
        if updated_at is not None:
          self.updated_at = updated_at
        if active is not None:
          self.active = active
        if settings is not None:
          self.settings = settings
        if language is not None:
          self.language = language
        if active_external_station_id is not None:
          self.active_external_station_id = active_external_station_id
        if role_id is not None:
          self.role_id = role_id

    @property
    def id(self):
        """
        Gets the id of this UserResult.

        :return: The id of this UserResult.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this UserResult.

        :param id: The id of this UserResult.
        :type: int
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")

        self._id = id

    @property
    def email(self):
        """
        Gets the email of this UserResult.

        :return: The email of this UserResult.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Sets the email of this UserResult.

        :param email: The email of this UserResult.
        :type: str
        """
        if email is None:
            raise ValueError("Invalid value for `email`, must not be `None`")

        self._email = email

    @property
    def firstname(self):
        """
        Gets the firstname of this UserResult.

        :return: The firstname of this UserResult.
        :rtype: str
        """
        return self._firstname

    @firstname.setter
    def firstname(self, firstname):
        """
        Sets the firstname of this UserResult.

        :param firstname: The firstname of this UserResult.
        :type: str
        """
        if firstname is None:
            raise ValueError("Invalid value for `firstname`, must not be `None`")

        self._firstname = firstname

    @property
    def lastname(self):
        """
        Gets the lastname of this UserResult.

        :return: The lastname of this UserResult.
        :rtype: str
        """
        return self._lastname

    @lastname.setter
    def lastname(self, lastname):
        """
        Sets the lastname of this UserResult.

        :param lastname: The lastname of this UserResult.
        :type: str
        """
        if lastname is None:
            raise ValueError("Invalid value for `lastname`, must not be `None`")

        self._lastname = lastname

    @property
    def phone(self):
        """
        Gets the phone of this UserResult.

        :return: The phone of this UserResult.
        :rtype: str
        """
        return self._phone

    @phone.setter
    def phone(self, phone):
        """
        Sets the phone of this UserResult.

        :param phone: The phone of this UserResult.
        :type: str
        """

        self._phone = phone

    @property
    def created_at(self):
        """
        Gets the created_at of this UserResult.

        :return: The created_at of this UserResult.
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """
        Sets the created_at of this UserResult.

        :param created_at: The created_at of this UserResult.
        :type: datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """
        Gets the updated_at of this UserResult.

        :return: The updated_at of this UserResult.
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """
        Sets the updated_at of this UserResult.

        :param updated_at: The updated_at of this UserResult.
        :type: datetime
        """

        self._updated_at = updated_at

    @property
    def active(self):
        """
        Gets the active of this UserResult.

        :return: The active of this UserResult.
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """
        Sets the active of this UserResult.

        :param active: The active of this UserResult.
        :type: bool
        """

        self._active = active

    @property
    def settings(self):
        """
        Gets the settings of this UserResult.

        :return: The settings of this UserResult.
        :rtype: UserResultSettings
        """
        return self._settings

    @settings.setter
    def settings(self, settings):
        """
        Sets the settings of this UserResult.

        :param settings: The settings of this UserResult.
        :type: UserResultSettings
        """

        self._settings = settings

    @property
    def language(self):
        """
        Gets the language of this UserResult.

        :return: The language of this UserResult.
        :rtype: bool
        """
        return self._language

    @language.setter
    def language(self, language):
        """
        Sets the language of this UserResult.

        :param language: The language of this UserResult.
        :type: bool
        """

        self._language = language

    @property
    def active_external_station_id(self):
        """
        Gets the active_external_station_id of this UserResult.

        :return: The active_external_station_id of this UserResult.
        :rtype: int
        """
        return self._active_external_station_id

    @active_external_station_id.setter
    def active_external_station_id(self, active_external_station_id):
        """
        Sets the active_external_station_id of this UserResult.

        :param active_external_station_id: The active_external_station_id of this UserResult.
        :type: int
        """

        self._active_external_station_id = active_external_station_id

    @property
    def role_id(self):
        """
        Gets the role_id of this UserResult.

        :return: The role_id of this UserResult.
        :rtype: int
        """
        return self._role_id

    @role_id.setter
    def role_id(self, role_id):
        """
        Sets the role_id of this UserResult.

        :param role_id: The role_id of this UserResult.
        :type: int
        """

        self._role_id = role_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, UserResult):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
