"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileFormat = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/file_format snowflake_file_format}
*/
class FileFormat extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/file_format snowflake_file_format} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FileFormatConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'snowflake_file_format',
            terraformGeneratorMetadata: {
                providerName: 'snowflake',
                providerVersion: '0.40.0',
                providerVersionConstraint: ' ~> 0.40'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._allowDuplicate = config.allowDuplicate;
        this._binaryAsText = config.binaryAsText;
        this._binaryFormat = config.binaryFormat;
        this._comment = config.comment;
        this._compression = config.compression;
        this._database = config.database;
        this._dateFormat = config.dateFormat;
        this._disableAutoConvert = config.disableAutoConvert;
        this._disableSnowflakeData = config.disableSnowflakeData;
        this._emptyFieldAsNull = config.emptyFieldAsNull;
        this._enableOctal = config.enableOctal;
        this._encoding = config.encoding;
        this._errorOnColumnCountMismatch = config.errorOnColumnCountMismatch;
        this._escape = config.escape;
        this._escapeUnenclosedField = config.escapeUnenclosedField;
        this._fieldDelimiter = config.fieldDelimiter;
        this._fieldOptionallyEnclosedBy = config.fieldOptionallyEnclosedBy;
        this._fileExtension = config.fileExtension;
        this._formatType = config.formatType;
        this._id = config.id;
        this._ignoreUtf8Errors = config.ignoreUtf8Errors;
        this._name = config.name;
        this._nullIf = config.nullIf;
        this._preserveSpace = config.preserveSpace;
        this._recordDelimiter = config.recordDelimiter;
        this._replaceInvalidCharacters = config.replaceInvalidCharacters;
        this._schema = config.schema;
        this._skipBlankLines = config.skipBlankLines;
        this._skipByteOrderMark = config.skipByteOrderMark;
        this._skipHeader = config.skipHeader;
        this._stripNullValues = config.stripNullValues;
        this._stripOuterArray = config.stripOuterArray;
        this._stripOuterElement = config.stripOuterElement;
        this._timeFormat = config.timeFormat;
        this._timestampFormat = config.timestampFormat;
        this._trimSpace = config.trimSpace;
        this._validateUtf8 = config.validateUtf8;
    }
    get allowDuplicate() {
        return this.getBooleanAttribute('allow_duplicate');
    }
    set allowDuplicate(value) {
        this._allowDuplicate = value;
    }
    resetAllowDuplicate() {
        this._allowDuplicate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowDuplicateInput() {
        return this._allowDuplicate;
    }
    get binaryAsText() {
        return this.getBooleanAttribute('binary_as_text');
    }
    set binaryAsText(value) {
        this._binaryAsText = value;
    }
    resetBinaryAsText() {
        this._binaryAsText = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get binaryAsTextInput() {
        return this._binaryAsText;
    }
    get binaryFormat() {
        return this.getStringAttribute('binary_format');
    }
    set binaryFormat(value) {
        this._binaryFormat = value;
    }
    resetBinaryFormat() {
        this._binaryFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get binaryFormatInput() {
        return this._binaryFormat;
    }
    get comment() {
        return this.getStringAttribute('comment');
    }
    set comment(value) {
        this._comment = value;
    }
    resetComment() {
        this._comment = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get commentInput() {
        return this._comment;
    }
    get compression() {
        return this.getStringAttribute('compression');
    }
    set compression(value) {
        this._compression = value;
    }
    resetCompression() {
        this._compression = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get compressionInput() {
        return this._compression;
    }
    get database() {
        return this.getStringAttribute('database');
    }
    set database(value) {
        this._database = value;
    }
    // Temporarily expose input value. Use with caution.
    get databaseInput() {
        return this._database;
    }
    get dateFormat() {
        return this.getStringAttribute('date_format');
    }
    set dateFormat(value) {
        this._dateFormat = value;
    }
    resetDateFormat() {
        this._dateFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get dateFormatInput() {
        return this._dateFormat;
    }
    get disableAutoConvert() {
        return this.getBooleanAttribute('disable_auto_convert');
    }
    set disableAutoConvert(value) {
        this._disableAutoConvert = value;
    }
    resetDisableAutoConvert() {
        this._disableAutoConvert = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableAutoConvertInput() {
        return this._disableAutoConvert;
    }
    get disableSnowflakeData() {
        return this.getBooleanAttribute('disable_snowflake_data');
    }
    set disableSnowflakeData(value) {
        this._disableSnowflakeData = value;
    }
    resetDisableSnowflakeData() {
        this._disableSnowflakeData = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableSnowflakeDataInput() {
        return this._disableSnowflakeData;
    }
    get emptyFieldAsNull() {
        return this.getBooleanAttribute('empty_field_as_null');
    }
    set emptyFieldAsNull(value) {
        this._emptyFieldAsNull = value;
    }
    resetEmptyFieldAsNull() {
        this._emptyFieldAsNull = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get emptyFieldAsNullInput() {
        return this._emptyFieldAsNull;
    }
    get enableOctal() {
        return this.getBooleanAttribute('enable_octal');
    }
    set enableOctal(value) {
        this._enableOctal = value;
    }
    resetEnableOctal() {
        this._enableOctal = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableOctalInput() {
        return this._enableOctal;
    }
    get encoding() {
        return this.getStringAttribute('encoding');
    }
    set encoding(value) {
        this._encoding = value;
    }
    resetEncoding() {
        this._encoding = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get encodingInput() {
        return this._encoding;
    }
    get errorOnColumnCountMismatch() {
        return this.getBooleanAttribute('error_on_column_count_mismatch');
    }
    set errorOnColumnCountMismatch(value) {
        this._errorOnColumnCountMismatch = value;
    }
    resetErrorOnColumnCountMismatch() {
        this._errorOnColumnCountMismatch = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get errorOnColumnCountMismatchInput() {
        return this._errorOnColumnCountMismatch;
    }
    get escape() {
        return this.getStringAttribute('escape');
    }
    set escape(value) {
        this._escape = value;
    }
    resetEscape() {
        this._escape = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get escapeInput() {
        return this._escape;
    }
    get escapeUnenclosedField() {
        return this.getStringAttribute('escape_unenclosed_field');
    }
    set escapeUnenclosedField(value) {
        this._escapeUnenclosedField = value;
    }
    resetEscapeUnenclosedField() {
        this._escapeUnenclosedField = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get escapeUnenclosedFieldInput() {
        return this._escapeUnenclosedField;
    }
    get fieldDelimiter() {
        return this.getStringAttribute('field_delimiter');
    }
    set fieldDelimiter(value) {
        this._fieldDelimiter = value;
    }
    resetFieldDelimiter() {
        this._fieldDelimiter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fieldDelimiterInput() {
        return this._fieldDelimiter;
    }
    get fieldOptionallyEnclosedBy() {
        return this.getStringAttribute('field_optionally_enclosed_by');
    }
    set fieldOptionallyEnclosedBy(value) {
        this._fieldOptionallyEnclosedBy = value;
    }
    resetFieldOptionallyEnclosedBy() {
        this._fieldOptionallyEnclosedBy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fieldOptionallyEnclosedByInput() {
        return this._fieldOptionallyEnclosedBy;
    }
    get fileExtension() {
        return this.getStringAttribute('file_extension');
    }
    set fileExtension(value) {
        this._fileExtension = value;
    }
    resetFileExtension() {
        this._fileExtension = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fileExtensionInput() {
        return this._fileExtension;
    }
    get formatType() {
        return this.getStringAttribute('format_type');
    }
    set formatType(value) {
        this._formatType = value;
    }
    // Temporarily expose input value. Use with caution.
    get formatTypeInput() {
        return this._formatType;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get ignoreUtf8Errors() {
        return this.getBooleanAttribute('ignore_utf8_errors');
    }
    set ignoreUtf8Errors(value) {
        this._ignoreUtf8Errors = value;
    }
    resetIgnoreUtf8Errors() {
        this._ignoreUtf8Errors = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ignoreUtf8ErrorsInput() {
        return this._ignoreUtf8Errors;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get nullIf() {
        return this.getListAttribute('null_if');
    }
    set nullIf(value) {
        this._nullIf = value;
    }
    resetNullIf() {
        this._nullIf = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get nullIfInput() {
        return this._nullIf;
    }
    get preserveSpace() {
        return this.getBooleanAttribute('preserve_space');
    }
    set preserveSpace(value) {
        this._preserveSpace = value;
    }
    resetPreserveSpace() {
        this._preserveSpace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get preserveSpaceInput() {
        return this._preserveSpace;
    }
    get recordDelimiter() {
        return this.getStringAttribute('record_delimiter');
    }
    set recordDelimiter(value) {
        this._recordDelimiter = value;
    }
    resetRecordDelimiter() {
        this._recordDelimiter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get recordDelimiterInput() {
        return this._recordDelimiter;
    }
    get replaceInvalidCharacters() {
        return this.getBooleanAttribute('replace_invalid_characters');
    }
    set replaceInvalidCharacters(value) {
        this._replaceInvalidCharacters = value;
    }
    resetReplaceInvalidCharacters() {
        this._replaceInvalidCharacters = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get replaceInvalidCharactersInput() {
        return this._replaceInvalidCharacters;
    }
    get schema() {
        return this.getStringAttribute('schema');
    }
    set schema(value) {
        this._schema = value;
    }
    // Temporarily expose input value. Use with caution.
    get schemaInput() {
        return this._schema;
    }
    get skipBlankLines() {
        return this.getBooleanAttribute('skip_blank_lines');
    }
    set skipBlankLines(value) {
        this._skipBlankLines = value;
    }
    resetSkipBlankLines() {
        this._skipBlankLines = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipBlankLinesInput() {
        return this._skipBlankLines;
    }
    get skipByteOrderMark() {
        return this.getBooleanAttribute('skip_byte_order_mark');
    }
    set skipByteOrderMark(value) {
        this._skipByteOrderMark = value;
    }
    resetSkipByteOrderMark() {
        this._skipByteOrderMark = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipByteOrderMarkInput() {
        return this._skipByteOrderMark;
    }
    get skipHeader() {
        return this.getNumberAttribute('skip_header');
    }
    set skipHeader(value) {
        this._skipHeader = value;
    }
    resetSkipHeader() {
        this._skipHeader = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipHeaderInput() {
        return this._skipHeader;
    }
    get stripNullValues() {
        return this.getBooleanAttribute('strip_null_values');
    }
    set stripNullValues(value) {
        this._stripNullValues = value;
    }
    resetStripNullValues() {
        this._stripNullValues = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get stripNullValuesInput() {
        return this._stripNullValues;
    }
    get stripOuterArray() {
        return this.getBooleanAttribute('strip_outer_array');
    }
    set stripOuterArray(value) {
        this._stripOuterArray = value;
    }
    resetStripOuterArray() {
        this._stripOuterArray = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get stripOuterArrayInput() {
        return this._stripOuterArray;
    }
    get stripOuterElement() {
        return this.getBooleanAttribute('strip_outer_element');
    }
    set stripOuterElement(value) {
        this._stripOuterElement = value;
    }
    resetStripOuterElement() {
        this._stripOuterElement = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get stripOuterElementInput() {
        return this._stripOuterElement;
    }
    get timeFormat() {
        return this.getStringAttribute('time_format');
    }
    set timeFormat(value) {
        this._timeFormat = value;
    }
    resetTimeFormat() {
        this._timeFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeFormatInput() {
        return this._timeFormat;
    }
    get timestampFormat() {
        return this.getStringAttribute('timestamp_format');
    }
    set timestampFormat(value) {
        this._timestampFormat = value;
    }
    resetTimestampFormat() {
        this._timestampFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timestampFormatInput() {
        return this._timestampFormat;
    }
    get trimSpace() {
        return this.getBooleanAttribute('trim_space');
    }
    set trimSpace(value) {
        this._trimSpace = value;
    }
    resetTrimSpace() {
        this._trimSpace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get trimSpaceInput() {
        return this._trimSpace;
    }
    get validateUtf8() {
        return this.getBooleanAttribute('validate_utf8');
    }
    set validateUtf8(value) {
        this._validateUtf8 = value;
    }
    resetValidateUtf8() {
        this._validateUtf8 = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get validateUtf8Input() {
        return this._validateUtf8;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allow_duplicate: cdktf.booleanToTerraform(this._allowDuplicate),
            binary_as_text: cdktf.booleanToTerraform(this._binaryAsText),
            binary_format: cdktf.stringToTerraform(this._binaryFormat),
            comment: cdktf.stringToTerraform(this._comment),
            compression: cdktf.stringToTerraform(this._compression),
            database: cdktf.stringToTerraform(this._database),
            date_format: cdktf.stringToTerraform(this._dateFormat),
            disable_auto_convert: cdktf.booleanToTerraform(this._disableAutoConvert),
            disable_snowflake_data: cdktf.booleanToTerraform(this._disableSnowflakeData),
            empty_field_as_null: cdktf.booleanToTerraform(this._emptyFieldAsNull),
            enable_octal: cdktf.booleanToTerraform(this._enableOctal),
            encoding: cdktf.stringToTerraform(this._encoding),
            error_on_column_count_mismatch: cdktf.booleanToTerraform(this._errorOnColumnCountMismatch),
            escape: cdktf.stringToTerraform(this._escape),
            escape_unenclosed_field: cdktf.stringToTerraform(this._escapeUnenclosedField),
            field_delimiter: cdktf.stringToTerraform(this._fieldDelimiter),
            field_optionally_enclosed_by: cdktf.stringToTerraform(this._fieldOptionallyEnclosedBy),
            file_extension: cdktf.stringToTerraform(this._fileExtension),
            format_type: cdktf.stringToTerraform(this._formatType),
            id: cdktf.stringToTerraform(this._id),
            ignore_utf8_errors: cdktf.booleanToTerraform(this._ignoreUtf8Errors),
            name: cdktf.stringToTerraform(this._name),
            null_if: cdktf.listMapper(cdktf.stringToTerraform, false)(this._nullIf),
            preserve_space: cdktf.booleanToTerraform(this._preserveSpace),
            record_delimiter: cdktf.stringToTerraform(this._recordDelimiter),
            replace_invalid_characters: cdktf.booleanToTerraform(this._replaceInvalidCharacters),
            schema: cdktf.stringToTerraform(this._schema),
            skip_blank_lines: cdktf.booleanToTerraform(this._skipBlankLines),
            skip_byte_order_mark: cdktf.booleanToTerraform(this._skipByteOrderMark),
            skip_header: cdktf.numberToTerraform(this._skipHeader),
            strip_null_values: cdktf.booleanToTerraform(this._stripNullValues),
            strip_outer_array: cdktf.booleanToTerraform(this._stripOuterArray),
            strip_outer_element: cdktf.booleanToTerraform(this._stripOuterElement),
            time_format: cdktf.stringToTerraform(this._timeFormat),
            timestamp_format: cdktf.stringToTerraform(this._timestampFormat),
            trim_space: cdktf.booleanToTerraform(this._trimSpace),
            validate_utf8: cdktf.booleanToTerraform(this._validateUtf8),
        };
    }
}
exports.FileFormat = FileFormat;
_a = JSII_RTTI_SYMBOL_1;
FileFormat[_a] = { fqn: "@cdktf/provider-snowflake.FileFormat", version: "2.0.1" };
// =================
// STATIC PROPERTIES
// =================
FileFormat.tfResourceType = "snowflake_file_format";
//# sourceMappingURL=data:application/json;base64,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