import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ResourceMonitorConfig extends cdktf.TerraformMetaArguments {
    /**
    * The number of credits allocated monthly to the resource monitor.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor#credit_quota ResourceMonitor#credit_quota}
    */
    readonly creditQuota?: number;
    /**
    * The date and time when the resource monitor suspends the assigned warehouses.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor#end_timestamp ResourceMonitor#end_timestamp}
    */
    readonly endTimestamp?: string;
    /**
    * The frequency interval at which the credit usage resets to 0. If you set a frequency for a resource monitor, you must also set START_TIMESTAMP.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor#frequency ResourceMonitor#frequency}
    */
    readonly frequency?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor#id ResourceMonitor#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Identifier for the resource monitor; must be unique for your account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor#name ResourceMonitor#name}
    */
    readonly name: string;
    /**
    * A list of percentage thresholds at which to send an alert to subscribed users.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor#notify_triggers ResourceMonitor#notify_triggers}
    */
    readonly notifyTriggers?: number[];
    /**
    * Specifies whether the resource monitor should be applied globally to your Snowflake account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor#set_for_account ResourceMonitor#set_for_account}
    */
    readonly setForAccount?: boolean | cdktf.IResolvable;
    /**
    * The date and time when the resource monitor starts monitoring credit usage for the assigned warehouses.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor#start_timestamp ResourceMonitor#start_timestamp}
    */
    readonly startTimestamp?: string;
    /**
    * A list of percentage thresholds at which to immediately suspend all warehouses.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor#suspend_immediate_triggers ResourceMonitor#suspend_immediate_triggers}
    */
    readonly suspendImmediateTriggers?: number[];
    /**
    * A list of percentage thresholds at which to suspend all warehouses.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor#suspend_triggers ResourceMonitor#suspend_triggers}
    */
    readonly suspendTriggers?: number[];
    /**
    * A list of warehouses to apply the resource monitor to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor#warehouses ResourceMonitor#warehouses}
    */
    readonly warehouses?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor snowflake_resource_monitor}
*/
export declare class ResourceMonitor extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_resource_monitor";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/resource_monitor snowflake_resource_monitor} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ResourceMonitorConfig
    */
    constructor(scope: Construct, id: string, config: ResourceMonitorConfig);
    private _creditQuota?;
    get creditQuota(): number;
    set creditQuota(value: number);
    resetCreditQuota(): void;
    get creditQuotaInput(): number | undefined;
    private _endTimestamp?;
    get endTimestamp(): string;
    set endTimestamp(value: string);
    resetEndTimestamp(): void;
    get endTimestampInput(): string | undefined;
    private _frequency?;
    get frequency(): string;
    set frequency(value: string);
    resetFrequency(): void;
    get frequencyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notifyTriggers?;
    get notifyTriggers(): number[];
    set notifyTriggers(value: number[]);
    resetNotifyTriggers(): void;
    get notifyTriggersInput(): number[] | undefined;
    private _setForAccount?;
    get setForAccount(): boolean | cdktf.IResolvable;
    set setForAccount(value: boolean | cdktf.IResolvable);
    resetSetForAccount(): void;
    get setForAccountInput(): boolean | cdktf.IResolvable | undefined;
    private _startTimestamp?;
    get startTimestamp(): string;
    set startTimestamp(value: string);
    resetStartTimestamp(): void;
    get startTimestampInput(): string | undefined;
    private _suspendImmediateTriggers?;
    get suspendImmediateTriggers(): number[];
    set suspendImmediateTriggers(value: number[]);
    resetSuspendImmediateTriggers(): void;
    get suspendImmediateTriggersInput(): number[] | undefined;
    private _suspendTriggers?;
    get suspendTriggers(): number[];
    set suspendTriggers(value: number[]);
    resetSuspendTriggers(): void;
    get suspendTriggersInput(): number[] | undefined;
    private _warehouses?;
    get warehouses(): string[];
    set warehouses(value: string[]);
    resetWarehouses(): void;
    get warehousesInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
