# coding: utf-8

"""
    FastAPI

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.4.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from perian.models.description import Description
from perian.models.memory_query_output import MemoryQueryOutput
from perian.models.name import Name
from perian.models.operator import Operator
from perian.models.query_options import QueryOptions
from typing import Optional, Set
from typing_extensions import Self

class AcceleratorQueryOutput(BaseModel):
    """
    Subquery for the accelerator attribute.
    """ # noqa: E501
    operator: Optional[Operator] = None
    options: Optional[QueryOptions] = None
    no: Optional[StrictInt] = None
    memory: Optional[MemoryQueryOutput] = None
    vendor: Optional[StrictStr] = None
    name: Optional[Name] = None
    description: Optional[Description] = None
    provider_specific_name: Optional[Dict[str, Any]] = None
    __properties: ClassVar[List[str]] = ["operator", "options", "no", "memory", "vendor", "name", "description", "provider_specific_name"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AcceleratorQueryOutput from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of options
        if self.options:
            _dict['options'] = self.options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of memory
        if self.memory:
            _dict['memory'] = self.memory.to_dict()
        # override the default output from pydantic by calling `to_dict()` of name
        if self.name:
            _dict['name'] = self.name.to_dict()
        # override the default output from pydantic by calling `to_dict()` of description
        if self.description:
            _dict['description'] = self.description.to_dict()
        # set to None if operator (nullable) is None
        # and model_fields_set contains the field
        if self.operator is None and "operator" in self.model_fields_set:
            _dict['operator'] = None

        # set to None if options (nullable) is None
        # and model_fields_set contains the field
        if self.options is None and "options" in self.model_fields_set:
            _dict['options'] = None

        # set to None if no (nullable) is None
        # and model_fields_set contains the field
        if self.no is None and "no" in self.model_fields_set:
            _dict['no'] = None

        # set to None if memory (nullable) is None
        # and model_fields_set contains the field
        if self.memory is None and "memory" in self.model_fields_set:
            _dict['memory'] = None

        # set to None if vendor (nullable) is None
        # and model_fields_set contains the field
        if self.vendor is None and "vendor" in self.model_fields_set:
            _dict['vendor'] = None

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if provider_specific_name (nullable) is None
        # and model_fields_set contains the field
        if self.provider_specific_name is None and "provider_specific_name" in self.model_fields_set:
            _dict['provider_specific_name'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AcceleratorQueryOutput from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "operator": obj.get("operator"),
            "options": QueryOptions.from_dict(obj["options"]) if obj.get("options") is not None else None,
            "no": obj.get("no"),
            "memory": MemoryQueryOutput.from_dict(obj["memory"]) if obj.get("memory") is not None else None,
            "vendor": obj.get("vendor"),
            "name": Name.from_dict(obj["name"]) if obj.get("name") is not None else None,
            "description": Description.from_dict(obj["description"]) if obj.get("description") is not None else None,
            "provider_specific_name": obj.get("provider_specific_name")
        })
        return _obj


