# coding: utf-8

"""
    FastAPI

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.4.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from perian.models.container_file import ContainerFile
from typing import Optional, Set
from typing_extensions import Self

class DockerRunParameters(BaseModel):
    """
    DockerRunParameters JSON schema for the docker_run_parameters JSON column.
    """ # noqa: E501
    image_name: Optional[StrictStr] = ''
    image_tag: Optional[StrictStr] = None
    command: Optional[StrictStr] = None
    env_variables: Optional[Dict[str, Any]] = None
    secrets: Optional[Dict[str, Any]] = None
    container_files: Optional[List[ContainerFile]] = None
    __properties: ClassVar[List[str]] = ["image_name", "image_tag", "command", "env_variables", "secrets", "container_files"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DockerRunParameters from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in container_files (list)
        _items = []
        if self.container_files:
            for _item in self.container_files:
                if _item:
                    _items.append(_item.to_dict())
            _dict['container_files'] = _items
        # set to None if image_tag (nullable) is None
        # and model_fields_set contains the field
        if self.image_tag is None and "image_tag" in self.model_fields_set:
            _dict['image_tag'] = None

        # set to None if command (nullable) is None
        # and model_fields_set contains the field
        if self.command is None and "command" in self.model_fields_set:
            _dict['command'] = None

        # set to None if env_variables (nullable) is None
        # and model_fields_set contains the field
        if self.env_variables is None and "env_variables" in self.model_fields_set:
            _dict['env_variables'] = None

        # set to None if secrets (nullable) is None
        # and model_fields_set contains the field
        if self.secrets is None and "secrets" in self.model_fields_set:
            _dict['secrets'] = None

        # set to None if container_files (nullable) is None
        # and model_fields_set contains the field
        if self.container_files is None and "container_files" in self.model_fields_set:
            _dict['container_files'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DockerRunParameters from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "image_name": obj.get("image_name") if obj.get("image_name") is not None else '',
            "image_tag": obj.get("image_tag"),
            "command": obj.get("command"),
            "env_variables": obj.get("env_variables"),
            "secrets": obj.get("secrets"),
            "container_files": [ContainerFile.from_dict(_item) for _item in obj["container_files"]] if obj.get("container_files") is not None else None
        })
        return _obj


