# coding: utf-8

"""
    FastAPI

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.4.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from perian.models.location import Location
from perian.models.provider_capabilities import ProviderCapabilities
from perian.models.provider_name import ProviderName
from perian.models.provider_properties import ProviderProperties
from perian.models.region import Region
from perian.models.status import Status
from typing import Optional, Set
from typing_extensions import Self

class Provider(BaseModel):
    """
    Provider database model.
    """ # noqa: E501
    id: Optional[StrictStr] = None
    name: Optional[ProviderName] = None
    name_short: Optional[StrictStr] = None
    regions: Optional[List[Region]] = None
    location: Optional[Location] = None
    status: Optional[Status] = None
    capabilities: Optional[List[ProviderCapabilities]] = None
    properties: Optional[ProviderProperties] = None
    created_at: Optional[datetime] = None
    updated_at: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["id", "name", "name_short", "regions", "location", "status", "capabilities", "properties", "created_at", "updated_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Provider from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in regions (list)
        _items = []
        if self.regions:
            for _item in self.regions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['regions'] = _items
        # override the default output from pydantic by calling `to_dict()` of properties
        if self.properties:
            _dict['properties'] = self.properties.to_dict()
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if name_short (nullable) is None
        # and model_fields_set contains the field
        if self.name_short is None and "name_short" in self.model_fields_set:
            _dict['name_short'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Provider from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "name_short": obj.get("name_short"),
            "regions": [Region.from_dict(_item) for _item in obj["regions"]] if obj.get("regions") is not None else None,
            "location": obj.get("location"),
            "status": obj.get("status"),
            "capabilities": obj.get("capabilities"),
            "properties": ProviderProperties.from_dict(obj["properties"]) if obj.get("properties") is not None else None,
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at")
        })
        return _obj


