# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSecurityZonesResult',
    'AwaitableGetSecurityZonesResult',
    'get_security_zones',
    'get_security_zones_output',
]

@pulumi.output_type
class GetSecurityZonesResult:
    """
    A collection of values returned by getSecurityZones.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, is_required_security_zones_in_subtree=None, security_recipe_id=None, security_zone_collections=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_required_security_zones_in_subtree and not isinstance(is_required_security_zones_in_subtree, bool):
            raise TypeError("Expected argument 'is_required_security_zones_in_subtree' to be a bool")
        pulumi.set(__self__, "is_required_security_zones_in_subtree", is_required_security_zones_in_subtree)
        if security_recipe_id and not isinstance(security_recipe_id, str):
            raise TypeError("Expected argument 'security_recipe_id' to be a str")
        pulumi.set(__self__, "security_recipe_id", security_recipe_id)
        if security_zone_collections and not isinstance(security_zone_collections, list):
            raise TypeError("Expected argument 'security_zone_collections' to be a list")
        pulumi.set(__self__, "security_zone_collections", security_zone_collections)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment for the security zone
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The security zone's display name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSecurityZonesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier that can’t be changed after creation
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isRequiredSecurityZonesInSubtree")
    def is_required_security_zones_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "is_required_security_zones_in_subtree")

    @property
    @pulumi.getter(name="securityRecipeId")
    def security_recipe_id(self) -> Optional[str]:
        return pulumi.get(self, "security_recipe_id")

    @property
    @pulumi.getter(name="securityZoneCollections")
    def security_zone_collections(self) -> Sequence['outputs.GetSecurityZonesSecurityZoneCollectionResult']:
        """
        The list of security_zone_collection.
        """
        return pulumi.get(self, "security_zone_collections")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current lifecycle state of the security zone
        """
        return pulumi.get(self, "state")


class AwaitableGetSecurityZonesResult(GetSecurityZonesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityZonesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            is_required_security_zones_in_subtree=self.is_required_security_zones_in_subtree,
            security_recipe_id=self.security_recipe_id,
            security_zone_collections=self.security_zone_collections,
            state=self.state)


def get_security_zones(compartment_id: Optional[str] = None,
                       display_name: Optional[str] = None,
                       filters: Optional[Sequence[pulumi.InputType['GetSecurityZonesFilterArgs']]] = None,
                       id: Optional[str] = None,
                       is_required_security_zones_in_subtree: Optional[bool] = None,
                       security_recipe_id: Optional[str] = None,
                       state: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityZonesResult:
    """
    This data source provides the list of Security Zones in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a list of security zones (SecurityZone resources) in a compartment identified by
    compartmentId. List is contained in a page of SecurityZoneSummary resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_zones = oci.CloudGuard.get_security_zones(compartment_id=compartment_id,
        display_name=security_zone_display_name,
        id=security_zone_id,
        is_required_security_zones_in_subtree=security_zone_is_required_security_zones_in_subtree,
        security_recipe_id=test_security_recipe["id"],
        state=security_zone_state)
    ```


    :param str compartment_id: The OCID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: The unique identifier of the security zone (`SecurityZone` resource).
    :param bool is_required_security_zones_in_subtree: Is security zones in the subtree?
    :param str security_recipe_id: The unique identifier of the security zone recipe. (`SecurityRecipe` resource).
    :param str state: The field lifecycle state. Only one state can be provided. Default value for state is active. If no value is specified state is active.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['isRequiredSecurityZonesInSubtree'] = is_required_security_zones_in_subtree
    __args__['securityRecipeId'] = security_recipe_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudGuard/getSecurityZones:getSecurityZones', __args__, opts=opts, typ=GetSecurityZonesResult).value

    return AwaitableGetSecurityZonesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_required_security_zones_in_subtree=pulumi.get(__ret__, 'is_required_security_zones_in_subtree'),
        security_recipe_id=pulumi.get(__ret__, 'security_recipe_id'),
        security_zone_collections=pulumi.get(__ret__, 'security_zone_collections'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_security_zones)
def get_security_zones_output(compartment_id: Optional[pulumi.Input[str]] = None,
                              display_name: Optional[pulumi.Input[Optional[str]]] = None,
                              filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetSecurityZonesFilterArgs']]]]] = None,
                              id: Optional[pulumi.Input[Optional[str]]] = None,
                              is_required_security_zones_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                              security_recipe_id: Optional[pulumi.Input[Optional[str]]] = None,
                              state: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSecurityZonesResult]:
    """
    This data source provides the list of Security Zones in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a list of security zones (SecurityZone resources) in a compartment identified by
    compartmentId. List is contained in a page of SecurityZoneSummary resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_zones = oci.CloudGuard.get_security_zones(compartment_id=compartment_id,
        display_name=security_zone_display_name,
        id=security_zone_id,
        is_required_security_zones_in_subtree=security_zone_is_required_security_zones_in_subtree,
        security_recipe_id=test_security_recipe["id"],
        state=security_zone_state)
    ```


    :param str compartment_id: The OCID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: The unique identifier of the security zone (`SecurityZone` resource).
    :param bool is_required_security_zones_in_subtree: Is security zones in the subtree?
    :param str security_recipe_id: The unique identifier of the security zone recipe. (`SecurityRecipe` resource).
    :param str state: The field lifecycle state. Only one state can be provided. Default value for state is active. If no value is specified state is active.
    """
    ...
