# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDrgRouteTablesResult',
    'AwaitableGetDrgRouteTablesResult',
    'get_drg_route_tables',
    'get_drg_route_tables_output',
]

@pulumi.output_type
class GetDrgRouteTablesResult:
    """
    A collection of values returned by getDrgRouteTables.
    """
    def __init__(__self__, display_name=None, drg_id=None, drg_route_tables=None, filters=None, id=None, import_drg_route_distribution_id=None, state=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if drg_id and not isinstance(drg_id, str):
            raise TypeError("Expected argument 'drg_id' to be a str")
        pulumi.set(__self__, "drg_id", drg_id)
        if drg_route_tables and not isinstance(drg_route_tables, list):
            raise TypeError("Expected argument 'drg_route_tables' to be a list")
        pulumi.set(__self__, "drg_route_tables", drg_route_tables)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if import_drg_route_distribution_id and not isinstance(import_drg_route_distribution_id, str):
            raise TypeError("Expected argument 'import_drg_route_distribution_id' to be a str")
        pulumi.set(__self__, "import_drg_route_distribution_id", import_drg_route_distribution_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="drgId")
    def drg_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG the DRG that contains this route table.
        """
        return pulumi.get(self, "drg_id")

    @property
    @pulumi.getter(name="drgRouteTables")
    def drg_route_tables(self) -> Sequence['outputs.GetDrgRouteTablesDrgRouteTableResult']:
        """
        The list of drg_route_tables.
        """
        return pulumi.get(self, "drg_route_tables")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDrgRouteTablesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="importDrgRouteDistributionId")
    def import_drg_route_distribution_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the import route distribution used to specify how incoming route advertisements from referenced attachments are inserted into the DRG route table.
        """
        return pulumi.get(self, "import_drg_route_distribution_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The DRG route table's current state.
        """
        return pulumi.get(self, "state")


class AwaitableGetDrgRouteTablesResult(GetDrgRouteTablesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDrgRouteTablesResult(
            display_name=self.display_name,
            drg_id=self.drg_id,
            drg_route_tables=self.drg_route_tables,
            filters=self.filters,
            id=self.id,
            import_drg_route_distribution_id=self.import_drg_route_distribution_id,
            state=self.state)


def get_drg_route_tables(display_name: Optional[str] = None,
                         drg_id: Optional[str] = None,
                         filters: Optional[Sequence[pulumi.InputType['GetDrgRouteTablesFilterArgs']]] = None,
                         import_drg_route_distribution_id: Optional[str] = None,
                         state: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDrgRouteTablesResult:
    """
    This data source provides the list of Drg Route Tables in Oracle Cloud Infrastructure Core service.

    Lists the DRG route tables for the specified DRG.

    Use the `ListDrgRouteRules` operation to retrieve the route rules in a table.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_drg_route_tables = oci.Core.get_drg_route_tables(drg_id=test_drg["id"],
        display_name=drg_route_table_display_name,
        import_drg_route_distribution_id=test_drg_route_distribution["id"],
        state=drg_route_table_state)
    ```


    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str drg_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
    :param str import_drg_route_distribution_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the import route distribution.
    :param str state: A filter that only returns matches for the specified lifecycle state. The value is case insensitive.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['drgId'] = drg_id
    __args__['filters'] = filters
    __args__['importDrgRouteDistributionId'] = import_drg_route_distribution_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getDrgRouteTables:getDrgRouteTables', __args__, opts=opts, typ=GetDrgRouteTablesResult).value

    return AwaitableGetDrgRouteTablesResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        drg_id=pulumi.get(__ret__, 'drg_id'),
        drg_route_tables=pulumi.get(__ret__, 'drg_route_tables'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        import_drg_route_distribution_id=pulumi.get(__ret__, 'import_drg_route_distribution_id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_drg_route_tables)
def get_drg_route_tables_output(display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                drg_id: Optional[pulumi.Input[str]] = None,
                                filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetDrgRouteTablesFilterArgs']]]]] = None,
                                import_drg_route_distribution_id: Optional[pulumi.Input[Optional[str]]] = None,
                                state: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDrgRouteTablesResult]:
    """
    This data source provides the list of Drg Route Tables in Oracle Cloud Infrastructure Core service.

    Lists the DRG route tables for the specified DRG.

    Use the `ListDrgRouteRules` operation to retrieve the route rules in a table.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_drg_route_tables = oci.Core.get_drg_route_tables(drg_id=test_drg["id"],
        display_name=drg_route_table_display_name,
        import_drg_route_distribution_id=test_drg_route_distribution["id"],
        state=drg_route_table_state)
    ```


    :param str display_name: A filter to return only resources that match the given display name exactly.
    :param str drg_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
    :param str import_drg_route_distribution_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the import route distribution.
    :param str state: A filter that only returns matches for the specified lifecycle state. The value is case insensitive.
    """
    ...
