# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDataGuardAssociationResult',
    'AwaitableGetDataGuardAssociationResult',
    'get_data_guard_association',
    'get_data_guard_association_output',
]

@pulumi.output_type
class GetDataGuardAssociationResult:
    """
    A collection of values returned by getDataGuardAssociation.
    """
    def __init__(__self__, apply_lag=None, apply_rate=None, availability_domain=None, backup_network_nsg_ids=None, cpu_core_count=None, create_async=None, creation_type=None, data_collection_options=None, data_guard_association_id=None, database_admin_password=None, database_defined_tags=None, database_freeform_tags=None, database_id=None, database_software_image_id=None, db_system_defined_tags=None, db_system_freeform_tags=None, delete_standby_db_home_on_delete=None, display_name=None, fault_domains=None, hostname=None, id=None, is_active_data_guard_enabled=None, license_model=None, lifecycle_details=None, node_count=None, nsg_ids=None, peer_data_guard_association_id=None, peer_database_id=None, peer_db_home_id=None, peer_db_system_id=None, peer_db_unique_name=None, peer_role=None, peer_sid_prefix=None, peer_vm_cluster_id=None, private_ip=None, protection_mode=None, role=None, shape=None, state=None, storage_volume_performance_mode=None, subnet_id=None, time_created=None, time_zone=None, transport_type=None):
        if apply_lag and not isinstance(apply_lag, str):
            raise TypeError("Expected argument 'apply_lag' to be a str")
        pulumi.set(__self__, "apply_lag", apply_lag)
        if apply_rate and not isinstance(apply_rate, str):
            raise TypeError("Expected argument 'apply_rate' to be a str")
        pulumi.set(__self__, "apply_rate", apply_rate)
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if backup_network_nsg_ids and not isinstance(backup_network_nsg_ids, list):
            raise TypeError("Expected argument 'backup_network_nsg_ids' to be a list")
        pulumi.set(__self__, "backup_network_nsg_ids", backup_network_nsg_ids)
        if cpu_core_count and not isinstance(cpu_core_count, int):
            raise TypeError("Expected argument 'cpu_core_count' to be a int")
        pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if create_async and not isinstance(create_async, bool):
            raise TypeError("Expected argument 'create_async' to be a bool")
        pulumi.set(__self__, "create_async", create_async)
        if creation_type and not isinstance(creation_type, str):
            raise TypeError("Expected argument 'creation_type' to be a str")
        pulumi.set(__self__, "creation_type", creation_type)
        if data_collection_options and not isinstance(data_collection_options, list):
            raise TypeError("Expected argument 'data_collection_options' to be a list")
        pulumi.set(__self__, "data_collection_options", data_collection_options)
        if data_guard_association_id and not isinstance(data_guard_association_id, str):
            raise TypeError("Expected argument 'data_guard_association_id' to be a str")
        pulumi.set(__self__, "data_guard_association_id", data_guard_association_id)
        if database_admin_password and not isinstance(database_admin_password, str):
            raise TypeError("Expected argument 'database_admin_password' to be a str")
        pulumi.set(__self__, "database_admin_password", database_admin_password)
        if database_defined_tags and not isinstance(database_defined_tags, dict):
            raise TypeError("Expected argument 'database_defined_tags' to be a dict")
        pulumi.set(__self__, "database_defined_tags", database_defined_tags)
        if database_freeform_tags and not isinstance(database_freeform_tags, dict):
            raise TypeError("Expected argument 'database_freeform_tags' to be a dict")
        pulumi.set(__self__, "database_freeform_tags", database_freeform_tags)
        if database_id and not isinstance(database_id, str):
            raise TypeError("Expected argument 'database_id' to be a str")
        pulumi.set(__self__, "database_id", database_id)
        if database_software_image_id and not isinstance(database_software_image_id, str):
            raise TypeError("Expected argument 'database_software_image_id' to be a str")
        pulumi.set(__self__, "database_software_image_id", database_software_image_id)
        if db_system_defined_tags and not isinstance(db_system_defined_tags, dict):
            raise TypeError("Expected argument 'db_system_defined_tags' to be a dict")
        pulumi.set(__self__, "db_system_defined_tags", db_system_defined_tags)
        if db_system_freeform_tags and not isinstance(db_system_freeform_tags, dict):
            raise TypeError("Expected argument 'db_system_freeform_tags' to be a dict")
        pulumi.set(__self__, "db_system_freeform_tags", db_system_freeform_tags)
        if delete_standby_db_home_on_delete and not isinstance(delete_standby_db_home_on_delete, str):
            raise TypeError("Expected argument 'delete_standby_db_home_on_delete' to be a str")
        pulumi.set(__self__, "delete_standby_db_home_on_delete", delete_standby_db_home_on_delete)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if fault_domains and not isinstance(fault_domains, list):
            raise TypeError("Expected argument 'fault_domains' to be a list")
        pulumi.set(__self__, "fault_domains", fault_domains)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_active_data_guard_enabled and not isinstance(is_active_data_guard_enabled, bool):
            raise TypeError("Expected argument 'is_active_data_guard_enabled' to be a bool")
        pulumi.set(__self__, "is_active_data_guard_enabled", is_active_data_guard_enabled)
        if license_model and not isinstance(license_model, str):
            raise TypeError("Expected argument 'license_model' to be a str")
        pulumi.set(__self__, "license_model", license_model)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if node_count and not isinstance(node_count, int):
            raise TypeError("Expected argument 'node_count' to be a int")
        pulumi.set(__self__, "node_count", node_count)
        if nsg_ids and not isinstance(nsg_ids, list):
            raise TypeError("Expected argument 'nsg_ids' to be a list")
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        if peer_data_guard_association_id and not isinstance(peer_data_guard_association_id, str):
            raise TypeError("Expected argument 'peer_data_guard_association_id' to be a str")
        pulumi.set(__self__, "peer_data_guard_association_id", peer_data_guard_association_id)
        if peer_database_id and not isinstance(peer_database_id, str):
            raise TypeError("Expected argument 'peer_database_id' to be a str")
        pulumi.set(__self__, "peer_database_id", peer_database_id)
        if peer_db_home_id and not isinstance(peer_db_home_id, str):
            raise TypeError("Expected argument 'peer_db_home_id' to be a str")
        pulumi.set(__self__, "peer_db_home_id", peer_db_home_id)
        if peer_db_system_id and not isinstance(peer_db_system_id, str):
            raise TypeError("Expected argument 'peer_db_system_id' to be a str")
        pulumi.set(__self__, "peer_db_system_id", peer_db_system_id)
        if peer_db_unique_name and not isinstance(peer_db_unique_name, str):
            raise TypeError("Expected argument 'peer_db_unique_name' to be a str")
        pulumi.set(__self__, "peer_db_unique_name", peer_db_unique_name)
        if peer_role and not isinstance(peer_role, str):
            raise TypeError("Expected argument 'peer_role' to be a str")
        pulumi.set(__self__, "peer_role", peer_role)
        if peer_sid_prefix and not isinstance(peer_sid_prefix, str):
            raise TypeError("Expected argument 'peer_sid_prefix' to be a str")
        pulumi.set(__self__, "peer_sid_prefix", peer_sid_prefix)
        if peer_vm_cluster_id and not isinstance(peer_vm_cluster_id, str):
            raise TypeError("Expected argument 'peer_vm_cluster_id' to be a str")
        pulumi.set(__self__, "peer_vm_cluster_id", peer_vm_cluster_id)
        if private_ip and not isinstance(private_ip, str):
            raise TypeError("Expected argument 'private_ip' to be a str")
        pulumi.set(__self__, "private_ip", private_ip)
        if protection_mode and not isinstance(protection_mode, str):
            raise TypeError("Expected argument 'protection_mode' to be a str")
        pulumi.set(__self__, "protection_mode", protection_mode)
        if role and not isinstance(role, str):
            raise TypeError("Expected argument 'role' to be a str")
        pulumi.set(__self__, "role", role)
        if shape and not isinstance(shape, str):
            raise TypeError("Expected argument 'shape' to be a str")
        pulumi.set(__self__, "shape", shape)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if storage_volume_performance_mode and not isinstance(storage_volume_performance_mode, str):
            raise TypeError("Expected argument 'storage_volume_performance_mode' to be a str")
        pulumi.set(__self__, "storage_volume_performance_mode", storage_volume_performance_mode)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_zone and not isinstance(time_zone, str):
            raise TypeError("Expected argument 'time_zone' to be a str")
        pulumi.set(__self__, "time_zone", time_zone)
        if transport_type and not isinstance(transport_type, str):
            raise TypeError("Expected argument 'transport_type' to be a str")
        pulumi.set(__self__, "transport_type", transport_type)

    @property
    @pulumi.getter(name="applyLag")
    def apply_lag(self) -> str:
        """
        The lag time between updates to the primary database and application of the redo data on the standby database, as computed by the reporting database.  Example: `9 seconds`
        """
        return pulumi.get(self, "apply_lag")

    @property
    @pulumi.getter(name="applyRate")
    def apply_rate(self) -> str:
        """
        The rate at which redo logs are synced between the associated databases.  Example: `180 Mb per second`
        """
        return pulumi.get(self, "apply_rate")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="backupNetworkNsgIds")
    def backup_network_nsg_ids(self) -> Sequence[str]:
        return pulumi.get(self, "backup_network_nsg_ids")

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> int:
        return pulumi.get(self, "cpu_core_count")

    @property
    @pulumi.getter(name="createAsync")
    def create_async(self) -> bool:
        return pulumi.get(self, "create_async")

    @property
    @pulumi.getter(name="creationType")
    def creation_type(self) -> str:
        return pulumi.get(self, "creation_type")

    @property
    @pulumi.getter(name="dataCollectionOptions")
    def data_collection_options(self) -> Sequence['outputs.GetDataGuardAssociationDataCollectionOptionResult']:
        return pulumi.get(self, "data_collection_options")

    @property
    @pulumi.getter(name="dataGuardAssociationId")
    def data_guard_association_id(self) -> str:
        return pulumi.get(self, "data_guard_association_id")

    @property
    @pulumi.getter(name="databaseAdminPassword")
    def database_admin_password(self) -> str:
        return pulumi.get(self, "database_admin_password")

    @property
    @pulumi.getter(name="databaseDefinedTags")
    def database_defined_tags(self) -> Mapping[str, Any]:
        return pulumi.get(self, "database_defined_tags")

    @property
    @pulumi.getter(name="databaseFreeformTags")
    def database_freeform_tags(self) -> Mapping[str, Any]:
        return pulumi.get(self, "database_freeform_tags")

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the reporting database.
        """
        return pulumi.get(self, "database_id")

    @property
    @pulumi.getter(name="databaseSoftwareImageId")
    def database_software_image_id(self) -> str:
        return pulumi.get(self, "database_software_image_id")

    @property
    @pulumi.getter(name="dbSystemDefinedTags")
    def db_system_defined_tags(self) -> Mapping[str, Any]:
        return pulumi.get(self, "db_system_defined_tags")

    @property
    @pulumi.getter(name="dbSystemFreeformTags")
    def db_system_freeform_tags(self) -> Mapping[str, Any]:
        return pulumi.get(self, "db_system_freeform_tags")

    @property
    @pulumi.getter(name="deleteStandbyDbHomeOnDelete")
    def delete_standby_db_home_on_delete(self) -> str:
        return pulumi.get(self, "delete_standby_db_home_on_delete")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> Sequence[str]:
        return pulumi.get(self, "fault_domains")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Data Guard association.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isActiveDataGuardEnabled")
    def is_active_data_guard_enabled(self) -> bool:
        """
        True if active Data Guard is enabled.
        """
        return pulumi.get(self, "is_active_data_guard_enabled")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> str:
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional information about the current lifecycleState, if available.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> int:
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[str]:
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="peerDataGuardAssociationId")
    def peer_data_guard_association_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer database's Data Guard association.
        """
        return pulumi.get(self, "peer_data_guard_association_id")

    @property
    @pulumi.getter(name="peerDatabaseId")
    def peer_database_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated peer database.
        """
        return pulumi.get(self, "peer_database_id")

    @property
    @pulumi.getter(name="peerDbHomeId")
    def peer_db_home_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Home containing the associated peer database.
        """
        return pulumi.get(self, "peer_db_home_id")

    @property
    @pulumi.getter(name="peerDbSystemId")
    def peer_db_system_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system containing the associated peer database.
        """
        return pulumi.get(self, "peer_db_system_id")

    @property
    @pulumi.getter(name="peerDbUniqueName")
    def peer_db_unique_name(self) -> str:
        return pulumi.get(self, "peer_db_unique_name")

    @property
    @pulumi.getter(name="peerRole")
    def peer_role(self) -> str:
        """
        The role of the peer database in this Data Guard association.
        """
        return pulumi.get(self, "peer_role")

    @property
    @pulumi.getter(name="peerSidPrefix")
    def peer_sid_prefix(self) -> str:
        return pulumi.get(self, "peer_sid_prefix")

    @property
    @pulumi.getter(name="peerVmClusterId")
    def peer_vm_cluster_id(self) -> str:
        return pulumi.get(self, "peer_vm_cluster_id")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="protectionMode")
    def protection_mode(self) -> str:
        """
        The protection mode of this Data Guard association. For more information, see [Oracle Data Guard Protection Modes](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000) in the Oracle Data Guard documentation.
        """
        return pulumi.get(self, "protection_mode")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The role of the reporting database in this Data Guard association.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def shape(self) -> str:
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Data Guard association.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageVolumePerformanceMode")
    def storage_volume_performance_mode(self) -> str:
        return pulumi.get(self, "storage_volume_performance_mode")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the Data Guard association was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> str:
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="transportType")
    def transport_type(self) -> str:
        """
        The redo transport type used by this Data Guard association.  For more information, see [Redo Transport Services](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-redo-transport-services.htm#SBYDB00400) in the Oracle Data Guard documentation.
        """
        return pulumi.get(self, "transport_type")


class AwaitableGetDataGuardAssociationResult(GetDataGuardAssociationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataGuardAssociationResult(
            apply_lag=self.apply_lag,
            apply_rate=self.apply_rate,
            availability_domain=self.availability_domain,
            backup_network_nsg_ids=self.backup_network_nsg_ids,
            cpu_core_count=self.cpu_core_count,
            create_async=self.create_async,
            creation_type=self.creation_type,
            data_collection_options=self.data_collection_options,
            data_guard_association_id=self.data_guard_association_id,
            database_admin_password=self.database_admin_password,
            database_defined_tags=self.database_defined_tags,
            database_freeform_tags=self.database_freeform_tags,
            database_id=self.database_id,
            database_software_image_id=self.database_software_image_id,
            db_system_defined_tags=self.db_system_defined_tags,
            db_system_freeform_tags=self.db_system_freeform_tags,
            delete_standby_db_home_on_delete=self.delete_standby_db_home_on_delete,
            display_name=self.display_name,
            fault_domains=self.fault_domains,
            hostname=self.hostname,
            id=self.id,
            is_active_data_guard_enabled=self.is_active_data_guard_enabled,
            license_model=self.license_model,
            lifecycle_details=self.lifecycle_details,
            node_count=self.node_count,
            nsg_ids=self.nsg_ids,
            peer_data_guard_association_id=self.peer_data_guard_association_id,
            peer_database_id=self.peer_database_id,
            peer_db_home_id=self.peer_db_home_id,
            peer_db_system_id=self.peer_db_system_id,
            peer_db_unique_name=self.peer_db_unique_name,
            peer_role=self.peer_role,
            peer_sid_prefix=self.peer_sid_prefix,
            peer_vm_cluster_id=self.peer_vm_cluster_id,
            private_ip=self.private_ip,
            protection_mode=self.protection_mode,
            role=self.role,
            shape=self.shape,
            state=self.state,
            storage_volume_performance_mode=self.storage_volume_performance_mode,
            subnet_id=self.subnet_id,
            time_created=self.time_created,
            time_zone=self.time_zone,
            transport_type=self.transport_type)


def get_data_guard_association(data_guard_association_id: Optional[str] = None,
                               database_id: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataGuardAssociationResult:
    """
    This data source provides details about a specific Data Guard Association resource in Oracle Cloud Infrastructure Database service.

    Gets the specified Data Guard association's configuration information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_guard_association = oci.Database.get_data_guard_association(data_guard_association_id=test_data_guard_association_oci_database_data_guard_association["id"],
        database_id=test_database["id"])
    ```


    :param str data_guard_association_id: The Data Guard association's [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['dataGuardAssociationId'] = data_guard_association_id
    __args__['databaseId'] = database_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDataGuardAssociation:getDataGuardAssociation', __args__, opts=opts, typ=GetDataGuardAssociationResult).value

    return AwaitableGetDataGuardAssociationResult(
        apply_lag=pulumi.get(__ret__, 'apply_lag'),
        apply_rate=pulumi.get(__ret__, 'apply_rate'),
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        backup_network_nsg_ids=pulumi.get(__ret__, 'backup_network_nsg_ids'),
        cpu_core_count=pulumi.get(__ret__, 'cpu_core_count'),
        create_async=pulumi.get(__ret__, 'create_async'),
        creation_type=pulumi.get(__ret__, 'creation_type'),
        data_collection_options=pulumi.get(__ret__, 'data_collection_options'),
        data_guard_association_id=pulumi.get(__ret__, 'data_guard_association_id'),
        database_admin_password=pulumi.get(__ret__, 'database_admin_password'),
        database_defined_tags=pulumi.get(__ret__, 'database_defined_tags'),
        database_freeform_tags=pulumi.get(__ret__, 'database_freeform_tags'),
        database_id=pulumi.get(__ret__, 'database_id'),
        database_software_image_id=pulumi.get(__ret__, 'database_software_image_id'),
        db_system_defined_tags=pulumi.get(__ret__, 'db_system_defined_tags'),
        db_system_freeform_tags=pulumi.get(__ret__, 'db_system_freeform_tags'),
        delete_standby_db_home_on_delete=pulumi.get(__ret__, 'delete_standby_db_home_on_delete'),
        display_name=pulumi.get(__ret__, 'display_name'),
        fault_domains=pulumi.get(__ret__, 'fault_domains'),
        hostname=pulumi.get(__ret__, 'hostname'),
        id=pulumi.get(__ret__, 'id'),
        is_active_data_guard_enabled=pulumi.get(__ret__, 'is_active_data_guard_enabled'),
        license_model=pulumi.get(__ret__, 'license_model'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        node_count=pulumi.get(__ret__, 'node_count'),
        nsg_ids=pulumi.get(__ret__, 'nsg_ids'),
        peer_data_guard_association_id=pulumi.get(__ret__, 'peer_data_guard_association_id'),
        peer_database_id=pulumi.get(__ret__, 'peer_database_id'),
        peer_db_home_id=pulumi.get(__ret__, 'peer_db_home_id'),
        peer_db_system_id=pulumi.get(__ret__, 'peer_db_system_id'),
        peer_db_unique_name=pulumi.get(__ret__, 'peer_db_unique_name'),
        peer_role=pulumi.get(__ret__, 'peer_role'),
        peer_sid_prefix=pulumi.get(__ret__, 'peer_sid_prefix'),
        peer_vm_cluster_id=pulumi.get(__ret__, 'peer_vm_cluster_id'),
        private_ip=pulumi.get(__ret__, 'private_ip'),
        protection_mode=pulumi.get(__ret__, 'protection_mode'),
        role=pulumi.get(__ret__, 'role'),
        shape=pulumi.get(__ret__, 'shape'),
        state=pulumi.get(__ret__, 'state'),
        storage_volume_performance_mode=pulumi.get(__ret__, 'storage_volume_performance_mode'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_zone=pulumi.get(__ret__, 'time_zone'),
        transport_type=pulumi.get(__ret__, 'transport_type'))


@_utilities.lift_output_func(get_data_guard_association)
def get_data_guard_association_output(data_guard_association_id: Optional[pulumi.Input[str]] = None,
                                      database_id: Optional[pulumi.Input[str]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDataGuardAssociationResult]:
    """
    This data source provides details about a specific Data Guard Association resource in Oracle Cloud Infrastructure Database service.

    Gets the specified Data Guard association's configuration information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_guard_association = oci.Database.get_data_guard_association(data_guard_association_id=test_data_guard_association_oci_database_data_guard_association["id"],
        database_id=test_database["id"])
    ```


    :param str data_guard_association_id: The Data Guard association's [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    ...
