# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDrPlanResult',
    'AwaitableGetDrPlanResult',
    'get_dr_plan',
    'get_dr_plan_output',
]

@pulumi.output_type
class GetDrPlanResult:
    """
    A collection of values returned by getDrPlan.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, display_name=None, dr_plan_id=None, dr_protection_group_id=None, freeform_tags=None, id=None, life_cycle_details=None, peer_dr_protection_group_id=None, peer_region=None, plan_groups=None, state=None, system_tags=None, time_created=None, time_updated=None, type=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if dr_plan_id and not isinstance(dr_plan_id, str):
            raise TypeError("Expected argument 'dr_plan_id' to be a str")
        pulumi.set(__self__, "dr_plan_id", dr_plan_id)
        if dr_protection_group_id and not isinstance(dr_protection_group_id, str):
            raise TypeError("Expected argument 'dr_protection_group_id' to be a str")
        pulumi.set(__self__, "dr_protection_group_id", dr_protection_group_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if life_cycle_details and not isinstance(life_cycle_details, str):
            raise TypeError("Expected argument 'life_cycle_details' to be a str")
        pulumi.set(__self__, "life_cycle_details", life_cycle_details)
        if peer_dr_protection_group_id and not isinstance(peer_dr_protection_group_id, str):
            raise TypeError("Expected argument 'peer_dr_protection_group_id' to be a str")
        pulumi.set(__self__, "peer_dr_protection_group_id", peer_dr_protection_group_id)
        if peer_region and not isinstance(peer_region, str):
            raise TypeError("Expected argument 'peer_region' to be a str")
        pulumi.set(__self__, "peer_region", peer_region)
        if plan_groups and not isinstance(plan_groups, list):
            raise TypeError("Expected argument 'plan_groups' to be a list")
        pulumi.set(__self__, "plan_groups", plan_groups)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing the DR plan.  Example: `ocid1.compartment.oc1..uniqueID`
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the group.  Example: `DATABASE_SWITCHOVER`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="drPlanId")
    def dr_plan_id(self) -> str:
        return pulumi.get(self, "dr_plan_id")

    @property
    @pulumi.getter(name="drProtectionGroupId")
    def dr_protection_group_id(self) -> str:
        """
        The OCID of the DR protection group to which this DR plan belongs.  Example: `ocid1.drplan.oc1..uniqueID`
        """
        return pulumi.get(self, "dr_protection_group_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique id of the step. Must not be modified by the user.  Example: `sgid1.step..uniqueID`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifeCycleDetails")
    def life_cycle_details(self) -> str:
        """
        A message describing the DR plan's current state in more detail.
        """
        return pulumi.get(self, "life_cycle_details")

    @property
    @pulumi.getter(name="peerDrProtectionGroupId")
    def peer_dr_protection_group_id(self) -> str:
        """
        The OCID of the peer DR protection group associated with this plan's DR protection group.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
        """
        return pulumi.get(self, "peer_dr_protection_group_id")

    @property
    @pulumi.getter(name="peerRegion")
    def peer_region(self) -> str:
        """
        The region of the peer DR protection group associated with this plan's DR protection group.  Example: `us-ashburn-1`
        """
        return pulumi.get(self, "peer_region")

    @property
    @pulumi.getter(name="planGroups")
    def plan_groups(self) -> Sequence['outputs.GetDrPlanPlanGroupResult']:
        """
        The list of groups in this DR plan.
        """
        return pulumi.get(self, "plan_groups")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the DR plan.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the DR plan was created. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the DR plan was updated. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the DR plan.
        """
        return pulumi.get(self, "type")


class AwaitableGetDrPlanResult(GetDrPlanResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDrPlanResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            dr_plan_id=self.dr_plan_id,
            dr_protection_group_id=self.dr_protection_group_id,
            freeform_tags=self.freeform_tags,
            id=self.id,
            life_cycle_details=self.life_cycle_details,
            peer_dr_protection_group_id=self.peer_dr_protection_group_id,
            peer_region=self.peer_region,
            plan_groups=self.plan_groups,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            type=self.type)


def get_dr_plan(dr_plan_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDrPlanResult:
    """
    This data source provides details about a specific Dr Plan resource in Oracle Cloud Infrastructure Disaster Recovery service.

    Get details for the DR plan identified by *drPlanId*.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dr_plan = oci.DisasterRecovery.get_dr_plan(dr_plan_id=test_dr_plan_oci_disaster_recovery_dr_plan["id"])
    ```


    :param str dr_plan_id: The OCID of the DR plan.  Example: `ocid1.drplan.oc1..uniqueID`
    """
    __args__ = dict()
    __args__['drPlanId'] = dr_plan_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DisasterRecovery/getDrPlan:getDrPlan', __args__, opts=opts, typ=GetDrPlanResult).value

    return AwaitableGetDrPlanResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        dr_plan_id=pulumi.get(__ret__, 'dr_plan_id'),
        dr_protection_group_id=pulumi.get(__ret__, 'dr_protection_group_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        life_cycle_details=pulumi.get(__ret__, 'life_cycle_details'),
        peer_dr_protection_group_id=pulumi.get(__ret__, 'peer_dr_protection_group_id'),
        peer_region=pulumi.get(__ret__, 'peer_region'),
        plan_groups=pulumi.get(__ret__, 'plan_groups'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        type=pulumi.get(__ret__, 'type'))


@_utilities.lift_output_func(get_dr_plan)
def get_dr_plan_output(dr_plan_id: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDrPlanResult]:
    """
    This data source provides details about a specific Dr Plan resource in Oracle Cloud Infrastructure Disaster Recovery service.

    Get details for the DR plan identified by *drPlanId*.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dr_plan = oci.DisasterRecovery.get_dr_plan(dr_plan_id=test_dr_plan_oci_disaster_recovery_dr_plan["id"])
    ```


    :param str dr_plan_id: The OCID of the DR plan.  Example: `ocid1.drplan.oc1..uniqueID`
    """
    ...
