# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PipelineArgs', 'Pipeline']

@pulumi.input_type
class PipelineArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 step_details: pulumi.Input[Sequence[pulumi.Input['PipelineStepDetailArgs']]],
                 configuration_details: Optional[pulumi.Input['PipelineConfigurationDetailsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 delete_related_pipeline_runs: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 infrastructure_configuration_details: Optional[pulumi.Input['PipelineInfrastructureConfigurationDetailsArgs']] = None,
                 log_configuration_details: Optional[pulumi.Input['PipelineLogConfigurationDetailsArgs']] = None,
                 step_artifact: Optional[pulumi.Input['PipelineStepArtifactArgs']] = None):
        """
        The set of arguments for constructing a Pipeline resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the pipeline.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the pipeline with.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineStepDetailArgs']]] step_details: (Updatable) Array of step details for each step.
        :param pulumi.Input['PipelineConfigurationDetailsArgs'] configuration_details: (Updatable) The configuration details of a pipeline.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) A short description of the pipeline.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input['PipelineInfrastructureConfigurationDetailsArgs'] infrastructure_configuration_details: (Updatable) The infrastructure configuration details of a pipeline or a step.
        :param pulumi.Input['PipelineLogConfigurationDetailsArgs'] log_configuration_details: (Updatable) The pipeline log configuration details.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "step_details", step_details)
        if configuration_details is not None:
            pulumi.set(__self__, "configuration_details", configuration_details)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if delete_related_pipeline_runs is not None:
            pulumi.set(__self__, "delete_related_pipeline_runs", delete_related_pipeline_runs)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if infrastructure_configuration_details is not None:
            pulumi.set(__self__, "infrastructure_configuration_details", infrastructure_configuration_details)
        if log_configuration_details is not None:
            pulumi.set(__self__, "log_configuration_details", log_configuration_details)
        if step_artifact is not None:
            pulumi.set(__self__, "step_artifact", step_artifact)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the pipeline.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the pipeline with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="stepDetails")
    def step_details(self) -> pulumi.Input[Sequence[pulumi.Input['PipelineStepDetailArgs']]]:
        """
        (Updatable) Array of step details for each step.
        """
        return pulumi.get(self, "step_details")

    @step_details.setter
    def step_details(self, value: pulumi.Input[Sequence[pulumi.Input['PipelineStepDetailArgs']]]):
        pulumi.set(self, "step_details", value)

    @property
    @pulumi.getter(name="configurationDetails")
    def configuration_details(self) -> Optional[pulumi.Input['PipelineConfigurationDetailsArgs']]:
        """
        (Updatable) The configuration details of a pipeline.
        """
        return pulumi.get(self, "configuration_details")

    @configuration_details.setter
    def configuration_details(self, value: Optional[pulumi.Input['PipelineConfigurationDetailsArgs']]):
        pulumi.set(self, "configuration_details", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deleteRelatedPipelineRuns")
    def delete_related_pipeline_runs(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "delete_related_pipeline_runs")

    @delete_related_pipeline_runs.setter
    def delete_related_pipeline_runs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_related_pipeline_runs", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A short description of the pipeline.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly display name for the resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="infrastructureConfigurationDetails")
    def infrastructure_configuration_details(self) -> Optional[pulumi.Input['PipelineInfrastructureConfigurationDetailsArgs']]:
        """
        (Updatable) The infrastructure configuration details of a pipeline or a step.
        """
        return pulumi.get(self, "infrastructure_configuration_details")

    @infrastructure_configuration_details.setter
    def infrastructure_configuration_details(self, value: Optional[pulumi.Input['PipelineInfrastructureConfigurationDetailsArgs']]):
        pulumi.set(self, "infrastructure_configuration_details", value)

    @property
    @pulumi.getter(name="logConfigurationDetails")
    def log_configuration_details(self) -> Optional[pulumi.Input['PipelineLogConfigurationDetailsArgs']]:
        """
        (Updatable) The pipeline log configuration details.
        """
        return pulumi.get(self, "log_configuration_details")

    @log_configuration_details.setter
    def log_configuration_details(self, value: Optional[pulumi.Input['PipelineLogConfigurationDetailsArgs']]):
        pulumi.set(self, "log_configuration_details", value)

    @property
    @pulumi.getter(name="stepArtifact")
    def step_artifact(self) -> Optional[pulumi.Input['PipelineStepArtifactArgs']]:
        return pulumi.get(self, "step_artifact")

    @step_artifact.setter
    def step_artifact(self, value: Optional[pulumi.Input['PipelineStepArtifactArgs']]):
        pulumi.set(self, "step_artifact", value)


@pulumi.input_type
class _PipelineState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 configuration_details: Optional[pulumi.Input['PipelineConfigurationDetailsArgs']] = None,
                 created_by: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 delete_related_pipeline_runs: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 infrastructure_configuration_details: Optional[pulumi.Input['PipelineInfrastructureConfigurationDetailsArgs']] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 log_configuration_details: Optional[pulumi.Input['PipelineLogConfigurationDetailsArgs']] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 step_artifact: Optional[pulumi.Input['PipelineStepArtifactArgs']] = None,
                 step_details: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineStepDetailArgs']]]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Pipeline resources.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the pipeline.
        :param pulumi.Input['PipelineConfigurationDetailsArgs'] configuration_details: (Updatable) The configuration details of a pipeline.
        :param pulumi.Input[str] created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the pipeline.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) A short description of the pipeline.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input['PipelineInfrastructureConfigurationDetailsArgs'] infrastructure_configuration_details: (Updatable) The infrastructure configuration details of a pipeline or a step.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in 'Failed' state.
        :param pulumi.Input['PipelineLogConfigurationDetailsArgs'] log_configuration_details: (Updatable) The pipeline log configuration details.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the pipeline with.
        :param pulumi.Input[str] state: The current state of the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineStepDetailArgs']]] step_details: (Updatable) Array of step details for each step.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2020-08-06T21:10:29.41Z
        :param pulumi.Input[str] time_updated: The date and time the resource was updated in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2020-08-06T21:10:29.41Z
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if configuration_details is not None:
            pulumi.set(__self__, "configuration_details", configuration_details)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if delete_related_pipeline_runs is not None:
            pulumi.set(__self__, "delete_related_pipeline_runs", delete_related_pipeline_runs)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if infrastructure_configuration_details is not None:
            pulumi.set(__self__, "infrastructure_configuration_details", infrastructure_configuration_details)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if log_configuration_details is not None:
            pulumi.set(__self__, "log_configuration_details", log_configuration_details)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if step_artifact is not None:
            pulumi.set(__self__, "step_artifact", step_artifact)
        if step_details is not None:
            pulumi.set(__self__, "step_details", step_details)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the pipeline.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="configurationDetails")
    def configuration_details(self) -> Optional[pulumi.Input['PipelineConfigurationDetailsArgs']]:
        """
        (Updatable) The configuration details of a pipeline.
        """
        return pulumi.get(self, "configuration_details")

    @configuration_details.setter
    def configuration_details(self, value: Optional[pulumi.Input['PipelineConfigurationDetailsArgs']]):
        pulumi.set(self, "configuration_details", value)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the pipeline.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_by", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deleteRelatedPipelineRuns")
    def delete_related_pipeline_runs(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "delete_related_pipeline_runs")

    @delete_related_pipeline_runs.setter
    def delete_related_pipeline_runs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_related_pipeline_runs", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A short description of the pipeline.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly display name for the resource.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="infrastructureConfigurationDetails")
    def infrastructure_configuration_details(self) -> Optional[pulumi.Input['PipelineInfrastructureConfigurationDetailsArgs']]:
        """
        (Updatable) The infrastructure configuration details of a pipeline or a step.
        """
        return pulumi.get(self, "infrastructure_configuration_details")

    @infrastructure_configuration_details.setter
    def infrastructure_configuration_details(self, value: Optional[pulumi.Input['PipelineInfrastructureConfigurationDetailsArgs']]):
        pulumi.set(self, "infrastructure_configuration_details", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in 'Failed' state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="logConfigurationDetails")
    def log_configuration_details(self) -> Optional[pulumi.Input['PipelineLogConfigurationDetailsArgs']]:
        """
        (Updatable) The pipeline log configuration details.
        """
        return pulumi.get(self, "log_configuration_details")

    @log_configuration_details.setter
    def log_configuration_details(self, value: Optional[pulumi.Input['PipelineLogConfigurationDetailsArgs']]):
        pulumi.set(self, "log_configuration_details", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the pipeline with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the pipeline.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stepArtifact")
    def step_artifact(self) -> Optional[pulumi.Input['PipelineStepArtifactArgs']]:
        return pulumi.get(self, "step_artifact")

    @step_artifact.setter
    def step_artifact(self, value: Optional[pulumi.Input['PipelineStepArtifactArgs']]):
        pulumi.set(self, "step_artifact", value)

    @property
    @pulumi.getter(name="stepDetails")
    def step_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineStepDetailArgs']]]]:
        """
        (Updatable) Array of step details for each step.
        """
        return pulumi.get(self, "step_details")

    @step_details.setter
    def step_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineStepDetailArgs']]]]):
        pulumi.set(self, "step_details", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2020-08-06T21:10:29.41Z
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the resource was updated in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2020-08-06T21:10:29.41Z
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class Pipeline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 configuration_details: Optional[pulumi.Input[pulumi.InputType['PipelineConfigurationDetailsArgs']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 delete_related_pipeline_runs: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 infrastructure_configuration_details: Optional[pulumi.Input[pulumi.InputType['PipelineInfrastructureConfigurationDetailsArgs']]] = None,
                 log_configuration_details: Optional[pulumi.Input[pulumi.InputType['PipelineLogConfigurationDetailsArgs']]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 step_artifact: Optional[pulumi.Input[pulumi.InputType['PipelineStepArtifactArgs']]] = None,
                 step_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineStepDetailArgs']]]]] = None,
                 __props__=None):
        """
        This resource provides the Pipeline resource in Oracle Cloud Infrastructure Data Science service.

        Creates a new Pipeline.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_pipeline = oci.data_science.Pipeline("test_pipeline",
            compartment_id=compartment_id,
            project_id=test_project["id"],
            step_details=[oci.data_science.PipelineStepDetailArgs(
                step_name=pipeline_step_details_step_name,
                step_type=pipeline_step_details_step_type,
                depends_ons=pipeline_step_details_depends_on,
                description=pipeline_step_details_description,
                is_artifact_uploaded=pipeline_step_details_is_artifact_uploaded,
                job_id=test_job["id"],
                step_configuration_details=oci.data_science.PipelineStepDetailStepConfigurationDetailsArgs(
                    command_line_arguments=pipeline_step_details_step_configuration_details_command_line_arguments,
                    environment_variables=pipeline_step_details_step_configuration_details_environment_variables,
                    maximum_runtime_in_minutes=pipeline_step_details_step_configuration_details_maximum_runtime_in_minutes,
                ),
                step_container_configuration_details=oci.data_science.PipelineStepDetailStepContainerConfigurationDetailsArgs(
                    container_type=pipeline_step_details_step_container_configuration_details_container_type,
                    image=pipeline_step_details_step_container_configuration_details_image,
                    cmds=pipeline_step_details_step_container_configuration_details_cmd,
                    entrypoints=pipeline_step_details_step_container_configuration_details_entrypoint,
                    image_digest=pipeline_step_details_step_container_configuration_details_image_digest,
                    image_signature_id=test_image_signature["id"],
                ),
                step_infrastructure_configuration_details=oci.data_science.PipelineStepDetailStepInfrastructureConfigurationDetailsArgs(
                    block_storage_size_in_gbs=pipeline_step_details_step_infrastructure_configuration_details_block_storage_size_in_gbs,
                    shape_config_details=oci.data_science.PipelineStepDetailStepInfrastructureConfigurationDetailsShapeConfigDetailsArgs(
                        memory_in_gbs=pipeline_step_details_step_infrastructure_configuration_details_shape_config_details_memory_in_gbs,
                        ocpus=pipeline_step_details_step_infrastructure_configuration_details_shape_config_details_ocpus,
                    ),
                    shape_name=test_shape["name"],
                    subnet_id=test_subnet["id"],
                ),
            )],
            configuration_details=oci.data_science.PipelineConfigurationDetailsArgs(
                type=pipeline_configuration_details_type,
                command_line_arguments=pipeline_configuration_details_command_line_arguments,
                environment_variables=pipeline_configuration_details_environment_variables,
                maximum_runtime_in_minutes=pipeline_configuration_details_maximum_runtime_in_minutes,
            ),
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=pipeline_description,
            display_name=pipeline_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            infrastructure_configuration_details=oci.data_science.PipelineInfrastructureConfigurationDetailsArgs(
                block_storage_size_in_gbs=pipeline_infrastructure_configuration_details_block_storage_size_in_gbs,
                shape_name=test_shape["name"],
                shape_config_details=oci.data_science.PipelineInfrastructureConfigurationDetailsShapeConfigDetailsArgs(
                    memory_in_gbs=pipeline_infrastructure_configuration_details_shape_config_details_memory_in_gbs,
                    ocpus=pipeline_infrastructure_configuration_details_shape_config_details_ocpus,
                ),
                subnet_id=test_subnet["id"],
            ),
            log_configuration_details=oci.data_science.PipelineLogConfigurationDetailsArgs(
                enable_auto_log_creation=pipeline_log_configuration_details_enable_auto_log_creation,
                enable_logging=pipeline_log_configuration_details_enable_logging,
                log_group_id=test_log_group["id"],
                log_id=test_log["id"],
            ))
        ```

        ## Import

        Pipelines can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataScience/pipeline:Pipeline test_pipeline "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the pipeline.
        :param pulumi.Input[pulumi.InputType['PipelineConfigurationDetailsArgs']] configuration_details: (Updatable) The configuration details of a pipeline.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) A short description of the pipeline.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[pulumi.InputType['PipelineInfrastructureConfigurationDetailsArgs']] infrastructure_configuration_details: (Updatable) The infrastructure configuration details of a pipeline or a step.
        :param pulumi.Input[pulumi.InputType['PipelineLogConfigurationDetailsArgs']] log_configuration_details: (Updatable) The pipeline log configuration details.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the pipeline with.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineStepDetailArgs']]]] step_details: (Updatable) Array of step details for each step.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PipelineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Pipeline resource in Oracle Cloud Infrastructure Data Science service.

        Creates a new Pipeline.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_pipeline = oci.data_science.Pipeline("test_pipeline",
            compartment_id=compartment_id,
            project_id=test_project["id"],
            step_details=[oci.data_science.PipelineStepDetailArgs(
                step_name=pipeline_step_details_step_name,
                step_type=pipeline_step_details_step_type,
                depends_ons=pipeline_step_details_depends_on,
                description=pipeline_step_details_description,
                is_artifact_uploaded=pipeline_step_details_is_artifact_uploaded,
                job_id=test_job["id"],
                step_configuration_details=oci.data_science.PipelineStepDetailStepConfigurationDetailsArgs(
                    command_line_arguments=pipeline_step_details_step_configuration_details_command_line_arguments,
                    environment_variables=pipeline_step_details_step_configuration_details_environment_variables,
                    maximum_runtime_in_minutes=pipeline_step_details_step_configuration_details_maximum_runtime_in_minutes,
                ),
                step_container_configuration_details=oci.data_science.PipelineStepDetailStepContainerConfigurationDetailsArgs(
                    container_type=pipeline_step_details_step_container_configuration_details_container_type,
                    image=pipeline_step_details_step_container_configuration_details_image,
                    cmds=pipeline_step_details_step_container_configuration_details_cmd,
                    entrypoints=pipeline_step_details_step_container_configuration_details_entrypoint,
                    image_digest=pipeline_step_details_step_container_configuration_details_image_digest,
                    image_signature_id=test_image_signature["id"],
                ),
                step_infrastructure_configuration_details=oci.data_science.PipelineStepDetailStepInfrastructureConfigurationDetailsArgs(
                    block_storage_size_in_gbs=pipeline_step_details_step_infrastructure_configuration_details_block_storage_size_in_gbs,
                    shape_config_details=oci.data_science.PipelineStepDetailStepInfrastructureConfigurationDetailsShapeConfigDetailsArgs(
                        memory_in_gbs=pipeline_step_details_step_infrastructure_configuration_details_shape_config_details_memory_in_gbs,
                        ocpus=pipeline_step_details_step_infrastructure_configuration_details_shape_config_details_ocpus,
                    ),
                    shape_name=test_shape["name"],
                    subnet_id=test_subnet["id"],
                ),
            )],
            configuration_details=oci.data_science.PipelineConfigurationDetailsArgs(
                type=pipeline_configuration_details_type,
                command_line_arguments=pipeline_configuration_details_command_line_arguments,
                environment_variables=pipeline_configuration_details_environment_variables,
                maximum_runtime_in_minutes=pipeline_configuration_details_maximum_runtime_in_minutes,
            ),
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=pipeline_description,
            display_name=pipeline_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            infrastructure_configuration_details=oci.data_science.PipelineInfrastructureConfigurationDetailsArgs(
                block_storage_size_in_gbs=pipeline_infrastructure_configuration_details_block_storage_size_in_gbs,
                shape_name=test_shape["name"],
                shape_config_details=oci.data_science.PipelineInfrastructureConfigurationDetailsShapeConfigDetailsArgs(
                    memory_in_gbs=pipeline_infrastructure_configuration_details_shape_config_details_memory_in_gbs,
                    ocpus=pipeline_infrastructure_configuration_details_shape_config_details_ocpus,
                ),
                subnet_id=test_subnet["id"],
            ),
            log_configuration_details=oci.data_science.PipelineLogConfigurationDetailsArgs(
                enable_auto_log_creation=pipeline_log_configuration_details_enable_auto_log_creation,
                enable_logging=pipeline_log_configuration_details_enable_logging,
                log_group_id=test_log_group["id"],
                log_id=test_log["id"],
            ))
        ```

        ## Import

        Pipelines can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataScience/pipeline:Pipeline test_pipeline "id"
        ```

        :param str resource_name: The name of the resource.
        :param PipelineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PipelineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 configuration_details: Optional[pulumi.Input[pulumi.InputType['PipelineConfigurationDetailsArgs']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 delete_related_pipeline_runs: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 infrastructure_configuration_details: Optional[pulumi.Input[pulumi.InputType['PipelineInfrastructureConfigurationDetailsArgs']]] = None,
                 log_configuration_details: Optional[pulumi.Input[pulumi.InputType['PipelineLogConfigurationDetailsArgs']]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 step_artifact: Optional[pulumi.Input[pulumi.InputType['PipelineStepArtifactArgs']]] = None,
                 step_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineStepDetailArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PipelineArgs.__new__(PipelineArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["configuration_details"] = configuration_details
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["delete_related_pipeline_runs"] = delete_related_pipeline_runs
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["infrastructure_configuration_details"] = infrastructure_configuration_details
            __props__.__dict__["log_configuration_details"] = log_configuration_details
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["step_artifact"] = step_artifact
            if step_details is None and not opts.urn:
                raise TypeError("Missing required property 'step_details'")
            __props__.__dict__["step_details"] = step_details
            __props__.__dict__["created_by"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(Pipeline, __self__).__init__(
            'oci:DataScience/pipeline:Pipeline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            configuration_details: Optional[pulumi.Input[pulumi.InputType['PipelineConfigurationDetailsArgs']]] = None,
            created_by: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            delete_related_pipeline_runs: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            infrastructure_configuration_details: Optional[pulumi.Input[pulumi.InputType['PipelineInfrastructureConfigurationDetailsArgs']]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            log_configuration_details: Optional[pulumi.Input[pulumi.InputType['PipelineLogConfigurationDetailsArgs']]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            step_artifact: Optional[pulumi.Input[pulumi.InputType['PipelineStepArtifactArgs']]] = None,
            step_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineStepDetailArgs']]]]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'Pipeline':
        """
        Get an existing Pipeline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the pipeline.
        :param pulumi.Input[pulumi.InputType['PipelineConfigurationDetailsArgs']] configuration_details: (Updatable) The configuration details of a pipeline.
        :param pulumi.Input[str] created_by: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the pipeline.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) A short description of the pipeline.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly display name for the resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[pulumi.InputType['PipelineInfrastructureConfigurationDetailsArgs']] infrastructure_configuration_details: (Updatable) The infrastructure configuration details of a pipeline or a step.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in 'Failed' state.
        :param pulumi.Input[pulumi.InputType['PipelineLogConfigurationDetailsArgs']] log_configuration_details: (Updatable) The pipeline log configuration details.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the pipeline with.
        :param pulumi.Input[str] state: The current state of the pipeline.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineStepDetailArgs']]]] step_details: (Updatable) Array of step details for each step.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2020-08-06T21:10:29.41Z
        :param pulumi.Input[str] time_updated: The date and time the resource was updated in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2020-08-06T21:10:29.41Z
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PipelineState.__new__(_PipelineState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["configuration_details"] = configuration_details
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["delete_related_pipeline_runs"] = delete_related_pipeline_runs
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["infrastructure_configuration_details"] = infrastructure_configuration_details
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["log_configuration_details"] = log_configuration_details
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["state"] = state
        __props__.__dict__["step_artifact"] = step_artifact
        __props__.__dict__["step_details"] = step_details
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return Pipeline(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the pipeline.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configurationDetails")
    def configuration_details(self) -> pulumi.Output['outputs.PipelineConfigurationDetails']:
        """
        (Updatable) The configuration details of a pipeline.
        """
        return pulumi.get(self, "configuration_details")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the pipeline.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deleteRelatedPipelineRuns")
    def delete_related_pipeline_runs(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "delete_related_pipeline_runs")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) A short description of the pipeline.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly display name for the resource.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="infrastructureConfigurationDetails")
    def infrastructure_configuration_details(self) -> pulumi.Output['outputs.PipelineInfrastructureConfigurationDetails']:
        """
        (Updatable) The infrastructure configuration details of a pipeline or a step.
        """
        return pulumi.get(self, "infrastructure_configuration_details")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in 'Failed' state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="logConfigurationDetails")
    def log_configuration_details(self) -> pulumi.Output['outputs.PipelineLogConfigurationDetails']:
        """
        (Updatable) The pipeline log configuration details.
        """
        return pulumi.get(self, "log_configuration_details")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate the pipeline with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the pipeline.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stepArtifact")
    def step_artifact(self) -> pulumi.Output['outputs.PipelineStepArtifact']:
        return pulumi.get(self, "step_artifact")

    @property
    @pulumi.getter(name="stepDetails")
    def step_details(self) -> pulumi.Output[Sequence['outputs.PipelineStepDetail']]:
        """
        (Updatable) Array of step details for each step.
        """
        return pulumi.get(self, "step_details")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2020-08-06T21:10:29.41Z
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time the resource was updated in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2020-08-06T21:10:29.41Z
        """
        return pulumi.get(self, "time_updated")

