# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetWaasPoliciesResult',
    'AwaitableGetWaasPoliciesResult',
    'get_waas_policies',
    'get_waas_policies_output',
]

@pulumi.output_type
class GetWaasPoliciesResult:
    """
    A collection of values returned by getWaasPolicies.
    """
    def __init__(__self__, compartment_id=None, display_names=None, filters=None, id=None, ids=None, states=None, time_created_greater_than_or_equal_to=None, time_created_less_than=None, waas_policies=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_names and not isinstance(display_names, list):
            raise TypeError("Expected argument 'display_names' to be a list")
        pulumi.set(__self__, "display_names", display_names)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if states and not isinstance(states, list):
            raise TypeError("Expected argument 'states' to be a list")
        pulumi.set(__self__, "states", states)
        if time_created_greater_than_or_equal_to and not isinstance(time_created_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_created_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_created_greater_than_or_equal_to", time_created_greater_than_or_equal_to)
        if time_created_less_than and not isinstance(time_created_less_than, str):
            raise TypeError("Expected argument 'time_created_less_than' to be a str")
        pulumi.set(__self__, "time_created_less_than", time_created_less_than)
        if waas_policies and not isinstance(waas_policies, list):
            raise TypeError("Expected argument 'waas_policies' to be a list")
        pulumi.set(__self__, "waas_policies", waas_policies)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WAAS policy's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayNames")
    def display_names(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "display_names")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetWaasPoliciesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def states(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "states")

    @property
    @pulumi.getter(name="timeCreatedGreaterThanOrEqualTo")
    def time_created_greater_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "time_created_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="timeCreatedLessThan")
    def time_created_less_than(self) -> Optional[str]:
        return pulumi.get(self, "time_created_less_than")

    @property
    @pulumi.getter(name="waasPolicies")
    def waas_policies(self) -> Sequence['outputs.GetWaasPoliciesWaasPolicyResult']:
        """
        The list of waas_policies.
        """
        return pulumi.get(self, "waas_policies")


class AwaitableGetWaasPoliciesResult(GetWaasPoliciesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWaasPoliciesResult(
            compartment_id=self.compartment_id,
            display_names=self.display_names,
            filters=self.filters,
            id=self.id,
            ids=self.ids,
            states=self.states,
            time_created_greater_than_or_equal_to=self.time_created_greater_than_or_equal_to,
            time_created_less_than=self.time_created_less_than,
            waas_policies=self.waas_policies)


def get_waas_policies(compartment_id: Optional[str] = None,
                      display_names: Optional[Sequence[str]] = None,
                      filters: Optional[Sequence[pulumi.InputType['GetWaasPoliciesFilterArgs']]] = None,
                      ids: Optional[Sequence[str]] = None,
                      states: Optional[Sequence[str]] = None,
                      time_created_greater_than_or_equal_to: Optional[str] = None,
                      time_created_less_than: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWaasPoliciesResult:
    """
    This data source provides the list of Waas Policies in Oracle Cloud Infrastructure Web Application Acceleration and Security service.

    Gets a list of WAAS policies.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_waas_policies = oci.Waas.get_waas_policies(compartment_id=compartment_id,
        display_names=waas_policy_display_names,
        ids=waas_policy_ids,
        states=waas_policy_states,
        time_created_greater_than_or_equal_to=waas_policy_time_created_greater_than_or_equal_to,
        time_created_less_than=waas_policy_time_created_less_than)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment. This number is generated when the compartment is created.
    :param Sequence[str] display_names: Filter policies using a list of display names.
    :param Sequence[str] ids: Filter policies using a list of policy OCIDs.
    :param Sequence[str] states: Filter policies using a list of lifecycle states.
    :param str time_created_greater_than_or_equal_to: A filter that matches policies created on or after the specified date and time.
    :param str time_created_less_than: A filter that matches policies created before the specified date-time.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayNames'] = display_names
    __args__['filters'] = filters
    __args__['ids'] = ids
    __args__['states'] = states
    __args__['timeCreatedGreaterThanOrEqualTo'] = time_created_greater_than_or_equal_to
    __args__['timeCreatedLessThan'] = time_created_less_than
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Waas/getWaasPolicies:getWaasPolicies', __args__, opts=opts, typ=GetWaasPoliciesResult).value

    return AwaitableGetWaasPoliciesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_names=pulumi.get(__ret__, 'display_names'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        states=pulumi.get(__ret__, 'states'),
        time_created_greater_than_or_equal_to=pulumi.get(__ret__, 'time_created_greater_than_or_equal_to'),
        time_created_less_than=pulumi.get(__ret__, 'time_created_less_than'),
        waas_policies=pulumi.get(__ret__, 'waas_policies'))


@_utilities.lift_output_func(get_waas_policies)
def get_waas_policies_output(compartment_id: Optional[pulumi.Input[str]] = None,
                             display_names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetWaasPoliciesFilterArgs']]]]] = None,
                             ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                             states: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                             time_created_greater_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                             time_created_less_than: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetWaasPoliciesResult]:
    """
    This data source provides the list of Waas Policies in Oracle Cloud Infrastructure Web Application Acceleration and Security service.

    Gets a list of WAAS policies.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_waas_policies = oci.Waas.get_waas_policies(compartment_id=compartment_id,
        display_names=waas_policy_display_names,
        ids=waas_policy_ids,
        states=waas_policy_states,
        time_created_greater_than_or_equal_to=waas_policy_time_created_greater_than_or_equal_to,
        time_created_less_than=waas_policy_time_created_less_than)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment. This number is generated when the compartment is created.
    :param Sequence[str] display_names: Filter policies using a list of display names.
    :param Sequence[str] ids: Filter policies using a list of policy OCIDs.
    :param Sequence[str] states: Filter policies using a list of lifecycle states.
    :param str time_created_greater_than_or_equal_to: A filter that matches policies created on or after the specified date and time.
    :param str time_created_less_than: A filter that matches policies created before the specified date-time.
    """
    ...
