"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ViaServicePrincipal = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
/**
 * A principal to allow access to a key if it's being used through another AWS service.
 *
 * @stability stable
 */
class ViaServicePrincipal extends iam.PrincipalBase {
    /**
     * @stability stable
     */
    constructor(serviceName, basePrincipal) {
        super();
        this.serviceName = serviceName;
        this.basePrincipal = basePrincipal ? basePrincipal : new iam.AnyPrincipal();
    }
    /**
     * Return the policy fragment that identifies this principal in a Policy.
     *
     * @stability stable
     */
    get policyFragment() {
        // Make a copy of the base policyFragment to add a condition to it
        const base = this.basePrincipal.policyFragment;
        const conditions = Object.assign({}, base.conditions);
        if (conditions.StringEquals) {
            conditions.StringEquals = Object.assign({ 'kms:ViaService': this.serviceName }, conditions.StringEquals);
        }
        else {
            conditions.StringEquals = { 'kms:ViaService': this.serviceName };
        }
        return { principalJson: base.principalJson, conditions };
    }
}
exports.ViaServicePrincipal = ViaServicePrincipal;
_a = JSII_RTTI_SYMBOL_1;
ViaServicePrincipal[_a] = { fqn: "@aws-cdk/aws-kms.ViaServicePrincipal", version: "1.93.0" };
//# sourceMappingURL=data:application/json;base64,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