# mypy-boto3-guardduty

Mypy-friendly auto-generated type annotations for `boto3 guardduty 1.10.36` service.
More information can be found [here](https://github.com/vemel/mypy_boto3).

- [mypy-boto3-guardduty](#mypy-boto3-guardduty)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
    - [Code auto-complete](#code-auto-complete)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `guardduty` service.

```bash
python -m pip install boto3-stubs[mypy-boto3-guardduty]

# build service index. You should execute this command everytime
# you update boto3-stubs or install/remove services
python -m python -m mypy_boto3
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking.

```python
import boto3

from mypy_boto3 import guardduty
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_guardduty as guardduty

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("guardduty")
client: guardduty.Client = boto3.client("guardduty")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: guardduty.Client = session.client("guardduty")


# Paginators need type annotation on creation
list_detectors_paginator: guardduty.ListDetectorsPaginator = client.get_paginator("list_detectors")
list_filters_paginator: guardduty.ListFiltersPaginator = client.get_paginator("list_filters")
list_findings_paginator: guardduty.ListFindingsPaginator = client.get_paginator("list_findings")
list_ip_sets_paginator: guardduty.ListIPSetsPaginator = client.get_paginator("list_ip_sets")
list_invitations_paginator: guardduty.ListInvitationsPaginator = client.get_paginator("list_invitations")
list_members_paginator: guardduty.ListMembersPaginator = client.get_paginator("list_members")
list_threat_intel_sets_paginator: guardduty.ListThreatIntelSetsPaginator = client.get_paginator("list_threat_intel_sets")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- Latest version of `boto3` is used.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from latest documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Code is processed by [black](https://github.com/psf/black) for readability.

## Submodules

- `master` - Install `mypy-boto3` package.