"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import date
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, QueryParamMetadata, RequestMetadata
import pydantic
from pydantic import model_serializer
from typing import Any, Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class CreatePaymentInclude(str, Enum):
    r"""This endpoint allows you to include additional information via the `include` query string parameter."""

    DETAILS_QR_CODE = "details.qrCode"


class CreatePaymentAmountRequestTypedDict(TypedDict):
    r"""The amount that you want to charge, e.g. `{currency:\"EUR\", value:\"1000.00\"}` if you would want to charge €1000.00.

    You can find the minimum and maximum amounts per payment method in our help center. Additionally, they can be
    retrieved using the Get method endpoint.

    If a tip was added for a Point-of-Sale payment, the amount will be updated to reflect the initial amount plus the
    tip amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentAmountRequest(BaseModel):
    r"""The amount that you want to charge, e.g. `{currency:\"EUR\", value:\"1000.00\"}` if you would want to charge €1000.00.

    You can find the minimum and maximum amounts per payment method in our help center. Additionally, they can be
    retrieved using the Get method endpoint.

    If a tip was added for a Point-of-Sale payment, the amount will be updated to reflect the initial amount plus the
    tip amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentLineTypeRequest(str, Enum):
    r"""The type of product purchased. For example, a physical or a digital product.

    The `tip` payment line type is not available when creating a payment.
    """

    PHYSICAL = "physical"
    DIGITAL = "digital"
    SHIPPING_FEE = "shipping_fee"
    DISCOUNT = "discount"
    STORE_CREDIT = "store_credit"
    GIFT_CARD = "gift_card"
    SURCHARGE = "surcharge"
    TIP = "tip"


class CreatePaymentUnitPriceRequestTypedDict(TypedDict):
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentUnitPriceRequest(BaseModel):
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentDiscountAmountRequestTypedDict(TypedDict):
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount
    type.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentDiscountAmountRequest(BaseModel):
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount
    type.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentTotalAmountRequestTypedDict(TypedDict):
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentTotalAmountRequest(BaseModel):
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentVatAmountRequestTypedDict(TypedDict):
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be
    calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of
    `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentVatAmountRequest(BaseModel):
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be
    calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of
    `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentCategoryRequest(str, Enum):
    MEAL = "meal"
    ECO = "eco"
    GIFT = "gift"
    SPORT_CULTURE = "sport_culture"


class CreatePaymentRecurringAmountRequestTypedDict(TypedDict):
    r"""Total amount and currency of the recurring item."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentRecurringAmountRequest(BaseModel):
    r"""Total amount and currency of the recurring item."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentRecurringRequestTypedDict(TypedDict):
    r"""The details of subsequent recurring billing cycles. These parameters are used in the Mollie Checkout
    to inform the shopper of the details for recurring products in the payments.
    """

    interval: str
    r"""Cadence unit of the recurring item. For example: `12 months`, `52 weeks` or `365 days`.

    Possible values: `... days`, `... weeks`, `... months`.
    """
    description: NotRequired[str]
    r"""A description of the recurring item. If not present, the main description of the item will be used."""
    amount: NotRequired[CreatePaymentRecurringAmountRequestTypedDict]
    r"""Total amount and currency of the recurring item."""
    times: NotRequired[int]
    r"""Total number of charges for the subscription to complete. Leave empty for ongoing subscription."""
    start_date: NotRequired[Nullable[str]]
    r"""The start date of the subscription if it does not start right away (format `YYYY-MM-DD`)"""


class CreatePaymentRecurringRequest(BaseModel):
    r"""The details of subsequent recurring billing cycles. These parameters are used in the Mollie Checkout
    to inform the shopper of the details for recurring products in the payments.
    """

    interval: str
    r"""Cadence unit of the recurring item. For example: `12 months`, `52 weeks` or `365 days`.

    Possible values: `... days`, `... weeks`, `... months`.
    """

    description: Optional[str] = None
    r"""A description of the recurring item. If not present, the main description of the item will be used."""

    amount: Optional[CreatePaymentRecurringAmountRequest] = None
    r"""Total amount and currency of the recurring item."""

    times: Optional[int] = None
    r"""Total number of charges for the subscription to complete. Leave empty for ongoing subscription."""

    start_date: Annotated[OptionalNullable[str], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the subscription if it does not start right away (format `YYYY-MM-DD`)"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "amount", "times", "startDate"]
        nullable_fields = ["startDate"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreatePaymentLineRequestTypedDict(TypedDict):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""
    quantity: int
    r"""The number of items."""
    unit_price: CreatePaymentUnitPriceRequestTypedDict
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """
    total_amount: CreatePaymentTotalAmountRequestTypedDict
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """
    type: NotRequired[CreatePaymentLineTypeRequest]
    r"""The type of product purchased. For example, a physical or a digital product.

    The `tip` payment line type is not available when creating a payment.
    """
    quantity_unit: NotRequired[str]
    r"""The unit for the quantity. For example *pcs*, *kg*, or *cm*."""
    discount_amount: NotRequired[CreatePaymentDiscountAmountRequestTypedDict]
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount
    type.
    """
    vat_rate: NotRequired[str]
    r"""The VAT rate applied to the line, for example `21.00` for 21%. The vatRate should be passed as a string and
    not as a float, to ensure the correct number of decimals are passed.
    """
    vat_amount: NotRequired[CreatePaymentVatAmountRequestTypedDict]
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be
    calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of
    `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """
    sku: NotRequired[str]
    r"""The SKU, EAN, ISBN or UPC of the product sold."""
    categories: NotRequired[List[CreatePaymentCategoryRequest]]
    r"""An array with the voucher categories, in case of a line eligible for a voucher. See the
    [Integrating Vouchers](https://docs.mollie.com/docs/integrating-vouchers/) guide for more information.
    """
    image_url: NotRequired[str]
    r"""A link pointing to an image of the product sold."""
    product_url: NotRequired[str]
    r"""A link pointing to the product page in your web shop of the product sold."""
    recurring: NotRequired[CreatePaymentRecurringRequestTypedDict]
    r"""The details of subsequent recurring billing cycles. These parameters are used in the Mollie Checkout
    to inform the shopper of the details for recurring products in the payments.
    """


class CreatePaymentLineRequest(BaseModel):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""

    quantity: int
    r"""The number of items."""

    unit_price: Annotated[
        CreatePaymentUnitPriceRequest, pydantic.Field(alias="unitPrice")
    ]
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """

    total_amount: Annotated[
        CreatePaymentTotalAmountRequest, pydantic.Field(alias="totalAmount")
    ]
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """

    type: Optional[CreatePaymentLineTypeRequest] = None
    r"""The type of product purchased. For example, a physical or a digital product.

    The `tip` payment line type is not available when creating a payment.
    """

    quantity_unit: Annotated[Optional[str], pydantic.Field(alias="quantityUnit")] = None
    r"""The unit for the quantity. For example *pcs*, *kg*, or *cm*."""

    discount_amount: Annotated[
        Optional[CreatePaymentDiscountAmountRequest],
        pydantic.Field(alias="discountAmount"),
    ] = None
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount
    type.
    """

    vat_rate: Annotated[Optional[str], pydantic.Field(alias="vatRate")] = None
    r"""The VAT rate applied to the line, for example `21.00` for 21%. The vatRate should be passed as a string and
    not as a float, to ensure the correct number of decimals are passed.
    """

    vat_amount: Annotated[
        Optional[CreatePaymentVatAmountRequest], pydantic.Field(alias="vatAmount")
    ] = None
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be
    calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of
    `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """

    sku: Optional[str] = None
    r"""The SKU, EAN, ISBN or UPC of the product sold."""

    categories: Optional[List[CreatePaymentCategoryRequest]] = None
    r"""An array with the voucher categories, in case of a line eligible for a voucher. See the
    [Integrating Vouchers](https://docs.mollie.com/docs/integrating-vouchers/) guide for more information.
    """

    image_url: Annotated[Optional[str], pydantic.Field(alias="imageUrl")] = None
    r"""A link pointing to an image of the product sold."""

    product_url: Annotated[Optional[str], pydantic.Field(alias="productUrl")] = None
    r"""A link pointing to the product page in your web shop of the product sold."""

    recurring: Optional[CreatePaymentRecurringRequest] = None
    r"""The details of subsequent recurring billing cycles. These parameters are used in the Mollie Checkout
    to inform the shopper of the details for recurring products in the payments.
    """


class CreatePaymentBillingAddressRequestTypedDict(TypedDict):
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.

    Required for payment method `in3`, `klarna`, `billie` and `riverty`.
    """

    title: NotRequired[str]
    r"""The title of the person, for example *Mr.* or *Mrs.*."""
    given_name: NotRequired[str]
    r"""The given name (first name) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    family_name: NotRequired[str]
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    organization_name: NotRequired[str]
    r"""The name of the organization, in case the addressee is an organization."""
    street_and_number: NotRequired[str]
    r"""A street and street number.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    street_additional: NotRequired[str]
    r"""Any additional addressing details, for example an apartment number."""
    postal_code: NotRequired[str]
    r"""A postal code. This field may be required if the provided country has a postal code system.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    email: NotRequired[str]
    r"""A valid e-mail address.

    If you provide the email address for a `banktransfer` payment, we will automatically send the instructions
    email upon payment creation. The language of the email will follow the locale parameter of the payment.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    phone: NotRequired[str]
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""
    city: NotRequired[str]
    r"""A city name.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    region: NotRequired[str]
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""
    country: NotRequired[str]
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """


class CreatePaymentBillingAddressRequest(BaseModel):
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.

    Required for payment method `in3`, `klarna`, `billie` and `riverty`.
    """

    title: Optional[str] = None
    r"""The title of the person, for example *Mr.* or *Mrs.*."""

    given_name: Annotated[Optional[str], pydantic.Field(alias="givenName")] = None
    r"""The given name (first name) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    family_name: Annotated[Optional[str], pydantic.Field(alias="familyName")] = None
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    organization_name: Annotated[
        Optional[str], pydantic.Field(alias="organizationName")
    ] = None
    r"""The name of the organization, in case the addressee is an organization."""

    street_and_number: Annotated[
        Optional[str], pydantic.Field(alias="streetAndNumber")
    ] = None
    r"""A street and street number.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    street_additional: Annotated[
        Optional[str], pydantic.Field(alias="streetAdditional")
    ] = None
    r"""Any additional addressing details, for example an apartment number."""

    postal_code: Annotated[Optional[str], pydantic.Field(alias="postalCode")] = None
    r"""A postal code. This field may be required if the provided country has a postal code system.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    email: Optional[str] = None
    r"""A valid e-mail address.

    If you provide the email address for a `banktransfer` payment, we will automatically send the instructions
    email upon payment creation. The language of the email will follow the locale parameter of the payment.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    phone: Optional[str] = None
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""

    city: Optional[str] = None
    r"""A city name.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    region: Optional[str] = None
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""

    country: Optional[str] = None
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """


class CreatePaymentShippingAddressRequestTypedDict(TypedDict):
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.
    """

    title: NotRequired[str]
    r"""The title of the person, for example *Mr.* or *Mrs.*."""
    given_name: NotRequired[str]
    r"""The given name (first name) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    family_name: NotRequired[str]
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    organization_name: NotRequired[str]
    r"""The name of the organization, in case the addressee is an organization."""
    street_and_number: NotRequired[str]
    r"""A street and street number.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    street_additional: NotRequired[str]
    r"""Any additional addressing details, for example an apartment number."""
    postal_code: NotRequired[str]
    r"""A postal code. This field may be required if the provided country has a postal code system.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    email: NotRequired[str]
    r"""A valid e-mail address.

    If you provide the email address for a `banktransfer` payment, we will automatically send the instructions
    email upon payment creation. The language of the email will follow the locale parameter of the payment.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    phone: NotRequired[str]
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""
    city: NotRequired[str]
    r"""A city name.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    region: NotRequired[str]
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""
    country: NotRequired[str]
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """


class CreatePaymentShippingAddressRequest(BaseModel):
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.
    """

    title: Optional[str] = None
    r"""The title of the person, for example *Mr.* or *Mrs.*."""

    given_name: Annotated[Optional[str], pydantic.Field(alias="givenName")] = None
    r"""The given name (first name) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    family_name: Annotated[Optional[str], pydantic.Field(alias="familyName")] = None
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    organization_name: Annotated[
        Optional[str], pydantic.Field(alias="organizationName")
    ] = None
    r"""The name of the organization, in case the addressee is an organization."""

    street_and_number: Annotated[
        Optional[str], pydantic.Field(alias="streetAndNumber")
    ] = None
    r"""A street and street number.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    street_additional: Annotated[
        Optional[str], pydantic.Field(alias="streetAdditional")
    ] = None
    r"""Any additional addressing details, for example an apartment number."""

    postal_code: Annotated[Optional[str], pydantic.Field(alias="postalCode")] = None
    r"""A postal code. This field may be required if the provided country has a postal code system.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    email: Optional[str] = None
    r"""A valid e-mail address.

    If you provide the email address for a `banktransfer` payment, we will automatically send the instructions
    email upon payment creation. The language of the email will follow the locale parameter of the payment.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    phone: Optional[str] = None
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""

    city: Optional[str] = None
    r"""A city name.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    region: Optional[str] = None
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""

    country: Optional[str] = None
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """


class CreatePaymentLocaleRequest(str, Enum):
    r"""Allows you to preset the language to be used in the hosted payment pages shown to the customer. Setting a locale
    is highly recommended and will greatly improve your conversion rate. When this parameter is omitted the browser
    language will be used instead if supported by the payment method. You can provide any `xx_XX` format ISO 15897
    locale, but our hosted payment pages currently only support the specified languages.

    For bank transfer payments specifically, the locale will determine the target bank account the customer has to
    transfer the money to. We have dedicated bank accounts for Belgium, Germany, and The Netherlands. Having the
    customer use a local bank account greatly increases the conversion and speed of payment.
    """

    EN_US = "en_US"
    EN_GB = "en_GB"
    NL_NL = "nl_NL"
    NL_BE = "nl_BE"
    DE_DE = "de_DE"
    DE_AT = "de_AT"
    DE_CH = "de_CH"
    FR_FR = "fr_FR"
    FR_BE = "fr_BE"
    ES_ES = "es_ES"
    CA_ES = "ca_ES"
    PT_PT = "pt_PT"
    IT_IT = "it_IT"
    NB_NO = "nb_NO"
    SV_SE = "sv_SE"
    FI_FI = "fi_FI"
    DA_DK = "da_DK"
    IS_IS = "is_IS"
    HU_HU = "hu_HU"
    PL_PL = "pl_PL"
    LV_LV = "lv_LV"
    LT_LT = "lt_LT"


class CreatePaymentMethodRequest(str, Enum):
    r"""Normally, a payment method screen is shown. However, when using this parameter, you can choose a specific payment
    method and your customer will skip the selection screen and is sent directly to the chosen payment method. The
    parameter enables you to fully integrate the payment method selection into your website.

    You can also specify the methods in an array. By doing so we will still show the payment method selection screen
    but will only show the methods specified in the array. For example, you can use this functionality to only show
    payment methods from a specific country to your customer `['bancontact', 'belfius']`.
    """

    ALMA = "alma"
    APPLEPAY = "applepay"
    BACS = "bacs"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    IDEAL = "ideal"
    IN3 = "in3"
    KBC = "kbc"
    KLARNA = "klarna"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    POINTOFSALE = "pointofsale"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


CreatePaymentMetadataRequestTypedDict = TypeAliasType(
    "CreatePaymentMetadataRequestTypedDict", Union[str, Dict[str, Any], List[str]]
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
"""


CreatePaymentMetadataRequest = TypeAliasType(
    "CreatePaymentMetadataRequest", Union[str, Dict[str, Any], List[str]]
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
"""


class CreatePaymentCaptureModeRequest(str, Enum):
    r"""Indicate if the funds should be captured immediately or if you want to [place a hold](https://docs.mollie.com/docs/place-a-hold-for-a-payment#/)
    and capture at a later time.

    This field needs to be set to `manual` for method `riverty`.
    """

    AUTOMATIC = "automatic"
    MANUAL = "manual"


class CreatePaymentApplicationFeeAmountRequestTypedDict(TypedDict):
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge
    a €0.99 fee on a €1.00 payment.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentApplicationFeeAmountRequest(BaseModel):
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge
    a €0.99 fee on a €1.00 payment.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentApplicationFeeRequestTypedDict(TypedDict):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the
    `routing` parameter.
    """

    amount: NotRequired[CreatePaymentApplicationFeeAmountRequestTypedDict]
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge
    a €0.99 fee on a €1.00 payment.
    """
    description: NotRequired[str]
    r"""The description of the application fee. This will appear on settlement reports towards both you and the
    connected merchant.
    """


class CreatePaymentApplicationFeeRequest(BaseModel):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the
    `routing` parameter.
    """

    amount: Optional[CreatePaymentApplicationFeeAmountRequest] = None
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge
    a €0.99 fee on a €1.00 payment.
    """

    description: Optional[str] = None
    r"""The description of the application fee. This will appear on settlement reports towards both you and the
    connected merchant.
    """


class CreatePaymentRoutingAmountRequestTypedDict(TypedDict):
    r"""The portion of the total payment amount being routed. Currently only `EUR` payments can be routed."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentRoutingAmountRequest(BaseModel):
    r"""The portion of the total payment amount being routed. Currently only `EUR` payments can be routed."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentRoutingTypeRequest(str, Enum):
    r"""The type of destination. Currently only the destination type `organization` is supported."""

    ORGANIZATION = "organization"


class CreatePaymentDestinationRequestTypedDict(TypedDict):
    r"""The destination of this portion of the payment."""

    type: CreatePaymentRoutingTypeRequest
    r"""The type of destination. Currently only the destination type `organization` is supported."""
    organization_id: str
    r"""Required for destination type `organization`. The ID of the connected organization the funds should be
    routed to.
    """


class CreatePaymentDestinationRequest(BaseModel):
    r"""The destination of this portion of the payment."""

    type: CreatePaymentRoutingTypeRequest
    r"""The type of destination. Currently only the destination type `organization` is supported."""

    organization_id: Annotated[str, pydantic.Field(alias="organizationId")]
    r"""Required for destination type `organization`. The ID of the connected organization the funds should be
    routed to.
    """


class CreatePaymentSelfRequestTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentSelfRequest(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentPaymentRequestTypedDict(TypedDict):
    r"""The API resource URL of the [payment](get-payment) that belong to this route."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentPaymentRequest(BaseModel):
    r"""The API resource URL of the [payment](get-payment) that belong to this route."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentLinksRequestTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: CreatePaymentSelfRequestTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payment: CreatePaymentPaymentRequestTypedDict
    r"""The API resource URL of the [payment](get-payment) that belong to this route."""


class CreatePaymentLinksRequest(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[CreatePaymentSelfRequest, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payment: CreatePaymentPaymentRequest
    r"""The API resource URL of the [payment](get-payment) that belong to this route."""


class CreatePaymentRoutingRequestTypedDict(TypedDict):
    amount: CreatePaymentRoutingAmountRequestTypedDict
    r"""The portion of the total payment amount being routed. Currently only `EUR` payments can be routed."""
    destination: CreatePaymentDestinationRequestTypedDict
    r"""The destination of this portion of the payment."""
    links: CreatePaymentLinksRequestTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    release_date: NotRequired[Nullable[str]]
    r"""Optionally, schedule this portion of the payment to be transferred to its destination on a later date. The
    date must be given in `YYYY-MM-DD` format.

    If no date is given, the funds become available to the connected merchant as soon as the payment succeeds.
    """


class CreatePaymentRoutingRequest(BaseModel):
    amount: CreatePaymentRoutingAmountRequest
    r"""The portion of the total payment amount being routed. Currently only `EUR` payments can be routed."""

    destination: CreatePaymentDestinationRequest
    r"""The destination of this portion of the payment."""

    links: Annotated[CreatePaymentLinksRequest, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    release_date: Annotated[
        OptionalNullable[str], pydantic.Field(alias="releaseDate")
    ] = UNSET
    r"""Optionally, schedule this portion of the payment to be transferred to its destination on a later date. The
    date must be given in `YYYY-MM-DD` format.

    If no date is given, the funds become available to the connected merchant as soon as the payment succeeds.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["releaseDate"]
        nullable_fields = ["releaseDate"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreatePaymentSequenceTypeRequest(str, Enum):
    r"""**Only relevant for recurring payments.**

    Indicate which part of a recurring sequence this payment is for.

    Recurring payments can only take place if a mandate is available. A common way to establish such a mandate is
    through a `first` payment. With a `first` payment, the customer agrees to automatic recurring charges taking place
    on their account in the future.

    If set to `recurring`, the customer's card is charged automatically.

    Defaults to `oneoff`, which is a regular non-recurring payment.

    For PayPal payments, recurring is only possible if your connected PayPal account allows it. You can call our
    [Methods API](list-methods) with parameter `sequenceType: first` to discover which payment methods on your account
    are set up correctly for recurring payments.
    """

    ONEOFF = "oneoff"
    FIRST = "first"
    RECURRING = "recurring"


class CreatePaymentCompanyTypedDict(TypedDict):
    r"""Billie is a business-to-business (B2B) payment method. It requires extra information to identify the organization
    that is completing the payment. It is recommended to include these parameters up front for a seamless flow.
    Otherwise, Billie will ask the customer to complete the missing fields during checkout.
    """

    registration_number: NotRequired[str]
    r"""The organization's registration number."""
    vat_number: NotRequired[str]
    r"""The organization's VAT number."""
    entity_type: NotRequired[str]
    r"""The organization's entity type."""


class CreatePaymentCompany(BaseModel):
    r"""Billie is a business-to-business (B2B) payment method. It requires extra information to identify the organization
    that is completing the payment. It is recommended to include these parameters up front for a seamless flow.
    Otherwise, Billie will ask the customer to complete the missing fields during checkout.
    """

    registration_number: Annotated[
        Optional[str], pydantic.Field(alias="registrationNumber")
    ] = None
    r"""The organization's registration number."""

    vat_number: Annotated[Optional[str], pydantic.Field(alias="vatNumber")] = None
    r"""The organization's VAT number."""

    entity_type: Annotated[Optional[str], pydantic.Field(alias="entityType")] = None
    r"""The organization's entity type."""


class CreatePaymentRequestBodyTypedDict(TypedDict):
    description: str
    r"""The description of the payment. This will be shown to your customer on their card or bank statement when possible.
    We truncate the description automatically according to the limits of the used payment method. The description is
    also visible in any exports you generate.

    We recommend you use a unique identifier so that you can always link the payment to the order in your back office.
    This is particularly useful for bookkeeping.

    The maximum length of the description field differs per payment method, with the absolute maximum being 255
    characters. The API will not reject strings longer than the maximum length but it will truncate them to fit.
    """
    amount: CreatePaymentAmountRequestTypedDict
    r"""The amount that you want to charge, e.g. `{currency:\"EUR\", value:\"1000.00\"}` if you would want to charge €1000.00.

    You can find the minimum and maximum amounts per payment method in our help center. Additionally, they can be
    retrieved using the Get method endpoint.

    If a tip was added for a Point-of-Sale payment, the amount will be updated to reflect the initial amount plus the
    tip amount.
    """
    redirect_url: Nullable[str]
    r"""The URL your customer will be redirected to after the payment process.

    It could make sense for the redirectUrl to contain a unique identifier – like your order ID – so you can show the
    right page referencing the order when your customer returns.

    The parameter is normally required, but can be omitted for recurring payments (`sequenceType: recurring`) and for
    Apple Pay payments with an `applePayPaymentToken`.
    """
    cancel_url: NotRequired[Nullable[str]]
    r"""The URL your customer will be redirected to when the customer explicitly cancels the payment. If this URL is not
    provided, the customer will be redirected to the `redirectUrl` instead — see above.

    Mollie will always give you status updates via webhooks, including for the canceled status. This parameter is
    therefore entirely optional, but can be useful when implementing a dedicated customer-facing flow to handle
    payment cancellations.
    """
    webhook_url: NotRequired[Nullable[str]]
    r"""The webhook URL where we will send payment status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to your payment.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use
    webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your
    local machine.
    """
    lines: NotRequired[Nullable[List[CreatePaymentLineRequestTypedDict]]]
    r"""Optionally provide the order lines for the payment. Each line contains details such as a description of the item
    ordered and its price.

    All lines must have the same currency as the payment.

    Required for payment methods `billie`, `in3`, `klarna`, `riverty` and `voucher`.
    """
    billing_address: NotRequired[CreatePaymentBillingAddressRequestTypedDict]
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.

    Required for payment method `in3`, `klarna`, `billie` and `riverty`.
    """
    shipping_address: NotRequired[CreatePaymentShippingAddressRequestTypedDict]
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.
    """
    locale: NotRequired[Nullable[CreatePaymentLocaleRequest]]
    r"""Allows you to preset the language to be used in the hosted payment pages shown to the customer. Setting a locale
    is highly recommended and will greatly improve your conversion rate. When this parameter is omitted the browser
    language will be used instead if supported by the payment method. You can provide any `xx_XX` format ISO 15897
    locale, but our hosted payment pages currently only support the specified languages.

    For bank transfer payments specifically, the locale will determine the target bank account the customer has to
    transfer the money to. We have dedicated bank accounts for Belgium, Germany, and The Netherlands. Having the
    customer use a local bank account greatly increases the conversion and speed of payment.
    """
    method: NotRequired[Nullable[CreatePaymentMethodRequest]]
    r"""Normally, a payment method screen is shown. However, when using this parameter, you can choose a specific payment
    method and your customer will skip the selection screen and is sent directly to the chosen payment method. The
    parameter enables you to fully integrate the payment method selection into your website.

    You can also specify the methods in an array. By doing so we will still show the payment method selection screen
    but will only show the methods specified in the array. For example, you can use this functionality to only show
    payment methods from a specific country to your customer `['bancontact', 'belfius']`.
    """
    issuer: NotRequired[Nullable[str]]
    r"""**Only relevant for iDEAL, KBC/CBC, gift card, and voucher payments.**

    **⚠️ With the introduction of iDEAL 2 in 2025, this field will be ignored for iDEAL payments. For more information
    on the migration, refer to our [help center](https://help.mollie.com/hc/articles/19100313768338-iDEAL-2-0).**

    Some payment methods are a network of connected banks or card issuers. In these cases, after selecting the payment
    method, the customer may still need to select the appropriate issuer before the payment can proceed.

    We provide hosted issuer selection screens, but these screens can be skipped by providing the `issuer` via the API
    up front.

    The full list of issuers for a specific method can be retrieved via the Methods API by using the optional
    `issuers` include.

    A valid issuer for iDEAL is for example `ideal_INGBNL2A` (for ING Bank).
    """
    restrict_payment_methods_to_country: NotRequired[Nullable[str]]
    r"""For digital goods in most jurisdictions, you must apply the VAT rate from your customer's country. Choose the VAT
    rates you have used for the order to ensure your customer's country matches the VAT country.

    Use this parameter to restrict the payment methods available to your customer to those from a single country.

    If available, the credit card method will still be offered, but only cards from the allowed country are accepted.

    The field expects a country code in ISO 3166-1 alpha-2 format, for example `NL`.
    """
    metadata: NotRequired[Nullable[CreatePaymentMetadataRequestTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """
    capture_mode: NotRequired[Nullable[CreatePaymentCaptureModeRequest]]
    r"""Indicate if the funds should be captured immediately or if you want to [place a hold](https://docs.mollie.com/docs/place-a-hold-for-a-payment#/)
    and capture at a later time.

    This field needs to be set to `manual` for method `riverty`.
    """
    capture_delay: NotRequired[Nullable[str]]
    r"""**Only relevant if you wish to manage authorization and capturing separately.**

    Some payment methods allow placing a hold on the card or bank account. This hold or 'authorization' can then at a
    later point either be 'captured' or canceled.

    By default, we charge the customer's card or bank account immediately when they complete the payment. If you set a
    capture delay however, we will delay the automatic capturing of the payment for the specified amount of time. For
    example `8 hours` or `2 days`.

    To schedule an automatic capture, the `captureMode` must be set to `automatic`.

    The maximum delay is 7 days (168 hours).

    Possible values: `... hours` `... days`
    """
    application_fee: NotRequired[Nullable[CreatePaymentApplicationFeeRequestTypedDict]]
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the
    `routing` parameter.
    """
    routing: NotRequired[Nullable[List[CreatePaymentRoutingRequestTypedDict]]]
    r"""*This functionality is not enabled by default. Reach out to our partner management team if you wish to use it.*

    With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    If you create payments on your own account that you want to split between yourself and one or more connected
    merchants, you can use this `routing` parameter to route the payment accordingly.

    The `routing` parameter should contain an array of objects, with each object describing the destination for a
    specific portion of the payment.

    It is not necessary to indicate in the array which portion goes to yourself. After all portions of the total
    payment amount have been routed, the amount left will be routed to the current organization automatically.

    If instead you use OAuth to create payments on a connected merchant's account, refer to the `applicationFee`
    parameter.
    """
    sequence_type: NotRequired[Nullable[CreatePaymentSequenceTypeRequest]]
    r"""**Only relevant for recurring payments.**

    Indicate which part of a recurring sequence this payment is for.

    Recurring payments can only take place if a mandate is available. A common way to establish such a mandate is
    through a `first` payment. With a `first` payment, the customer agrees to automatic recurring charges taking place
    on their account in the future.

    If set to `recurring`, the customer's card is charged automatically.

    Defaults to `oneoff`, which is a regular non-recurring payment.

    For PayPal payments, recurring is only possible if your connected PayPal account allows it. You can call our
    [Methods API](list-methods) with parameter `sequenceType: first` to discover which payment methods on your account
    are set up correctly for recurring payments.
    """
    mandate_id: NotRequired[Nullable[str]]
    r"""**Only relevant for recurring payments.**

    When creating recurring payments, the ID of a specific [mandate](get-mandate) can be supplied to indicate which of
    the customer's accounts should be credited.
    """
    customer_id: NotRequired[Nullable[str]]
    r"""The ID of the [customer](get-customer) the payment is being created for. This is used primarily for recurring
    payments, but can also be used on regular payments to enable single-click payments.

    If `sequenceType` is set to `recurring`, this field is required.
    """
    profile_id: NotRequired[str]
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    When using an API Key, the `profileId` can be omitted since it is linked to the key. However, for OAuth and
    Organization tokens, the `profileId` is required.

    For more information, see [Authentication](authentication).
    """
    due_date: NotRequired[str]
    r"""The date by which the payment should be completed in `YYYY-MM-DD` format"""
    testmode: NotRequired[Nullable[bool]]
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """
    apple_pay_payment_token: NotRequired[str]
    r"""The Apple Pay Payment token object (encoded as JSON) that is part of the result of authorizing a payment request.
    The token contains the payment information needed to authorize the payment.

    The object should be passed encoded in a JSON string.
    """
    company: NotRequired[CreatePaymentCompanyTypedDict]
    r"""Billie is a business-to-business (B2B) payment method. It requires extra information to identify the organization
    that is completing the payment. It is recommended to include these parameters up front for a seamless flow.
    Otherwise, Billie will ask the customer to complete the missing fields during checkout.
    """
    card_token: NotRequired[str]
    r"""When creating credit card payments using Mollie Components, you need to provide the card token you received from
    the card component in this field. The token represents the customer's card information needed to complete the
    payment. Note: field only valid for oneoff and first payments. For recurring payments, the customerId alone is
    enough.
    """
    voucher_number: NotRequired[str]
    r"""The card token you received from the card component of Mollie Components. The token represents the customer's card
    information needed to complete the payment.
    """
    voucher_pin: NotRequired[str]
    r"""The PIN on the gift card. You can supply this to prefill the PIN, if the card has any."""
    consumer_date_of_birth: NotRequired[date]
    r"""The customer's date of birth. If not provided via the API, iDeal in3 will ask the customer to provide it during
    the payment process.
    """
    extra_merchant_data: NotRequired[Dict[str, Any]]
    r"""For some industries, additional purchase information can be sent to Klarna to increase the authorization rate.
    You can submit your extra data in this field if you have agreed upon this with Klarna. This field should be an
    object containing any of the allowed keys and sub-objects described at the Klarna Developer Documentation.
    """
    session_id: NotRequired[str]
    r"""The unique ID you have used for the PayPal fraud library. You should include this if you use PayPal for an
    on-demand payment.
    """
    digital_goods: NotRequired[bool]
    r"""Indicate if you are about to deliver digital goods, such as for example a software license. Setting this parameter
    can have consequences for your PayPal Seller Protection. Refer to PayPal's documentation for more information.
    """
    customer_reference: NotRequired[str]
    r"""Used by paysafecard for customer identification across payments. When you generate a customer reference yourself,
    make sure not to put personal identifiable information or IP addresses in the customer reference directly.
    """
    terminal_id: NotRequired[str]
    r"""The ID of the terminal device where you want to initiate the payment on."""


class CreatePaymentRequestBody(BaseModel):
    description: str
    r"""The description of the payment. This will be shown to your customer on their card or bank statement when possible.
    We truncate the description automatically according to the limits of the used payment method. The description is
    also visible in any exports you generate.

    We recommend you use a unique identifier so that you can always link the payment to the order in your back office.
    This is particularly useful for bookkeeping.

    The maximum length of the description field differs per payment method, with the absolute maximum being 255
    characters. The API will not reject strings longer than the maximum length but it will truncate them to fit.
    """

    amount: CreatePaymentAmountRequest
    r"""The amount that you want to charge, e.g. `{currency:\"EUR\", value:\"1000.00\"}` if you would want to charge €1000.00.

    You can find the minimum and maximum amounts per payment method in our help center. Additionally, they can be
    retrieved using the Get method endpoint.

    If a tip was added for a Point-of-Sale payment, the amount will be updated to reflect the initial amount plus the
    tip amount.
    """

    redirect_url: Annotated[Nullable[str], pydantic.Field(alias="redirectUrl")]
    r"""The URL your customer will be redirected to after the payment process.

    It could make sense for the redirectUrl to contain a unique identifier – like your order ID – so you can show the
    right page referencing the order when your customer returns.

    The parameter is normally required, but can be omitted for recurring payments (`sequenceType: recurring`) and for
    Apple Pay payments with an `applePayPaymentToken`.
    """

    cancel_url: Annotated[OptionalNullable[str], pydantic.Field(alias="cancelUrl")] = (
        UNSET
    )
    r"""The URL your customer will be redirected to when the customer explicitly cancels the payment. If this URL is not
    provided, the customer will be redirected to the `redirectUrl` instead — see above.

    Mollie will always give you status updates via webhooks, including for the canceled status. This parameter is
    therefore entirely optional, but can be useful when implementing a dedicated customer-facing flow to handle
    payment cancellations.
    """

    webhook_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="webhookUrl")
    ] = UNSET
    r"""The webhook URL where we will send payment status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to your payment.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use
    webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your
    local machine.
    """

    lines: OptionalNullable[List[CreatePaymentLineRequest]] = UNSET
    r"""Optionally provide the order lines for the payment. Each line contains details such as a description of the item
    ordered and its price.

    All lines must have the same currency as the payment.

    Required for payment methods `billie`, `in3`, `klarna`, `riverty` and `voucher`.
    """

    billing_address: Annotated[
        Optional[CreatePaymentBillingAddressRequest],
        pydantic.Field(alias="billingAddress"),
    ] = None
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.

    Required for payment method `in3`, `klarna`, `billie` and `riverty`.
    """

    shipping_address: Annotated[
        Optional[CreatePaymentShippingAddressRequest],
        pydantic.Field(alias="shippingAddress"),
    ] = None
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.
    """

    locale: OptionalNullable[CreatePaymentLocaleRequest] = UNSET
    r"""Allows you to preset the language to be used in the hosted payment pages shown to the customer. Setting a locale
    is highly recommended and will greatly improve your conversion rate. When this parameter is omitted the browser
    language will be used instead if supported by the payment method. You can provide any `xx_XX` format ISO 15897
    locale, but our hosted payment pages currently only support the specified languages.

    For bank transfer payments specifically, the locale will determine the target bank account the customer has to
    transfer the money to. We have dedicated bank accounts for Belgium, Germany, and The Netherlands. Having the
    customer use a local bank account greatly increases the conversion and speed of payment.
    """

    method: OptionalNullable[CreatePaymentMethodRequest] = UNSET
    r"""Normally, a payment method screen is shown. However, when using this parameter, you can choose a specific payment
    method and your customer will skip the selection screen and is sent directly to the chosen payment method. The
    parameter enables you to fully integrate the payment method selection into your website.

    You can also specify the methods in an array. By doing so we will still show the payment method selection screen
    but will only show the methods specified in the array. For example, you can use this functionality to only show
    payment methods from a specific country to your customer `['bancontact', 'belfius']`.
    """

    issuer: OptionalNullable[str] = UNSET
    r"""**Only relevant for iDEAL, KBC/CBC, gift card, and voucher payments.**

    **⚠️ With the introduction of iDEAL 2 in 2025, this field will be ignored for iDEAL payments. For more information
    on the migration, refer to our [help center](https://help.mollie.com/hc/articles/19100313768338-iDEAL-2-0).**

    Some payment methods are a network of connected banks or card issuers. In these cases, after selecting the payment
    method, the customer may still need to select the appropriate issuer before the payment can proceed.

    We provide hosted issuer selection screens, but these screens can be skipped by providing the `issuer` via the API
    up front.

    The full list of issuers for a specific method can be retrieved via the Methods API by using the optional
    `issuers` include.

    A valid issuer for iDEAL is for example `ideal_INGBNL2A` (for ING Bank).
    """

    restrict_payment_methods_to_country: Annotated[
        OptionalNullable[str], pydantic.Field(alias="restrictPaymentMethodsToCountry")
    ] = UNSET
    r"""For digital goods in most jurisdictions, you must apply the VAT rate from your customer's country. Choose the VAT
    rates you have used for the order to ensure your customer's country matches the VAT country.

    Use this parameter to restrict the payment methods available to your customer to those from a single country.

    If available, the credit card method will still be offered, but only cards from the allowed country are accepted.

    The field expects a country code in ISO 3166-1 alpha-2 format, for example `NL`.
    """

    metadata: OptionalNullable[CreatePaymentMetadataRequest] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """

    capture_mode: Annotated[
        OptionalNullable[CreatePaymentCaptureModeRequest],
        pydantic.Field(alias="captureMode"),
    ] = UNSET
    r"""Indicate if the funds should be captured immediately or if you want to [place a hold](https://docs.mollie.com/docs/place-a-hold-for-a-payment#/)
    and capture at a later time.

    This field needs to be set to `manual` for method `riverty`.
    """

    capture_delay: Annotated[
        OptionalNullable[str], pydantic.Field(alias="captureDelay")
    ] = UNSET
    r"""**Only relevant if you wish to manage authorization and capturing separately.**

    Some payment methods allow placing a hold on the card or bank account. This hold or 'authorization' can then at a
    later point either be 'captured' or canceled.

    By default, we charge the customer's card or bank account immediately when they complete the payment. If you set a
    capture delay however, we will delay the automatic capturing of the payment for the specified amount of time. For
    example `8 hours` or `2 days`.

    To schedule an automatic capture, the `captureMode` must be set to `automatic`.

    The maximum delay is 7 days (168 hours).

    Possible values: `... hours` `... days`
    """

    application_fee: Annotated[
        OptionalNullable[CreatePaymentApplicationFeeRequest],
        pydantic.Field(alias="applicationFee"),
    ] = UNSET
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the
    `routing` parameter.
    """

    routing: OptionalNullable[List[CreatePaymentRoutingRequest]] = UNSET
    r"""*This functionality is not enabled by default. Reach out to our partner management team if you wish to use it.*

    With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    If you create payments on your own account that you want to split between yourself and one or more connected
    merchants, you can use this `routing` parameter to route the payment accordingly.

    The `routing` parameter should contain an array of objects, with each object describing the destination for a
    specific portion of the payment.

    It is not necessary to indicate in the array which portion goes to yourself. After all portions of the total
    payment amount have been routed, the amount left will be routed to the current organization automatically.

    If instead you use OAuth to create payments on a connected merchant's account, refer to the `applicationFee`
    parameter.
    """

    sequence_type: Annotated[
        OptionalNullable[CreatePaymentSequenceTypeRequest],
        pydantic.Field(alias="sequenceType"),
    ] = UNSET
    r"""**Only relevant for recurring payments.**

    Indicate which part of a recurring sequence this payment is for.

    Recurring payments can only take place if a mandate is available. A common way to establish such a mandate is
    through a `first` payment. With a `first` payment, the customer agrees to automatic recurring charges taking place
    on their account in the future.

    If set to `recurring`, the customer's card is charged automatically.

    Defaults to `oneoff`, which is a regular non-recurring payment.

    For PayPal payments, recurring is only possible if your connected PayPal account allows it. You can call our
    [Methods API](list-methods) with parameter `sequenceType: first` to discover which payment methods on your account
    are set up correctly for recurring payments.
    """

    mandate_id: Annotated[OptionalNullable[str], pydantic.Field(alias="mandateId")] = (
        UNSET
    )
    r"""**Only relevant for recurring payments.**

    When creating recurring payments, the ID of a specific [mandate](get-mandate) can be supplied to indicate which of
    the customer's accounts should be credited.
    """

    customer_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="customerId")
    ] = UNSET
    r"""The ID of the [customer](get-customer) the payment is being created for. This is used primarily for recurring
    payments, but can also be used on regular payments to enable single-click payments.

    If `sequenceType` is set to `recurring`, this field is required.
    """

    profile_id: Annotated[Optional[str], pydantic.Field(alias="profileId")] = None
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    When using an API Key, the `profileId` can be omitted since it is linked to the key. However, for OAuth and
    Organization tokens, the `profileId` is required.

    For more information, see [Authentication](authentication).
    """

    due_date: Annotated[Optional[str], pydantic.Field(alias="dueDate")] = None
    r"""The date by which the payment should be completed in `YYYY-MM-DD` format"""

    testmode: OptionalNullable[bool] = UNSET
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """

    apple_pay_payment_token: Annotated[
        Optional[str], pydantic.Field(alias="applePayPaymentToken")
    ] = None
    r"""The Apple Pay Payment token object (encoded as JSON) that is part of the result of authorizing a payment request.
    The token contains the payment information needed to authorize the payment.

    The object should be passed encoded in a JSON string.
    """

    company: Optional[CreatePaymentCompany] = None
    r"""Billie is a business-to-business (B2B) payment method. It requires extra information to identify the organization
    that is completing the payment. It is recommended to include these parameters up front for a seamless flow.
    Otherwise, Billie will ask the customer to complete the missing fields during checkout.
    """

    card_token: Annotated[Optional[str], pydantic.Field(alias="cardToken")] = None
    r"""When creating credit card payments using Mollie Components, you need to provide the card token you received from
    the card component in this field. The token represents the customer's card information needed to complete the
    payment. Note: field only valid for oneoff and first payments. For recurring payments, the customerId alone is
    enough.
    """

    voucher_number: Annotated[Optional[str], pydantic.Field(alias="voucherNumber")] = (
        None
    )
    r"""The card token you received from the card component of Mollie Components. The token represents the customer's card
    information needed to complete the payment.
    """

    voucher_pin: Annotated[Optional[str], pydantic.Field(alias="voucherPin")] = None
    r"""The PIN on the gift card. You can supply this to prefill the PIN, if the card has any."""

    consumer_date_of_birth: Annotated[
        Optional[date], pydantic.Field(alias="consumerDateOfBirth")
    ] = None
    r"""The customer's date of birth. If not provided via the API, iDeal in3 will ask the customer to provide it during
    the payment process.
    """

    extra_merchant_data: Annotated[
        Optional[Dict[str, Any]], pydantic.Field(alias="extraMerchantData")
    ] = None
    r"""For some industries, additional purchase information can be sent to Klarna to increase the authorization rate.
    You can submit your extra data in this field if you have agreed upon this with Klarna. This field should be an
    object containing any of the allowed keys and sub-objects described at the Klarna Developer Documentation.
    """

    session_id: Annotated[Optional[str], pydantic.Field(alias="sessionId")] = None
    r"""The unique ID you have used for the PayPal fraud library. You should include this if you use PayPal for an
    on-demand payment.
    """

    digital_goods: Annotated[Optional[bool], pydantic.Field(alias="digitalGoods")] = (
        None
    )
    r"""Indicate if you are about to deliver digital goods, such as for example a software license. Setting this parameter
    can have consequences for your PayPal Seller Protection. Refer to PayPal's documentation for more information.
    """

    customer_reference: Annotated[
        Optional[str], pydantic.Field(alias="customerReference")
    ] = None
    r"""Used by paysafecard for customer identification across payments. When you generate a customer reference yourself,
    make sure not to put personal identifiable information or IP addresses in the customer reference directly.
    """

    terminal_id: Annotated[Optional[str], pydantic.Field(alias="terminalId")] = None
    r"""The ID of the terminal device where you want to initiate the payment on."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "cancelUrl",
            "webhookUrl",
            "lines",
            "billingAddress",
            "shippingAddress",
            "locale",
            "method",
            "issuer",
            "restrictPaymentMethodsToCountry",
            "metadata",
            "captureMode",
            "captureDelay",
            "applicationFee",
            "routing",
            "sequenceType",
            "mandateId",
            "customerId",
            "profileId",
            "dueDate",
            "testmode",
            "applePayPaymentToken",
            "company",
            "cardToken",
            "voucherNumber",
            "voucherPin",
            "consumerDateOfBirth",
            "extraMerchantData",
            "sessionId",
            "digitalGoods",
            "customerReference",
            "terminalId",
        ]
        nullable_fields = [
            "redirectUrl",
            "cancelUrl",
            "webhookUrl",
            "lines",
            "locale",
            "method",
            "issuer",
            "restrictPaymentMethodsToCountry",
            "metadata",
            "captureMode",
            "captureDelay",
            "applicationFee",
            "routing",
            "sequenceType",
            "mandateId",
            "customerId",
            "testmode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreatePaymentRequestTypedDict(TypedDict):
    include: NotRequired[Nullable[CreatePaymentInclude]]
    r"""This endpoint allows you to include additional information via the `include` query string parameter."""
    request_body: NotRequired[CreatePaymentRequestBodyTypedDict]


class CreatePaymentRequest(BaseModel):
    include: Annotated[
        OptionalNullable[CreatePaymentInclude],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""This endpoint allows you to include additional information via the `include` query string parameter."""

    request_body: Annotated[
        Optional[CreatePaymentRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["include", "RequestBody"]
        nullable_fields = ["include"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreatePaymentServiceUnavailableDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class CreatePaymentServiceUnavailableDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class CreatePaymentServiceUnavailableLinksTypedDict(TypedDict):
    documentation: CreatePaymentServiceUnavailableDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class CreatePaymentServiceUnavailableLinks(BaseModel):
    documentation: CreatePaymentServiceUnavailableDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class CreatePaymentServiceUnavailableHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[
        CreatePaymentServiceUnavailableLinks, pydantic.Field(alias="_links")
    ]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class CreatePaymentServiceUnavailableHalJSONError(ClientError):
    r"""An error response object."""

    data: CreatePaymentServiceUnavailableHalJSONErrorData

    def __init__(
        self,
        data: CreatePaymentServiceUnavailableHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class CreatePaymentUnprocessableEntityDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class CreatePaymentUnprocessableEntityDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class CreatePaymentUnprocessableEntityLinksTypedDict(TypedDict):
    documentation: CreatePaymentUnprocessableEntityDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class CreatePaymentUnprocessableEntityLinks(BaseModel):
    documentation: CreatePaymentUnprocessableEntityDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class CreatePaymentUnprocessableEntityHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[
        CreatePaymentUnprocessableEntityLinks, pydantic.Field(alias="_links")
    ]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class CreatePaymentUnprocessableEntityHalJSONError(ClientError):
    r"""An error response object."""

    data: CreatePaymentUnprocessableEntityHalJSONErrorData

    def __init__(
        self,
        data: CreatePaymentUnprocessableEntityHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class CreatePaymentMode(str, Enum):
    r"""Whether this entity was created in live mode or in test mode."""

    LIVE = "live"
    TEST = "test"


class CreatePaymentAmountResponseTypedDict(TypedDict):
    r"""The amount that you want to charge, e.g. `{currency:\"EUR\", value:\"1000.00\"}` if you would want to charge €1000.00.

    You can find the minimum and maximum amounts per payment method in our help center. Additionally, they can be
    retrieved using the Get method endpoint.

    If a tip was added for a Point-of-Sale payment, the amount will be updated to reflect the initial amount plus the
    tip amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentAmountResponse(BaseModel):
    r"""The amount that you want to charge, e.g. `{currency:\"EUR\", value:\"1000.00\"}` if you would want to charge €1000.00.

    You can find the minimum and maximum amounts per payment method in our help center. Additionally, they can be
    retrieved using the Get method endpoint.

    If a tip was added for a Point-of-Sale payment, the amount will be updated to reflect the initial amount plus the
    tip amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentAmountRefundedTypedDict(TypedDict):
    r"""The total amount that is already refunded. Only available when refunds are available for this payment. For some
    payment methods, this amount may be higher than the payment amount, for example to allow reimbursement of the
    costs for a return shipment to the customer.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentAmountRefunded(BaseModel):
    r"""The total amount that is already refunded. Only available when refunds are available for this payment. For some
    payment methods, this amount may be higher than the payment amount, for example to allow reimbursement of the
    costs for a return shipment to the customer.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentAmountRemainingTypedDict(TypedDict):
    r"""The remaining amount that can be refunded. Only available when refunds are available for this payment."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentAmountRemaining(BaseModel):
    r"""The remaining amount that can be refunded. Only available when refunds are available for this payment."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentAmountCapturedTypedDict(TypedDict):
    r"""The total amount that is already captured for this payment. Only available when this payment supports captures."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentAmountCaptured(BaseModel):
    r"""The total amount that is already captured for this payment. Only available when this payment supports captures."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentAmountChargedBackTypedDict(TypedDict):
    r"""The total amount that was charged back for this payment. Only available when the total charged back amount is not
    zero.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentAmountChargedBack(BaseModel):
    r"""The total amount that was charged back for this payment. Only available when the total charged back amount is not
    zero.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentSettlementAmountTypedDict(TypedDict):
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the
    currency your account is settled in.

    Any amounts not settled by Mollie will not be reflected in this amount, e.g. PayPal or gift cards. If no amount is
    settled by Mollie the `settlementAmount` is omitted from the response.

    Please note that this amount might be recalculated and changed when the status of the payment changes. We suggest
    using the List balance transactions endpoint instead to get more accurate settlement amounts for your payments.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentSettlementAmount(BaseModel):
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the
    currency your account is settled in.

    Any amounts not settled by Mollie will not be reflected in this amount, e.g. PayPal or gift cards. If no amount is
    settled by Mollie the `settlementAmount` is omitted from the response.

    Please note that this amount might be recalculated and changed when the status of the payment changes. We suggest
    using the List balance transactions endpoint instead to get more accurate settlement amounts for your payments.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentLineTypeResponse(str, Enum):
    r"""The type of product purchased. For example, a physical or a digital product.

    The `tip` payment line type is not available when creating a payment.
    """

    PHYSICAL = "physical"
    DIGITAL = "digital"
    SHIPPING_FEE = "shipping_fee"
    DISCOUNT = "discount"
    STORE_CREDIT = "store_credit"
    GIFT_CARD = "gift_card"
    SURCHARGE = "surcharge"
    TIP = "tip"


class CreatePaymentUnitPriceResponseTypedDict(TypedDict):
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentUnitPriceResponse(BaseModel):
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentDiscountAmountResponseTypedDict(TypedDict):
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount
    type.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentDiscountAmountResponse(BaseModel):
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount
    type.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentTotalAmountResponseTypedDict(TypedDict):
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentTotalAmountResponse(BaseModel):
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentVatAmountResponseTypedDict(TypedDict):
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be
    calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of
    `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentVatAmountResponse(BaseModel):
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be
    calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of
    `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentCategoryResponse(str, Enum):
    MEAL = "meal"
    ECO = "eco"
    GIFT = "gift"
    SPORT_CULTURE = "sport_culture"


class CreatePaymentRecurringAmountResponseTypedDict(TypedDict):
    r"""Total amount and currency of the recurring item."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentRecurringAmountResponse(BaseModel):
    r"""Total amount and currency of the recurring item."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentRecurringResponseTypedDict(TypedDict):
    r"""The details of subsequent recurring billing cycles. These parameters are used in the Mollie Checkout
    to inform the shopper of the details for recurring products in the payments.
    """

    interval: str
    r"""Cadence unit of the recurring item. For example: `12 months`, `52 weeks` or `365 days`.

    Possible values: `... days`, `... weeks`, `... months`.
    """
    description: NotRequired[str]
    r"""A description of the recurring item. If not present, the main description of the item will be used."""
    amount: NotRequired[CreatePaymentRecurringAmountResponseTypedDict]
    r"""Total amount and currency of the recurring item."""
    times: NotRequired[int]
    r"""Total number of charges for the subscription to complete. Leave empty for ongoing subscription."""
    start_date: NotRequired[Nullable[str]]
    r"""The start date of the subscription if it does not start right away (format `YYYY-MM-DD`)"""


class CreatePaymentRecurringResponse(BaseModel):
    r"""The details of subsequent recurring billing cycles. These parameters are used in the Mollie Checkout
    to inform the shopper of the details for recurring products in the payments.
    """

    interval: str
    r"""Cadence unit of the recurring item. For example: `12 months`, `52 weeks` or `365 days`.

    Possible values: `... days`, `... weeks`, `... months`.
    """

    description: Optional[str] = None
    r"""A description of the recurring item. If not present, the main description of the item will be used."""

    amount: Optional[CreatePaymentRecurringAmountResponse] = None
    r"""Total amount and currency of the recurring item."""

    times: Optional[int] = None
    r"""Total number of charges for the subscription to complete. Leave empty for ongoing subscription."""

    start_date: Annotated[OptionalNullable[str], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the subscription if it does not start right away (format `YYYY-MM-DD`)"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "amount", "times", "startDate"]
        nullable_fields = ["startDate"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreatePaymentLineResponseTypedDict(TypedDict):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""
    quantity: int
    r"""The number of items."""
    unit_price: CreatePaymentUnitPriceResponseTypedDict
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """
    total_amount: CreatePaymentTotalAmountResponseTypedDict
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """
    type: NotRequired[CreatePaymentLineTypeResponse]
    r"""The type of product purchased. For example, a physical or a digital product.

    The `tip` payment line type is not available when creating a payment.
    """
    quantity_unit: NotRequired[str]
    r"""The unit for the quantity. For example *pcs*, *kg*, or *cm*."""
    discount_amount: NotRequired[CreatePaymentDiscountAmountResponseTypedDict]
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount
    type.
    """
    vat_rate: NotRequired[str]
    r"""The VAT rate applied to the line, for example `21.00` for 21%. The vatRate should be passed as a string and
    not as a float, to ensure the correct number of decimals are passed.
    """
    vat_amount: NotRequired[CreatePaymentVatAmountResponseTypedDict]
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be
    calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of
    `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """
    sku: NotRequired[str]
    r"""The SKU, EAN, ISBN or UPC of the product sold."""
    categories: NotRequired[List[CreatePaymentCategoryResponse]]
    r"""An array with the voucher categories, in case of a line eligible for a voucher. See the
    [Integrating Vouchers](https://docs.mollie.com/docs/integrating-vouchers/) guide for more information.
    """
    image_url: NotRequired[str]
    r"""A link pointing to an image of the product sold."""
    product_url: NotRequired[str]
    r"""A link pointing to the product page in your web shop of the product sold."""
    recurring: NotRequired[CreatePaymentRecurringResponseTypedDict]
    r"""The details of subsequent recurring billing cycles. These parameters are used in the Mollie Checkout
    to inform the shopper of the details for recurring products in the payments.
    """


class CreatePaymentLineResponse(BaseModel):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""

    quantity: int
    r"""The number of items."""

    unit_price: Annotated[
        CreatePaymentUnitPriceResponse, pydantic.Field(alias="unitPrice")
    ]
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """

    total_amount: Annotated[
        CreatePaymentTotalAmountResponse, pydantic.Field(alias="totalAmount")
    ]
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """

    type: Optional[CreatePaymentLineTypeResponse] = None
    r"""The type of product purchased. For example, a physical or a digital product.

    The `tip` payment line type is not available when creating a payment.
    """

    quantity_unit: Annotated[Optional[str], pydantic.Field(alias="quantityUnit")] = None
    r"""The unit for the quantity. For example *pcs*, *kg*, or *cm*."""

    discount_amount: Annotated[
        Optional[CreatePaymentDiscountAmountResponse],
        pydantic.Field(alias="discountAmount"),
    ] = None
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount
    type.
    """

    vat_rate: Annotated[Optional[str], pydantic.Field(alias="vatRate")] = None
    r"""The VAT rate applied to the line, for example `21.00` for 21%. The vatRate should be passed as a string and
    not as a float, to ensure the correct number of decimals are passed.
    """

    vat_amount: Annotated[
        Optional[CreatePaymentVatAmountResponse], pydantic.Field(alias="vatAmount")
    ] = None
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be
    calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of
    `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """

    sku: Optional[str] = None
    r"""The SKU, EAN, ISBN or UPC of the product sold."""

    categories: Optional[List[CreatePaymentCategoryResponse]] = None
    r"""An array with the voucher categories, in case of a line eligible for a voucher. See the
    [Integrating Vouchers](https://docs.mollie.com/docs/integrating-vouchers/) guide for more information.
    """

    image_url: Annotated[Optional[str], pydantic.Field(alias="imageUrl")] = None
    r"""A link pointing to an image of the product sold."""

    product_url: Annotated[Optional[str], pydantic.Field(alias="productUrl")] = None
    r"""A link pointing to the product page in your web shop of the product sold."""

    recurring: Optional[CreatePaymentRecurringResponse] = None
    r"""The details of subsequent recurring billing cycles. These parameters are used in the Mollie Checkout
    to inform the shopper of the details for recurring products in the payments.
    """


class CreatePaymentBillingAddressResponseTypedDict(TypedDict):
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.

    Required for payment method `in3`, `klarna`, `billie` and `riverty`.
    """

    title: NotRequired[str]
    r"""The title of the person, for example *Mr.* or *Mrs.*."""
    given_name: NotRequired[str]
    r"""The given name (first name) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    family_name: NotRequired[str]
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    organization_name: NotRequired[str]
    r"""The name of the organization, in case the addressee is an organization."""
    street_and_number: NotRequired[str]
    r"""A street and street number.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    street_additional: NotRequired[str]
    r"""Any additional addressing details, for example an apartment number."""
    postal_code: NotRequired[str]
    r"""A postal code. This field may be required if the provided country has a postal code system.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    email: NotRequired[str]
    r"""A valid e-mail address.

    If you provide the email address for a `banktransfer` payment, we will automatically send the instructions
    email upon payment creation. The language of the email will follow the locale parameter of the payment.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    phone: NotRequired[str]
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""
    city: NotRequired[str]
    r"""A city name.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    region: NotRequired[str]
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""
    country: NotRequired[str]
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """


class CreatePaymentBillingAddressResponse(BaseModel):
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.

    Required for payment method `in3`, `klarna`, `billie` and `riverty`.
    """

    title: Optional[str] = None
    r"""The title of the person, for example *Mr.* or *Mrs.*."""

    given_name: Annotated[Optional[str], pydantic.Field(alias="givenName")] = None
    r"""The given name (first name) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    family_name: Annotated[Optional[str], pydantic.Field(alias="familyName")] = None
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    organization_name: Annotated[
        Optional[str], pydantic.Field(alias="organizationName")
    ] = None
    r"""The name of the organization, in case the addressee is an organization."""

    street_and_number: Annotated[
        Optional[str], pydantic.Field(alias="streetAndNumber")
    ] = None
    r"""A street and street number.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    street_additional: Annotated[
        Optional[str], pydantic.Field(alias="streetAdditional")
    ] = None
    r"""Any additional addressing details, for example an apartment number."""

    postal_code: Annotated[Optional[str], pydantic.Field(alias="postalCode")] = None
    r"""A postal code. This field may be required if the provided country has a postal code system.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    email: Optional[str] = None
    r"""A valid e-mail address.

    If you provide the email address for a `banktransfer` payment, we will automatically send the instructions
    email upon payment creation. The language of the email will follow the locale parameter of the payment.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    phone: Optional[str] = None
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""

    city: Optional[str] = None
    r"""A city name.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    region: Optional[str] = None
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""

    country: Optional[str] = None
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """


class CreatePaymentShippingAddressResponseTypedDict(TypedDict):
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.
    """

    title: NotRequired[str]
    r"""The title of the person, for example *Mr.* or *Mrs.*."""
    given_name: NotRequired[str]
    r"""The given name (first name) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    family_name: NotRequired[str]
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    organization_name: NotRequired[str]
    r"""The name of the organization, in case the addressee is an organization."""
    street_and_number: NotRequired[str]
    r"""A street and street number.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    street_additional: NotRequired[str]
    r"""Any additional addressing details, for example an apartment number."""
    postal_code: NotRequired[str]
    r"""A postal code. This field may be required if the provided country has a postal code system.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    email: NotRequired[str]
    r"""A valid e-mail address.

    If you provide the email address for a `banktransfer` payment, we will automatically send the instructions
    email upon payment creation. The language of the email will follow the locale parameter of the payment.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    phone: NotRequired[str]
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""
    city: NotRequired[str]
    r"""A city name.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    region: NotRequired[str]
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""
    country: NotRequired[str]
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """


class CreatePaymentShippingAddressResponse(BaseModel):
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.
    """

    title: Optional[str] = None
    r"""The title of the person, for example *Mr.* or *Mrs.*."""

    given_name: Annotated[Optional[str], pydantic.Field(alias="givenName")] = None
    r"""The given name (first name) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    family_name: Annotated[Optional[str], pydantic.Field(alias="familyName")] = None
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    organization_name: Annotated[
        Optional[str], pydantic.Field(alias="organizationName")
    ] = None
    r"""The name of the organization, in case the addressee is an organization."""

    street_and_number: Annotated[
        Optional[str], pydantic.Field(alias="streetAndNumber")
    ] = None
    r"""A street and street number.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    street_additional: Annotated[
        Optional[str], pydantic.Field(alias="streetAdditional")
    ] = None
    r"""Any additional addressing details, for example an apartment number."""

    postal_code: Annotated[Optional[str], pydantic.Field(alias="postalCode")] = None
    r"""A postal code. This field may be required if the provided country has a postal code system.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    email: Optional[str] = None
    r"""A valid e-mail address.

    If you provide the email address for a `banktransfer` payment, we will automatically send the instructions
    email upon payment creation. The language of the email will follow the locale parameter of the payment.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    phone: Optional[str] = None
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""

    city: Optional[str] = None
    r"""A city name.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    region: Optional[str] = None
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""

    country: Optional[str] = None
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """


class CreatePaymentLocaleResponse(str, Enum):
    r"""Allows you to preset the language to be used in the hosted payment pages shown to the customer. Setting a locale
    is highly recommended and will greatly improve your conversion rate. When this parameter is omitted the browser
    language will be used instead if supported by the payment method. You can provide any `xx_XX` format ISO 15897
    locale, but our hosted payment pages currently only support the specified languages.

    For bank transfer payments specifically, the locale will determine the target bank account the customer has to
    transfer the money to. We have dedicated bank accounts for Belgium, Germany, and The Netherlands. Having the
    customer use a local bank account greatly increases the conversion and speed of payment.
    """

    EN_US = "en_US"
    EN_GB = "en_GB"
    NL_NL = "nl_NL"
    NL_BE = "nl_BE"
    DE_DE = "de_DE"
    DE_AT = "de_AT"
    DE_CH = "de_CH"
    FR_FR = "fr_FR"
    FR_BE = "fr_BE"
    ES_ES = "es_ES"
    CA_ES = "ca_ES"
    PT_PT = "pt_PT"
    IT_IT = "it_IT"
    NB_NO = "nb_NO"
    SV_SE = "sv_SE"
    FI_FI = "fi_FI"
    DA_DK = "da_DK"
    IS_IS = "is_IS"
    HU_HU = "hu_HU"
    PL_PL = "pl_PL"
    LV_LV = "lv_LV"
    LT_LT = "lt_LT"


class CreatePaymentMethodResponse(str, Enum):
    r"""The payment method used for this transaction. If a specific method was selected during payment initialization,
    this field reflects that choice.
    """

    ALMA = "alma"
    APPLEPAY = "applepay"
    BACS = "bacs"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    IDEAL = "ideal"
    IN3 = "in3"
    KBC = "kbc"
    KLARNA = "klarna"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    POINTOFSALE = "pointofsale"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


CreatePaymentMetadataResponseTypedDict = TypeAliasType(
    "CreatePaymentMetadataResponseTypedDict", Union[str, Dict[str, Any], List[str]]
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
"""


CreatePaymentMetadataResponse = TypeAliasType(
    "CreatePaymentMetadataResponse", Union[str, Dict[str, Any], List[str]]
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
"""


class CreatePaymentCaptureModeResponse(str, Enum):
    r"""Indicate if the funds should be captured immediately or if you want to [place a hold](https://docs.mollie.com/docs/place-a-hold-for-a-payment#/)
    and capture at a later time.

    This field needs to be set to `manual` for method `riverty`.
    """

    AUTOMATIC = "automatic"
    MANUAL = "manual"


class CreatePaymentApplicationFeeAmountResponseTypedDict(TypedDict):
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge
    a €0.99 fee on a €1.00 payment.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentApplicationFeeAmountResponse(BaseModel):
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge
    a €0.99 fee on a €1.00 payment.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentApplicationFeeResponseTypedDict(TypedDict):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the
    `routing` parameter.
    """

    amount: NotRequired[CreatePaymentApplicationFeeAmountResponseTypedDict]
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge
    a €0.99 fee on a €1.00 payment.
    """
    description: NotRequired[str]
    r"""The description of the application fee. This will appear on settlement reports towards both you and the
    connected merchant.
    """


class CreatePaymentApplicationFeeResponse(BaseModel):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the
    `routing` parameter.
    """

    amount: Optional[CreatePaymentApplicationFeeAmountResponse] = None
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge
    a €0.99 fee on a €1.00 payment.
    """

    description: Optional[str] = None
    r"""The description of the application fee. This will appear on settlement reports towards both you and the
    connected merchant.
    """


class CreatePaymentRoutingMode(str, Enum):
    r"""Whether this entity was created in live mode or in test mode."""

    LIVE = "live"
    TEST = "test"


class CreatePaymentRoutingAmountResponseTypedDict(TypedDict):
    r"""The portion of the total payment amount being routed. Currently only `EUR` payments can be routed."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentRoutingAmountResponse(BaseModel):
    r"""The portion of the total payment amount being routed. Currently only `EUR` payments can be routed."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentRoutingTypeResponse(str, Enum):
    r"""The type of destination. Currently only the destination type `organization` is supported."""

    ORGANIZATION = "organization"


class CreatePaymentDestinationResponseTypedDict(TypedDict):
    r"""The destination of this portion of the payment."""

    type: CreatePaymentRoutingTypeResponse
    r"""The type of destination. Currently only the destination type `organization` is supported."""
    organization_id: str
    r"""Required for destination type `organization`. The ID of the connected organization the funds should be
    routed to.
    """


class CreatePaymentDestinationResponse(BaseModel):
    r"""The destination of this portion of the payment."""

    type: CreatePaymentRoutingTypeResponse
    r"""The type of destination. Currently only the destination type `organization` is supported."""

    organization_id: Annotated[str, pydantic.Field(alias="organizationId")]
    r"""Required for destination type `organization`. The ID of the connected organization the funds should be
    routed to.
    """


class CreatePaymentRoutingSelfResponseTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentRoutingSelfResponse(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentPaymentResponseTypedDict(TypedDict):
    r"""The API resource URL of the [payment](get-payment) that belong to this route."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentPaymentResponse(BaseModel):
    r"""The API resource URL of the [payment](get-payment) that belong to this route."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentRoutingLinksResponseTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: CreatePaymentRoutingSelfResponseTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payment: CreatePaymentPaymentResponseTypedDict
    r"""The API resource URL of the [payment](get-payment) that belong to this route."""


class CreatePaymentRoutingLinksResponse(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[CreatePaymentRoutingSelfResponse, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payment: CreatePaymentPaymentResponse
    r"""The API resource URL of the [payment](get-payment) that belong to this route."""


class CreatePaymentRoutingResponseTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a route object. Will always contain the string `route` for this endpoint."""
    id: str
    r"""The identifier uniquely referring to this route. Mollie will always refer to the route by this ID.
    Example: `rt_5B8cwPMGnU6qLbRvo7qEZo`.
    """
    mode: CreatePaymentRoutingMode
    r"""Whether this entity was created in live mode or in test mode."""
    amount: CreatePaymentRoutingAmountResponseTypedDict
    r"""The portion of the total payment amount being routed. Currently only `EUR` payments can be routed."""
    destination: CreatePaymentDestinationResponseTypedDict
    r"""The destination of this portion of the payment."""
    created_at: str
    r"""The date and time when the route was created. The date is given in ISO 8601 format."""
    links: CreatePaymentRoutingLinksResponseTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    release_date: NotRequired[Nullable[str]]
    r"""Optionally, schedule this portion of the payment to be transferred to its destination on a later date. The
    date must be given in `YYYY-MM-DD` format.

    If no date is given, the funds become available to the connected merchant as soon as the payment succeeds.
    """


class CreatePaymentRoutingResponse(BaseModel):
    resource: str
    r"""Indicates the response contains a route object. Will always contain the string `route` for this endpoint."""

    id: str
    r"""The identifier uniquely referring to this route. Mollie will always refer to the route by this ID.
    Example: `rt_5B8cwPMGnU6qLbRvo7qEZo`.
    """

    mode: CreatePaymentRoutingMode
    r"""Whether this entity was created in live mode or in test mode."""

    amount: CreatePaymentRoutingAmountResponse
    r"""The portion of the total payment amount being routed. Currently only `EUR` payments can be routed."""

    destination: CreatePaymentDestinationResponse
    r"""The destination of this portion of the payment."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The date and time when the route was created. The date is given in ISO 8601 format."""

    links: Annotated[CreatePaymentRoutingLinksResponse, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    release_date: Annotated[
        OptionalNullable[str], pydantic.Field(alias="releaseDate")
    ] = UNSET
    r"""Optionally, schedule this portion of the payment to be transferred to its destination on a later date. The
    date must be given in `YYYY-MM-DD` format.

    If no date is given, the funds become available to the connected merchant as soon as the payment succeeds.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["releaseDate"]
        nullable_fields = ["releaseDate"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreatePaymentSequenceTypeResponse(str, Enum):
    r"""**Only relevant for recurring payments.**

    Indicate which part of a recurring sequence this payment is for.

    Recurring payments can only take place if a mandate is available. A common way to establish such a mandate is
    through a `first` payment. With a `first` payment, the customer agrees to automatic recurring charges taking place
    on their account in the future.

    If set to `recurring`, the customer's card is charged automatically.

    Defaults to `oneoff`, which is a regular non-recurring payment.

    For PayPal payments, recurring is only possible if your connected PayPal account allows it. You can call our
    [Methods API](list-methods) with parameter `sequenceType: first` to discover which payment methods on your account
    are set up correctly for recurring payments.
    """

    ONEOFF = "oneoff"
    FIRST = "first"
    RECURRING = "recurring"


class CreatePaymentStatusEnum(str, Enum):
    r"""The payment's status. Refer to the [documentation regarding statuses](https://docs.mollie.com/docs/status-change#/) for more info about which
    statuses occur at what point.
    """

    OPEN = "open"
    PENDING = "pending"
    AUTHORIZED = "authorized"
    PAID = "paid"
    CANCELED = "canceled"
    EXPIRED = "expired"
    FAILED = "failed"


class CreatePaymentCode(str, Enum):
    r"""A machine-readable code that indicates the reason for the payment's status."""

    APPROVED_OR_COMPLETED_SUCCESSFULLY = "approved_or_completed_successfully"
    REFER_TO_CARD_ISSUER = "refer_to_card_issuer"
    INVALID_MERCHANT = "invalid_merchant"
    CAPTURE_CARD = "capture_card"
    DO_NOT_HONOR = "do_not_honor"
    ERROR = "error"
    PARTIAL_APPROVAL = "partial_approval"
    INVALID_TRANSACTION = "invalid_transaction"
    INVALID_AMOUNT = "invalid_amount"
    INVALID_ISSUER = "invalid_issuer"
    LOST_CARD = "lost_card"
    STOLEN_CARD = "stolen_card"
    INSUFFICIENT_FUNDS = "insufficient_funds"
    EXPIRED_CARD = "expired_card"
    INVALID_PIN = "invalid_pin"
    TRANSACTION_NOT_PERMITTED_TO_CARDHOLDER = "transaction_not_permitted_to_cardholder"
    TRANSACTION_NOT_ALLOWED_AT_TERMINAL = "transaction_not_allowed_at_terminal"
    EXCEEDS_WITHDRAWAL_AMOUNT_LIMIT = "exceeds_withdrawal_amount_limit"
    RESTRICTED_CARD = "restricted_card"
    SECURITY_VIOLATION = "security_violation"
    EXCEEDS_WITHDRAWAL_COUNT_LIMIT = "exceeds_withdrawal_count_limit"
    ALLOWABLE_NUMBER_OF_PIN_TRIES_EXCEEDED = "allowable_number_of_pin_tries_exceeded"
    NO_REASON_TO_DECLINE = "no_reason_to_decline"
    CANNOT_VERIFY_PIN = "cannot_verify_pin"
    ISSUER_UNAVAILABLE = "issuer_unavailable"
    UNABLE_TO_ROUTE_TRANSACTION = "unable_to_route_transaction"
    DUPLICATE_TRANSACTION = "duplicate_transaction"
    SYSTEM_MALFUNCTION = "system_malfunction"
    HONOR_WITH_ID = "honor_with_id"
    INVALID_CARD_NUMBER = "invalid_card_number"
    FORMAT_ERROR = "format_error"
    CONTACT_CARD_ISSUER = "contact_card_issuer"
    PIN_NOT_CHANGED = "pin_not_changed"
    INVALID_NONEXISTENT_TO_ACCOUNT_SPECIFIED = (
        "invalid_nonexistent_to_account_specified"
    )
    INVALID_NONEXISTENT_FROM_ACCOUNT_SPECIFIED = (
        "invalid_nonexistent_from_account_specified"
    )
    INVALID_NONEXISTENT_ACCOUNT_SPECIFIED = "invalid_nonexistent_account_specified"
    LIFECYCLE_RELATED = "lifecycle_related"
    DOMESTIC_DEBIT_TRANSACTION_NOT_ALLOWED = "domestic_debit_transaction_not_allowed"
    POLICY_RELATED = "policy_related"
    FRAUD_SECURITY_RELATED = "fraud_security_related"
    INVALID_AUTHORIZATION_LIFE_CYCLE = "invalid_authorization_life_cycle"
    PURCHASE_AMOUNT_ONLY_NO_CASH_BACK_ALLOWED = (
        "purchase_amount_only_no_cash_back_allowed"
    )
    CRYPTOGRAPHIC_FAILURE = "cryptographic_failure"
    UNACCEPTABLE_PIN = "unacceptable_pin"
    REFER_TO_CARD_ISSUER_SPECIAL_CONDITION = "refer_to_card_issuer_special_condition"
    PICK_UP_CARD_SPECIAL_CONDITION = "pick_up_card_special_condition"
    VIP_APPROVAL = "vip_approval"
    INVALID_ACCOUNT_NUMBER = "invalid_account_number"
    RE_ENTER_TRANSACTION = "re_enter_transaction"
    NO_ACTION_TAKEN = "no_action_taken"
    UNABLE_TO_LOCATE_RECORD = "unable_to_locate_record"
    FILE_TEMPORARILY_UNAVAILABLE = "file_temporarily_unavailable"
    NO_CREDIT_ACCOUNT = "no_credit_account"
    CLOSED_ACCOUNT = "closed_account"
    NO_CHECKING_ACCOUNT = "no_checking_account"
    NO_SAVINGS_ACCOUNT = "no_savings_account"
    SUSPECTED_FRAUD = "suspected_fraud"
    TRANSACTION_DOES_NOT_FULFILL_AML_REQUIREMENT = (
        "transaction_does_not_fulfill_aml_requirement"
    )
    PIN_DATA_REQUIRED = "pin_data_required"
    UNABLE_TO_LOCATE_PREVIOUS_MESSAGE = "unable_to_locate_previous_message"
    PREVIOUS_MESSAGE_LOCATED_INCONSISTENT_DATA = (
        "previous_message_located_inconsistent_data"
    )
    BLOCKED_FIRST_USED = "blocked_first_used"
    TRANSACTION_REVERSED = "transaction_reversed"
    CREDIT_ISSUER_UNAVAILABLE = "credit_issuer_unavailable"
    PIN_CRYPTOGRAPHIC_ERROR_FOUND = "pin_cryptographic_error_found"
    NEGATIVE_ONLINE_CAM_RESULT = "negative_online_cam_result"
    VIOLATION_OF_LAW = "violation_of_law"
    FORCE_STIP = "force_stip"
    CASH_SERVICE_NOT_AVAILABLE = "cash_service_not_available"
    CASHBACK_REQUEST_EXCEEDS_ISSUER_LIMIT = "cashback_request_exceeds_issuer_limit"
    DECLINE_FOR_CVV2_FAILURE = "decline_for_cvv2_failure"
    TRANSACTION_AMOUNT_EXCEEDS_PRE_AUTHORIZED_AMOUNT = (
        "transaction_amount_exceeds_pre_authorized_amount"
    )
    INVALID_BILLER_INFORMATION = "invalid_biller_information"
    PIN_CHANGE_UNBLOCK_REQUEST_DECLINED = "pin_change_unblock_request_declined"
    UNSAFE_PIN = "unsafe_pin"
    CARD_AUTHENTICATION_FAILED = "card_authentication_failed"
    STOP_PAYMENT_ORDER = "stop_payment_order"
    REVOCATION_OF_AUTHORIZATION = "revocation_of_authorization"
    REVOCATION_OF_ALL_AUTHORIZATIONS = "revocation_of_all_authorizations"
    FORWARD_TO_ISSUER_XA = "forward_to_issuer_xa"
    FORWARD_TO_ISSUER_XD = "forward_to_issuer_xd"
    UNABLE_TO_GO_ONLINE = "unable_to_go_online"
    ADDITIONAL_CUSTOMER_AUTHENTICATION_REQUIRED = (
        "additional_customer_authentication_required"
    )
    MERCHANT_ID_NOT_FOUND = "merchant_id_not_found"
    MERCHANT_ACCOUNT_CLOSED = "merchant_account_closed"
    TERMINAL_ID_NOT_FOUND = "terminal_id_not_found"
    TERMINAL_CLOSED = "terminal_closed"
    INVALID_CATEGORY_CODE = "invalid_category_code"
    INVALID_CURRENCY = "invalid_currency"
    MISSING_CVV2_CVC2 = "missing_cvv2_cvc2"
    CVV2_NOT_ALLOWED = "cvv2_not_allowed"
    MERCHANT_NOT_REGISTERED_VBV = "merchant_not_registered_vbv"
    MERCHANT_NOT_REGISTERED_FOR_AMEX = "merchant_not_registered_for_amex"
    TRANSACTION_NOT_PERMITTED_AT_TERMINAL = "transaction_not_permitted_at_terminal"
    AGREEMENT_TERMINAL_NOT_RELATED = "agreement_terminal_not_related"
    INVALID_PROCESSOR_ID = "invalid_processor_id"
    INVALID_MERCHANT_DATA = "invalid_merchant_data"
    SUB_MERCHANT_ACCOUNT_CLOSED = "sub_merchant_account_closed"
    TERMINAL_BUSY = "terminal_busy"
    TERMINAL_UNREACHABLE = "terminal_unreachable"
    SERVICE_FAILED = "service_failed"
    INVALID_OPERATION = "invalid_operation"
    AUTHORIZATION_ERROR = "authorization_error"
    LOGIN_FAILED_WITHOUT_REASON = "login_failed_without_reason"
    INVALID_RETAILER = "invalid_retailer"
    CARD_DOES_NOT_EXIST = "card_does_not_exist"
    CARD_IS_BLOCKED = "card_is_blocked"
    INVALID_CARD_ID = "invalid_card_id"
    CARD_IS_TRANSFERRED = "card_is_transferred"
    CARD_IS_NOT_ACTIVE = "card_is_not_active"
    INCORRECT_PURCHASE_VALUE = "incorrect_purchase_value"
    CARD_NOT_AVAILABLE = "card_not_available"
    WRONG_CURRENCY = "wrong_currency"
    LOGIN_FAILED_UNKNOWN_USER = "login_failed_unknown_user"
    LOGIN_FAILED_INVALID_PASSWORD = "login_failed_invalid_password"
    INVALID_EAN_CODE = "invalid_ean_code"


class CreatePaymentStatusReasonTypedDict(TypedDict):
    r"""This object offers details about the status of a payment. Currently it is only available for point-of-sale
    payments.

    You can find more information about the possible values of this object on
    [this page](status-reasons).**
    """

    code: CreatePaymentCode
    message: str
    r"""A description of the status reason, localized according to the payment `locale`."""


class CreatePaymentStatusReason(BaseModel):
    r"""This object offers details about the status of a payment. Currently it is only available for point-of-sale
    payments.

    You can find more information about the possible values of this object on
    [this page](status-reasons).**
    """

    code: CreatePaymentCode

    message: str
    r"""A description of the status reason, localized according to the payment `locale`."""


class CreatePaymentCardAudition(str, Enum):
    r"""The card's target audience, if known."""

    CONSUMER = "consumer"
    BUSINESS = "business"


class CreatePaymentCardLabel(str, Enum):
    r"""The card's label, if known."""

    AMERICAN_EXPRESS = "American Express"
    CARTA_SI = "Carta Si"
    CARTE_BLEUE = "Carte Bleue"
    DANKORT = "Dankort"
    DINERS_CLUB = "Diners Club"
    DISCOVER = "Discover"
    JCB = "JCB"
    LASER = "Laser"
    MAESTRO = "Maestro"
    MASTERCARD = "Mastercard"
    UNIONPAY = "Unionpay"
    VISA = "Visa"
    VPAY = "Vpay"


class CreatePaymentCardFunding(str, Enum):
    r"""The card type."""

    DEBIT = "debit"
    CREDIT = "credit"
    PREPAID = "prepaid"
    DEFERRED_DEBIT = "deferred-debit"


class CreatePaymentCardSecurity(str, Enum):
    r"""The level of security applied during card processing."""

    NORMAL = "normal"
    THREEDSECURE = "3dsecure"


class CreatePaymentFeeRegion(str, Enum):
    r"""The applicable card fee region."""

    AMERICAN_EXPRESS = "american-express"
    AMEX_INTRA_EEA = "amex-intra-eea"
    CARTE_BANCAIRE = "carte-bancaire"
    INTRA_EU = "intra-eu"
    INTRA_EU_CORPORATE = "intra-eu-corporate"
    DOMESTIC = "domestic"
    MAESTRO = "maestro"
    OTHER = "other"
    INTER = "inter"
    INTRA_EEA = "intra-eea"


class CreatePaymentFailureReason(str, Enum):
    r"""A failure code to help understand why the payment failed."""

    AUTHENTICATION_ABANDONED = "authentication_abandoned"
    AUTHENTICATION_FAILED = "authentication_failed"
    AUTHENTICATION_REQUIRED = "authentication_required"
    AUTHENTICATION_UNAVAILABLE_ACS = "authentication_unavailable_acs"
    CARD_DECLINED = "card_declined"
    CARD_EXPIRED = "card_expired"
    INACTIVE_CARD = "inactive_card"
    INSUFFICIENT_FUNDS = "insufficient_funds"
    INVALID_CVV = "invalid_cvv"
    INVALID_CARD_HOLDER_NAME = "invalid_card_holder_name"
    INVALID_CARD_NUMBER = "invalid_card_number"
    INVALID_CARD_TYPE = "invalid_card_type"
    POSSIBLE_FRAUD = "possible_fraud"
    REFUSED_BY_ISSUER = "refused_by_issuer"
    UNKNOWN_REASON = "unknown_reason"


class CreatePaymentWallet(str, Enum):
    r"""The wallet used when creating the payment."""

    APPLEPAY = "applepay"


class CreatePaymentSellerProtection(str, Enum):
    r"""Indicates to what extent the payment is eligible for PayPal's Seller Protection. Only available for PayPal
    payments, and if the information is made available by PayPal.
    """

    ELIGIBLE = "Eligible"
    INELIGIBLE = "Ineligible"
    PARTIALLY_ELIGIBLE_INR_ONLY = "Partially Eligible - INR Only"
    PARTIALLY_ELIGIBLE_UNAUTH_ONLY = "Partially Eligible - Unauth Only"
    PARTIALLY_ELIGIBLE = "Partially Eligible"
    NONE = "None"
    ACTIVE = "Active"
    FRAUD_CONTROL_UNAUTH_PREMIUM_ELIGIBLE = "Fraud Control - Unauth Premium Eligible"


class CreatePaymentPaypalFeeTypedDict(TypedDict):
    r"""An amount object containing the fee PayPal will charge for this transaction. The field may be omitted if
    PayPal will not charge a fee for this transaction.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentPaypalFee(BaseModel):
    r"""An amount object containing the fee PayPal will charge for this transaction. The field may be omitted if
    PayPal will not charge a fee for this transaction.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentCardReadMethod(str, Enum):
    r"""The method by which the card was read by the terminal."""

    CHIP = "chip"
    MAGNETIC_STRIPE = "magnetic-stripe"
    NEAR_FIELD_COMMUNICATION = "near-field-communication"
    CONTACTLESS = "contactless"
    MOTO = "moto"


class CreatePaymentCardVerificationMethod(str, Enum):
    r"""The method used to verify the cardholder's identity."""

    NO_CVM_REQUIRED = "no-cvm-required"
    ONLINE_PIN = "online-pin"
    OFFLINE_PIN = "offline-pin"
    CONSUMER_DEVICE = "consumer-device"
    SIGNATURE = "signature"
    SIGNATURE_AND_ONLINE_PIN = "signature-and-online-pin"
    ONLINE_PIN_AND_SIGNATURE = "online-pin-and-signature"
    NONE = "none"
    FAILED = "failed"


class CreatePaymentReceiptTypedDict(TypedDict):
    r"""The Point of sale receipt object."""

    authorization_code: NotRequired[Nullable[str]]
    r"""A unique code provided by the cardholder’s bank to confirm that the transaction was successfully approved."""
    application_identifier: NotRequired[Nullable[str]]
    r"""The unique number that identifies a specific payment application on a chip card."""
    card_read_method: NotRequired[Nullable[CreatePaymentCardReadMethod]]
    r"""The method by which the card was read by the terminal."""
    card_verification_method: NotRequired[Nullable[CreatePaymentCardVerificationMethod]]
    r"""The method used to verify the cardholder's identity."""


class CreatePaymentReceipt(BaseModel):
    r"""The Point of sale receipt object."""

    authorization_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="authorizationCode")
    ] = UNSET
    r"""A unique code provided by the cardholder’s bank to confirm that the transaction was successfully approved."""

    application_identifier: Annotated[
        OptionalNullable[str], pydantic.Field(alias="applicationIdentifier")
    ] = UNSET
    r"""The unique number that identifies a specific payment application on a chip card."""

    card_read_method: Annotated[
        OptionalNullable[CreatePaymentCardReadMethod],
        pydantic.Field(alias="cardReadMethod"),
    ] = UNSET
    r"""The method by which the card was read by the terminal."""

    card_verification_method: Annotated[
        OptionalNullable[CreatePaymentCardVerificationMethod],
        pydantic.Field(alias="cardVerificationMethod"),
    ] = UNSET
    r"""The method used to verify the cardholder's identity."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "authorizationCode",
            "applicationIdentifier",
            "cardReadMethod",
            "cardVerificationMethod",
        ]
        nullable_fields = [
            "authorizationCode",
            "applicationIdentifier",
            "cardReadMethod",
            "cardVerificationMethod",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreatePaymentQrCodeTypedDict(TypedDict):
    r"""Optional include. If a QR code was requested during payment creation for a QR-compatible payment method,
    the QR code details will be available in this object.

    The QR code can be scanned by the customer to complete the payment on their mobile device. For example,
    Bancontact QR payments can be completed by the customer using the Bancontact app.
    """

    height: NotRequired[int]
    r"""The height of the QR code image in pixels."""
    width: NotRequired[int]
    r"""The width of the QR code image in pixels."""
    src: NotRequired[str]
    r"""The URL to the QR code image. The image is a PNG file, and can be displayed directly in the browser or
    downloaded.
    """


class CreatePaymentQrCode(BaseModel):
    r"""Optional include. If a QR code was requested during payment creation for a QR-compatible payment method,
    the QR code details will be available in this object.

    The QR code can be scanned by the customer to complete the payment on their mobile device. For example,
    Bancontact QR payments can be completed by the customer using the Bancontact app.
    """

    height: Optional[int] = None
    r"""The height of the QR code image in pixels."""

    width: Optional[int] = None
    r"""The width of the QR code image in pixels."""

    src: Optional[str] = None
    r"""The URL to the QR code image. The image is a PNG file, and can be displayed directly in the browser or
    downloaded.
    """


class CreatePaymentRemainderAmountTypedDict(TypedDict):
    r"""An amount object for the amount that remained after all gift cards or vouchers were applied."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentRemainderAmount(BaseModel):
    r"""An amount object for the amount that remained after all gift cards or vouchers were applied."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreatePaymentDetailsTypedDict(TypedDict):
    r"""An object containing payment details collected during the payment process. For example, details may include the
    customer's card or bank details and a payment reference. For the full list of details, please refer to the
    [method-specific parameters](extra-payment-parameters) guide.
    """

    consumer_name: NotRequired[Nullable[str]]
    r"""The customer's name, if made available by the payment method. For card payments, refer to details.cardHolder."""
    consumer_account: NotRequired[Nullable[str]]
    r"""The customer's account reference.

    For banking-based payment methods — such as iDEAL — this is normally either an IBAN or a domestic bank account
    number.

    For PayPal, the account reference is an email address.

    For card and Bancontact payments, refer to details.cardNumber.
    """
    consumer_bic: NotRequired[Nullable[str]]
    r"""The BIC of the customer's bank account, if applicable."""
    shipping_address: NotRequired[Nullable[Dict[str, Any]]]
    r"""For wallet payment methods — such as Apple Pay and PayPal — the shipping address is often already known by the
    wallet provider. In these cases the shipping address may be available as a payment detail.
    """
    card_number: NotRequired[Nullable[str]]
    r"""For bancontact, it will be the customer's masked card number. For cards, it will be the last 4-digit of the
    PAN. For Point-of-sale, it will be the the last 4 digits of the customer's masked card number.
    """
    bank_name: NotRequired[str]
    r"""The name of the bank that the customer will need to make the bank transfer payment towards."""
    bank_account: NotRequired[str]
    r"""The bank account number the customer will need to make the bank transfer payment towards."""
    bank_bic: NotRequired[str]
    r"""The BIC of the bank the customer will need to make the bank transfer payment towards."""
    transfer_reference: NotRequired[Nullable[str]]
    r"""The Mollie-generated reference the customer needs to use when transfering the amount. Do not apply any
    formatting here; show it to the customer as-is.
    """
    card_fingerprint: NotRequired[Nullable[str]]
    r"""A unique fingerprint for a specific card. Can be used to identify returning customers.

    In the case of Point-of-sale payments, it's a unique identifier assigned to a cardholder's payment account,
    linking multiple transactions from wallets and physical card to a single account, also across payment methods
    or when the card is reissued.
    """
    card_holder: NotRequired[Nullable[str]]
    r"""The customer's name as shown on their card."""
    card_audition: NotRequired[Nullable[CreatePaymentCardAudition]]
    r"""The card's target audience, if known."""
    card_label: NotRequired[Nullable[CreatePaymentCardLabel]]
    r"""The card's label, if known."""
    card_country_code: NotRequired[Nullable[str]]
    r"""The ISO 3166-1 alpha-2 country code of the country the card was issued in."""
    card_expiry_date: NotRequired[Nullable[str]]
    r"""The expiry date (MM/YY) of the card as displayed on the card."""
    card_funding: NotRequired[Nullable[CreatePaymentCardFunding]]
    r"""The card type."""
    card_security: NotRequired[Nullable[CreatePaymentCardSecurity]]
    r"""The level of security applied during card processing."""
    fee_region: NotRequired[Nullable[CreatePaymentFeeRegion]]
    r"""The applicable card fee region."""
    card_masked_number: NotRequired[Nullable[str]]
    r"""The first 6 and last 4 digits of the card number."""
    card3ds_eci: NotRequired[Nullable[str]]
    r"""The outcome of authentication attempted on transactions enforced by 3DS (ie valid only for oneoff and first)."""
    card_bin: NotRequired[Nullable[str]]
    r"""The first 6 digit of the card bank identification number."""
    card_issuer: NotRequired[Nullable[str]]
    r"""The issuer of the Card."""
    failure_reason: NotRequired[Nullable[CreatePaymentFailureReason]]
    r"""A failure code to help understand why the payment failed."""
    failure_message: NotRequired[Nullable[str]]
    r"""A human-friendly failure message that can be shown to the customer. The message is translated in accordance
    with the payment's locale setting.
    """
    wallet: NotRequired[Nullable[CreatePaymentWallet]]
    r"""The wallet used when creating the payment."""
    paypal_reference: NotRequired[Nullable[str]]
    r"""PayPal's reference for the payment."""
    paypal_payer_id: NotRequired[Nullable[str]]
    r"""ID of the customer's PayPal account."""
    seller_protection: NotRequired[Nullable[CreatePaymentSellerProtection]]
    r"""Indicates to what extent the payment is eligible for PayPal's Seller Protection. Only available for PayPal
    payments, and if the information is made available by PayPal.
    """
    paypal_fee: NotRequired[Nullable[CreatePaymentPaypalFeeTypedDict]]
    r"""An amount object containing the fee PayPal will charge for this transaction. The field may be omitted if
    PayPal will not charge a fee for this transaction.
    """
    customer_reference: NotRequired[str]
    r"""The paysafecard customer reference either provided via the API or otherwise auto-generated by Mollie."""
    terminal_id: NotRequired[str]
    r"""The ID of the terminal device where the payment took place on."""
    masked_number: NotRequired[Nullable[str]]
    r"""The first 6 digits & last 4 digits of the customer's masked card number."""
    receipt: NotRequired[CreatePaymentReceiptTypedDict]
    r"""The Point of sale receipt object."""
    creditor_identifier: NotRequired[Nullable[str]]
    r"""The creditor identifier indicates who is authorized to execute the payment. In this case, it is a
    reference to Mollie.
    """
    due_date: NotRequired[Nullable[date]]
    r"""Estimated date the payment is debited from the customer's bank account, in YYYY-MM-DD format."""
    signature_date: NotRequired[Nullable[date]]
    r"""Date the payment has been signed by the customer, in YYYY-MM-DD format. Only available if the payment
    has been signed.
    """
    bank_reason_code: NotRequired[Nullable[str]]
    r"""The official reason why this payment has failed. A detailed description of each reason is available on the
    website of the European Payments Council.
    """
    bank_reason: NotRequired[Nullable[str]]
    r"""A human-friendly description of the failure reason."""
    end_to_end_identifier: NotRequired[Nullable[str]]
    r"""The end-to-end identifier you provided in the batch file."""
    mandate_reference: NotRequired[Nullable[str]]
    r"""The mandate reference you provided in the batch file."""
    batch_reference: NotRequired[Nullable[str]]
    r"""The batch reference you provided in the batch file."""
    file_reference: NotRequired[Nullable[str]]
    r"""The file reference you provided in the batch file."""
    qr_code: NotRequired[CreatePaymentQrCodeTypedDict]
    r"""Optional include. If a QR code was requested during payment creation for a QR-compatible payment method,
    the QR code details will be available in this object.

    The QR code can be scanned by the customer to complete the payment on their mobile device. For example,
    Bancontact QR payments can be completed by the customer using the Bancontact app.
    """
    voucher_number: NotRequired[str]
    r"""For payments with gift cards: the masked gift card number of the first gift card applied to the payment."""
    giftcards: NotRequired[List[Dict[str, Any]]]
    r"""An array of detail objects for each gift card that was used on this payment, if any."""
    issuer: NotRequired[str]
    r"""For payments with vouchers: the brand name of the first voucher applied."""
    vouchers: NotRequired[List[Dict[str, Any]]]
    r"""An array of detail objects for each voucher that was used on this payment, if any."""
    remainder_amount: NotRequired[CreatePaymentRemainderAmountTypedDict]
    r"""An amount object for the amount that remained after all gift cards or vouchers were applied."""
    remainder_method: NotRequired[str]
    r"""The payment method used to pay the remainder amount, after all gift cards or vouchers were applied."""
    remainder_details: NotRequired[Dict[str, Any]]
    r"""Optional include. The full payment method details of the remainder payment."""


class CreatePaymentDetails(BaseModel):
    r"""An object containing payment details collected during the payment process. For example, details may include the
    customer's card or bank details and a payment reference. For the full list of details, please refer to the
    [method-specific parameters](extra-payment-parameters) guide.
    """

    consumer_name: Annotated[
        OptionalNullable[str], pydantic.Field(alias="consumerName")
    ] = UNSET
    r"""The customer's name, if made available by the payment method. For card payments, refer to details.cardHolder."""

    consumer_account: Annotated[
        OptionalNullable[str], pydantic.Field(alias="consumerAccount")
    ] = UNSET
    r"""The customer's account reference.

    For banking-based payment methods — such as iDEAL — this is normally either an IBAN or a domestic bank account
    number.

    For PayPal, the account reference is an email address.

    For card and Bancontact payments, refer to details.cardNumber.
    """

    consumer_bic: Annotated[
        OptionalNullable[str], pydantic.Field(alias="consumerBic")
    ] = UNSET
    r"""The BIC of the customer's bank account, if applicable."""

    shipping_address: Annotated[
        OptionalNullable[Dict[str, Any]], pydantic.Field(alias="shippingAddress")
    ] = UNSET
    r"""For wallet payment methods — such as Apple Pay and PayPal — the shipping address is often already known by the
    wallet provider. In these cases the shipping address may be available as a payment detail.
    """

    card_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardNumber")
    ] = UNSET
    r"""For bancontact, it will be the customer's masked card number. For cards, it will be the last 4-digit of the
    PAN. For Point-of-sale, it will be the the last 4 digits of the customer's masked card number.
    """

    bank_name: Annotated[Optional[str], pydantic.Field(alias="bankName")] = None
    r"""The name of the bank that the customer will need to make the bank transfer payment towards."""

    bank_account: Annotated[Optional[str], pydantic.Field(alias="bankAccount")] = None
    r"""The bank account number the customer will need to make the bank transfer payment towards."""

    bank_bic: Annotated[Optional[str], pydantic.Field(alias="bankBic")] = None
    r"""The BIC of the bank the customer will need to make the bank transfer payment towards."""

    transfer_reference: Annotated[
        OptionalNullable[str], pydantic.Field(alias="transferReference")
    ] = UNSET
    r"""The Mollie-generated reference the customer needs to use when transfering the amount. Do not apply any
    formatting here; show it to the customer as-is.
    """

    card_fingerprint: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardFingerprint")
    ] = UNSET
    r"""A unique fingerprint for a specific card. Can be used to identify returning customers.

    In the case of Point-of-sale payments, it's a unique identifier assigned to a cardholder's payment account,
    linking multiple transactions from wallets and physical card to a single account, also across payment methods
    or when the card is reissued.
    """

    card_holder: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardHolder")
    ] = UNSET
    r"""The customer's name as shown on their card."""

    card_audition: Annotated[
        OptionalNullable[CreatePaymentCardAudition],
        pydantic.Field(alias="cardAudition"),
    ] = UNSET
    r"""The card's target audience, if known."""

    card_label: Annotated[
        OptionalNullable[CreatePaymentCardLabel], pydantic.Field(alias="cardLabel")
    ] = UNSET
    r"""The card's label, if known."""

    card_country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardCountryCode")
    ] = UNSET
    r"""The ISO 3166-1 alpha-2 country code of the country the card was issued in."""

    card_expiry_date: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardExpiryDate")
    ] = UNSET
    r"""The expiry date (MM/YY) of the card as displayed on the card."""

    card_funding: Annotated[
        OptionalNullable[CreatePaymentCardFunding], pydantic.Field(alias="cardFunding")
    ] = UNSET
    r"""The card type."""

    card_security: Annotated[
        OptionalNullable[CreatePaymentCardSecurity],
        pydantic.Field(alias="cardSecurity"),
    ] = UNSET
    r"""The level of security applied during card processing."""

    fee_region: Annotated[
        OptionalNullable[CreatePaymentFeeRegion], pydantic.Field(alias="feeRegion")
    ] = UNSET
    r"""The applicable card fee region."""

    card_masked_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardMaskedNumber")
    ] = UNSET
    r"""The first 6 and last 4 digits of the card number."""

    card3ds_eci: Annotated[
        OptionalNullable[str], pydantic.Field(alias="card3dsEci")
    ] = UNSET
    r"""The outcome of authentication attempted on transactions enforced by 3DS (ie valid only for oneoff and first)."""

    card_bin: Annotated[OptionalNullable[str], pydantic.Field(alias="cardBin")] = UNSET
    r"""The first 6 digit of the card bank identification number."""

    card_issuer: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardIssuer")
    ] = UNSET
    r"""The issuer of the Card."""

    failure_reason: Annotated[
        OptionalNullable[CreatePaymentFailureReason],
        pydantic.Field(alias="failureReason"),
    ] = UNSET
    r"""A failure code to help understand why the payment failed."""

    failure_message: Annotated[
        OptionalNullable[str], pydantic.Field(alias="failureMessage")
    ] = UNSET
    r"""A human-friendly failure message that can be shown to the customer. The message is translated in accordance
    with the payment's locale setting.
    """

    wallet: OptionalNullable[CreatePaymentWallet] = UNSET
    r"""The wallet used when creating the payment."""

    paypal_reference: Annotated[
        OptionalNullable[str], pydantic.Field(alias="paypalReference")
    ] = UNSET
    r"""PayPal's reference for the payment."""

    paypal_payer_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="paypalPayerId")
    ] = UNSET
    r"""ID of the customer's PayPal account."""

    seller_protection: Annotated[
        OptionalNullable[CreatePaymentSellerProtection],
        pydantic.Field(alias="sellerProtection"),
    ] = UNSET
    r"""Indicates to what extent the payment is eligible for PayPal's Seller Protection. Only available for PayPal
    payments, and if the information is made available by PayPal.
    """

    paypal_fee: Annotated[
        OptionalNullable[CreatePaymentPaypalFee], pydantic.Field(alias="paypalFee")
    ] = UNSET
    r"""An amount object containing the fee PayPal will charge for this transaction. The field may be omitted if
    PayPal will not charge a fee for this transaction.
    """

    customer_reference: Annotated[
        Optional[str], pydantic.Field(alias="customerReference")
    ] = None
    r"""The paysafecard customer reference either provided via the API or otherwise auto-generated by Mollie."""

    terminal_id: Annotated[Optional[str], pydantic.Field(alias="terminalId")] = None
    r"""The ID of the terminal device where the payment took place on."""

    masked_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="maskedNumber")
    ] = UNSET
    r"""The first 6 digits & last 4 digits of the customer's masked card number."""

    receipt: Optional[CreatePaymentReceipt] = None
    r"""The Point of sale receipt object."""

    creditor_identifier: Annotated[
        OptionalNullable[str], pydantic.Field(alias="creditorIdentifier")
    ] = UNSET
    r"""The creditor identifier indicates who is authorized to execute the payment. In this case, it is a
    reference to Mollie.
    """

    due_date: Annotated[OptionalNullable[date], pydantic.Field(alias="dueDate")] = UNSET
    r"""Estimated date the payment is debited from the customer's bank account, in YYYY-MM-DD format."""

    signature_date: Annotated[
        OptionalNullable[date], pydantic.Field(alias="signatureDate")
    ] = UNSET
    r"""Date the payment has been signed by the customer, in YYYY-MM-DD format. Only available if the payment
    has been signed.
    """

    bank_reason_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="bankReasonCode")
    ] = UNSET
    r"""The official reason why this payment has failed. A detailed description of each reason is available on the
    website of the European Payments Council.
    """

    bank_reason: Annotated[
        OptionalNullable[str], pydantic.Field(alias="bankReason")
    ] = UNSET
    r"""A human-friendly description of the failure reason."""

    end_to_end_identifier: Annotated[
        OptionalNullable[str], pydantic.Field(alias="endToEndIdentifier")
    ] = UNSET
    r"""The end-to-end identifier you provided in the batch file."""

    mandate_reference: Annotated[
        OptionalNullable[str], pydantic.Field(alias="mandateReference")
    ] = UNSET
    r"""The mandate reference you provided in the batch file."""

    batch_reference: Annotated[
        OptionalNullable[str], pydantic.Field(alias="batchReference")
    ] = UNSET
    r"""The batch reference you provided in the batch file."""

    file_reference: Annotated[
        OptionalNullable[str], pydantic.Field(alias="fileReference")
    ] = UNSET
    r"""The file reference you provided in the batch file."""

    qr_code: Annotated[
        Optional[CreatePaymentQrCode], pydantic.Field(alias="qrCode")
    ] = None
    r"""Optional include. If a QR code was requested during payment creation for a QR-compatible payment method,
    the QR code details will be available in this object.

    The QR code can be scanned by the customer to complete the payment on their mobile device. For example,
    Bancontact QR payments can be completed by the customer using the Bancontact app.
    """

    voucher_number: Annotated[Optional[str], pydantic.Field(alias="voucherNumber")] = (
        None
    )
    r"""For payments with gift cards: the masked gift card number of the first gift card applied to the payment."""

    giftcards: Optional[List[Dict[str, Any]]] = None
    r"""An array of detail objects for each gift card that was used on this payment, if any."""

    issuer: Optional[str] = None
    r"""For payments with vouchers: the brand name of the first voucher applied."""

    vouchers: Optional[List[Dict[str, Any]]] = None
    r"""An array of detail objects for each voucher that was used on this payment, if any."""

    remainder_amount: Annotated[
        Optional[CreatePaymentRemainderAmount], pydantic.Field(alias="remainderAmount")
    ] = None
    r"""An amount object for the amount that remained after all gift cards or vouchers were applied."""

    remainder_method: Annotated[
        Optional[str], pydantic.Field(alias="remainderMethod")
    ] = None
    r"""The payment method used to pay the remainder amount, after all gift cards or vouchers were applied."""

    remainder_details: Annotated[
        Optional[Dict[str, Any]], pydantic.Field(alias="remainderDetails")
    ] = None
    r"""Optional include. The full payment method details of the remainder payment."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "consumerName",
            "consumerAccount",
            "consumerBic",
            "shippingAddress",
            "cardNumber",
            "bankName",
            "bankAccount",
            "bankBic",
            "transferReference",
            "cardFingerprint",
            "cardHolder",
            "cardAudition",
            "cardLabel",
            "cardCountryCode",
            "cardExpiryDate",
            "cardFunding",
            "cardSecurity",
            "feeRegion",
            "cardMaskedNumber",
            "card3dsEci",
            "cardBin",
            "cardIssuer",
            "failureReason",
            "failureMessage",
            "wallet",
            "paypalReference",
            "paypalPayerId",
            "sellerProtection",
            "paypalFee",
            "customerReference",
            "terminalId",
            "maskedNumber",
            "receipt",
            "creditorIdentifier",
            "dueDate",
            "signatureDate",
            "bankReasonCode",
            "bankReason",
            "endToEndIdentifier",
            "mandateReference",
            "batchReference",
            "fileReference",
            "qrCode",
            "voucherNumber",
            "giftcards",
            "issuer",
            "vouchers",
            "remainderAmount",
            "remainderMethod",
            "remainderDetails",
        ]
        nullable_fields = [
            "consumerName",
            "consumerAccount",
            "consumerBic",
            "shippingAddress",
            "cardNumber",
            "transferReference",
            "cardFingerprint",
            "cardHolder",
            "cardAudition",
            "cardLabel",
            "cardCountryCode",
            "cardExpiryDate",
            "cardFunding",
            "cardSecurity",
            "feeRegion",
            "cardMaskedNumber",
            "card3dsEci",
            "cardBin",
            "cardIssuer",
            "failureReason",
            "failureMessage",
            "wallet",
            "paypalReference",
            "paypalPayerId",
            "sellerProtection",
            "paypalFee",
            "maskedNumber",
            "creditorIdentifier",
            "dueDate",
            "signatureDate",
            "bankReasonCode",
            "bankReason",
            "endToEndIdentifier",
            "mandateReference",
            "batchReference",
            "fileReference",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreatePaymentSelfResponseTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentSelfResponse(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentCheckoutTypedDict(TypedDict):
    r"""The URL your customer should visit to make the payment. This is where you should redirect the customer to."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentCheckout(BaseModel):
    r"""The URL your customer should visit to make the payment. This is where you should redirect the customer to."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentMobileAppCheckoutTypedDict(TypedDict):
    r"""The deeplink URL to the app of the payment method. Currently only available for `bancontact`."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentMobileAppCheckout(BaseModel):
    r"""The deeplink URL to the app of the payment method. Currently only available for `bancontact`."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentChangePaymentStateTypedDict(TypedDict):
    r"""For test mode payments in certain scenarios, a hosted interface is available to help you test different
    payment states.

    Firstly, for recurring test mode payments. Recurring payments do not have a checkout URL, because these
    payments are executed without any user interaction.

    Secondly, for paid test mode payments. The payment state screen will then allow you to create a refund or
    chargeback for the test payment.
    """

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentChangePaymentState(BaseModel):
    r"""For test mode payments in certain scenarios, a hosted interface is available to help you test different
    payment states.

    Firstly, for recurring test mode payments. Recurring payments do not have a checkout URL, because these
    payments are executed without any user interaction.

    Secondly, for paid test mode payments. The payment state screen will then allow you to create a refund or
    chargeback for the test payment.
    """

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentDashboardTypedDict(TypedDict):
    r"""Direct link to the payment in the Mollie Dashboard."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentDashboard(BaseModel):
    r"""Direct link to the payment in the Mollie Dashboard."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentRefundsTypedDict(TypedDict):
    r"""The API resource URL of the [refunds](list-payment-refunds) that belong to this payment."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentRefunds(BaseModel):
    r"""The API resource URL of the [refunds](list-payment-refunds) that belong to this payment."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentChargebacksTypedDict(TypedDict):
    r"""The API resource URL of the [chargebacks](list-payment-chargebacks) that belong to this
    payment.
    """

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentChargebacks(BaseModel):
    r"""The API resource URL of the [chargebacks](list-payment-chargebacks) that belong to this
    payment.
    """

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentCapturesTypedDict(TypedDict):
    r"""The API resource URL of the [captures](list-payment-captures) that belong to this payment."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentCaptures(BaseModel):
    r"""The API resource URL of the [captures](list-payment-captures) that belong to this payment."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentSettlementTypedDict(TypedDict):
    r"""The API resource URL of the [settlement](get-settlement) this payment has been settled with.
    Not present if not yet settled.
    """

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentSettlement(BaseModel):
    r"""The API resource URL of the [settlement](get-settlement) this payment has been settled with.
    Not present if not yet settled.
    """

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentCustomerTypedDict(TypedDict):
    r"""The API resource URL of the [customer](get-customer)."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentCustomer(BaseModel):
    r"""The API resource URL of the [customer](get-customer)."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentMandateTypedDict(TypedDict):
    r"""The API resource URL of the [mandate](get-mandate)."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentMandate(BaseModel):
    r"""The API resource URL of the [mandate](get-mandate)."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentSubscriptionTypedDict(TypedDict):
    r"""The API resource URL of the [subscription](get-subscription)."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentSubscription(BaseModel):
    r"""The API resource URL of the [subscription](get-subscription)."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentOrderTypedDict(TypedDict):
    r"""The API resource URL of the [order](get-order) this payment was created for. Not present if not created for an
    order.
    """

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentOrder(BaseModel):
    r"""The API resource URL of the [order](get-order) this payment was created for. Not present if not created for an
    order.
    """

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentTerminalTypedDict(TypedDict):
    r"""The API resource URL of the [terminal](get-terminal) this payment was created for. Only present for
    point-of-sale payments.
    """

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentTerminal(BaseModel):
    r"""The API resource URL of the [terminal](get-terminal) this payment was created for. Only present for
    point-of-sale payments.
    """

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentLinksStatusTypedDict(TypedDict):
    r"""Link to customer-facing page showing the status of the bank transfer (to verify if the transaction was
    successful).
    """

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentLinksStatus(BaseModel):
    r"""Link to customer-facing page showing the status of the bank transfer (to verify if the transaction was
    successful).
    """

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentPayOnlineTypedDict(TypedDict):
    r"""Link to Mollie Checkout page allowing customers to select a different payment method instead of legacy
    bank transfer.
    """

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentPayOnline(BaseModel):
    r"""Link to Mollie Checkout page allowing customers to select a different payment method instead of legacy
    bank transfer.
    """

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreatePaymentLinksResponseTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: CreatePaymentSelfResponseTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    dashboard: CreatePaymentDashboardTypedDict
    r"""Direct link to the payment in the Mollie Dashboard."""
    checkout: NotRequired[CreatePaymentCheckoutTypedDict]
    r"""The URL your customer should visit to make the payment. This is where you should redirect the customer to."""
    mobile_app_checkout: NotRequired[CreatePaymentMobileAppCheckoutTypedDict]
    r"""The deeplink URL to the app of the payment method. Currently only available for `bancontact`."""
    change_payment_state: NotRequired[CreatePaymentChangePaymentStateTypedDict]
    r"""For test mode payments in certain scenarios, a hosted interface is available to help you test different
    payment states.

    Firstly, for recurring test mode payments. Recurring payments do not have a checkout URL, because these
    payments are executed without any user interaction.

    Secondly, for paid test mode payments. The payment state screen will then allow you to create a refund or
    chargeback for the test payment.
    """
    refunds: NotRequired[CreatePaymentRefundsTypedDict]
    r"""The API resource URL of the [refunds](list-payment-refunds) that belong to this payment."""
    chargebacks: NotRequired[CreatePaymentChargebacksTypedDict]
    r"""The API resource URL of the [chargebacks](list-payment-chargebacks) that belong to this
    payment.
    """
    captures: NotRequired[CreatePaymentCapturesTypedDict]
    r"""The API resource URL of the [captures](list-payment-captures) that belong to this payment."""
    settlement: NotRequired[CreatePaymentSettlementTypedDict]
    r"""The API resource URL of the [settlement](get-settlement) this payment has been settled with.
    Not present if not yet settled.
    """
    customer: NotRequired[CreatePaymentCustomerTypedDict]
    r"""The API resource URL of the [customer](get-customer)."""
    mandate: NotRequired[CreatePaymentMandateTypedDict]
    r"""The API resource URL of the [mandate](get-mandate)."""
    subscription: NotRequired[CreatePaymentSubscriptionTypedDict]
    r"""The API resource URL of the [subscription](get-subscription)."""
    order: NotRequired[CreatePaymentOrderTypedDict]
    r"""The API resource URL of the [order](get-order) this payment was created for. Not present if not created for an
    order.
    """
    terminal: NotRequired[CreatePaymentTerminalTypedDict]
    r"""The API resource URL of the [terminal](get-terminal) this payment was created for. Only present for
    point-of-sale payments.
    """
    documentation: NotRequired[CreatePaymentDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    status: NotRequired[CreatePaymentLinksStatusTypedDict]
    r"""Link to customer-facing page showing the status of the bank transfer (to verify if the transaction was
    successful).
    """
    pay_online: NotRequired[CreatePaymentPayOnlineTypedDict]
    r"""Link to Mollie Checkout page allowing customers to select a different payment method instead of legacy
    bank transfer.
    """


class CreatePaymentLinksResponse(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[CreatePaymentSelfResponse, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    dashboard: CreatePaymentDashboard
    r"""Direct link to the payment in the Mollie Dashboard."""

    checkout: Optional[CreatePaymentCheckout] = None
    r"""The URL your customer should visit to make the payment. This is where you should redirect the customer to."""

    mobile_app_checkout: Annotated[
        Optional[CreatePaymentMobileAppCheckout],
        pydantic.Field(alias="mobileAppCheckout"),
    ] = None
    r"""The deeplink URL to the app of the payment method. Currently only available for `bancontact`."""

    change_payment_state: Annotated[
        Optional[CreatePaymentChangePaymentState],
        pydantic.Field(alias="changePaymentState"),
    ] = None
    r"""For test mode payments in certain scenarios, a hosted interface is available to help you test different
    payment states.

    Firstly, for recurring test mode payments. Recurring payments do not have a checkout URL, because these
    payments are executed without any user interaction.

    Secondly, for paid test mode payments. The payment state screen will then allow you to create a refund or
    chargeback for the test payment.
    """

    refunds: Optional[CreatePaymentRefunds] = None
    r"""The API resource URL of the [refunds](list-payment-refunds) that belong to this payment."""

    chargebacks: Optional[CreatePaymentChargebacks] = None
    r"""The API resource URL of the [chargebacks](list-payment-chargebacks) that belong to this
    payment.
    """

    captures: Optional[CreatePaymentCaptures] = None
    r"""The API resource URL of the [captures](list-payment-captures) that belong to this payment."""

    settlement: Optional[CreatePaymentSettlement] = None
    r"""The API resource URL of the [settlement](get-settlement) this payment has been settled with.
    Not present if not yet settled.
    """

    customer: Optional[CreatePaymentCustomer] = None
    r"""The API resource URL of the [customer](get-customer)."""

    mandate: Optional[CreatePaymentMandate] = None
    r"""The API resource URL of the [mandate](get-mandate)."""

    subscription: Optional[CreatePaymentSubscription] = None
    r"""The API resource URL of the [subscription](get-subscription)."""

    order: Optional[CreatePaymentOrder] = None
    r"""The API resource URL of the [order](get-order) this payment was created for. Not present if not created for an
    order.
    """

    terminal: Optional[CreatePaymentTerminal] = None
    r"""The API resource URL of the [terminal](get-terminal) this payment was created for. Only present for
    point-of-sale payments.
    """

    documentation: Optional[CreatePaymentDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    status: Optional[CreatePaymentLinksStatus] = None
    r"""Link to customer-facing page showing the status of the bank transfer (to verify if the transaction was
    successful).
    """

    pay_online: Annotated[
        Optional[CreatePaymentPayOnline], pydantic.Field(alias="payOnline")
    ] = None
    r"""Link to Mollie Checkout page allowing customers to select a different payment method instead of legacy
    bank transfer.
    """


class CreatePaymentResponseTypedDict(TypedDict):
    r"""The newly created payment object."""

    resource: str
    r"""Indicates the response contains a payment object. Will always contain the string `payment` for this endpoint."""
    id: str
    r"""The identifier uniquely referring to this payment. Mollie assigns this identifier at payment creation time. Mollie
    will always refer to the payment by this ID. Example: `tr_5B8cwPMGnU6qLbRvo7qEZo`.
    """
    mode: CreatePaymentMode
    r"""Whether this entity was created in live mode or in test mode."""
    description: str
    r"""The description of the payment. This will be shown to your customer on their card or bank statement when possible.
    We truncate the description automatically according to the limits of the used payment method. The description is
    also visible in any exports you generate.

    We recommend you use a unique identifier so that you can always link the payment to the order in your back office.
    This is particularly useful for bookkeeping.

    The maximum length of the description field differs per payment method, with the absolute maximum being 255
    characters. The API will not reject strings longer than the maximum length but it will truncate them to fit.
    """
    amount: CreatePaymentAmountResponseTypedDict
    r"""The amount that you want to charge, e.g. `{currency:\"EUR\", value:\"1000.00\"}` if you would want to charge €1000.00.

    You can find the minimum and maximum amounts per payment method in our help center. Additionally, they can be
    retrieved using the Get method endpoint.

    If a tip was added for a Point-of-Sale payment, the amount will be updated to reflect the initial amount plus the
    tip amount.
    """
    sequence_type: Nullable[CreatePaymentSequenceTypeResponse]
    r"""**Only relevant for recurring payments.**

    Indicate which part of a recurring sequence this payment is for.

    Recurring payments can only take place if a mandate is available. A common way to establish such a mandate is
    through a `first` payment. With a `first` payment, the customer agrees to automatic recurring charges taking place
    on their account in the future.

    If set to `recurring`, the customer's card is charged automatically.

    Defaults to `oneoff`, which is a regular non-recurring payment.

    For PayPal payments, recurring is only possible if your connected PayPal account allows it. You can call our
    [Methods API](list-methods) with parameter `sequenceType: first` to discover which payment methods on your account
    are set up correctly for recurring payments.
    """
    profile_id: str
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    When using an API Key, the `profileId` can be omitted since it is linked to the key. However, for OAuth and
    Organization tokens, the `profileId` is required.

    For more information, see [Authentication](authentication).
    """
    status: CreatePaymentStatusEnum
    r"""The payment's status. Refer to the [documentation regarding statuses](https://docs.mollie.com/docs/status-change#/) for more info about which
    statuses occur at what point.
    """
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: CreatePaymentLinksResponseTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    amount_refunded: NotRequired[CreatePaymentAmountRefundedTypedDict]
    r"""The total amount that is already refunded. Only available when refunds are available for this payment. For some
    payment methods, this amount may be higher than the payment amount, for example to allow reimbursement of the
    costs for a return shipment to the customer.
    """
    amount_remaining: NotRequired[CreatePaymentAmountRemainingTypedDict]
    r"""The remaining amount that can be refunded. Only available when refunds are available for this payment."""
    amount_captured: NotRequired[CreatePaymentAmountCapturedTypedDict]
    r"""The total amount that is already captured for this payment. Only available when this payment supports captures."""
    amount_charged_back: NotRequired[CreatePaymentAmountChargedBackTypedDict]
    r"""The total amount that was charged back for this payment. Only available when the total charged back amount is not
    zero.
    """
    settlement_amount: NotRequired[CreatePaymentSettlementAmountTypedDict]
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the
    currency your account is settled in.

    Any amounts not settled by Mollie will not be reflected in this amount, e.g. PayPal or gift cards. If no amount is
    settled by Mollie the `settlementAmount` is omitted from the response.

    Please note that this amount might be recalculated and changed when the status of the payment changes. We suggest
    using the List balance transactions endpoint instead to get more accurate settlement amounts for your payments.
    """
    redirect_url: NotRequired[Nullable[str]]
    r"""The URL your customer will be redirected to after the payment process.

    It could make sense for the redirectUrl to contain a unique identifier – like your order ID – so you can show the
    right page referencing the order when your customer returns.

    The parameter is normally required, but can be omitted for recurring payments (`sequenceType: recurring`) and for
    Apple Pay payments with an `applePayPaymentToken`.
    """
    cancel_url: NotRequired[Nullable[str]]
    r"""The URL your customer will be redirected to when the customer explicitly cancels the payment. If this URL is not
    provided, the customer will be redirected to the `redirectUrl` instead — see above.

    Mollie will always give you status updates via webhooks, including for the canceled status. This parameter is
    therefore entirely optional, but can be useful when implementing a dedicated customer-facing flow to handle
    payment cancellations.
    """
    webhook_url: NotRequired[Nullable[str]]
    r"""The webhook URL where we will send payment status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to your payment.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use
    webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your
    local machine.
    """
    lines: NotRequired[Nullable[List[CreatePaymentLineResponseTypedDict]]]
    r"""Optionally provide the order lines for the payment. Each line contains details such as a description of the item
    ordered and its price.

    All lines must have the same currency as the payment.

    Required for payment methods `billie`, `in3`, `klarna`, `riverty` and `voucher`.
    """
    billing_address: NotRequired[CreatePaymentBillingAddressResponseTypedDict]
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.

    Required for payment method `in3`, `klarna`, `billie` and `riverty`.
    """
    shipping_address: NotRequired[CreatePaymentShippingAddressResponseTypedDict]
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.
    """
    locale: NotRequired[Nullable[CreatePaymentLocaleResponse]]
    r"""Allows you to preset the language to be used in the hosted payment pages shown to the customer. Setting a locale
    is highly recommended and will greatly improve your conversion rate. When this parameter is omitted the browser
    language will be used instead if supported by the payment method. You can provide any `xx_XX` format ISO 15897
    locale, but our hosted payment pages currently only support the specified languages.

    For bank transfer payments specifically, the locale will determine the target bank account the customer has to
    transfer the money to. We have dedicated bank accounts for Belgium, Germany, and The Netherlands. Having the
    customer use a local bank account greatly increases the conversion and speed of payment.
    """
    country_code: NotRequired[Nullable[str]]
    r"""This optional field contains your customer's ISO 3166-1 alpha-2 country code, detected by us during checkout. This
    field is omitted if the country code was not detected.
    """
    method: NotRequired[Nullable[CreatePaymentMethodResponse]]
    r"""The payment method used for this transaction. If a specific method was selected during payment initialization,
    this field reflects that choice.
    """
    restrict_payment_methods_to_country: NotRequired[Nullable[str]]
    r"""For digital goods in most jurisdictions, you must apply the VAT rate from your customer's country. Choose the VAT
    rates you have used for the order to ensure your customer's country matches the VAT country.

    Use this parameter to restrict the payment methods available to your customer to those from a single country.

    If available, the credit card method will still be offered, but only cards from the allowed country are accepted.

    The field expects a country code in ISO 3166-1 alpha-2 format, for example `NL`.
    """
    metadata: NotRequired[Nullable[CreatePaymentMetadataResponseTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """
    capture_mode: NotRequired[Nullable[CreatePaymentCaptureModeResponse]]
    r"""Indicate if the funds should be captured immediately or if you want to [place a hold](https://docs.mollie.com/docs/place-a-hold-for-a-payment#/)
    and capture at a later time.

    This field needs to be set to `manual` for method `riverty`.
    """
    capture_delay: NotRequired[Nullable[str]]
    r"""**Only relevant if you wish to manage authorization and capturing separately.**

    Some payment methods allow placing a hold on the card or bank account. This hold or 'authorization' can then at a
    later point either be 'captured' or canceled.

    By default, we charge the customer's card or bank account immediately when they complete the payment. If you set a
    capture delay however, we will delay the automatic capturing of the payment for the specified amount of time. For
    example `8 hours` or `2 days`.

    To schedule an automatic capture, the `captureMode` must be set to `automatic`.

    The maximum delay is 7 days (168 hours).

    Possible values: `... hours` `... days`
    """
    capture_before: NotRequired[Nullable[str]]
    r"""Indicates the date before which the payment needs to be captured, in ISO 8601 format. From this date onwards we
    can no longer guarantee a successful capture. The parameter is omitted if the payment is not authorized (yet).
    """
    application_fee: NotRequired[Nullable[CreatePaymentApplicationFeeResponseTypedDict]]
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the
    `routing` parameter.
    """
    routing: NotRequired[Nullable[List[CreatePaymentRoutingResponseTypedDict]]]
    r"""*This functionality is not enabled by default. Reach out to our partner management team if you wish to use it.*

    With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    If you create payments on your own account that you want to split between yourself and one or more connected
    merchants, you can use this `routing` parameter to route the payment accordingly.

    The `routing` parameter should contain an array of objects, with each object describing the destination for a
    specific portion of the payment.

    It is not necessary to indicate in the array which portion goes to yourself. After all portions of the total
    payment amount have been routed, the amount left will be routed to the current organization automatically.

    If instead you use OAuth to create payments on a connected merchant's account, refer to the `applicationFee`
    parameter.
    """
    subscription_id: NotRequired[Nullable[str]]
    r"""If the payment was automatically created via a subscription, the ID of the [subscription](get-subscription) will
    be added to the response.
    """
    mandate_id: NotRequired[Nullable[str]]
    r"""**Only relevant for recurring payments.**

    When creating recurring payments, the ID of a specific [mandate](get-mandate) can be supplied to indicate which of
    the customer's accounts should be credited.
    """
    customer_id: NotRequired[Nullable[str]]
    r"""The ID of the [customer](get-customer) the payment is being created for. This is used primarily for recurring
    payments, but can also be used on regular payments to enable single-click payments.

    If `sequenceType` is set to `recurring`, this field is required.
    """
    settlement_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the [settlement](get-settlement) this payment was settled with."""
    order_id: NotRequired[Nullable[str]]
    r"""If the payment was created for an [order](get-order), the ID of that order will be part of the response."""
    status_reason: NotRequired[Nullable[CreatePaymentStatusReasonTypedDict]]
    r"""This object offers details about the status of a payment. Currently it is only available for point-of-sale
    payments.

    You can find more information about the possible values of this object on
    [this page](status-reasons).**
    """
    is_cancelable: NotRequired[Nullable[bool]]
    r"""Whether the payment can be canceled. This parameter is omitted if the payment reaches a final state."""
    details: NotRequired[Nullable[CreatePaymentDetailsTypedDict]]
    r"""An object containing payment details collected during the payment process. For example, details may include the
    customer's card or bank details and a payment reference. For the full list of details, please refer to the
    [method-specific parameters](extra-payment-parameters) guide.
    """
    authorized_at: NotRequired[Nullable[str]]
    r"""The date and time the payment became authorized, in ISO 8601 format. This parameter is omitted if the payment is
    not authorized (yet).
    """
    paid_at: NotRequired[Nullable[str]]
    r"""The date and time the payment became paid, in ISO 8601 format. This parameter is omitted if the payment is not
    completed (yet).
    """
    canceled_at: NotRequired[Nullable[str]]
    r"""The date and time the payment was canceled, in ISO 8601 format. This parameter is omitted if the payment is not
    canceled (yet).
    """
    expires_at: NotRequired[Nullable[str]]
    r"""The date and time the payment will expire, in ISO 8601 format. This parameter is omitted if the payment can no
    longer expire.
    """
    expired_at: NotRequired[Nullable[str]]
    r"""The date and time the payment was expired, in ISO 8601 format. This parameter is omitted if the payment did not
    expire (yet).
    """
    failed_at: NotRequired[Nullable[str]]
    r"""The date and time the payment failed, in ISO 8601 format. This parameter is omitted if the payment did not fail
    (yet).
    """


class CreatePaymentResponse(BaseModel):
    r"""The newly created payment object."""

    resource: str
    r"""Indicates the response contains a payment object. Will always contain the string `payment` for this endpoint."""

    id: str
    r"""The identifier uniquely referring to this payment. Mollie assigns this identifier at payment creation time. Mollie
    will always refer to the payment by this ID. Example: `tr_5B8cwPMGnU6qLbRvo7qEZo`.
    """

    mode: CreatePaymentMode
    r"""Whether this entity was created in live mode or in test mode."""

    description: str
    r"""The description of the payment. This will be shown to your customer on their card or bank statement when possible.
    We truncate the description automatically according to the limits of the used payment method. The description is
    also visible in any exports you generate.

    We recommend you use a unique identifier so that you can always link the payment to the order in your back office.
    This is particularly useful for bookkeeping.

    The maximum length of the description field differs per payment method, with the absolute maximum being 255
    characters. The API will not reject strings longer than the maximum length but it will truncate them to fit.
    """

    amount: CreatePaymentAmountResponse
    r"""The amount that you want to charge, e.g. `{currency:\"EUR\", value:\"1000.00\"}` if you would want to charge €1000.00.

    You can find the minimum and maximum amounts per payment method in our help center. Additionally, they can be
    retrieved using the Get method endpoint.

    If a tip was added for a Point-of-Sale payment, the amount will be updated to reflect the initial amount plus the
    tip amount.
    """

    sequence_type: Annotated[
        Nullable[CreatePaymentSequenceTypeResponse],
        pydantic.Field(alias="sequenceType"),
    ]
    r"""**Only relevant for recurring payments.**

    Indicate which part of a recurring sequence this payment is for.

    Recurring payments can only take place if a mandate is available. A common way to establish such a mandate is
    through a `first` payment. With a `first` payment, the customer agrees to automatic recurring charges taking place
    on their account in the future.

    If set to `recurring`, the customer's card is charged automatically.

    Defaults to `oneoff`, which is a regular non-recurring payment.

    For PayPal payments, recurring is only possible if your connected PayPal account allows it. You can call our
    [Methods API](list-methods) with parameter `sequenceType: first` to discover which payment methods on your account
    are set up correctly for recurring payments.
    """

    profile_id: Annotated[str, pydantic.Field(alias="profileId")]
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    When using an API Key, the `profileId` can be omitted since it is linked to the key. However, for OAuth and
    Organization tokens, the `profileId` is required.

    For more information, see [Authentication](authentication).
    """

    status: CreatePaymentStatusEnum
    r"""The payment's status. Refer to the [documentation regarding statuses](https://docs.mollie.com/docs/status-change#/) for more info about which
    statuses occur at what point.
    """

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[CreatePaymentLinksResponse, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    amount_refunded: Annotated[
        Optional[CreatePaymentAmountRefunded], pydantic.Field(alias="amountRefunded")
    ] = None
    r"""The total amount that is already refunded. Only available when refunds are available for this payment. For some
    payment methods, this amount may be higher than the payment amount, for example to allow reimbursement of the
    costs for a return shipment to the customer.
    """

    amount_remaining: Annotated[
        Optional[CreatePaymentAmountRemaining], pydantic.Field(alias="amountRemaining")
    ] = None
    r"""The remaining amount that can be refunded. Only available when refunds are available for this payment."""

    amount_captured: Annotated[
        Optional[CreatePaymentAmountCaptured], pydantic.Field(alias="amountCaptured")
    ] = None
    r"""The total amount that is already captured for this payment. Only available when this payment supports captures."""

    amount_charged_back: Annotated[
        Optional[CreatePaymentAmountChargedBack],
        pydantic.Field(alias="amountChargedBack"),
    ] = None
    r"""The total amount that was charged back for this payment. Only available when the total charged back amount is not
    zero.
    """

    settlement_amount: Annotated[
        Optional[CreatePaymentSettlementAmount],
        pydantic.Field(alias="settlementAmount"),
    ] = None
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the
    currency your account is settled in.

    Any amounts not settled by Mollie will not be reflected in this amount, e.g. PayPal or gift cards. If no amount is
    settled by Mollie the `settlementAmount` is omitted from the response.

    Please note that this amount might be recalculated and changed when the status of the payment changes. We suggest
    using the List balance transactions endpoint instead to get more accurate settlement amounts for your payments.
    """

    redirect_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="redirectUrl")
    ] = UNSET
    r"""The URL your customer will be redirected to after the payment process.

    It could make sense for the redirectUrl to contain a unique identifier – like your order ID – so you can show the
    right page referencing the order when your customer returns.

    The parameter is normally required, but can be omitted for recurring payments (`sequenceType: recurring`) and for
    Apple Pay payments with an `applePayPaymentToken`.
    """

    cancel_url: Annotated[OptionalNullable[str], pydantic.Field(alias="cancelUrl")] = (
        UNSET
    )
    r"""The URL your customer will be redirected to when the customer explicitly cancels the payment. If this URL is not
    provided, the customer will be redirected to the `redirectUrl` instead — see above.

    Mollie will always give you status updates via webhooks, including for the canceled status. This parameter is
    therefore entirely optional, but can be useful when implementing a dedicated customer-facing flow to handle
    payment cancellations.
    """

    webhook_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="webhookUrl")
    ] = UNSET
    r"""The webhook URL where we will send payment status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to your payment.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use
    webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your
    local machine.
    """

    lines: OptionalNullable[List[CreatePaymentLineResponse]] = UNSET
    r"""Optionally provide the order lines for the payment. Each line contains details such as a description of the item
    ordered and its price.

    All lines must have the same currency as the payment.

    Required for payment methods `billie`, `in3`, `klarna`, `riverty` and `voucher`.
    """

    billing_address: Annotated[
        Optional[CreatePaymentBillingAddressResponse],
        pydantic.Field(alias="billingAddress"),
    ] = None
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.

    Required for payment method `in3`, `klarna`, `billie` and `riverty`.
    """

    shipping_address: Annotated[
        Optional[CreatePaymentShippingAddressResponse],
        pydantic.Field(alias="shippingAddress"),
    ] = None
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.
    """

    locale: OptionalNullable[CreatePaymentLocaleResponse] = UNSET
    r"""Allows you to preset the language to be used in the hosted payment pages shown to the customer. Setting a locale
    is highly recommended and will greatly improve your conversion rate. When this parameter is omitted the browser
    language will be used instead if supported by the payment method. You can provide any `xx_XX` format ISO 15897
    locale, but our hosted payment pages currently only support the specified languages.

    For bank transfer payments specifically, the locale will determine the target bank account the customer has to
    transfer the money to. We have dedicated bank accounts for Belgium, Germany, and The Netherlands. Having the
    customer use a local bank account greatly increases the conversion and speed of payment.
    """

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""This optional field contains your customer's ISO 3166-1 alpha-2 country code, detected by us during checkout. This
    field is omitted if the country code was not detected.
    """

    method: OptionalNullable[CreatePaymentMethodResponse] = UNSET
    r"""The payment method used for this transaction. If a specific method was selected during payment initialization,
    this field reflects that choice.
    """

    restrict_payment_methods_to_country: Annotated[
        OptionalNullable[str], pydantic.Field(alias="restrictPaymentMethodsToCountry")
    ] = UNSET
    r"""For digital goods in most jurisdictions, you must apply the VAT rate from your customer's country. Choose the VAT
    rates you have used for the order to ensure your customer's country matches the VAT country.

    Use this parameter to restrict the payment methods available to your customer to those from a single country.

    If available, the credit card method will still be offered, but only cards from the allowed country are accepted.

    The field expects a country code in ISO 3166-1 alpha-2 format, for example `NL`.
    """

    metadata: OptionalNullable[CreatePaymentMetadataResponse] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """

    capture_mode: Annotated[
        OptionalNullable[CreatePaymentCaptureModeResponse],
        pydantic.Field(alias="captureMode"),
    ] = UNSET
    r"""Indicate if the funds should be captured immediately or if you want to [place a hold](https://docs.mollie.com/docs/place-a-hold-for-a-payment#/)
    and capture at a later time.

    This field needs to be set to `manual` for method `riverty`.
    """

    capture_delay: Annotated[
        OptionalNullable[str], pydantic.Field(alias="captureDelay")
    ] = UNSET
    r"""**Only relevant if you wish to manage authorization and capturing separately.**

    Some payment methods allow placing a hold on the card or bank account. This hold or 'authorization' can then at a
    later point either be 'captured' or canceled.

    By default, we charge the customer's card or bank account immediately when they complete the payment. If you set a
    capture delay however, we will delay the automatic capturing of the payment for the specified amount of time. For
    example `8 hours` or `2 days`.

    To schedule an automatic capture, the `captureMode` must be set to `automatic`.

    The maximum delay is 7 days (168 hours).

    Possible values: `... hours` `... days`
    """

    capture_before: Annotated[
        OptionalNullable[str], pydantic.Field(alias="captureBefore")
    ] = UNSET
    r"""Indicates the date before which the payment needs to be captured, in ISO 8601 format. From this date onwards we
    can no longer guarantee a successful capture. The parameter is omitted if the payment is not authorized (yet).
    """

    application_fee: Annotated[
        OptionalNullable[CreatePaymentApplicationFeeResponse],
        pydantic.Field(alias="applicationFee"),
    ] = UNSET
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payments on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If the payment succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.

    If instead you want to split a payment on your own account between yourself and a connected merchant, refer to the
    `routing` parameter.
    """

    routing: OptionalNullable[List[CreatePaymentRoutingResponse]] = UNSET
    r"""*This functionality is not enabled by default. Reach out to our partner management team if you wish to use it.*

    With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    If you create payments on your own account that you want to split between yourself and one or more connected
    merchants, you can use this `routing` parameter to route the payment accordingly.

    The `routing` parameter should contain an array of objects, with each object describing the destination for a
    specific portion of the payment.

    It is not necessary to indicate in the array which portion goes to yourself. After all portions of the total
    payment amount have been routed, the amount left will be routed to the current organization automatically.

    If instead you use OAuth to create payments on a connected merchant's account, refer to the `applicationFee`
    parameter.
    """

    subscription_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="subscriptionId")
    ] = UNSET
    r"""If the payment was automatically created via a subscription, the ID of the [subscription](get-subscription) will
    be added to the response.
    """

    mandate_id: Annotated[OptionalNullable[str], pydantic.Field(alias="mandateId")] = (
        UNSET
    )
    r"""**Only relevant for recurring payments.**

    When creating recurring payments, the ID of a specific [mandate](get-mandate) can be supplied to indicate which of
    the customer's accounts should be credited.
    """

    customer_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="customerId")
    ] = UNSET
    r"""The ID of the [customer](get-customer) the payment is being created for. This is used primarily for recurring
    payments, but can also be used on regular payments to enable single-click payments.

    If `sequenceType` is set to `recurring`, this field is required.
    """

    settlement_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="settlementId")
    ] = UNSET
    r"""The identifier referring to the [settlement](get-settlement) this payment was settled with."""

    order_id: Annotated[OptionalNullable[str], pydantic.Field(alias="orderId")] = UNSET
    r"""If the payment was created for an [order](get-order), the ID of that order will be part of the response."""

    status_reason: Annotated[
        OptionalNullable[CreatePaymentStatusReason],
        pydantic.Field(alias="statusReason"),
    ] = UNSET
    r"""This object offers details about the status of a payment. Currently it is only available for point-of-sale
    payments.

    You can find more information about the possible values of this object on
    [this page](status-reasons).**
    """

    is_cancelable: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="isCancelable")
    ] = UNSET
    r"""Whether the payment can be canceled. This parameter is omitted if the payment reaches a final state."""

    details: OptionalNullable[CreatePaymentDetails] = UNSET
    r"""An object containing payment details collected during the payment process. For example, details may include the
    customer's card or bank details and a payment reference. For the full list of details, please refer to the
    [method-specific parameters](extra-payment-parameters) guide.
    """

    authorized_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="authorizedAt")
    ] = UNSET
    r"""The date and time the payment became authorized, in ISO 8601 format. This parameter is omitted if the payment is
    not authorized (yet).
    """

    paid_at: Annotated[OptionalNullable[str], pydantic.Field(alias="paidAt")] = UNSET
    r"""The date and time the payment became paid, in ISO 8601 format. This parameter is omitted if the payment is not
    completed (yet).
    """

    canceled_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="canceledAt")
    ] = UNSET
    r"""The date and time the payment was canceled, in ISO 8601 format. This parameter is omitted if the payment is not
    canceled (yet).
    """

    expires_at: Annotated[OptionalNullable[str], pydantic.Field(alias="expiresAt")] = (
        UNSET
    )
    r"""The date and time the payment will expire, in ISO 8601 format. This parameter is omitted if the payment can no
    longer expire.
    """

    expired_at: Annotated[OptionalNullable[str], pydantic.Field(alias="expiredAt")] = (
        UNSET
    )
    r"""The date and time the payment was expired, in ISO 8601 format. This parameter is omitted if the payment did not
    expire (yet).
    """

    failed_at: Annotated[OptionalNullable[str], pydantic.Field(alias="failedAt")] = (
        UNSET
    )
    r"""The date and time the payment failed, in ISO 8601 format. This parameter is omitted if the payment did not fail
    (yet).
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "amountRefunded",
            "amountRemaining",
            "amountCaptured",
            "amountChargedBack",
            "settlementAmount",
            "redirectUrl",
            "cancelUrl",
            "webhookUrl",
            "lines",
            "billingAddress",
            "shippingAddress",
            "locale",
            "countryCode",
            "method",
            "restrictPaymentMethodsToCountry",
            "metadata",
            "captureMode",
            "captureDelay",
            "captureBefore",
            "applicationFee",
            "routing",
            "subscriptionId",
            "mandateId",
            "customerId",
            "settlementId",
            "orderId",
            "statusReason",
            "isCancelable",
            "details",
            "authorizedAt",
            "paidAt",
            "canceledAt",
            "expiresAt",
            "expiredAt",
            "failedAt",
        ]
        nullable_fields = [
            "redirectUrl",
            "cancelUrl",
            "webhookUrl",
            "lines",
            "locale",
            "countryCode",
            "method",
            "restrictPaymentMethodsToCountry",
            "metadata",
            "captureMode",
            "captureDelay",
            "captureBefore",
            "applicationFee",
            "routing",
            "sequenceType",
            "subscriptionId",
            "mandateId",
            "customerId",
            "settlementId",
            "orderId",
            "statusReason",
            "isCancelable",
            "details",
            "authorizedAt",
            "paidAt",
            "canceledAt",
            "expiresAt",
            "expiredAt",
            "failedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
