"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from pydantic import model_serializer
from typing import Any, Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class CreateSubscriptionAmountRequestTypedDict(TypedDict):
    r"""The amount for each individual payment that is charged with this subscription. For example, for a monthly
    subscription of €10, the subscription amount should be set to €10.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateSubscriptionAmountRequest(BaseModel):
    r"""The amount for each individual payment that is charged with this subscription. For example, for a monthly
    subscription of €10, the subscription amount should be set to €10.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateSubscriptionMethodRequest(str, Enum):
    r"""The payment method used for this subscription. If omitted, any of the customer's valid mandates may be used."""

    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    PAYPAL = "paypal"


class CreateSubscriptionApplicationFeeAmountRequestTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateSubscriptionApplicationFeeAmountRequest(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateSubscriptionApplicationFeeRequestTypedDict(TypedDict):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more
    information.
    """

    amount: CreateSubscriptionApplicationFeeAmountRequestTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    description: str


class CreateSubscriptionApplicationFeeRequest(BaseModel):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more
    information.
    """

    amount: CreateSubscriptionApplicationFeeAmountRequest
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    description: str


CreateSubscriptionMetadataRequestTypedDict = TypeAliasType(
    "CreateSubscriptionMetadataRequestTypedDict", Union[str, Dict[str, Any], List[str]]
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity.
Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately
1kB.

Any metadata added to the subscription will be automatically forwarded to the payments generated for it.
"""


CreateSubscriptionMetadataRequest = TypeAliasType(
    "CreateSubscriptionMetadataRequest", Union[str, Dict[str, Any], List[str]]
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity.
Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately
1kB.

Any metadata added to the subscription will be automatically forwarded to the payments generated for it.
"""


class CreateSubscriptionRequestBodyTypedDict(TypedDict):
    amount: CreateSubscriptionAmountRequestTypedDict
    r"""The amount for each individual payment that is charged with this subscription. For example, for a monthly
    subscription of €10, the subscription amount should be set to €10.
    """
    interval: str
    r"""Interval to wait between payments, for example `1 month` or `14 days`.

    The maximum interval is one year (`12 months`, `52 weeks`, or `365 days`).

    Possible values: `... days`, `... weeks`, `... months`.
    """
    description: str
    r"""The subscription's description will be used as the description of the resulting individual payments and so showing
    up on the bank statement of the consumer.

    **Please note:** the description needs to be unique for the Customer in case it has multiple active subscriptions.
    """
    times: NotRequired[Nullable[int]]
    r"""Total number of payments for the subscription. Once this number of payments is reached, the subscription is
    considered completed.

    Test mode subscriptions will get canceled automatically after 10 payments.
    """
    start_date: NotRequired[str]
    r"""The start date of the subscription in `YYYY-MM-DD` format."""
    method: NotRequired[Nullable[CreateSubscriptionMethodRequest]]
    r"""The payment method used for this subscription. If omitted, any of the customer's valid mandates may be used."""
    application_fee: NotRequired[CreateSubscriptionApplicationFeeRequestTypedDict]
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more
    information.
    """
    metadata: NotRequired[Nullable[CreateSubscriptionMetadataRequestTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity.
    Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately
    1kB.

    Any metadata added to the subscription will be automatically forwarded to the payments generated for it.
    """
    webhook_url: NotRequired[str]
    r"""We will call this URL for any payment status changes of payments resulting from this subscription.

    This webhook will receive **all** events for the subscription's payments. This may include payment failures as
    well. Be sure to verify the payment's subscription ID and its status.
    """
    mandate_id: NotRequired[Nullable[str]]
    r"""The mandate used for this subscription, if any."""
    testmode: NotRequired[Nullable[bool]]
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """


class CreateSubscriptionRequestBody(BaseModel):
    amount: CreateSubscriptionAmountRequest
    r"""The amount for each individual payment that is charged with this subscription. For example, for a monthly
    subscription of €10, the subscription amount should be set to €10.
    """

    interval: str
    r"""Interval to wait between payments, for example `1 month` or `14 days`.

    The maximum interval is one year (`12 months`, `52 weeks`, or `365 days`).

    Possible values: `... days`, `... weeks`, `... months`.
    """

    description: str
    r"""The subscription's description will be used as the description of the resulting individual payments and so showing
    up on the bank statement of the consumer.

    **Please note:** the description needs to be unique for the Customer in case it has multiple active subscriptions.
    """

    times: OptionalNullable[int] = UNSET
    r"""Total number of payments for the subscription. Once this number of payments is reached, the subscription is
    considered completed.

    Test mode subscriptions will get canceled automatically after 10 payments.
    """

    start_date: Annotated[Optional[str], pydantic.Field(alias="startDate")] = None
    r"""The start date of the subscription in `YYYY-MM-DD` format."""

    method: OptionalNullable[CreateSubscriptionMethodRequest] = UNSET
    r"""The payment method used for this subscription. If omitted, any of the customer's valid mandates may be used."""

    application_fee: Annotated[
        Optional[CreateSubscriptionApplicationFeeRequest],
        pydantic.Field(alias="applicationFee"),
    ] = None
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more
    information.
    """

    metadata: OptionalNullable[CreateSubscriptionMetadataRequest] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity.
    Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately
    1kB.

    Any metadata added to the subscription will be automatically forwarded to the payments generated for it.
    """

    webhook_url: Annotated[Optional[str], pydantic.Field(alias="webhookUrl")] = None
    r"""We will call this URL for any payment status changes of payments resulting from this subscription.

    This webhook will receive **all** events for the subscription's payments. This may include payment failures as
    well. Be sure to verify the payment's subscription ID and its status.
    """

    mandate_id: Annotated[OptionalNullable[str], pydantic.Field(alias="mandateId")] = (
        UNSET
    )
    r"""The mandate used for this subscription, if any."""

    testmode: OptionalNullable[bool] = UNSET
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "times",
            "startDate",
            "method",
            "applicationFee",
            "metadata",
            "webhookUrl",
            "mandateId",
            "testmode",
        ]
        nullable_fields = ["times", "method", "metadata", "mandateId", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateSubscriptionRequestTypedDict(TypedDict):
    customer_id: str
    r"""Provide the ID of the related customer."""
    request_body: NotRequired[CreateSubscriptionRequestBodyTypedDict]


class CreateSubscriptionRequest(BaseModel):
    customer_id: Annotated[
        str,
        pydantic.Field(alias="customerId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related customer."""

    request_body: Annotated[
        Optional[CreateSubscriptionRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


class CreateSubscriptionNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class CreateSubscriptionNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class CreateSubscriptionNotFoundLinksTypedDict(TypedDict):
    documentation: CreateSubscriptionNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class CreateSubscriptionNotFoundLinks(BaseModel):
    documentation: CreateSubscriptionNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class CreateSubscriptionHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[CreateSubscriptionNotFoundLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class CreateSubscriptionHalJSONError(ClientError):
    r"""An error response object."""

    data: CreateSubscriptionHalJSONErrorData

    def __init__(
        self,
        data: CreateSubscriptionHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class CreateSubscriptionMode(str, Enum):
    r"""Whether this entity was created in live mode or in test mode."""

    LIVE = "live"
    TEST = "test"


class CreateSubscriptionStatus(str, Enum):
    r"""The subscription's current status is directly related to the status of the underlying customer or mandate that is
    enabling the subscription.
    """

    PENDING = "pending"
    ACTIVE = "active"
    CANCELED = "canceled"
    SUSPENDED = "suspended"
    COMPLETED = "completed"


class CreateSubscriptionAmountResponseTypedDict(TypedDict):
    r"""The amount for each individual payment that is charged with this subscription. For example, for a monthly
    subscription of €10, the subscription amount should be set to €10.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateSubscriptionAmountResponse(BaseModel):
    r"""The amount for each individual payment that is charged with this subscription. For example, for a monthly
    subscription of €10, the subscription amount should be set to €10.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateSubscriptionMethodResponse(str, Enum):
    r"""The payment method used for this subscription. If omitted, any of the customer's valid mandates may be used."""

    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    PAYPAL = "paypal"


class CreateSubscriptionApplicationFeeAmountResponseTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateSubscriptionApplicationFeeAmountResponse(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CreateSubscriptionApplicationFeeResponseTypedDict(TypedDict):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more
    information.
    """

    amount: CreateSubscriptionApplicationFeeAmountResponseTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    description: str


class CreateSubscriptionApplicationFeeResponse(BaseModel):
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more
    information.
    """

    amount: CreateSubscriptionApplicationFeeAmountResponse
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    description: str


CreateSubscriptionMetadataResponseTypedDict = TypeAliasType(
    "CreateSubscriptionMetadataResponseTypedDict", Union[str, Dict[str, Any], List[str]]
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity.
Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately
1kB.

Any metadata added to the subscription will be automatically forwarded to the payments generated for it.
"""


CreateSubscriptionMetadataResponse = TypeAliasType(
    "CreateSubscriptionMetadataResponse", Union[str, Dict[str, Any], List[str]]
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity.
Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately
1kB.

Any metadata added to the subscription will be automatically forwarded to the payments generated for it.
"""


class CreateSubscriptionSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateSubscriptionSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateSubscriptionCustomerTypedDict(TypedDict):
    r"""The API resource URL of the [customer](get-customer) this subscription was created for."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class CreateSubscriptionCustomer(BaseModel):
    r"""The API resource URL of the [customer](get-customer) this subscription was created for."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class CreateSubscriptionMandateTypedDict(TypedDict):
    r"""The API resource URL of the [mandate](get-mandate) this subscription was created for."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class CreateSubscriptionMandate(BaseModel):
    r"""The API resource URL of the [mandate](get-mandate) this subscription was created for."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class CreateSubscriptionProfileTypedDict(TypedDict):
    r"""The API resource URL of the [profile](get-profile) this subscription was created for."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class CreateSubscriptionProfile(BaseModel):
    r"""The API resource URL of the [profile](get-profile) this subscription was created for."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class CreateSubscriptionPaymentsTypedDict(TypedDict):
    r"""The API resource URL of the [payments](list-payments) created for this subscription. Omitted if no such
    payments exist (yet).
    """

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class CreateSubscriptionPayments(BaseModel):
    r"""The API resource URL of the [payments](list-payments) created for this subscription. Omitted if no such
    payments exist (yet).
    """

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class CreateSubscriptionDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateSubscriptionDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateSubscriptionLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: CreateSubscriptionSelfTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    customer: Nullable[CreateSubscriptionCustomerTypedDict]
    r"""The API resource URL of the [customer](get-customer) this subscription was created for."""
    profile: Nullable[CreateSubscriptionProfileTypedDict]
    r"""The API resource URL of the [profile](get-profile) this subscription was created for."""
    documentation: CreateSubscriptionDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    mandate: NotRequired[Nullable[CreateSubscriptionMandateTypedDict]]
    r"""The API resource URL of the [mandate](get-mandate) this subscription was created for."""
    payments: NotRequired[Nullable[CreateSubscriptionPaymentsTypedDict]]
    r"""The API resource URL of the [payments](list-payments) created for this subscription. Omitted if no such
    payments exist (yet).
    """


class CreateSubscriptionLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[CreateSubscriptionSelf, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    customer: Nullable[CreateSubscriptionCustomer]
    r"""The API resource URL of the [customer](get-customer) this subscription was created for."""

    profile: Nullable[CreateSubscriptionProfile]
    r"""The API resource URL of the [profile](get-profile) this subscription was created for."""

    documentation: CreateSubscriptionDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    mandate: OptionalNullable[CreateSubscriptionMandate] = UNSET
    r"""The API resource URL of the [mandate](get-mandate) this subscription was created for."""

    payments: OptionalNullable[CreateSubscriptionPayments] = UNSET
    r"""The API resource URL of the [payments](list-payments) created for this subscription. Omitted if no such
    payments exist (yet).
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["mandate", "payments"]
        nullable_fields = ["customer", "mandate", "profile", "payments"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateSubscriptionResponseTypedDict(TypedDict):
    r"""The newly created subscription object."""

    resource: str
    r"""Indicates the response contains a subscription object. Will always contain the string `subscription` for this
    endpoint.
    """
    id: str
    r"""The identifier uniquely referring to this subscription. Example: `sub_rVKGtNd6s3`."""
    mode: CreateSubscriptionMode
    r"""Whether this entity was created in live mode or in test mode."""
    status: CreateSubscriptionStatus
    r"""The subscription's current status is directly related to the status of the underlying customer or mandate that is
    enabling the subscription.
    """
    amount: CreateSubscriptionAmountResponseTypedDict
    r"""The amount for each individual payment that is charged with this subscription. For example, for a monthly
    subscription of €10, the subscription amount should be set to €10.
    """
    times: Nullable[int]
    r"""Total number of payments for the subscription. Once this number of payments is reached, the subscription is
    considered completed.

    Test mode subscriptions will get canceled automatically after 10 payments.
    """
    times_remaining: Nullable[int]
    r"""Number of payments left for the subscription."""
    interval: str
    r"""Interval to wait between payments, for example `1 month` or `14 days`.

    The maximum interval is one year (`12 months`, `52 weeks`, or `365 days`).

    Possible values: `... days`, `... weeks`, `... months`.
    """
    start_date: str
    r"""The start date of the subscription in `YYYY-MM-DD` format."""
    description: str
    r"""The subscription's description will be used as the description of the resulting individual payments and so showing
    up on the bank statement of the consumer.

    **Please note:** the description needs to be unique for the Customer in case it has multiple active subscriptions.
    """
    method: Nullable[CreateSubscriptionMethodResponse]
    r"""The payment method used for this subscription. If omitted, any of the customer's valid mandates may be used."""
    metadata: Nullable[CreateSubscriptionMetadataResponseTypedDict]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity.
    Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately
    1kB.

    Any metadata added to the subscription will be automatically forwarded to the payments generated for it.
    """
    webhook_url: str
    r"""We will call this URL for any payment status changes of payments resulting from this subscription.

    This webhook will receive **all** events for the subscription's payments. This may include payment failures as
    well. Be sure to verify the payment's subscription ID and its status.
    """
    customer_id: str
    r"""The customer this subscription belongs to."""
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: CreateSubscriptionLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    next_payment_date: NotRequired[Nullable[str]]
    r"""The date of the next scheduled payment in `YYYY-MM-DD` format. If the subscription has been completed or canceled,
    this parameter will not be returned.
    """
    application_fee: NotRequired[CreateSubscriptionApplicationFeeResponseTypedDict]
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more
    information.
    """
    mandate_id: NotRequired[Nullable[str]]
    r"""The mandate used for this subscription, if any."""
    canceled_at: NotRequired[Nullable[str]]
    r"""The subscription's date and time of cancellation, in ISO 8601 format. This parameter is omitted if the
    subscription is not canceled (yet).
    """


class CreateSubscriptionResponse(BaseModel):
    r"""The newly created subscription object."""

    resource: str
    r"""Indicates the response contains a subscription object. Will always contain the string `subscription` for this
    endpoint.
    """

    id: str
    r"""The identifier uniquely referring to this subscription. Example: `sub_rVKGtNd6s3`."""

    mode: CreateSubscriptionMode
    r"""Whether this entity was created in live mode or in test mode."""

    status: CreateSubscriptionStatus
    r"""The subscription's current status is directly related to the status of the underlying customer or mandate that is
    enabling the subscription.
    """

    amount: CreateSubscriptionAmountResponse
    r"""The amount for each individual payment that is charged with this subscription. For example, for a monthly
    subscription of €10, the subscription amount should be set to €10.
    """

    times: Nullable[int]
    r"""Total number of payments for the subscription. Once this number of payments is reached, the subscription is
    considered completed.

    Test mode subscriptions will get canceled automatically after 10 payments.
    """

    times_remaining: Annotated[Nullable[int], pydantic.Field(alias="timesRemaining")]
    r"""Number of payments left for the subscription."""

    interval: str
    r"""Interval to wait between payments, for example `1 month` or `14 days`.

    The maximum interval is one year (`12 months`, `52 weeks`, or `365 days`).

    Possible values: `... days`, `... weeks`, `... months`.
    """

    start_date: Annotated[str, pydantic.Field(alias="startDate")]
    r"""The start date of the subscription in `YYYY-MM-DD` format."""

    description: str
    r"""The subscription's description will be used as the description of the resulting individual payments and so showing
    up on the bank statement of the consumer.

    **Please note:** the description needs to be unique for the Customer in case it has multiple active subscriptions.
    """

    method: Nullable[CreateSubscriptionMethodResponse]
    r"""The payment method used for this subscription. If omitted, any of the customer's valid mandates may be used."""

    metadata: Nullable[CreateSubscriptionMetadataResponse]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity.
    Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately
    1kB.

    Any metadata added to the subscription will be automatically forwarded to the payments generated for it.
    """

    webhook_url: Annotated[str, pydantic.Field(alias="webhookUrl")]
    r"""We will call this URL for any payment status changes of payments resulting from this subscription.

    This webhook will receive **all** events for the subscription's payments. This may include payment failures as
    well. Be sure to verify the payment's subscription ID and its status.
    """

    customer_id: Annotated[str, pydantic.Field(alias="customerId")]
    r"""The customer this subscription belongs to."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[CreateSubscriptionLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    next_payment_date: Annotated[
        OptionalNullable[str], pydantic.Field(alias="nextPaymentDate")
    ] = UNSET
    r"""The date of the next scheduled payment in `YYYY-MM-DD` format. If the subscription has been completed or canceled,
    this parameter will not be returned.
    """

    application_fee: Annotated[
        Optional[CreateSubscriptionApplicationFeeResponse],
        pydantic.Field(alias="applicationFee"),
    ] = None
    r"""With Mollie Connect you can charge fees on payments that your app is processing on behalf of other Mollie
    merchants.

    Setting an application fee on the subscription will ensure this fee is charged on each individual payment.

    Refer to the `applicationFee` parameter on the [Get payment endpoint](get-payment) documentation for more
    information.
    """

    mandate_id: Annotated[OptionalNullable[str], pydantic.Field(alias="mandateId")] = (
        UNSET
    )
    r"""The mandate used for this subscription, if any."""

    canceled_at: Annotated[
        OptionalNullable[str], pydantic.Field(alias="canceledAt")
    ] = UNSET
    r"""The subscription's date and time of cancellation, in ISO 8601 format. This parameter is omitted if the
    subscription is not canceled (yet).
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "nextPaymentDate",
            "applicationFee",
            "mandateId",
            "canceledAt",
        ]
        nullable_fields = [
            "times",
            "timesRemaining",
            "nextPaymentDate",
            "method",
            "metadata",
            "mandateId",
            "canceledAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
