"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CreateWebhookEventTypes(str, Enum):
    r"""The list of events to enable for this webhook. You may specify `'*'` to add all events, except those that require explicit selection. Separate multiple event types with a comma."""

    PAYMENT_LINK_PAID = "payment-link.paid"
    BALANCE_TRANSACTION_CREATED = "balance-transaction.created"
    SALES_INVOICE_CREATED = "sales-invoice.created"
    SALES_INVOICE_ISSUED = "sales-invoice.issued"
    SALES_INVOICE_CANCELED = "sales-invoice.canceled"
    SALES_INVOICE_PAID = "sales-invoice.paid"


class CreateWebhookRequestTypedDict(TypedDict):
    name: str
    r"""A name that identifies the webhook."""
    url: str
    r"""The URL Mollie will send the events to. This URL must be publicly accessible."""
    event_types: CreateWebhookEventTypes
    r"""The list of events to enable for this webhook. You may specify `'*'` to add all events, except those that require explicit selection. Separate multiple event types with a comma."""
    testmode: NotRequired[Nullable[bool]]
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """


class CreateWebhookRequest(BaseModel):
    name: str
    r"""A name that identifies the webhook."""

    url: str
    r"""The URL Mollie will send the events to. This URL must be publicly accessible."""

    event_types: Annotated[CreateWebhookEventTypes, pydantic.Field(alias="eventTypes")]
    r"""The list of events to enable for this webhook. You may specify `'*'` to add all events, except those that require explicit selection. Separate multiple event types with a comma."""

    testmode: OptionalNullable[bool] = UNSET
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["testmode"]
        nullable_fields = ["testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreateWebhookUnprocessableEntityDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class CreateWebhookUnprocessableEntityDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class CreateWebhookUnprocessableEntityLinksTypedDict(TypedDict):
    documentation: CreateWebhookUnprocessableEntityDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class CreateWebhookUnprocessableEntityLinks(BaseModel):
    documentation: CreateWebhookUnprocessableEntityDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class CreateWebhookHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[
        CreateWebhookUnprocessableEntityLinks, pydantic.Field(alias="_links")
    ]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class CreateWebhookHalJSONError(ClientError):
    r"""An error response object."""

    data: CreateWebhookHalJSONErrorData

    def __init__(
        self,
        data: CreateWebhookHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class CreateWebhookStatus(str, Enum):
    r"""The subscription's current status."""

    ENABLED = "enabled"
    BLOCKED = "blocked"
    DISABLED = "disabled"


class CreateWebhookMode(str, Enum):
    r"""The subscription's mode."""

    LIVE = "live"
    TEST = "test"


class CreateWebhookDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateWebhookDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class CreateWebhookLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    documentation: NotRequired[CreateWebhookDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class CreateWebhookLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    documentation: Optional[CreateWebhookDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class CreateWebhookResponseTypedDict(TypedDict):
    r"""The webhook object."""

    resource: NotRequired[str]
    r"""Indicates the response contains a webhook subscription object. Will always contain the string `webhook` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this subscription."""
    url: NotRequired[str]
    r"""The subscription's events destination."""
    profile_id: NotRequired[str]
    r"""The identifier uniquely referring to the profile that created the subscription."""
    created_at: NotRequired[str]
    r"""The subscription's date time of creation."""
    name: NotRequired[str]
    r"""The subscription's name."""
    event_types: NotRequired[List[str]]
    r"""The events types that are subscribed."""
    status: NotRequired[CreateWebhookStatus]
    r"""The subscription's current status."""
    mode: NotRequired[CreateWebhookMode]
    r"""The subscription's mode."""
    webhook_secret: NotRequired[str]
    r"""The subscription's secret."""
    links: NotRequired[CreateWebhookLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class CreateWebhookResponse(BaseModel):
    r"""The webhook object."""

    resource: Optional[str] = None
    r"""Indicates the response contains a webhook subscription object. Will always contain the string `webhook` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this subscription."""

    url: Optional[str] = None
    r"""The subscription's events destination."""

    profile_id: Annotated[Optional[str], pydantic.Field(alias="profileId")] = None
    r"""The identifier uniquely referring to the profile that created the subscription."""

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The subscription's date time of creation."""

    name: Optional[str] = None
    r"""The subscription's name."""

    event_types: Annotated[Optional[List[str]], pydantic.Field(alias="eventTypes")] = (
        None
    )
    r"""The events types that are subscribed."""

    status: Optional[CreateWebhookStatus] = None
    r"""The subscription's current status."""

    mode: Optional[CreateWebhookMode] = None
    r"""The subscription's mode."""

    webhook_secret: Annotated[Optional[str], pydantic.Field(alias="webhookSecret")] = (
        None
    )
    r"""The subscription's secret."""

    links: Annotated[Optional[CreateWebhookLinks], pydantic.Field(alias="_links")] = (
        None
    )
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
