"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListMandatesSort(str, Enum):
    r"""Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from
    newest to oldest.
    """

    ASC = "asc"
    DESC = "desc"


class ListMandatesRequestTypedDict(TypedDict):
    customer_id: str
    r"""Provide the ID of the related customer."""
    from_: NotRequired[str]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""
    sort: NotRequired[Nullable[ListMandatesSort]]
    r"""Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from
    newest to oldest.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class ListMandatesRequest(BaseModel):
    customer_id: Annotated[
        str,
        pydantic.Field(alias="customerId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related customer."""

    from_: Annotated[
        Optional[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The maximum number of items to return. Defaults to 50 items."""

    sort: Annotated[
        OptionalNullable[ListMandatesSort],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from
    newest to oldest.
    """

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["from", "limit", "sort", "testmode"]
        nullable_fields = ["limit", "sort", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListMandatesNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListMandatesNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListMandatesNotFoundLinksTypedDict(TypedDict):
    documentation: ListMandatesNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListMandatesNotFoundLinks(BaseModel):
    documentation: ListMandatesNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListMandatesNotFoundHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[ListMandatesNotFoundLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class ListMandatesNotFoundHalJSONError(ClientError):
    r"""An error response object."""

    data: ListMandatesNotFoundHalJSONErrorData

    def __init__(
        self,
        data: ListMandatesNotFoundHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ListMandatesBadRequestDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListMandatesBadRequestDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListMandatesBadRequestLinksTypedDict(TypedDict):
    documentation: ListMandatesBadRequestDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListMandatesBadRequestLinks(BaseModel):
    documentation: ListMandatesBadRequestDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListMandatesBadRequestHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[ListMandatesBadRequestLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class ListMandatesBadRequestHalJSONError(ClientError):
    r"""An error response object."""

    data: ListMandatesBadRequestHalJSONErrorData

    def __init__(
        self,
        data: ListMandatesBadRequestHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ListMandatesMode(str, Enum):
    r"""Whether this entity was created in live mode or in test mode."""

    LIVE = "live"
    TEST = "test"


class ListMandatesMethod(str, Enum):
    r"""Payment method of the mandate.

    SEPA Direct Debit and PayPal mandates can be created directly.
    """

    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    PAYPAL = "paypal"


class ListMandatesCardLabel(str, Enum):
    r"""The card's label. Available for card mandates, if the card label could be detected."""

    AMERICAN_EXPRESS = "American Express"
    CARTA_SI = "Carta Si"
    CARTE_BLEUE = "Carte Bleue"
    DANKORT = "Dankort"
    DINERS_CLUB = "Diners Club"
    DISCOVER = "Discover"
    JCB = "JCB"
    LASER = "Laser"
    MAESTRO = "Maestro"
    MASTERCARD = "Mastercard"
    UNIONPAY = "Unionpay"
    VISA = "Visa"


class ListMandatesDetailsTypedDict(TypedDict):
    consumer_name: NotRequired[Nullable[str]]
    r"""The customer's name. Available for SEPA Direct Debit and PayPal mandates."""
    consumer_account: NotRequired[Nullable[str]]
    r"""The customer's IBAN or email address. Available for SEPA Direct Debit and PayPal mandates."""
    consumer_bic: NotRequired[Nullable[str]]
    r"""The BIC of the customer's bank. Available for SEPA Direct Debit mandates."""
    card_holder: NotRequired[Nullable[str]]
    r"""The card holder's name. Available for card mandates."""
    card_number: NotRequired[Nullable[str]]
    r"""The last four digits of the card number. Available for card mandates."""
    card_expiry_date: NotRequired[Nullable[str]]
    r"""The card's expiry date in `YYYY-MM-DD` format. Available for card mandates."""
    card_label: NotRequired[Nullable[ListMandatesCardLabel]]
    r"""The card's label. Available for card mandates, if the card label could be detected."""
    card_fingerprint: NotRequired[Nullable[str]]
    r"""Unique alphanumeric representation of this specific card. Available for card mandates. Can be used to identify
    returning customers.
    """


class ListMandatesDetails(BaseModel):
    consumer_name: Annotated[
        OptionalNullable[str], pydantic.Field(alias="consumerName")
    ] = UNSET
    r"""The customer's name. Available for SEPA Direct Debit and PayPal mandates."""

    consumer_account: Annotated[
        OptionalNullable[str], pydantic.Field(alias="consumerAccount")
    ] = UNSET
    r"""The customer's IBAN or email address. Available for SEPA Direct Debit and PayPal mandates."""

    consumer_bic: Annotated[
        OptionalNullable[str], pydantic.Field(alias="consumerBic")
    ] = UNSET
    r"""The BIC of the customer's bank. Available for SEPA Direct Debit mandates."""

    card_holder: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardHolder")
    ] = UNSET
    r"""The card holder's name. Available for card mandates."""

    card_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardNumber")
    ] = UNSET
    r"""The last four digits of the card number. Available for card mandates."""

    card_expiry_date: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardExpiryDate")
    ] = UNSET
    r"""The card's expiry date in `YYYY-MM-DD` format. Available for card mandates."""

    card_label: Annotated[
        OptionalNullable[ListMandatesCardLabel], pydantic.Field(alias="cardLabel")
    ] = UNSET
    r"""The card's label. Available for card mandates, if the card label could be detected."""

    card_fingerprint: Annotated[
        OptionalNullable[str], pydantic.Field(alias="cardFingerprint")
    ] = UNSET
    r"""Unique alphanumeric representation of this specific card. Available for card mandates. Can be used to identify
    returning customers.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "consumerName",
            "consumerAccount",
            "consumerBic",
            "cardHolder",
            "cardNumber",
            "cardExpiryDate",
            "cardLabel",
            "cardFingerprint",
        ]
        nullable_fields = [
            "consumerName",
            "consumerAccount",
            "consumerBic",
            "cardHolder",
            "cardNumber",
            "cardExpiryDate",
            "cardLabel",
            "cardFingerprint",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListMandatesStatus(str, Enum):
    r"""The status of the mandate. A status can be `pending` for mandates when the first payment is not yet finalized, or
    when we did not received the IBAN yet from the first payment.
    """

    VALID = "valid"
    PENDING = "pending"
    INVALID = "invalid"


class MandateSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class MandateSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMandatesCustomerTypedDict(TypedDict):
    r"""The API resource URL of the [customer](get-customer) that this mandate belongs to."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMandatesCustomer(BaseModel):
    r"""The API resource URL of the [customer](get-customer) that this mandate belongs to."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class MandateDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class MandateDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class MandateLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: MandateSelfTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    customer: ListMandatesCustomerTypedDict
    r"""The API resource URL of the [customer](get-customer) that this mandate belongs to."""
    documentation: MandateDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class MandateLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[MandateSelf, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    customer: ListMandatesCustomer
    r"""The API resource URL of the [customer](get-customer) that this mandate belongs to."""

    documentation: MandateDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListMandatesMandateTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a mandate object. Will always contain the string `mandate` for this endpoint."""
    id: str
    r"""The identifier uniquely referring to this mandate. Example: `mdt_pWUnw6pkBN`."""
    mode: ListMandatesMode
    r"""Whether this entity was created in live mode or in test mode."""
    method: ListMandatesMethod
    r"""Payment method of the mandate.

    SEPA Direct Debit and PayPal mandates can be created directly.
    """
    details: ListMandatesDetailsTypedDict
    signature_date: Nullable[str]
    r"""The date when the mandate was signed in `YYYY-MM-DD` format."""
    mandate_reference: Nullable[str]
    r"""A custom mandate reference. For SEPA Direct Debit, it is vital to provide a unique reference. Some banks will
    decline Direct Debit payments if the mandate reference is not unique.
    """
    status: ListMandatesStatus
    r"""The status of the mandate. A status can be `pending` for mandates when the first payment is not yet finalized, or
    when we did not received the IBAN yet from the first payment.
    """
    customer_id: str
    r"""The identifier referring to the [customer](get-customer) this mandate was linked to."""
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: MandateLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class ListMandatesMandate(BaseModel):
    resource: str
    r"""Indicates the response contains a mandate object. Will always contain the string `mandate` for this endpoint."""

    id: str
    r"""The identifier uniquely referring to this mandate. Example: `mdt_pWUnw6pkBN`."""

    mode: ListMandatesMode
    r"""Whether this entity was created in live mode or in test mode."""

    method: ListMandatesMethod
    r"""Payment method of the mandate.

    SEPA Direct Debit and PayPal mandates can be created directly.
    """

    details: ListMandatesDetails

    signature_date: Annotated[Nullable[str], pydantic.Field(alias="signatureDate")]
    r"""The date when the mandate was signed in `YYYY-MM-DD` format."""

    mandate_reference: Annotated[
        Nullable[str], pydantic.Field(alias="mandateReference")
    ]
    r"""A custom mandate reference. For SEPA Direct Debit, it is vital to provide a unique reference. Some banks will
    decline Direct Debit payments if the mandate reference is not unique.
    """

    status: ListMandatesStatus
    r"""The status of the mandate. A status can be `pending` for mandates when the first payment is not yet finalized, or
    when we did not received the IBAN yet from the first payment.
    """

    customer_id: Annotated[str, pydantic.Field(alias="customerId")]
    r"""The identifier referring to the [customer](get-customer) this mandate was linked to."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[MandateLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["signatureDate", "mandateReference"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListMandatesEmbeddedTypedDict(TypedDict):
    mandates: NotRequired[List[ListMandatesMandateTypedDict]]
    r"""An array of mandate objects."""


class ListMandatesEmbedded(BaseModel):
    mandates: Optional[List[ListMandatesMandate]] = None
    r"""An array of mandate objects."""


class ListMandatesSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMandatesSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMandatesPreviousTypedDict(TypedDict):
    r"""The previous set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListMandatesPrevious(BaseModel):
    r"""The previous set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListMandatesNextTypedDict(TypedDict):
    r"""The next set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListMandatesNext(BaseModel):
    r"""The next set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListMandatesDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMandatesDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListMandatesLinksTypedDict(TypedDict):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: ListMandatesSelfTypedDict
    r"""The URL to the current set of items."""
    previous: Nullable[ListMandatesPreviousTypedDict]
    r"""The previous set of items, if available."""
    next: Nullable[ListMandatesNextTypedDict]
    r"""The next set of items, if available."""
    documentation: ListMandatesDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListMandatesLinks(BaseModel):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[ListMandatesSelf, pydantic.Field(alias="self")]
    r"""The URL to the current set of items."""

    previous: Nullable[ListMandatesPrevious]
    r"""The previous set of items, if available."""

    next: Nullable[ListMandatesNext]
    r"""The next set of items, if available."""

    documentation: ListMandatesDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["previous", "next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListMandatesResponseTypedDict(TypedDict):
    r"""A list of mandate objects."""

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """
    embedded: NotRequired[ListMandatesEmbeddedTypedDict]
    links: NotRequired[ListMandatesLinksTypedDict]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class ListMandatesResponse(BaseModel):
    r"""A list of mandate objects."""

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """

    embedded: Annotated[
        Optional[ListMandatesEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[Optional[ListMandatesLinks], pydantic.Field(alias="_links")] = None
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
