"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListTerminalsSort(str, Enum):
    r"""Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from
    newest to oldest.
    """

    ASC = "asc"
    DESC = "desc"


class ListTerminalsRequestTypedDict(TypedDict):
    from_: NotRequired[str]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""
    sort: NotRequired[Nullable[ListTerminalsSort]]
    r"""Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from
    newest to oldest.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class ListTerminalsRequest(BaseModel):
    from_: Annotated[
        Optional[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The maximum number of items to return. Defaults to 50 items."""

    sort: Annotated[
        OptionalNullable[ListTerminalsSort],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Used for setting the direction of the result set. Defaults to descending order, meaning the results are ordered from
    newest to oldest.
    """

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["from", "limit", "sort", "testmode"]
        nullable_fields = ["limit", "sort", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListTerminalsBadRequestDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListTerminalsBadRequestDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListTerminalsBadRequestLinksTypedDict(TypedDict):
    documentation: ListTerminalsBadRequestDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListTerminalsBadRequestLinks(BaseModel):
    documentation: ListTerminalsBadRequestDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListTerminalsHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[ListTerminalsBadRequestLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class ListTerminalsHalJSONError(ClientError):
    r"""An error response object."""

    data: ListTerminalsHalJSONErrorData

    def __init__(
        self,
        data: ListTerminalsHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ListTerminalsMode(str, Enum):
    r"""Whether this entity was created in live mode or in test mode."""

    LIVE = "live"
    TEST = "test"


class ListTerminalsStatus(str, Enum):
    r"""The status of the terminal."""

    PENDING = "pending"
    ACTIVE = "active"
    INACTIVE = "inactive"


class ListTerminalsBrand(str, Enum):
    r"""The brand of the terminal."""

    PAX = "PAX"
    TAP = "Tap"


class ListTerminalsModel(str, Enum):
    r"""The model of the terminal. For example for a PAX A920, this field's value will be `A920`."""

    A35 = "A35"
    A77 = "A77"
    A920 = "A920"
    A920_PRO = "A920Pro"
    IM30 = "IM30"
    TAP = "Tap"


class TerminalSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class TerminalSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class TerminalDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class TerminalDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class TerminalLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: TerminalSelfTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: TerminalDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class TerminalLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[TerminalSelf, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: TerminalDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListTerminalsTerminalTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a terminal object. Will always contain the string `terminal` for this endpoint."""
    id: str
    r"""The identifier uniquely referring to this terminal. Example: `term_7MgL4wea46qkRcoTZjWEH`."""
    mode: ListTerminalsMode
    r"""Whether this entity was created in live mode or in test mode."""
    description: str
    r"""A short description of the terminal. The description can be used as an identifier for the terminal. Currently, the
    description is set when the terminal is initially configured. It will be visible in the Mollie Dashboard, and it
    may be visible on the device itself depending on the device.
    """
    status: ListTerminalsStatus
    r"""The status of the terminal."""
    brand: Nullable[ListTerminalsBrand]
    r"""The brand of the terminal."""
    model: Nullable[ListTerminalsModel]
    r"""The model of the terminal. For example for a PAX A920, this field's value will be `A920`."""
    serial_number: Nullable[str]
    r"""The serial number of the terminal. The serial number is provided at terminal creation time."""
    currency: str
    r"""The currency configured on the terminal, in ISO 4217 format. Currently most of our terminals are bound to a
    specific currency, chosen during setup.
    """
    profile_id: str
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation
    request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is
    required.
    """
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    updated_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: TerminalLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class ListTerminalsTerminal(BaseModel):
    resource: str
    r"""Indicates the response contains a terminal object. Will always contain the string `terminal` for this endpoint."""

    id: str
    r"""The identifier uniquely referring to this terminal. Example: `term_7MgL4wea46qkRcoTZjWEH`."""

    mode: ListTerminalsMode
    r"""Whether this entity was created in live mode or in test mode."""

    description: str
    r"""A short description of the terminal. The description can be used as an identifier for the terminal. Currently, the
    description is set when the terminal is initially configured. It will be visible in the Mollie Dashboard, and it
    may be visible on the device itself depending on the device.
    """

    status: ListTerminalsStatus
    r"""The status of the terminal."""

    brand: Nullable[ListTerminalsBrand]
    r"""The brand of the terminal."""

    model: Nullable[ListTerminalsModel]
    r"""The model of the terminal. For example for a PAX A920, this field's value will be `A920`."""

    serial_number: Annotated[Nullable[str], pydantic.Field(alias="serialNumber")]
    r"""The serial number of the terminal. The serial number is provided at terminal creation time."""

    currency: str
    r"""The currency configured on the terminal, in ISO 4217 format. Currently most of our terminals are bound to a
    specific currency, chosen during setup.
    """

    profile_id: Annotated[str, pydantic.Field(alias="profileId")]
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation
    request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is
    required.
    """

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    updated_at: Annotated[str, pydantic.Field(alias="updatedAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[TerminalLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["brand", "model", "serialNumber"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListTerminalsEmbeddedTypedDict(TypedDict):
    terminals: NotRequired[List[ListTerminalsTerminalTypedDict]]
    r"""An array of terminal objects."""


class ListTerminalsEmbedded(BaseModel):
    terminals: Optional[List[ListTerminalsTerminal]] = None
    r"""An array of terminal objects."""


class ListTerminalsSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListTerminalsSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListTerminalsPreviousTypedDict(TypedDict):
    r"""The previous set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListTerminalsPrevious(BaseModel):
    r"""The previous set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListTerminalsNextTypedDict(TypedDict):
    r"""The next set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListTerminalsNext(BaseModel):
    r"""The next set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListTerminalsDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListTerminalsDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListTerminalsLinksTypedDict(TypedDict):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: ListTerminalsSelfTypedDict
    r"""The URL to the current set of items."""
    previous: Nullable[ListTerminalsPreviousTypedDict]
    r"""The previous set of items, if available."""
    next: Nullable[ListTerminalsNextTypedDict]
    r"""The next set of items, if available."""
    documentation: ListTerminalsDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListTerminalsLinks(BaseModel):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[ListTerminalsSelf, pydantic.Field(alias="self")]
    r"""The URL to the current set of items."""

    previous: Nullable[ListTerminalsPrevious]
    r"""The previous set of items, if available."""

    next: Nullable[ListTerminalsNext]
    r"""The next set of items, if available."""

    documentation: ListTerminalsDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["previous", "next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListTerminalsResponseTypedDict(TypedDict):
    r"""A list of terminal objects."""

    count: int
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """
    embedded: ListTerminalsEmbeddedTypedDict
    links: ListTerminalsLinksTypedDict
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class ListTerminalsResponse(BaseModel):
    r"""A list of terminal objects."""

    count: int
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """

    embedded: Annotated[ListTerminalsEmbedded, pydantic.Field(alias="_embedded")]

    links: Annotated[ListTerminalsLinks, pydantic.Field(alias="_links")]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
