"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BucketPolicy = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const s3_generated_1 = require("./s3.generated");
/**
 * The bucket policy for an Amazon S3 bucket
 *
 * Policies define the operations that are allowed on this resource.
 *
 * You almost never need to define this construct directly.
 *
 * All AWS resources that support resource policies have a method called
 * `addToResourcePolicy()`, which will automatically create a new resource
 * policy if one doesn't exist yet, otherwise it will add to the existing
 * policy.
 *
 * Prefer to use `addToResourcePolicy()` instead.
 */
class BucketPolicy extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * A policy document containing permissions to add to the specified bucket.
         * For more information, see Access Policy Language Overview in the Amazon
         * Simple Storage Service Developer Guide.
         */
        this.document = new aws_iam_1.PolicyDocument();
        jsiiDeprecationWarnings._aws_cdk_aws_s3_BucketPolicyProps(props);
        if (!props.bucket.bucketName) {
            throw new Error('Bucket doesn\'t have a bucketName defined');
        }
        this.resource = new s3_generated_1.CfnBucketPolicy(this, 'Resource', {
            bucket: props.bucket.bucketName,
            policyDocument: this.document,
        });
        if (props.removalPolicy) {
            this.resource.applyRemovalPolicy(props.removalPolicy);
        }
    }
    /**
     * Sets the removal policy for the BucketPolicy.
     * @param removalPolicy the RemovalPolicy to set.
     */
    applyRemovalPolicy(removalPolicy) {
        this.resource.applyRemovalPolicy(removalPolicy);
    }
}
exports.BucketPolicy = BucketPolicy;
_a = JSII_RTTI_SYMBOL_1;
BucketPolicy[_a] = { fqn: "@aws-cdk/aws-s3.BucketPolicy", version: "1.152.0" };
//# sourceMappingURL=data:application/json;base64,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