"""
Financial codes and instruments
"""

CURRENCY_SYMBOLS = {
    "USD": "$",
    "RUB": "₽",
    "EUR": "€",
    "TRY": "₺",
    "UAH": "₴",
    "THB": "฿",
    "AFN": "؋",
    "AOA": "Kz",
    "AZN": "₼",
    "BIF": "FBu",
    "BND": "B$",
    "BWP": "P",
    "BYN": "Br",
    "CDF": "FC",
    "CNY": "￥",
    "CRC": "₡",
    "DJF": "Fdj",
    "DKK": "Kr.",
    "ERN": "Nfk",
    "ETB": "Br",
    "GNF": "FG",
    "GTQ": "Q",
    "HNL": "L",
    "HRK": "T",
    "HUF": "Ft",
    "IQD": "د.ع",
    "ISK": "Íkr",
    "JOD": "د.ا",
    "KGS": "Лв",
    "KMF": "CF",
    "KWD": "د.ك",
    "LYD": "ل.د",
    "MDL": "L",
    "MGA": "Ar",
    "MOP": "MOP$",
    "MWK": "MK",
    "MZN": "MT",
    "NAD": "N$",
    "NIO": "C$",
    "NOK": "kr",
    "PGK": "K",
    "RSD": "din",
    "SCR": "SRe",
    "TJS": "SM",
    "TMT": "T",
    "YER": "﷼",
    "ZMW": "ZK",
    "ZWD": "Z$",
    "VND": "₫",
    "NGN": "₦",
    "COP": "COL$",
    "BRL": "R$",
    "ARS": "ARS$",
    "PEN": "S/",
    "ZAR": "R",
    "MXN": "Mex$",
    "HKD": "HK$",
    "GBP": "£",
    "KES": "KSh",
    "AUD": "A$",
    "CAD": "C$",
    "VES": "Bs",
    "INR": "₹",
    "IDR": "Rp",
    "KZT": "〒",
    "JPY": "¥",
    "PHP": "₱",
    "TWD": "NT$",
    "SAR": "ر.س",
    "BDT": "৳",
    "EGP": "E£",
    "AED": "د.إ",
    "BGN": "лв",
    "MAD": "د.م.",
    "PLN": "zł",
    "PKR": "₨",
    "RON": "lei",
    "CHF": "Fr.",
    "CZK": "Kč",
    "SEK": "kr",
    "UGX": "Sh",
    "GHS": "GH¢",
    "LBP": "ل.ل",
    "AMD": "֏",
    "GEL": "₾",
    "UYU": "$U",
    "CLP": "$",
    "XAF": "Fr",
    "DZD": "د.ج",
    "PYG": "₲",
    "BOB": "Bs.",
    "LKR": "ரூ",
    "PAB": "B/.",
    "NZD": "$",
    "KHR": "៛",
    "LAK": "₭",
    "MMK": "K",
    "DOP": "RD$",
    "QAR": "ر.ق",
    "BHD": "ب.د",
    "OMR": "ر.ع.",
    "TND": "د.ت",
    "SDG": "£",
    "MNT": "₮",
    "UZS": "so'm",
    "NPR": "रु",
    "TZS": "TSh",
    "XOF": "FCFA",
    "RWF": "FRw",
    "BZD": "$",
    "GMD": "D",
    "HTG": "G",
    "SLL": "Le",
    "CVE": "$",
    "JMD": "$",
    "LRD": "L$",
    "MRU": "UM",
    "BSD": "B$",
    "TTD": "TT$",
}

CURRENCY_TITLES = {
    "USD": "United States Dollar",
    "RUB": "Russian Ruble",
    "EUR": "Euro",
    "TRY": "Turkish Lira",
    "UAH": "Ukrainian Hryvnia",
    "THB": "Thai Baht",
    "AFN": "Afghan Afghani",
    "AOA": "Angolan Kwanza",
    "AZN": "Azerbaijani Manat",
    "BIF": "Burundian Franc",
    "BND": "Brunei Dollar",
    "BWP": "Botswanan Pula",
    "BYN": "Belarusian Ruble",
    "CDF": "Congolese Franc",
    "CNY": "Chinese Yuan",
    "CRC": "Costa Rican Colon",
    "DJF": "Djiboutian Franc",
    "DKK": "Danish Krone",
    "ERN": "Eritrean Nakfa",
    "ETB": "Ethiopian Birr",
    "GNF": "Guinean Franc",
    "GTQ": "Guatemalan Quetzal",
    "HNL": "Honduran Lempira",
    "HRK": "Croatian Kuna",
    "HUF": "Hungarian Forint",
    "IQD": "Iraqi Dinar",
    "ISK": "Icelandic Krona",
    "JOD": "Jordanian Dinar",
    "KGS": "Kyrgystani Som",
    "KMF": "Comorian Franc",
    "KWD": "Kuwaiti Dinar",
    "LYD": "Libyan Dinar",
    "MDL": "Moldovan Leu",
    "MGA": "Malagasy Ariary",
    "MOP": "Macanese Pataca",
    "MWK": "Malawian Kwacha",
    "MZN": "Mozambican Metical",
    "NAD": "Namibian Dollar",
    "NIO": "Nicaraguan Cordoba",
    "NOK": "Norwegian Krone",
    "PGK": "Papua New Guinean Kina",
    "RSD": "Serbian Dinar",
    "SCR": "Seychellois Rupee",
    "TJS": "Tajikistani Somoni",
    "TMT": "Turkmenistani Manat",
    "YER": "Yemeni Rial",
    "ZMW": "Zambian Kwacha",
    "ZWD": "Zimbabwean Dollar",
    "VND": "Vietnamese Dong",
    "NGN": "Nigerian Naira",
    "COP": "Colombian Peso",
    "BRL": "Brazilian Real",
    "ARS": "Argentine Peso",
    "PEN": "Peruvian Sol",
    "ZAR": "South African Rand",
    "MXN": "Mexican Peso",
    "HKD": "Hong Kong Dollar",
    "GBP": "British pound Sterling",
    "KES": "Kenyan Shilling",
    "AUD": "Australian Dollar",
    "CAD": "Canadian Dollar",
    "VES": "Venezuelan Bolivar",
    "INR": "Indian Rupee",
    "IDR": "Indonesian Rupiah",
    "KZT": "Kazakhstani Tenge",
    "JPY": "Japanese Yen",
    "PHP": "Philippine Peso",
    "TWD": "New Taiwan Dollar",
    "SAR": "Saudi Riyal",
    "BDT": "Bangladeshi Taka",
    "EGP": "Egyptian Pound",
    "AED": "United Arab Emirates Dirham",
    "BGN": "Bulgarian Lev",
    "MAD": "Moroccan Dirham",
    "PLN": "Polish Zloty",
    "PKR": "Pakistani Rupee",
    "RON": "Romanian Leu",
    "CHF": "Swiss Franc",
    "CZK": "Czech Koruna",
    "SEK": "Swedish Krona",
    "UGX": "Ugandan Shilling",
    "GHS": "Ghanaian Cedi",
    "LBP": "Lebanese Pound",
    "AMD": "Armenian Dram",
    "GEL": "Georgian Lari",
    "UYU": "Uruguayan Peso",
    "CLP": "Chilean Peso",
    "XAF": "Central African CFA Franc",
    "DZD": "Algerian Dinar",
    "PYG": "Paraguayan Guarani",
    "BOB": "Bolivian Boliviano",
    "LKR": "Sri Lankan Rupee",
    "PAB": "Panamanian Balboa",
    "NZD": "New Zealand Dollar",
    "KHR": "Cambodian Riel",
    "LAK": "Laotian Kip",
    "MMK": "Myanmar Kyat",
    "DOP": "Dominican Peso",
    "QAR": "Qatari Riyal",
    "BHD": "Bahraini Dinar",
    "OMR": "Omani Rial",
    "TND": "Tunisian Dinar",
    "SDG": "Sudanese Pound",
    "MNT": "Mongolian Tugrik",
    "UZS": "Uzbekistani Sum",
    "NPR": "Nepalese Rupee",
    "TZS": "Tanzanian Shilling",
    "XOF": "West African CFA Franc",
    "RWF": "Rwandan Franc",
    "BZD": "Belize Dollar",
    "GMD": "Gambian Dalasi",
    "HTG": "Haitian Gourde",
    "SLL": "Sierra Leonean Leone",
    "CVE": "Cape Verde Escudo",
    "JMD": "Jamaican Dollar",
    "LRD": "Liberian Dollar",
    "MRU": "Mauritanian Ouguiya",
    "BSD": "Bahamian Dollar",
    "TTD": "Trinidad and Tobago Dollar",
}

CURRENCY_RATES = {
    "USD": 1,
    "XAF": 622.5,
    "KGS": 84.45,
    "PAB": 1,
    "DZD": 138.16,
    "UZS": 11257.19,
    "BYN": 2.53,
    "GEL": 2.69,
    "EUR": 0.95,
    "INR": 81.44,
    "BRL": 5.22,
    "PEN": 3.82,
    "CHF": 0.94,
    "KES": 122.59,
    "KZT": 469.6,
    "NGN": 462.53,
    "QAR": 3.64,
    "CNY": 7.02,
    "PHP": 55.73,
    "UAH": 36.78,
    "RUB": 74.86,
    "TWD": 30.56,
    "BGN": 1.86,
    "SAR": 3.75,
    "KWD": 0.31,
    "COP": 4766.44,
    "UGX": 3733.69,
    "ZAR": 17.55,
    "DKK": 7.05,
    "NZD": 1.56,
    "MAD": 10.55,
    "THB": 34.72,
    "PKR": 224.33,
    "BOB": 6.91,
    "BHD": 0.38,
    "TRY": 18.63,
    "ARS": 312.96,
    "BDT": 102.6,
    "MXN": 19.38,
    "SEK": 10.33,
    "HUF": 388.93,
    "HRK": 7.16,
    "JPY": 134.33,
    "AED": 3.67,
    "CAD": 1.35,
    "AUD": 1.47,
    "EGP": 24.57,
    "MNT": 3425.3,
    "RON": 4.67,
    "IDR": 15382.2,
    "PLN": 4.44,
    "HKD": 7.79,
    "VND": 24360.57,
    "GBP": 0.81,
    "CZK": 23.12,
    "OMR": 0.39,
    "VES": 11.24,
    "AMD": 394.29,
    "AFN": 87.43,
    "AOA": 504.30,
    "AZN": 1.70,
    "BIF": 2061.0,
    "BND": 1.36,
    "BWP": 12.9,
    "CDF": 2031.0,
    "CRC": 583.89,
    "DJF": 177.72,
    "ERN": 15.0,
    "ETB": 53.63,
    "GNF": 8776.0,
    "GTQ": 7.87,
    "HNL": 24.7,
    "IQD": 1459.64,
    "ISK": 142.64,
    "JOD": 0.71,
    "KMF": 464.3,
    "MDL": 19.37,
    "MGA": 4430.0,
    "MOP": 8.01,
    "MWK": 1027.2,
    "MZN": 63.83,
    "NAD": 17.68,
    "NIO": 36.42,
    "NOK": 9.89,
    "PGK": 3.52,
    "RSD": 110.46,
    "SCR": 12.91,
    "TJS": 10.20,
    "TMT": 3.51,
    "YER": 250.30,
    "ZMW": 17.73,
    "ZWD": 322.0,
    "BZD": 2.01,
    "GMD": 62.60,
    "HTG": 149.30,
    "SLL": 20.0,
    "CVE": 103.62,
    "JMD": 154.15,
    "LRD": 157.69,
    "MRU": 36.30,
    "BSD": 1.0,
    "TTD": 6.78,
}
