"""
This type stub file was generated by pyright.
"""

"""
ldap.asyncsearch - handle async LDAP search operations

See https://www.python-ldap.org/ for details.
"""
SEARCH_RESULT_TYPES = ...
ENTRY_RESULT_TYPES = ...
class WrongResultType(Exception):
  def __init__(self, receivedResultType, expectedResultTypes) -> None:
    ...
  
  def __str__(self) -> str:
    ...
  


class AsyncSearchHandler:
  """
  Class for stream-processing LDAP search results

  Arguments:

  l
    LDAPObject instance
  """
  def __init__(self, l) -> None:
    ...
  
  def startSearch(self, searchRoot, searchScope, filterStr, attrList=..., attrsOnly=..., timeout=..., sizelimit=..., serverctrls=..., clientctrls=...): # -> None:
    """
    searchRoot
        See parameter base of method LDAPObject.search()
    searchScope
        See parameter scope of method LDAPObject.search()
    filterStr
        See parameter filter of method LDAPObject.search()
    attrList=None
        See parameter attrlist of method LDAPObject.search()
    attrsOnly
        See parameter attrsonly of method LDAPObject.search()
    timeout
        Maximum time the server shall use for search operation
    sizelimit
        Maximum number of entries a server should return
        (request client-side limit)
    serverctrls
        list of server-side LDAP controls
    clientctrls
        list of client-side LDAP controls
    """
    ...
  
  def preProcessing(self): # -> None:
    """
    Do anything you want after starting search but
    before receiving and processing results
    """
    ...
  
  def afterFirstResult(self): # -> None:
    """
    Do anything you want right after successfully receiving but before
    processing first result
    """
    ...
  
  def postProcessing(self): # -> None:
    """
    Do anything you want after receiving and processing all results
    """
    ...
  
  def processResults(self, ignoreResultsNumber=..., processResultsCount=..., timeout=...): # -> Literal[1, 0]:
    """
    ignoreResultsNumber
        Don't process the first ignoreResultsNumber results.
    processResultsCount
        If non-zero this parameters indicates the number of results
        processed is limited to processResultsCount.
    timeout
        See parameter timeout of ldap.LDAPObject.result()
    """
    ...
  


class List(AsyncSearchHandler):
  """
  Class for collecting all search results.

  This does not seem to make sense in the first place but think
  of retrieving exactly a certain portion of the available search
  results.
  """
  def __init__(self, l) -> None:
    ...
  


class Dict(AsyncSearchHandler):
  """
  Class for collecting all search results into a dictionary {dn:entry}
  """
  def __init__(self, l) -> None:
    ...
  


class IndexedDict(Dict):
  """
  Class for collecting all search results into a dictionary {dn:entry}
  and maintain case-sensitive equality indexes to entries
  """
  def __init__(self, l, indexed_attrs=...) -> None:
    ...
  


class FileWriter(AsyncSearchHandler):
  """
  Class for writing a stream of LDAP search results to a file object

  Arguments:
  l
    LDAPObject instance
  f
    File object instance where the LDIF data is written to
  """
  def __init__(self, l, f, headerStr=..., footerStr=...) -> None:
    ...
  
  def preProcessing(self): # -> None:
    """
    The headerStr is written to output after starting search but
    before receiving and processing results.
    """
    ...
  
  def postProcessing(self): # -> None:
    """
    The footerStr is written to output after receiving and
    processing results.
    """
    ...
  


class LDIFWriter(FileWriter):
  """
  Class for writing a stream LDAP search results to a LDIF file

  Arguments:

  l
    LDAPObject instance
  writer_obj
    Either a file-like object or a ldif.LDIFWriter instance used for output
  """
  def __init__(self, l, writer_obj, headerStr=..., footerStr=...) -> None:
    ...
  


