"""
This type stub file was generated by pyright.
"""

import ldap

"""
ldapobject.py - wraps class _ldap.LDAPObject

See https://www.python-ldap.org/ for details.
"""
__all__ = ['LDAPObject', 'SimpleLDAPObject', 'ReconnectLDAPObject', 'LDAPBytesWarning']
if __debug__:
  ...
class LDAPBytesWarning(BytesWarning):
  """Python 2 bytes mode warning"""
  def __init__(self, *args, **kwargs) -> None:
    ...
  


class NO_UNIQUE_ENTRY(ldap.NO_SUCH_OBJECT):
  """
  Exception raised if a LDAP search returned more than entry entry
  although assumed to return a unique single search result.
  """
  ...


class SimpleLDAPObject:
  """
  This basic class wraps all methods of the underlying C API object.

  The arguments are same as for the :func:`~ldap.initialize()` function.
  """
  CLASSATTR_OPTION_MAPPING = ...
  def __init__(self, uri, trace_level=..., trace_file=..., trace_stack_limit=..., bytes_mode=..., bytes_strictness=..., fileno=...) -> None:
    ...
  
  @property
  def bytes_mode(self): # -> Literal[False]:
    ...
  
  @property
  def bytes_strictness(self): # -> Literal['error']:
    ...
  
  def __setattr__(self, name, value): # -> None:
    ...
  
  def __getattr__(self, name): # -> list[Any] | Any:
    ...
  
  def fileno(self): # -> list[Any]:
    """
    Returns file description of LDAP connection.

    Just a convenience wrapper for LDAPObject.get_option(ldap.OPT_DESC)
    """
    ...
  
  def abandon_ext(self, msgid, serverctrls=..., clientctrls=...):
    """
    abandon_ext(msgid[,serverctrls=None[,clientctrls=None]]) -> None
    abandon(msgid) -> None
        Abandons or cancels an LDAP operation in progress. The msgid should
        be the message id of an outstanding LDAP operation as returned
        by the asynchronous methods search(), modify() etc.  The caller
        can expect that the result of an abandoned operation will not be
        returned from a future call to result().
    """
    ...
  
  def abandon(self, msgid):
    ...
  
  def cancel(self, cancelid, serverctrls=..., clientctrls=...):
    """
    cancel(cancelid[,serverctrls=None[,clientctrls=None]]) -> int
        Send cancels extended operation for an LDAP operation specified by cancelid.
        The cancelid should be the message id of an outstanding LDAP operation as returned
        by the asynchronous methods search(), modify() etc.  The caller
        can expect that the result of an abandoned operation will not be
        returned from a future call to result().
        In opposite to abandon() this extended operation gets an result from
        the server and thus should be preferred if the server supports it.
    """
    ...
  
  def cancel_s(self, cancelid, serverctrls=..., clientctrls=...): # -> tuple[Any | None, list[tuple[Any, Any, list[Any]]] | Any | None] | None:
    ...
  
  def add_ext(self, dn, modlist, serverctrls=..., clientctrls=...):
    """
    add_ext(dn, modlist[,serverctrls=None[,clientctrls=None]]) -> int
        This function adds a new entry with a distinguished name
        specified by dn which means it must not already exist.
        The parameter modlist is similar to the one passed to modify(),
        except that no operation integer need be included in the tuples.
    """
    ...
  
  def add_ext_s(self, dn, modlist, serverctrls=..., clientctrls=...): # -> tuple[Any | None, list[tuple[Any, Any, list[Any]]] | Any | None, Any | None, list[Any]]:
    ...
  
  def add(self, dn, modlist):
    """
    add(dn, modlist) -> int
        This function adds a new entry with a distinguished name
        specified by dn which means it must not already exist.
        The parameter modlist is similar to the one passed to modify(),
        except that no operation integer need be included in the tuples.
    """
    ...
  
  def add_s(self, dn, modlist): # -> tuple[Any | None, list[tuple[Any, Any, list[Any]]] | Any | None, Any | None, list[Any]]:
    ...
  
  def simple_bind(self, who=..., cred=..., serverctrls=..., clientctrls=...):
    """
    simple_bind([who='' [,cred='']]) -> int
    """
    ...
  
  def simple_bind_s(self, who=..., cred=..., serverctrls=..., clientctrls=...): # -> tuple[Any | None, list[tuple[Any, Any, list[Any]]] | Any | None, Any | None, list[Any]]:
    """
    simple_bind_s([who='' [,cred='']]) -> 4-tuple
    """
    ...
  
  def bind(self, who, cred, method=...):
    """
    bind(who, cred, method) -> int
    """
    ...
  
  def bind_s(self, who, cred, method=...): # -> tuple[Any | None, list[tuple[Any, Any, list[Any]]] | Any | None]:
    """
    bind_s(who, cred, method) -> None
    """
    ...
  
  def sasl_interactive_bind_s(self, who, auth, serverctrls=..., clientctrls=..., sasl_flags=...):
    """
    sasl_interactive_bind_s(who, auth [,serverctrls=None[,clientctrls=None[,sasl_flags=ldap.SASL_QUIET]]]) -> None
    """
    ...
  
  def sasl_non_interactive_bind_s(self, sasl_mech, serverctrls=..., clientctrls=..., sasl_flags=..., authz_id=...): # -> None:
    """
    Send a SASL bind request using a non-interactive SASL method (e.g. GSSAPI, EXTERNAL)
    """
    ...
  
  def sasl_external_bind_s(self, serverctrls=..., clientctrls=..., sasl_flags=..., authz_id=...): # -> None:
    """
    Send SASL bind request using SASL mech EXTERNAL
    """
    ...
  
  def sasl_gssapi_bind_s(self, serverctrls=..., clientctrls=..., sasl_flags=..., authz_id=...): # -> None:
    """
    Send SASL bind request using SASL mech GSSAPI
    """
    ...
  
  def sasl_bind_s(self, dn, mechanism, cred, serverctrls=..., clientctrls=...):
    """
    sasl_bind_s(dn, mechanism, cred [,serverctrls=None[,clientctrls=None]]) -> int|str
    """
    ...
  
  def compare_ext(self, dn, attr, value, serverctrls=..., clientctrls=...):
    """
    compare_ext(dn, attr, value [,serverctrls=None[,clientctrls=None]]) -> int
    compare_ext_s(dn, attr, value [,serverctrls=None[,clientctrls=None]]) -> bool
    compare(dn, attr, value) -> int
    compare_s(dn, attr, value) -> bool
        Perform an LDAP comparison between the attribute named attr of entry
        dn, and the value value. The synchronous form returns True or False.
        The asynchronous form returns the message id of the initiates request,
        and the result of the asynchronous compare can be obtained using
        result().

        Note that this latter technique yields the answer by raising
        the exception objects COMPARE_TRUE or COMPARE_FALSE.

        A design bug in the library prevents value from containing
        nul characters.
    """
    ...
  
  def compare_ext_s(self, dn, attr, value, serverctrls=..., clientctrls=...): # -> bool:
    ...
  
  def compare(self, dn, attr, value):
    ...
  
  def compare_s(self, dn, attr, value): # -> bool:
    ...
  
  def delete_ext(self, dn, serverctrls=..., clientctrls=...):
    """
    delete(dn) -> int
    delete_s(dn) -> None
    delete_ext(dn[,serverctrls=None[,clientctrls=None]]) -> int
    delete_ext_s(dn[,serverctrls=None[,clientctrls=None]]) -> tuple
        Performs an LDAP delete operation on dn. The asynchronous
        form returns the message id of the initiated request, and the
        result can be obtained from a subsequent call to result().
    """
    ...
  
  def delete_ext_s(self, dn, serverctrls=..., clientctrls=...): # -> tuple[Any | None, list[tuple[Any, Any, list[Any]]] | Any | None, Any | None, list[Any]]:
    ...
  
  def delete(self, dn):
    ...
  
  def delete_s(self, dn): # -> tuple[Any | None, list[tuple[Any, Any, list[Any]]] | Any | None, Any | None, list[Any]]:
    ...
  
  def extop(self, extreq, serverctrls=..., clientctrls=...):
    """
    extop(extreq[,serverctrls=None[,clientctrls=None]]]) -> int
    extop_s(extreq[,serverctrls=None[,clientctrls=None[,extop_resp_class=None]]]]) ->
        (respoid,respvalue)
        Performs an LDAP extended operation. The asynchronous
        form returns the message id of the initiated request, and the
        result can be obtained from a subsequent call to extop_result().
        The extreq is an instance of class ldap.extop.ExtendedRequest.

        If argument extop_resp_class is set to a sub-class of
        ldap.extop.ExtendedResponse this class is used to return an
        object of this class instead of a raw BER value in respvalue.
    """
    ...
  
  def extop_result(self, msgid=..., all=..., timeout=...): # -> tuple[Any | None, Any | None]:
    ...
  
  def extop_s(self, extreq, serverctrls=..., clientctrls=..., extop_resp_class=...): # -> tuple[Any | None, Any | None]:
    ...
  
  def modify_ext(self, dn, modlist, serverctrls=..., clientctrls=...):
    """
    modify_ext(dn, modlist[,serverctrls=None[,clientctrls=None]]) -> int
    """
    ...
  
  def modify_ext_s(self, dn, modlist, serverctrls=..., clientctrls=...): # -> tuple[Any | None, list[tuple[Any, Any, list[Any]]] | Any | None, Any | None, list[Any]]:
    ...
  
  def modify(self, dn, modlist):
    """
    modify(dn, modlist) -> int
    modify_s(dn, modlist) -> None
    modify_ext(dn, modlist[,serverctrls=None[,clientctrls=None]]) -> int
    modify_ext_s(dn, modlist[,serverctrls=None[,clientctrls=None]]) -> tuple
        Performs an LDAP modify operation on an entry's attributes.
        dn is the DN of the entry to modify, and modlist is the list
        of modifications to make to the entry.

        Each element of the list modlist should be a tuple of the form
        (mod_op,mod_type,mod_vals), where mod_op is the operation (one of
        MOD_ADD, MOD_DELETE, MOD_INCREMENT or MOD_REPLACE), mod_type is a
        string indicating the attribute type name, and mod_vals is either a
        string value or a list of string values to add, delete, increment by or
        replace respectively.  For the delete operation, mod_vals may be None
        indicating that all attributes are to be deleted.

        The asynchronous modify() returns the message id of the
        initiated request.
    """
    ...
  
  def modify_s(self, dn, modlist): # -> tuple[Any | None, list[tuple[Any, Any, list[Any]]] | Any | None, Any | None, list[Any]]:
    ...
  
  def modrdn(self, dn, newrdn, delold=...):
    """
    modrdn(dn, newrdn [,delold=1]) -> int
    modrdn_s(dn, newrdn [,delold=1]) -> None
        Perform a modify RDN operation. These routines take dn, the
        DN of the entry whose RDN is to be changed, and newrdn, the
        new RDN to give to the entry. The optional parameter delold
        is used to specify whether the old RDN should be kept as
        an attribute of the entry or not.  The asynchronous version
        returns the initiated message id.

        This operation is emulated by rename() and rename_s() methods
        since the modrdn2* routines in the C library are deprecated.
    """
    ...
  
  def modrdn_s(self, dn, newrdn, delold=...): # -> tuple[Any | None, list[tuple[Any, Any, list[Any]]] | Any | None, Any | None, list[Any]]:
    ...
  
  def passwd(self, user, oldpw, newpw, serverctrls=..., clientctrls=...):
    ...
  
  def passwd_s(self, user, oldpw, newpw, serverctrls=..., clientctrls=..., extract_newpw=...): # -> tuple[Any | None, PasswordModifyResponse | Any | None]:
    ...
  
  def rename(self, dn, newrdn, newsuperior=..., delold=..., serverctrls=..., clientctrls=...):
    """
    rename(dn, newrdn [, newsuperior=None [,delold=1][,serverctrls=None[,clientctrls=None]]]) -> int
    rename_s(dn, newrdn [, newsuperior=None] [,delold=1][,serverctrls=None[,clientctrls=None]]) -> None
        Perform a rename entry operation. These routines take dn, the
        DN of the entry whose RDN is to be changed, newrdn, the
        new RDN, and newsuperior, the new parent DN, to give to the entry.
        If newsuperior is None then only the RDN is modified.
        The optional parameter delold is used to specify whether the
        old RDN should be kept as an attribute of the entry or not.
        The asynchronous version returns the initiated message id.

        This actually corresponds to the rename* routines in the
        LDAP-EXT C API library.
    """
    ...
  
  def rename_s(self, dn, newrdn, newsuperior=..., delold=..., serverctrls=..., clientctrls=...): # -> tuple[Any | None, list[tuple[Any, Any, list[Any]]] | Any | None, Any | None, list[Any]]:
    ...
  
  def result(self, msgid=..., all=..., timeout=...): # -> tuple[Any | None, list[tuple[Any, Any, list[Any]]] | Any | None]:
    """
    result([msgid=RES_ANY [,all=1 [,timeout=None]]]) -> (result_type, result_data)

        This method is used to wait for and return the result of an
        operation previously initiated by one of the LDAP asynchronous
        operation routines (e.g. search(), modify(), etc.) They all
        returned an invocation identifier (a message id) upon successful
        initiation of their operation. This id is guaranteed to be
        unique across an LDAP session, and can be used to request the
        result of a specific operation via the msgid parameter of the
        result() method.

        If the result of a specific operation is required, msgid should
        be set to the invocation message id returned when the operation
        was initiated; otherwise RES_ANY should be supplied.

        The all parameter only has meaning for search() responses
        and is used to select whether a single entry of the search
        response should be returned, or to wait for all the results
        of the search before returning.

        A search response is made up of zero or more search entries
        followed by a search result. If all is 0, search entries will
        be returned one at a time as they come in, via separate calls
        to result(). If all is 1, the search response will be returned
        in its entirety, i.e. after all entries and the final search
        result have been received.

        For all set to 0, result tuples
        trickle in (with the same message id), and with the result type
        RES_SEARCH_ENTRY, until the final result which has a result
        type of RES_SEARCH_RESULT and a (usually) empty data field.
        When all is set to 1, only one result is returned, with a
        result type of RES_SEARCH_RESULT, and all the result tuples
        listed in the data field.

        The method returns a tuple of the form (result_type,
        result_data).  The result_type is one of the constants RES_*.

        See search() for a description of the search result's
        result_data, otherwise the result_data is normally meaningless.

        The result() method will block for timeout seconds, or
        indefinitely if timeout is negative.  A timeout of 0 will effect
        a poll. The timeout can be expressed as a floating-point value.
        If timeout is None the default in self.timeout is used.

        If a timeout occurs, a TIMEOUT exception is raised, unless
        polling (timeout = 0), in which case (None, None) is returned.
    """
    ...
  
  def result2(self, msgid=..., all=..., timeout=...): # -> tuple[Any | None, list[tuple[Any, Any, list[Any]]] | Any | None, Any | None]:
    ...
  
  def result3(self, msgid=..., all=..., timeout=..., resp_ctrl_classes=...): # -> tuple[Any | None, list[tuple[Any, Any, list[Any]]] | Any | None, Any | None, list[Any]]:
    ...
  
  def result4(self, msgid=..., all=..., timeout=..., add_ctrls=..., add_intermediates=..., add_extop=..., resp_ctrl_classes=...): # -> tuple[Any | None, list[tuple[Any, Any, list[Any]]] | Any | None, Any | None, list[Any], Any | None, Any | None]:
    ...
  
  def search_ext(self, base, scope, filterstr=..., attrlist=..., attrsonly=..., serverctrls=..., clientctrls=..., timeout=..., sizelimit=...):
    """
    search(base, scope [,filterstr='(objectClass=*)' [,attrlist=None [,attrsonly=0]]]) -> int
    search_s(base, scope [,filterstr='(objectClass=*)' [,attrlist=None [,attrsonly=0]]])
    search_st(base, scope [,filterstr='(objectClass=*)' [,attrlist=None [,attrsonly=0 [,timeout=-1]]]])
    search_ext(base,scope,[,filterstr='(objectClass=*)' [,attrlist=None [,attrsonly=0 [,serverctrls=None [,clientctrls=None [,timeout=-1 [,sizelimit=0]]]]]]])
    search_ext_s(base,scope,[,filterstr='(objectClass=*)' [,attrlist=None [,attrsonly=0 [,serverctrls=None [,clientctrls=None [,timeout=-1 [,sizelimit=0]]]]]]])

        Perform an LDAP search operation, with base as the DN of
        the entry at which to start the search, scope being one of
        SCOPE_BASE (to search the object itself), SCOPE_ONELEVEL
        (to search the object's immediate children), or SCOPE_SUBTREE
        (to search the object and all its descendants).

        filter is a string representation of the filter to
        apply in the search (see RFC 4515).

        Each result tuple is of the form (dn,entry), where dn is a
        string containing the DN (distinguished name) of the entry, and
        entry is a dictionary containing the attributes.
        Attributes types are used as string dictionary keys and attribute
        values are stored in a list as dictionary value.

        The DN in dn is extracted using the underlying ldap_get_dn(),
        which may raise an exception of the DN is malformed.

        If attrsonly is non-zero, the values of attrs will be
        meaningless (they are not transmitted in the result).

        The retrieved attributes can be limited with the attrlist
        parameter.  If attrlist is None, all the attributes of each
        entry are returned.

        serverctrls=None

        clientctrls=None

        The synchronous form with timeout, search_st() or search_ext_s(),
        will block for at most timeout seconds (or indefinitely if
        timeout is negative). A TIMEOUT exception is raised if no result is
        received within the time.

        The amount of search results retrieved can be limited with the
        sizelimit parameter if non-zero.
    """
    ...
  
  def search_ext_s(self, base, scope, filterstr=..., attrlist=..., attrsonly=..., serverctrls=..., clientctrls=..., timeout=..., sizelimit=...): # -> list[tuple[Any, Any, list[Any]]] | None:
    ...
  
  def search(self, base, scope, filterstr=..., attrlist=..., attrsonly=...):
    ...
  
  def search_s(self, base, scope, filterstr=..., attrlist=..., attrsonly=...): # -> list[tuple[Any, Any, list[Any]]] | None:
    ...
  
  def search_st(self, base, scope, filterstr=..., attrlist=..., attrsonly=..., timeout=...): # -> list[tuple[Any, Any, list[Any]]] | None:
    ...
  
  def start_tls_s(self):
    """
    start_tls_s() -> None
    Negotiate TLS with server. The `version' attribute must have been
    set to VERSION3 before calling start_tls_s.
    If TLS could not be started an exception will be raised.
    """
    ...
  
  def unbind_ext(self, serverctrls=..., clientctrls=...):
    """
    unbind() -> int
    unbind_s() -> None
    unbind_ext() -> int
    unbind_ext_s() -> None
        This call is used to unbind from the directory, terminate
        the current association, and free resources. Once called, the
        connection to the LDAP server is closed and the LDAP object
        is invalid. Further invocation of methods on the object will
        yield an exception.

        The unbind and unbind_s methods are identical, and are
        synchronous in nature
    """
    ...
  
  def unbind_ext_s(self, serverctrls=..., clientctrls=...): # -> tuple[Any | None, list[tuple[Any, Any, list[Any]]] | Any | None, Any | None, list[Any]] | None:
    ...
  
  def unbind(self):
    ...
  
  def unbind_s(self): # -> tuple[Any | None, list[tuple[Any, Any, list[Any]]] | Any | None, Any | None, list[Any]] | None:
    ...
  
  def whoami_s(self, serverctrls=..., clientctrls=...):
    ...
  
  def get_option(self, option): # -> list[Any]:
    ...
  
  def set_option(self, option, invalue):
    ...
  
  def search_subschemasubentry_s(self, dn=...): # -> None:
    """
    Returns the distinguished name of the sub schema sub entry
    for a part of a DIT specified by dn.

    None as result indicates that the DN of the sub schema sub entry could
    not be determined.

    Returns: None or text/bytes depending on bytes_mode.
    """
    ...
  
  def read_s(self, dn, filterstr=..., attrlist=..., serverctrls=..., clientctrls=..., timeout=...): # -> None:
    """
    Reads and returns a single entry specified by `dn'.

    Other attributes just like those passed to `search_ext_s()'
    """
    ...
  
  def read_subschemasubentry_s(self, subschemasubentry_dn, attrs=...): # -> None:
    """
    Returns the sub schema sub entry's data
    """
    ...
  
  def find_unique_entry(self, base, scope=..., filterstr=..., attrlist=..., attrsonly=..., serverctrls=..., clientctrls=..., timeout=...): # -> tuple[Any, Any, list[Any]]:
    """
    Returns a unique entry, raises exception if not unique
    """
    ...
  
  def read_rootdse_s(self, filterstr=..., attrlist=...): # -> None:
    """
    convenience wrapper around read_s() for reading rootDSE
    """
    ...
  
  def get_naming_contexts(self):
    """
    returns all attribute values of namingContexts in rootDSE
    if namingContexts is not present (not readable) then empty list is returned
    """
    ...
  


class ReconnectLDAPObject(SimpleLDAPObject):
  """
  :py:class:`SimpleLDAPObject` subclass whose synchronous request methods
  automatically reconnect and re-try in case of server failure
  (:exc:`ldap.SERVER_DOWN`).

  The first arguments are same as for the :py:func:`~ldap.initialize()`
  function.
  For automatic reconnects it has additional arguments:

  * retry_max: specifies the number of reconnect attempts before
    re-raising the :py:exc:`ldap.SERVER_DOWN` exception.

  * retry_delay: specifies the time in seconds between reconnect attempts.

  This class also implements the pickle protocol.
  """
  __transient_attrs__ = ...
  def __init__(self, uri, trace_level=..., trace_file=..., trace_stack_limit=..., bytes_mode=..., bytes_strictness=..., retry_max=..., retry_delay=..., fileno=...) -> None:
    """
    Parameters like SimpleLDAPObject.__init__() with these
    additional arguments:

    retry_max
        Maximum count of reconnect trials
    retry_delay
        Time span to wait between two reconnect trials
    """
    ...
  
  def __getstate__(self): # -> dict[str, Any]:
    """return data representation for pickled object"""
    ...
  
  def __setstate__(self, d): # -> None:
    """set up the object from pickled data"""
    ...
  
  def passwd_s(self, *args, **kwargs): # -> tuple[Any | None, PasswordModifyResponse | Any | None]:
    ...
  
  def reconnect(self, uri, retry_max=..., retry_delay=..., force=...): # -> None:
    ...
  
  def set_option(self, option, invalue):
    ...
  
  def bind_s(self, *args, **kwargs): # -> tuple[Any | None, list[tuple[Any, Any, list[Any]]] | Any | None]:
    ...
  
  def simple_bind_s(self, *args, **kwargs): # -> tuple[Any | None, list[tuple[Any, Any, list[Any]]] | Any | None, Any | None, list[Any]]:
    ...
  
  def start_tls_s(self, *args, **kwargs):
    ...
  
  def sasl_interactive_bind_s(self, *args, **kwargs):
    """
    sasl_interactive_bind_s(who, auth) -> None
    """
    ...
  
  def sasl_bind_s(self, *args, **kwargs):
    ...
  
  def add_ext_s(self, *args, **kwargs): # -> tuple[Any | None, list[tuple[Any, Any, list[Any]]] | Any | None, Any | None, list[Any]]:
    ...
  
  def cancel_s(self, *args, **kwargs): # -> tuple[Any | None, list[tuple[Any, Any, list[Any]]] | Any | None] | None:
    ...
  
  def compare_ext_s(self, *args, **kwargs): # -> bool:
    ...
  
  def delete_ext_s(self, *args, **kwargs): # -> tuple[Any | None, list[tuple[Any, Any, list[Any]]] | Any | None, Any | None, list[Any]]:
    ...
  
  def extop_s(self, *args, **kwargs): # -> tuple[Any | None, Any | None]:
    ...
  
  def modify_ext_s(self, *args, **kwargs): # -> tuple[Any | None, list[tuple[Any, Any, list[Any]]] | Any | None, Any | None, list[Any]]:
    ...
  
  def rename_s(self, *args, **kwargs): # -> tuple[Any | None, list[tuple[Any, Any, list[Any]]] | Any | None, Any | None, list[Any]]:
    ...
  
  def search_ext_s(self, *args, **kwargs): # -> list[tuple[Any, Any, list[Any]]] | None:
    ...
  
  def whoami_s(self, *args, **kwargs):
    ...
  


LDAPObject = SimpleLDAPObject
