/*
	shader outlining selected objects
*/
#version 330

uniform sampler2D idents;
uniform vec4 selected_color;
uniform vec2 interval;
uniform float width;
in vec2 position;
out vec4 color;

const int kernel_size = 4;
const vec2 kernel[kernel_size] = {
    vec2(-1,0), vec2(+1,0),
    vec2(0,-1), vec2(+1,0),
};

void main() {
	float middle = texture(idents, position).r;
//     min(1, abs(dFdx(ident) + dFdy(ident)))
    bool border = false;
    bool inside = interval.x <= middle & middle <= interval.y;
    for (int i=0; i<kernel_size; i++) {
        aside = texture(idents, position+kernel[i]*width).r;
        border |= aside != middle;
        inside |= interval.x <= aside & aside <= interval.y;
    }
    float intensity = (inside * border);
    
	color = vec4(selected_color, 1) * intensity;
}
