/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.demos.autoanalysis;

import infodynamics.demos.autoanalysis.AutoAnalyser;
import infodynamics.measures.continuous.ConditionalMutualInfoCalculatorMultiVariate;
import infodynamics.measures.continuous.InfoMeasureCalculatorContinuous;
import infodynamics.measures.continuous.gaussian.ConditionalMutualInfoCalculatorMultiVariateGaussian;
import infodynamics.measures.continuous.kraskov.ConditionalMutualInfoCalculatorMultiVariateKraskov1;
import infodynamics.measures.continuous.kraskov.ConditionalMutualInfoCalculatorMultiVariateKraskov2;
import infodynamics.measures.discrete.ConditionalMutualInformationCalculatorDiscrete;
import infodynamics.measures.discrete.InfoMeasureCalculatorDiscrete;
import infodynamics.utils.MatrixUtils;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentListener;

public class AutoAnalyserCMI
extends AutoAnalyser
implements ActionListener,
DocumentListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    protected String[] gaussianProperties;
    protected String[] gaussianPropertiesFieldNames;
    protected String[] gaussianPropertyDescriptions;
    protected String[] kraskovProperties;
    protected String[] kraskovPropertiesFieldNames;
    protected String[] kraskovPropertyDescriptions;
    protected static final String CALC_TYPE_KRASKOV_ALG1 = "Kraskov (KSG) alg. 1";
    protected static final String CALC_TYPE_KRASKOV_ALG2 = "Kraskov (KSG) alg. 2";

    public AutoAnalyserCMI() {
    }

    public AutoAnalyserCMI(String string) {
        super(string);
    }

    @Override
    protected void makeSpecificInitialisations() {
        this.numVariables = 3;
        this.variableColNumLabels = new String[]{"Source", "Destination", "Conditional"};
        this.useAllCombosCheckBox = true;
        this.useStatSigCheckBox = true;
        this.wordForCombinations = "pairs";
        this.variableRelationshipFormatString = "col_%d -> col_%d | col_%d";
        this.disableVariableColTextFieldsForAllCombos = new boolean[]{true, true, false};
        this.indentsForAllCombos = 2;
        this.measureAcronym = "CMI";
        this.appletTitle = "JIDT Conditional MI Auto-Analyser";
        this.calcTypes = new String[]{"Discrete", "Binned", "Gaussian", CALC_TYPE_KRASKOV_ALG1, CALC_TYPE_KRASKOV_ALG2};
        this.unitsForEachCalc = new String[]{"bits", "bits", "nats", "nats", "nats"};
        this.discreteClass = ConditionalMutualInformationCalculatorDiscrete.class;
        this.discreteProperties = new String[]{"base"};
        this.discretePropertyDefaultValues = new String[]{"2"};
        this.discretePropertyDescriptions = new String[]{"Number of discrete states available for each variable (i.e. 2 for binary).<br/>Can be set individually for each variable -- see code."};
        this.abstractContinuousClass = ConditionalMutualInfoCalculatorMultiVariate.class;
        this.commonContPropertyNames = new String[0];
        this.commonContPropertiesFieldNames = new String[0];
        this.commonContPropertyDescriptions = new String[0];
        this.gaussianProperties = new String[0];
        this.gaussianPropertiesFieldNames = new String[0];
        this.gaussianPropertyDescriptions = new String[0];
        this.kraskovProperties = new String[]{"NORMALISE", "k", "NOISE_LEVEL_TO_ADD", "DYN_CORR_EXCL", "NORM_TYPE", "NUM_THREADS"};
        this.kraskovPropertiesFieldNames = new String[]{"ConditionalMutualInfoMultiVariateCommon.PROP_NORMALISE", "ConditionalMutualInfoCalculatorMultiVariateKraskov.PROP_K", "ConditionalMutualInfoCalculatorMultiVariateKraskov.PROP_ADD_NOISE", "ConditionalMutualInfoCalculatorMultiVariateKraskov.PROP_DYN_CORR_EXCL_TIME", "ConditionalMutualInfoCalculatorMultiVariateKraskov.PROP_NORM_TYPE", "ConditionalMutualInfoCalculatorMultiVariateKraskov.PROP_NUM_THREADS"};
        this.kraskovPropertyDescriptions = new String[]{"(boolean) whether to normalise <br/>each incoming time-series to mean 0, standard deviation 1, or not (recommended)", "Number of k nearest neighbours to use <br/>in the full joint kernel space in the KSG algorithm", "Standard deviation for an amount <br/>of random Gaussian noise to add to each variable, to avoid having neighbourhoods with artificially large counts. <br/>(\"false\" may be used to indicate \"0\".). The amount is added in after any normalisation.", "Dynamic correlation exclusion time or <br/>Theiler window (see Kantz and Schreiber); 0 (default) means no dynamic exclusion window", "<br/>Norm type to use in KSG algorithm between the points in each marginal space. <br/>Options are: \"MAX_NORM\" (default), otherwise \"EUCLIDEAN\" or \"EUCLIDEAN_SQUARED\" (both equivalent here)", "Number of parallel threads to use <br/>in computation: an integer > 0 or \"USE_ALL\" (default, to indicate to use all available processors)"};
    }

    @Override
    protected void fillOutAllCombinations(Vector<int[]> vector) throws Exception {
        int n = Integer.parseInt(this.variableColTextFields[2].getText());
        if (n >= this.dataColumns) {
            throw new Exception(String.format("%s column must be between 0 and %d for this data set", this.variableColNumLabels[2], this.dataColumns - 1));
        }
        for (int i = 0; i < this.dataColumns; ++i) {
            int n2 = 0;
            while (n2 < this.dataColumns) {
                vector.add(new int[]{i, n2++, n});
            }
        }
    }

    @Override
    protected String[] setUpLoopsForAllCombos(StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3) {
        int n = Integer.parseInt(this.variableColTextFields[2].getText());
        stringBuffer.append("    \n");
        stringBuffer.append("    int c = " + n + ";\n");
        stringBuffer.append("    // Compute for all source-destination pairs:\n");
        stringBuffer.append("    for (int s = 0; s < " + this.dataColumns + "; s++) {\n");
        stringBuffer.append("        for (int d = 0; d < " + this.dataColumns + "; d++) {\n");
        String string = "            ";
        stringBuffer.append(string + "// For each source-dest pair (given conditional):\n");
        stringBuffer.append(string + "if ((s == d) || (s == c) || (d == c)) {\n");
        stringBuffer.append(string + "    continue;\n");
        stringBuffer.append(string + "}\n");
        stringBuffer2.append("\n");
        stringBuffer2.append("c = " + n + "\n");
        stringBuffer2.append("# Compute for all pairs:\n");
        stringBuffer2.append("for s in range(" + this.dataColumns + "):\n");
        stringBuffer2.append("    for d in range(" + this.dataColumns + "):\n");
        String string2 = "        ";
        stringBuffer2.append(string2 + "# For each source-dest pair (given conditional):\n");
        stringBuffer2.append(string2 + "if ((s == d) or (s == c) or (d == c)):\n");
        stringBuffer2.append(string2 + "    continue\n");
        stringBuffer3.append("\n");
        stringBuffer3.append("c = " + (n + 1) + ";\n");
        stringBuffer3.append("% Compute for all pairs:\n");
        stringBuffer3.append("for s = 1:" + this.dataColumns + "\n");
        stringBuffer3.append("\tfor d = 1:" + this.dataColumns + "\n");
        String string3 = "\t\t";
        stringBuffer3.append(string3 + "% For each source-dest pair (given conditional):\n");
        stringBuffer3.append(string3 + "if ((s == d) || (s == c) || (d == c))\n");
        stringBuffer3.append(string3 + "\tcontinue;\n");
        stringBuffer3.append(string3 + "end\n");
        return new String[]{"s", "d", "c"};
    }

    @Override
    protected void finaliseLoopsForAllCombos(StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3) {
        stringBuffer.append("        }\n");
        stringBuffer.append("    }\n");
        stringBuffer3.append("\tend\n");
        stringBuffer3.append("end\n");
    }

    @Override
    protected String formatStringWithColumnNumbers(String string, int[] nArray) {
        return String.format(string, nArray[0], nArray[1], nArray[2]);
    }

    @Override
    protected boolean skipColumnCombo(int[] nArray) {
        return nArray[0] == nArray[1] || nArray[0] == nArray[2] || nArray[1] == nArray[2];
    }

    @Override
    protected void setObservations(InfoMeasureCalculatorDiscrete infoMeasureCalculatorDiscrete, InfoMeasureCalculatorContinuous infoMeasureCalculatorContinuous, int[] nArray) throws Exception {
        String string = (String)this.calcTypeComboBox.getSelectedItem();
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        if (string.equalsIgnoreCase("Discrete")) {
            ConditionalMutualInformationCalculatorDiscrete conditionalMutualInformationCalculatorDiscrete = (ConditionalMutualInformationCalculatorDiscrete)infoMeasureCalculatorDiscrete;
            conditionalMutualInformationCalculatorDiscrete.addObservations(MatrixUtils.selectColumn(this.dataDiscrete, n), MatrixUtils.selectColumn(this.dataDiscrete, n2), MatrixUtils.selectColumn(this.dataDiscrete, n3));
        } else if (string.equalsIgnoreCase("Binned")) {
            ConditionalMutualInformationCalculatorDiscrete conditionalMutualInformationCalculatorDiscrete = (ConditionalMutualInformationCalculatorDiscrete)infoMeasureCalculatorDiscrete;
            conditionalMutualInformationCalculatorDiscrete.addObservations(MatrixUtils.discretise(MatrixUtils.selectColumn(this.data, n), Integer.parseInt((String)this.propertyValues.get("base"))), MatrixUtils.discretise(MatrixUtils.selectColumn(this.data, n2), Integer.parseInt((String)this.propertyValues.get("base"))), MatrixUtils.discretise(MatrixUtils.selectColumn(this.data, n3), Integer.parseInt((String)this.propertyValues.get("base"))));
        } else {
            ConditionalMutualInfoCalculatorMultiVariate conditionalMutualInfoCalculatorMultiVariate = (ConditionalMutualInfoCalculatorMultiVariate)infoMeasureCalculatorContinuous;
            conditionalMutualInfoCalculatorMultiVariate.setObservations(MatrixUtils.selectColumn(this.data, n), MatrixUtils.selectColumn(this.data, n2), MatrixUtils.selectColumn(this.data, n3));
        }
    }

    @Override
    protected AutoAnalyser.CalcProperties assignCalcProperties(String string) throws Exception {
        AutoAnalyser.CalcProperties calcProperties = super.assignCalcProperties(string);
        if (calcProperties == null) {
            calcProperties = new AutoAnalyser.CalcProperties();
            calcProperties.calc = this.assignCalcObjectContinuous(string);
            calcProperties.calcClass = calcProperties.calc.getClass();
            if (string.equalsIgnoreCase("Gaussian")) {
                calcProperties.classSpecificPropertyNames = this.gaussianProperties;
                calcProperties.classSpecificPropertiesFieldNames = this.gaussianPropertiesFieldNames;
                calcProperties.classSpecificPropertyDescriptions = this.gaussianPropertyDescriptions;
            } else if (string.startsWith("Kraskov (KSG)")) {
                calcProperties.classSpecificPropertyNames = this.kraskovProperties;
                calcProperties.classSpecificPropertiesFieldNames = this.kraskovPropertiesFieldNames;
                calcProperties.classSpecificPropertyDescriptions = this.kraskovPropertyDescriptions;
            } else {
                calcProperties = null;
                throw new Exception("No recognised calculator selected: " + string);
            }
        }
        return calcProperties;
    }

    @Override
    protected ConditionalMutualInfoCalculatorMultiVariate assignCalcObjectContinuous(String string) throws Exception {
        if (string.equalsIgnoreCase("Gaussian")) {
            return new ConditionalMutualInfoCalculatorMultiVariateGaussian();
        }
        if (string.equalsIgnoreCase(CALC_TYPE_KRASKOV_ALG1)) {
            return new ConditionalMutualInfoCalculatorMultiVariateKraskov1();
        }
        if (string.equalsIgnoreCase(CALC_TYPE_KRASKOV_ALG2)) {
            return new ConditionalMutualInfoCalculatorMultiVariateKraskov2();
        }
        throw new Exception("No recognised continuous calculator selected: " + string);
    }

    @Override
    protected AutoAnalyser.DiscreteCalcAndArguments assignCalcObjectDiscrete() throws Exception {
        int n;
        try {
            String string = (String)this.propertyValues.get("base");
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage());
            this.resultsLabel.setText("Cannot find a value for property base");
            return null;
        }
        return new AutoAnalyser.DiscreteCalcAndArguments(new ConditionalMutualInformationCalculatorDiscrete(n, n, n), n, n + ", " + n + ", " + n);
    }

    public static void main(String[] stringArray) {
        new AutoAnalyserCMI();
    }
}

