/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.demos.autoanalysis;

import infodynamics.demos.autoanalysis.AutoAnalyser;
import infodynamics.measures.continuous.EntropyCalculator;
import infodynamics.measures.continuous.InfoMeasureCalculatorContinuous;
import infodynamics.measures.continuous.gaussian.EntropyCalculatorGaussian;
import infodynamics.measures.continuous.kernel.EntropyCalculatorKernel;
import infodynamics.measures.continuous.kozachenko.EntropyCalculatorMultiVariateKozachenko;
import infodynamics.measures.discrete.EntropyCalculatorDiscrete;
import infodynamics.measures.discrete.InfoMeasureCalculatorDiscrete;
import infodynamics.measures.discrete.MutualInformationCalculatorDiscrete;
import infodynamics.utils.MatrixUtils;
import java.util.Vector;
import javax.swing.JOptionPane;

public class AutoAnalyserEntropy
extends AutoAnalyser {
    private static final long serialVersionUID = 1L;
    protected String[] gaussianProperties;
    protected String[] gaussianPropertiesFieldNames;
    protected String[] gaussianPropertyDescriptions;
    protected String[] kernelProperties;
    protected String[] kernelPropertiesFieldNames;
    protected String[] kernelPropertyDescriptions;
    protected String[] klProperties;
    protected String[] klPropertiesFieldNames;
    protected String[] klPropertyDescriptions;

    public AutoAnalyserEntropy() {
    }

    public AutoAnalyserEntropy(String string) {
        super(string);
    }

    @Override
    protected void makeSpecificInitialisations() {
        this.numVariables = 1;
        this.variableColNumLabels = new String[]{"Variable"};
        this.useAllCombosCheckBox = true;
        this.useStatSigCheckBox = false;
        this.wordForCombinations = "variables";
        this.variableRelationshipFormatString = "col_%d";
        this.disableVariableColTextFieldsForAllCombos = new boolean[]{true};
        this.indentsForAllCombos = 1;
        this.measureAcronym = "H";
        this.appletTitle = "JIDT Entropy Auto-Analyser";
        this.calcTypes = new String[]{"Discrete", "Binned", "Gaussian", "Kozachenko-Leonenko", "Kernel"};
        this.unitsForEachCalc = new String[]{"bits", "bits", "nats", "nats", "bits"};
        this.discreteClass = MutualInformationCalculatorDiscrete.class;
        this.discreteProperties = new String[]{"base"};
        this.discretePropertyDefaultValues = new String[]{"2"};
        this.discretePropertyDescriptions = new String[]{"Number of discrete states available for each variable (i.e. 2 for binary)"};
        this.abstractContinuousClass = EntropyCalculator.class;
        this.commonContPropertyNames = new String[0];
        this.commonContPropertiesFieldNames = new String[0];
        this.commonContPropertyDescriptions = new String[0];
        this.gaussianProperties = new String[0];
        this.gaussianPropertiesFieldNames = new String[0];
        this.gaussianPropertyDescriptions = new String[0];
        this.kernelProperties = new String[]{"KERNEL_WIDTH", "NORMALISE"};
        this.kernelPropertiesFieldNames = new String[]{"KERNEL_WIDTH_PROP_NAME", "NORMALISE_PROP_NAME"};
        this.kernelPropertyDescriptions = new String[]{"Kernel width to be used in the calculation. <br/>If the property NORMALISE is set, then this is a number of standard deviations; otherwise it is an absolute value.", "(boolean) whether to normalise <br/>the incoming time-series to mean 0, standard deviation 1, or not  (recommended)"};
        this.klProperties = new String[0];
        this.klPropertiesFieldNames = new String[0];
        this.klPropertyDescriptions = new String[0];
    }

    @Override
    protected void fillOutAllCombinations(Vector<int[]> vector) {
        int n = 0;
        while (n < this.dataColumns) {
            vector.add(new int[]{n++});
        }
    }

    @Override
    protected String[] setUpLoopsForAllCombos(StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3) {
        stringBuffer.append("    \n");
        stringBuffer.append("    // Compute for all variables:\n");
        stringBuffer.append("    for (int v = 0; v < " + this.dataColumns + "; v++) {\n");
        String string = "        ";
        stringBuffer.append(string + "// For each variable:\n");
        stringBuffer2.append("\n");
        stringBuffer2.append("# Compute for all variables:\n");
        stringBuffer2.append("for v in range(" + this.dataColumns + "):\n");
        String string2 = "    ";
        stringBuffer2.append(string2 + "# For each variable:\n");
        stringBuffer3.append("\n");
        stringBuffer3.append("% Compute for all variables:\n");
        stringBuffer3.append("for v = 1:" + this.dataColumns + "\n");
        String string3 = "\t";
        stringBuffer3.append(string3 + "% For each variable:\n");
        return new String[]{"v"};
    }

    @Override
    protected void finaliseLoopsForAllCombos(StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3) {
        stringBuffer.append("    }\n");
        stringBuffer3.append("end\n");
    }

    @Override
    protected String formatStringWithColumnNumbers(String string, int[] nArray) {
        return String.format(string, nArray[0]);
    }

    @Override
    protected boolean skipColumnCombo(int[] nArray) {
        return false;
    }

    @Override
    protected void setObservations(InfoMeasureCalculatorDiscrete infoMeasureCalculatorDiscrete, InfoMeasureCalculatorContinuous infoMeasureCalculatorContinuous, int[] nArray) throws Exception {
        String string = (String)this.calcTypeComboBox.getSelectedItem();
        int n = nArray[0];
        if (string.equalsIgnoreCase("Discrete")) {
            EntropyCalculatorDiscrete entropyCalculatorDiscrete = (EntropyCalculatorDiscrete)infoMeasureCalculatorDiscrete;
            entropyCalculatorDiscrete.addObservations(MatrixUtils.selectColumn(this.dataDiscrete, n));
        } else if (string.equalsIgnoreCase("Binned")) {
            EntropyCalculatorDiscrete entropyCalculatorDiscrete = (EntropyCalculatorDiscrete)infoMeasureCalculatorDiscrete;
            entropyCalculatorDiscrete.addObservations(MatrixUtils.discretise(MatrixUtils.selectColumn(this.data, n), Integer.parseInt((String)this.propertyValues.get("base"))));
        } else {
            EntropyCalculator entropyCalculator = (EntropyCalculator)infoMeasureCalculatorContinuous;
            entropyCalculator.setObservations(MatrixUtils.selectColumn(this.data, n));
        }
    }

    @Override
    protected AutoAnalyser.CalcProperties assignCalcProperties(String string) throws Exception {
        AutoAnalyser.CalcProperties calcProperties = super.assignCalcProperties(string);
        if (calcProperties == null) {
            calcProperties = new AutoAnalyser.CalcProperties();
            calcProperties.calc = this.assignCalcObjectContinuous(string);
            calcProperties.calcClass = calcProperties.calc.getClass();
            if (string.equalsIgnoreCase("Gaussian")) {
                calcProperties.classSpecificPropertyNames = this.gaussianProperties;
                calcProperties.classSpecificPropertiesFieldNames = this.gaussianPropertiesFieldNames;
                calcProperties.classSpecificPropertyDescriptions = this.gaussianPropertyDescriptions;
            } else if (string.equalsIgnoreCase("Kozachenko-Leonenko")) {
                calcProperties.classSpecificPropertyNames = this.klProperties;
                calcProperties.classSpecificPropertiesFieldNames = this.klPropertiesFieldNames;
                calcProperties.classSpecificPropertyDescriptions = this.klPropertyDescriptions;
            } else if (string.equalsIgnoreCase("Kernel")) {
                calcProperties.classSpecificPropertyNames = this.kernelProperties;
                calcProperties.classSpecificPropertiesFieldNames = this.kernelPropertiesFieldNames;
                calcProperties.classSpecificPropertyDescriptions = this.kernelPropertyDescriptions;
            } else {
                calcProperties = null;
                throw new Exception("No recognised calculator selected: " + string);
            }
        }
        return calcProperties;
    }

    @Override
    protected EntropyCalculator assignCalcObjectContinuous(String string) throws Exception {
        if (string.equalsIgnoreCase("Gaussian")) {
            return new EntropyCalculatorGaussian();
        }
        if (string.equalsIgnoreCase("Kozachenko-Leonenko")) {
            return new EntropyCalculatorMultiVariateKozachenko();
        }
        if (string.equalsIgnoreCase("Kernel")) {
            return new EntropyCalculatorKernel();
        }
        throw new Exception("No recognised continuous calculator selected: " + string);
    }

    @Override
    protected AutoAnalyser.DiscreteCalcAndArguments assignCalcObjectDiscrete() throws Exception {
        int n;
        String string;
        try {
            string = (String)this.propertyValues.get("base");
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage());
            this.resultsLabel.setText("Cannot find a value for property base");
            return null;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, "Cannot parse number for property base: " + numberFormatException.getMessage());
            this.resultsLabel.setText("Cannot parse number for property base: " + numberFormatException.getMessage());
            return null;
        }
        return new AutoAnalyser.DiscreteCalcAndArguments(new EntropyCalculatorDiscrete(n), n, Integer.toString(n));
    }

    public static void main(String[] stringArray) {
        new AutoAnalyserEntropy();
    }
}

