/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.demos.autoanalysis;

import infodynamics.demos.autoanalysis.AutoAnalyser;
import infodynamics.demos.autoanalysis.AutoAnalyserChannelCalculator;
import infodynamics.measures.continuous.MutualInfoCalculatorMultiVariate;
import infodynamics.measures.continuous.gaussian.MutualInfoCalculatorMultiVariateGaussian;
import infodynamics.measures.continuous.kernel.MutualInfoCalculatorMultiVariateKernel;
import infodynamics.measures.continuous.kraskov.MutualInfoCalculatorMultiVariateKraskov1;
import infodynamics.measures.continuous.kraskov.MutualInfoCalculatorMultiVariateKraskov2;
import infodynamics.measures.discrete.MutualInformationCalculatorDiscrete;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentListener;

public class AutoAnalyserMI
extends AutoAnalyserChannelCalculator
implements ActionListener,
DocumentListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    protected static final String DISCRETE_PROPNAME_TIME_DIFF = "time difference";
    protected static final String CALC_TYPE_KRASKOV_ALG1 = "Kraskov (KSG) alg. 1";
    protected static final String CALC_TYPE_KRASKOV_ALG2 = "Kraskov (KSG) alg. 2";

    public AutoAnalyserMI() {
    }

    public AutoAnalyserMI(String string) {
        super(string);
    }

    @Override
    protected void makeSpecificInitialisations() {
        super.makeSpecificInitialisations();
        this.measureAcronym = "MI";
        this.appletTitle = "JIDT Mutual Information Auto-Analyser";
        this.calcTypes = new String[]{"Discrete", "Binned", "Gaussian", CALC_TYPE_KRASKOV_ALG1, CALC_TYPE_KRASKOV_ALG2, "Kernel"};
        this.unitsForEachCalc = new String[]{"bits", "bits", "nats", "nats", "nats", "bits"};
        this.discreteClass = MutualInformationCalculatorDiscrete.class;
        this.discreteProperties = new String[]{"base", DISCRETE_PROPNAME_TIME_DIFF};
        this.discretePropertyDefaultValues = new String[]{"2", "0"};
        this.discretePropertyDescriptions = new String[]{"Number of discrete states available for each variable (i.e. 2 for binary)", "Time-lag from source to dest to consider MI across; must be >= 0 (0 for standard MI)"};
        this.abstractContinuousClass = MutualInfoCalculatorMultiVariate.class;
        this.commonContPropertyNames = new String[]{"TIME_DIFF"};
        this.commonContPropertiesFieldNames = new String[]{"PROP_TIME_DIFF"};
        this.commonContPropertyDescriptions = new String[]{"Time-lag from source to dest to consider MI across; must be >= 0 (0 for standard MI)"};
        this.gaussianProperties = new String[0];
        this.gaussianPropertiesFieldNames = new String[0];
        this.gaussianPropertyDescriptions = new String[0];
        this.kernelProperties = new String[]{"KERNEL_WIDTH", "DYN_CORR_EXCL", "NORMALISE"};
        this.kernelPropertiesFieldNames = new String[]{"KERNEL_WIDTH_PROP_NAME", "DYN_CORR_EXCL_TIME_NAME", "NORMALISE_PROP_NAME"};
        this.kernelPropertyDescriptions = new String[]{"Kernel width to be used in the calculation. <br/>If the property NORMALISE is set, then this is a number of standard deviations; otherwise it is an absolute value.", "Dynamic correlation exclusion time or <br/>Theiler window (see Kantz and Schreiber); 0 (default) means no dynamic exclusion window", "(boolean) whether to normalise <br/>each incoming time-series to mean 0, standard deviation 1, or not  (recommended)"};
        this.kraskovProperties = new String[]{"NORMALISE", "k", "NOISE_LEVEL_TO_ADD", "DYN_CORR_EXCL", "NORM_TYPE", "NUM_THREADS", "USE_GPU"};
        this.kraskovPropertiesFieldNames = new String[]{"MutualInfoCalculatorMultiVariateKraskov.PROP_NORMALISE", "MutualInfoCalculatorMultiVariateKraskov.PROP_K", "MutualInfoCalculatorMultiVariateKraskov.PROP_ADD_NOISE", "MutualInfoCalculatorMultiVariateKraskov.PROP_DYN_CORR_EXCL_TIME", "MutualInfoCalculatorMultiVariateKraskov.PROP_NORM_TYPE", "MutualInfoCalculatorMultiVariateKraskov.PROP_NUM_THREADS", "MutualInfoCalculatorMultiVariateKraskov.PROP_USE_GPU"};
        this.kraskovPropertyDescriptions = new String[]{"(boolean) whether to normalise <br/>each incoming time-series to mean 0, standard deviation 1, or not (recommended)", "Number of k nearest neighbours to use <br/>in the full joint kernel space in the KSG algorithm", "Standard deviation for an amount <br/>of random Gaussian noise to add to each variable, to avoid having neighbourhoods with artificially large counts. <br/>(\"false\" may be used to indicate \"0\".). The amount is added in after any normalisation.", "Dynamic correlation exclusion time or <br/>Theiler window (see Kantz and Schreiber); 0 (default) means no dynamic exclusion window", "<br/>Norm type to use in KSG algorithm between the points in each marginal space. <br/>Options are: \"MAX_NORM\" (default), otherwise \"EUCLIDEAN\" or \"EUCLIDEAN_SQUARED\" (both equivalent here)", "Number of parallel threads to use <br/>in computation: an integer > 0 or \"USE_ALL\" (default, to indicate to use all available processors)", "Whether to enable the GPU module (number of threads then has no bearing); boolean, default false"};
    }

    @Override
    protected MutualInfoCalculatorMultiVariate assignCalcObjectContinuous(String string) throws Exception {
        if (string.equalsIgnoreCase("Gaussian")) {
            return new MutualInfoCalculatorMultiVariateGaussian();
        }
        if (string.equalsIgnoreCase(CALC_TYPE_KRASKOV_ALG1)) {
            return new MutualInfoCalculatorMultiVariateKraskov1();
        }
        if (string.equalsIgnoreCase(CALC_TYPE_KRASKOV_ALG2)) {
            return new MutualInfoCalculatorMultiVariateKraskov2();
        }
        if (string.equalsIgnoreCase("Kernel")) {
            return new MutualInfoCalculatorMultiVariateKernel();
        }
        throw new Exception("No recognised continuous calculator selected: " + string);
    }

    @Override
    protected AutoAnalyser.DiscreteCalcAndArguments assignCalcObjectDiscrete() throws Exception {
        int n;
        int n2;
        String string;
        try {
            string = (String)this.propertyValues.get(DISCRETE_PROPNAME_TIME_DIFF);
            n2 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage());
            this.resultsLabel.setText("Cannot find a value for property time difference");
            return null;
        }
        try {
            string = (String)this.propertyValues.get("base");
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage());
            this.resultsLabel.setText("Cannot find a value for property base");
            return null;
        }
        return new AutoAnalyser.DiscreteCalcAndArguments(new MutualInformationCalculatorDiscrete(n, n2), n, n + ", " + n2);
    }

    public static void main(String[] stringArray) {
        new AutoAnalyserMI();
    }
}

