/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.continuous.kraskov;

import infodynamics.measures.continuous.kraskov.MutualInfoCalculatorMultiVariateKraskov;
import infodynamics.utils.MathsUtils;
import infodynamics.utils.NeighbourNodeData;
import java.util.Calendar;
import java.util.PriorityQueue;

public class MutualInfoCalculatorMultiVariateKraskov2
extends MutualInfoCalculatorMultiVariateKraskov {
    public MutualInfoCalculatorMultiVariateKraskov2() {
        this.isAlgorithm1 = false;
    }

    @Override
    protected double[] partialComputeFromObservations(int n, int n2, boolean bl) throws Exception {
        double d = Calendar.getInstance().getTimeInMillis();
        double[] dArray = null;
        if (bl) {
            dArray = new double[n2];
        }
        double d2 = 1.0 / (double)this.k;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = n; i < n + n2; ++i) {
            int n3;
            PriorityQueue<NeighbourNodeData> priorityQueue = this.kdTreeJoint.findKNearestNeighbours(this.k, i, this.dynCorrExclTime);
            double d6 = 0.0;
            double d7 = 0.0;
            for (n3 = 0; n3 < this.k; ++n3) {
                NeighbourNodeData neighbourNodeData = priorityQueue.poll();
                if (neighbourNodeData.norms[0] > d6) {
                    d6 = neighbourNodeData.norms[0];
                }
                if (!(neighbourNodeData.norms[1] > d7)) continue;
                d7 = neighbourNodeData.norms[1];
            }
            n3 = this.nnSearcherSource.countPointsWithinOrOnR(i, d6, this.dynCorrExclTime);
            int n4 = this.nnSearcherDest.countPointsWithinOrOnR(i, d7, this.dynCorrExclTime);
            d4 += (double)n3;
            d5 += (double)n4;
            double d8 = MathsUtils.digamma(n3);
            double d9 = MathsUtils.digamma(n4);
            d3 += d8 + d9;
            if (!bl) continue;
            dArray[i - n] = this.digammaK - d2 - d8 - d9 + this.digammaN;
        }
        if (this.debug) {
            Calendar calendar = Calendar.getInstance();
            long l = calendar.getTimeInMillis();
            System.out.println("Subset " + n + ":" + (n + n2) + " Calculation time: " + ((double)l - d) / 1000.0 + " sec");
        }
        if (bl) {
            return dArray;
        }
        return new double[]{d3, d4, d5};
    }
}

