/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.discrete;

import infodynamics.measures.discrete.InfoMeasureCalculatorDiscrete;
import infodynamics.utils.AnalyticMeasurementDistribution;
import infodynamics.utils.AnalyticNullDistributionComputer;
import infodynamics.utils.ChiSquareMeasurementDistribution;
import infodynamics.utils.EmpiricalMeasurementDistribution;
import infodynamics.utils.EmpiricalNullDistributionComputer;
import infodynamics.utils.MatrixUtils;
import infodynamics.utils.RandomGenerator;

public class ConditionalMutualInformationCalculatorDiscrete
extends InfoMeasureCalculatorDiscrete
implements EmpiricalNullDistributionComputer,
AnalyticNullDistributionComputer {
    protected int base1;
    protected int base2;
    protected int condBase;
    protected int[][][] firstSecondCondCount = null;
    protected int[][] firstCondCount = null;
    protected int[][] secondCondCount = null;
    protected int[] condCount = null;
    protected boolean condMiComputed = false;

    public static ConditionalMutualInformationCalculatorDiscrete newInstance(int n, int n2, int n3) {
        return new ConditionalMutualInformationCalculatorDiscrete(n, n2, n3);
    }

    public ConditionalMutualInformationCalculatorDiscrete(int n, int n2, int n3) {
        super(n);
        this.base1 = n;
        this.base2 = n2;
        this.condBase = n3;
        this.firstSecondCondCount = new int[n][n2][n3];
        this.firstCondCount = new int[n][n3];
        this.secondCondCount = new int[n2][n3];
        this.condCount = new int[n3];
    }

    @Override
    public void initialise() {
        super.initialise();
        this.condMiComputed = false;
        MatrixUtils.fill(this.firstSecondCondCount, 0);
        MatrixUtils.fill(this.firstCondCount, 0);
        MatrixUtils.fill(this.secondCondCount, 0);
        MatrixUtils.fill(this.condCount, 0);
    }

    public void addObservations(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = nArray.length;
        this.observations += n;
        for (int i = 0; i < n; ++i) {
            int[] nArray4 = this.firstSecondCondCount[nArray[i]][nArray2[i]];
            int n2 = nArray3[i];
            nArray4[n2] = nArray4[n2] + 1;
            int[] nArray5 = this.firstCondCount[nArray[i]];
            int n3 = nArray3[i];
            nArray5[n3] = nArray5[n3] + 1;
            int[] nArray6 = this.secondCondCount[nArray2[i]];
            int n4 = nArray3[i];
            nArray6[n4] = nArray6[n4] + 1;
            int n5 = nArray3[i];
            this.condCount[n5] = this.condCount[n5] + 1;
        }
    }

    public void addObservations(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n = byArray.length;
        this.observations += n;
        for (int i = 0; i < n; ++i) {
            int[] nArray = this.firstSecondCondCount[byArray[i]][byArray2[i]];
            byte by = byArray3[i];
            nArray[by] = nArray[by] + 1;
            int[] nArray2 = this.firstCondCount[byArray[i]];
            byte by2 = byArray3[i];
            nArray2[by2] = nArray2[by2] + 1;
            int[] nArray3 = this.secondCondCount[byArray2[i]];
            byte by3 = byArray3[i];
            nArray3[by3] = nArray3[by3] + 1;
            byte by4 = byArray3[i];
            this.condCount[by4] = this.condCount[by4] + 1;
        }
    }

    public void addObservations(int[] nArray, int[] nArray2, int[] nArray3, boolean[] blArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (!blArray[i]) continue;
            int[] nArray4 = this.firstSecondCondCount[nArray[i]][nArray2[i]];
            int n2 = nArray3[i];
            nArray4[n2] = nArray4[n2] + 1;
            int[] nArray5 = this.firstCondCount[nArray[i]];
            int n3 = nArray3[i];
            nArray5[n3] = nArray5[n3] + 1;
            int[] nArray6 = this.secondCondCount[nArray2[i]];
            int n4 = nArray3[i];
            nArray6[n4] = nArray6[n4] + 1;
            int n5 = nArray3[i];
            this.condCount[n5] = this.condCount[n5] + 1;
            ++this.observations;
        }
    }

    public void addObservations(byte[] byArray, byte[] byArray2, byte[] byArray3, boolean[] blArray) {
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            if (!blArray[i]) continue;
            int[] nArray = this.firstSecondCondCount[byArray[i]][byArray2[i]];
            byte by = byArray3[i];
            nArray[by] = nArray[by] + 1;
            int[] nArray2 = this.firstCondCount[byArray[i]];
            byte by2 = byArray3[i];
            nArray2[by2] = nArray2[by2] + 1;
            int[] nArray3 = this.secondCondCount[byArray2[i]];
            byte by3 = byArray3[i];
            nArray3[by3] = nArray3[by3] + 1;
            byte by4 = byArray3[i];
            this.condCount[by4] = this.condCount[by4] + 1;
            ++this.observations;
        }
    }

    public void addObservations(int[][] nArray, int[][] nArray2, int[][] nArray3) {
        int n = nArray.length;
        int n2 = nArray[0].length;
        this.observations += n * n2;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int[] nArray4 = this.firstSecondCondCount[nArray[i][j]][nArray2[i][j]];
                int n3 = nArray3[i][j];
                nArray4[n3] = nArray4[n3] + 1;
                int[] nArray5 = this.firstCondCount[nArray[i][j]];
                int n4 = nArray3[i][j];
                nArray5[n4] = nArray5[n4] + 1;
                int[] nArray6 = this.secondCondCount[nArray2[i][j]];
                int n5 = nArray3[i][j];
                nArray6[n5] = nArray6[n5] + 1;
                int n6 = nArray3[i][j];
                this.condCount[n6] = this.condCount[n6] + 1;
            }
        }
    }

    @Override
    public double computeAverageLocalOfObservations() {
        double d = 0.0;
        double d2 = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.condBase; ++i) {
            for (int j = 0; j < this.base2; ++j) {
                for (int k = 0; k < this.base1; ++k) {
                    double d4 = (double)this.firstSecondCondCount[k][j][i] / (double)this.observations;
                    if (this.firstSecondCondCount[k][j][i] != 0) {
                        double d5 = (double)this.firstSecondCondCount[k][j][i] / (double)this.firstCondCount[k][i] / ((double)this.secondCondCount[j][i] / (double)this.condCount[i]);
                        double d6 = Math.log(d5) / this.log_2;
                        d2 = d4 * d6;
                        if (d6 > this.max) {
                            this.max = d6;
                        } else if (d6 < this.min) {
                            this.min = d6;
                        }
                        d3 += d2 * d6;
                    } else {
                        d2 = 0.0;
                    }
                    d += d2;
                }
            }
        }
        this.average = d;
        this.std = Math.sqrt(d3 - this.average * this.average);
        this.condMiComputed = true;
        return d;
    }

    public void debugPrintObservations() {
        System.out.println("Var1\tVar2\tCond\tc(1,2,c)\tc(1,c)\tc(2,c)\tc(c)");
        for (int i = 0; i < this.condBase; ++i) {
            for (int j = 0; j < this.base2; ++j) {
                for (int k = 0; k < this.base1; ++k) {
                    System.out.println(k + "\t" + j + "\t" + i + "\t" + this.firstSecondCondCount[k][j][i] + "\t\t" + this.firstCondCount[k][i] + "\t" + this.secondCondCount[j][i] + "\t" + this.condCount[i]);
                }
            }
        }
    }

    public double[] computeLocalFromPreviousObservations(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = nArray.length;
        double[] dArray = new double[n];
        this.average = 0.0;
        this.max = 0.0;
        this.min = 0.0;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            int n3 = nArray2[i];
            int n4 = nArray3[i];
            double d = (double)this.firstSecondCondCount[n2][n3][n4] / (double)this.firstCondCount[n2][n4] / ((double)this.secondCondCount[n3][n4] / (double)this.condCount[n4]);
            dArray[i] = Math.log(d) / this.log_2;
            this.average += dArray[i];
            if (dArray[i] > this.max) {
                this.max = dArray[i];
                continue;
            }
            if (!(dArray[i] < this.min)) continue;
            this.min = dArray[i];
        }
        this.average /= (double)n;
        this.condMiComputed = true;
        return dArray;
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int n) {
        RandomGenerator randomGenerator = new RandomGenerator();
        int[][] nArray = randomGenerator.generateRandomPerturbations(this.observations, n);
        return this.computeSignificance(nArray);
    }

    @Override
    public EmpiricalMeasurementDistribution computeSignificance(int[][] nArray) {
        int n;
        int n2;
        double d = this.computeAverageLocalOfObservations();
        int n3 = nArray.length;
        int[] nArray2 = new int[this.observations];
        int[] nArray3 = new int[this.observations];
        int[] nArray4 = new int[this.observations];
        int n4 = 0;
        for (int i = 0; i < this.base1; ++i) {
            for (n2 = 0; n2 < this.base2; ++n2) {
                for (int j = 0; j < this.condBase; ++j) {
                    n = this.firstSecondCondCount[i][n2][j];
                    MatrixUtils.fill(nArray2, i, n4, n);
                    MatrixUtils.fill(nArray3, n2, n4, n);
                    MatrixUtils.fill(nArray4, j, n4, n);
                    n4 += n;
                }
            }
        }
        ConditionalMutualInformationCalculatorDiscrete conditionalMutualInformationCalculatorDiscrete = new ConditionalMutualInformationCalculatorDiscrete(this.base1, this.base2, this.condBase);
        conditionalMutualInformationCalculatorDiscrete.initialise();
        conditionalMutualInformationCalculatorDiscrete.observations = this.observations;
        conditionalMutualInformationCalculatorDiscrete.secondCondCount = this.secondCondCount;
        conditionalMutualInformationCalculatorDiscrete.condCount = this.condCount;
        n2 = 0;
        EmpiricalMeasurementDistribution empiricalMeasurementDistribution = new EmpiricalMeasurementDistribution(n3);
        for (n = 0; n < n3; ++n) {
            double d2;
            int[] nArray5 = MatrixUtils.extractSelectedTimePoints(nArray2, nArray[n]);
            MatrixUtils.fill(conditionalMutualInformationCalculatorDiscrete.firstCondCount, 0);
            MatrixUtils.fill(conditionalMutualInformationCalculatorDiscrete.firstSecondCondCount, 0);
            for (int i = 0; i < this.observations; ++i) {
                int[] nArray6 = conditionalMutualInformationCalculatorDiscrete.firstCondCount[nArray5[i]];
                int n5 = nArray4[i];
                nArray6[n5] = nArray6[n5] + 1;
                int[] nArray7 = conditionalMutualInformationCalculatorDiscrete.firstSecondCondCount[nArray5[i]][nArray3[i]];
                int n6 = nArray4[i];
                nArray7[n6] = nArray7[n6] + 1;
            }
            empiricalMeasurementDistribution.distribution[n] = d2 = conditionalMutualInformationCalculatorDiscrete.computeAverageLocalOfObservations();
            if (!(d2 >= d)) continue;
            ++n2;
        }
        empiricalMeasurementDistribution.pValue = (double)n2 / (double)n3;
        empiricalMeasurementDistribution.actualValue = d;
        return empiricalMeasurementDistribution;
    }

    @Override
    public AnalyticMeasurementDistribution computeSignificance() {
        if (!this.condMiComputed) {
            this.computeAverageLocalOfObservations();
        }
        return new ChiSquareMeasurementDistribution(this.average, this.observations, (this.base1 - 1) * (this.base2 - 1) * this.condBase);
    }

    public double[] computeLocal(int[] nArray, int[] nArray2, int[] nArray3) {
        this.initialise();
        this.addObservations(nArray, nArray2, nArray3);
        return this.computeLocalFromPreviousObservations(nArray, nArray2, nArray3);
    }

    public double computeAverageLocal(int[] nArray, int[] nArray2, int[] nArray3) {
        this.initialise();
        this.addObservations(nArray, nArray2, nArray3);
        return this.computeAverageLocalOfObservations();
    }
}

