/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.measures.discrete;

import infodynamics.measures.discrete.InfoMeasureCalculatorDiscrete;
import infodynamics.utils.MathsUtils;
import infodynamics.utils.MatrixUtils;

public abstract class ContextOfPastMeasureCalculatorDiscrete
extends InfoMeasureCalculatorDiscrete {
    protected int k = 0;
    protected boolean noObservationStorage = false;
    protected int[][] nextPastCount = null;
    protected int[] pastCount = null;
    protected int[] nextCount = null;
    protected int[] maxShiftedValue = null;
    protected int base_power_k = 0;

    public ContextOfPastMeasureCalculatorDiscrete(int n, int n2) {
        this(n, n2, false);
    }

    protected ContextOfPastMeasureCalculatorDiscrete(int n, int n2, boolean bl) {
        super(n);
        this.k = n2;
        this.base_power_k = MathsUtils.power(n, this.k);
        if ((double)this.k > Math.log(2.147483647E9) / this.log_base) {
            throw new RuntimeException("Base and history combination too large");
        }
        this.maxShiftedValue = new int[n];
        for (int i = 0; i < n; ++i) {
            this.maxShiftedValue[i] = i * MathsUtils.power(n, this.k - 1);
        }
        this.noObservationStorage = bl;
        if (!bl) {
            this.nextPastCount = new int[n][this.base_power_k];
            this.pastCount = new int[this.base_power_k];
            this.nextCount = new int[n];
        }
    }

    @Override
    public void initialise() {
        super.initialise();
        if (!this.noObservationStorage) {
            MatrixUtils.fill(this.nextPastCount, 0);
            MatrixUtils.fill(this.pastCount, 0);
            MatrixUtils.fill(this.nextCount, 0);
        }
    }

    public int computePastValue(int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < this.k; ++i) {
            n2 *= this.base;
            n2 += nArray[n - this.k + 1 + i];
        }
        return n2;
    }

    public int computePastValue(int[][] nArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.k; ++i) {
            n3 *= this.base;
            n3 += nArray[n2 - this.k + 1 + i][n];
        }
        return n3;
    }

    public int computePastValue(int[][][] nArray, int n, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < this.k; ++i) {
            n4 *= this.base;
            n4 += nArray[n3 - this.k + 1 + i][n][n2];
        }
        return n4;
    }
}

