/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.utils;

public class EuclideanUtils {
    public static int MAX_TIMESTEPS_FOR_FAST_DISTANCE = 2000;
    public static final int NORM_EUCLIDEAN = 0;
    public static final String NORM_EUCLIDEAN_STRING = "EUCLIDEAN";
    public static final int NORM_EUCLIDEAN_NORMALISED = 1;
    public static final String NORM_EUCLIDEAN_NORMALISED_STRING = "EUCLIDEAN_NORMALISED";
    public static final int NORM_MAX_NORM = 2;
    public static final String NORM_MAX_NORM_STRING = "MAX_NORM";
    public static final int NORM_EUCLIDEAN_SQUARED = 3;
    public static final String NORM_EUCLIDEAN_SQUARED_STRING = "EUCLIDEAN_SQUARED";
    private int normToUse = 0;

    public EuclideanUtils(int n) {
        this.setNormToUse(n);
    }

    public EuclideanUtils(String string) {
        this.setNormToUse(string);
    }

    public static double[] computeMinEuclideanDistances(double[][] dArray) {
        if (dArray.length <= MAX_TIMESTEPS_FOR_FAST_DISTANCE) {
            return EuclideanUtils.computeMinEuclideanDistancesFast(dArray);
        }
        return EuclideanUtils.computeMinEuclideanDistancesNaive(dArray);
    }

    public static double[] computeMinEuclideanDistancesNaive(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = Double.POSITIVE_INFINITY;
            for (int j = 0; j < n; ++j) {
                double d2;
                if (i == j) continue;
                double d3 = 0.0;
                for (int k = 0; k < n2 && d3 < d; d3 += d2 * d2, ++k) {
                    d2 = dArray[i][k] - dArray[j][k];
                }
                if (!((d3 = Math.sqrt(d3)) < d)) continue;
                d = d3;
            }
            dArray2[i] = d;
        }
        return dArray2;
    }

    public static double[] computeMinEuclideanDistancesFast(double[][] dArray) {
        int n = dArray[0].length;
        int n2 = dArray.length;
        double[][] dArray2 = new double[n2][n2];
        int[][] nArray = new int[n2][n2];
        double[] dArray3 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            double d;
            int n3;
            double d2 = Double.POSITIVE_INFINITY;
            for (n3 = 0; n3 < i; ++n3) {
                if (nArray[n3][i] != n) continue;
                dArray2[i][n3] = dArray2[n3][i];
                nArray[i][n3] = n;
                if (!(dArray2[i][n3] < d2)) continue;
                d2 = dArray2[i][n3];
            }
            for (n3 = 0; n3 < i; ++n3) {
                if (nArray[n3][i] == n) continue;
                nArray[i][n3] = nArray[n3][i];
                dArray2[i][n3] = dArray2[n3][i];
                while (dArray2[i][n3] < d2 && nArray[i][n3] < n) {
                    d = dArray[i][nArray[i][n3]] - dArray[n3][nArray[i][n3]];
                    double[] dArray4 = dArray2[i];
                    int n4 = n3;
                    dArray4[n4] = dArray4[n4] + d * d;
                    int[] nArray2 = nArray[i];
                    int n5 = n3;
                    nArray2[n5] = nArray2[n5] + 1;
                }
                if (!(dArray2[i][n3] < d2)) continue;
                d2 = dArray2[i][n3];
            }
            for (n3 = i + 1; n3 < n2; ++n3) {
                while (dArray2[i][n3] < d2 && nArray[i][n3] < n) {
                    d = dArray[i][nArray[i][n3]] - dArray[n3][nArray[i][n3]];
                    double[] dArray5 = dArray2[i];
                    int n6 = n3;
                    dArray5[n6] = dArray5[n6] + d * d;
                    int[] nArray3 = nArray[i];
                    int n7 = n3;
                    nArray3[n7] = nArray3[n7] + 1;
                }
                if (!(dArray2[i][n3] < d2)) continue;
                d2 = dArray2[i][n3];
            }
            dArray3[i] = Math.sqrt(d2);
        }
        return dArray3;
    }

    public double maxJointSpaceNorm(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        return Math.max(this.norm(dArray, dArray3), this.norm(dArray2, dArray4));
    }

    public double norm(double[] dArray, double[] dArray2) {
        switch (this.normToUse) {
            case 1: {
                return EuclideanUtils.euclideanNorm(dArray, dArray2) / Math.sqrt(dArray.length);
            }
            case 2: {
                return EuclideanUtils.maxNorm(dArray, dArray2);
            }
            case 3: {
                return EuclideanUtils.euclideanNormSquared(dArray, dArray2);
            }
        }
        return EuclideanUtils.euclideanNorm(dArray, dArray2);
    }

    public double normWithAbort(double[] dArray, double[] dArray2, double d) {
        switch (this.normToUse) {
            case 1: {
                return EuclideanUtils.euclideanNormWithAbort(dArray, dArray2, d) / Math.sqrt(dArray.length);
            }
            case 2: {
                return EuclideanUtils.maxNormWithAbort(dArray, dArray2, d);
            }
            case 3: {
                return EuclideanUtils.euclideanNormSquaredWithAbort(dArray, dArray2, d);
            }
        }
        return EuclideanUtils.euclideanNormWithAbort(dArray, dArray2, d);
    }

    public static double euclideanNorm(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = dArray[i] - dArray2[i];
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }

    public static double euclideanNormWithAbort(double[] dArray, double[] dArray2, double d) {
        double d2 = 0.0;
        d *= d;
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = dArray[i] - dArray2[i];
            if (!((d2 += d3 * d3) > d)) continue;
            return Double.POSITIVE_INFINITY;
        }
        return Math.sqrt(d2);
    }

    public static double euclideanNormSquared(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = dArray[i] - dArray2[i];
            d += d2 * d2;
        }
        return d;
    }

    public static double euclideanNormSquaredWithAbort(double[] dArray, double[] dArray2, double d) {
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = dArray[i] - dArray2[i];
            if (!((d2 += d3 * d3) > d)) continue;
            return Double.POSITIVE_INFINITY;
        }
        return d2;
    }

    public static double maxNorm(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = dArray[i] - dArray2[i];
            if (d2 < 0.0) {
                d2 = -d2;
            }
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static double maxNormWithAbort(double[] dArray, double[] dArray2, double d) {
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = dArray[i] - dArray2[i];
            if (d3 < 0.0) {
                d3 = -d3;
            }
            if (!(d3 > d2)) continue;
            if (d3 > d) {
                return Double.POSITIVE_INFINITY;
            }
            d2 = d3;
        }
        return d2;
    }

    public double[][] computeNorms(double[][] dArray, double[][] dArray2, int n) {
        int n2 = dArray.length;
        double[][] dArray3 = new double[n2][2];
        for (int i = 0; i < n2; ++i) {
            if (i == n) {
                dArray3[i][0] = Double.POSITIVE_INFINITY;
                dArray3[i][1] = Double.POSITIVE_INFINITY;
                continue;
            }
            dArray3[i][0] = this.norm(dArray[n], dArray[i]);
            dArray3[i][1] = this.norm(dArray2[n], dArray2[i]);
        }
        return dArray3;
    }

    public double[][] computeNorms(double[][] dArray, double[][] dArray2, double[][] dArray3, int n) {
        int n2 = dArray.length;
        double[][] dArray4 = new double[n2][3];
        for (int i = 0; i < n2; ++i) {
            if (i == n) {
                dArray4[i][0] = Double.POSITIVE_INFINITY;
                dArray4[i][1] = Double.POSITIVE_INFINITY;
                dArray4[i][2] = Double.POSITIVE_INFINITY;
                continue;
            }
            dArray4[i][0] = this.norm(dArray[n], dArray[i]);
            dArray4[i][1] = this.norm(dArray2[n], dArray2[i]);
            dArray4[i][2] = this.norm(dArray3[n], dArray3[i]);
        }
        return dArray4;
    }

    public static double[][] computeNorms(double[][] dArray, int n) {
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        double[][] dArray2 = new double[n2][n3];
        for (int i = 0; i < n2; ++i) {
            int n4;
            if (i == n) {
                for (n4 = 0; n4 < n3; ++n4) {
                    dArray2[i][n4] = Double.POSITIVE_INFINITY;
                }
                continue;
            }
            for (n4 = 0; n4 < n3; ++n4) {
                dArray2[i][n4] = Math.abs(dArray[n][n4] - dArray[i][n4]);
            }
        }
        return dArray2;
    }

    public void setNormToUse(int n) {
        this.normToUse = n;
    }

    public void setNormToUse(String string) {
        this.normToUse = string.equalsIgnoreCase(NORM_EUCLIDEAN_NORMALISED_STRING) ? 1 : (string.equalsIgnoreCase(NORM_MAX_NORM_STRING) ? 2 : (string.equalsIgnoreCase(NORM_EUCLIDEAN_SQUARED_STRING) ? 3 : 0));
    }

    public int getNormInUse() {
        return this.normToUse;
    }

    public String getNormInUseString() {
        switch (this.normToUse) {
            case 1: {
                return NORM_EUCLIDEAN_NORMALISED_STRING;
            }
            case 2: {
                return NORM_MAX_NORM_STRING;
            }
            case 3: {
                return NORM_EUCLIDEAN_SQUARED_STRING;
            }
        }
        return NORM_EUCLIDEAN_STRING;
    }
}

