/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.utils.commonsmath3.distribution;

import infodynamics.utils.commonsmath3.distribution.AbstractRealDistribution;
import infodynamics.utils.commonsmath3.distribution.GammaDistribution;
import infodynamics.utils.commonsmath3.random.RandomGenerator;
import infodynamics.utils.commonsmath3.random.Well19937c;

public class ChiSquaredDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = -8352658048349159782L;
    private final GammaDistribution gamma;
    private final double solverAbsoluteAccuracy;

    public ChiSquaredDistribution(double d) {
        this(d, 1.0E-9);
    }

    public ChiSquaredDistribution(double d, double d2) {
        this(new Well19937c(), d, d2);
    }

    public ChiSquaredDistribution(RandomGenerator randomGenerator, double d) {
        this(randomGenerator, d, 1.0E-9);
    }

    public ChiSquaredDistribution(RandomGenerator randomGenerator, double d, double d2) {
        super(randomGenerator);
        this.gamma = new GammaDistribution(d / 2.0, 2.0);
        this.solverAbsoluteAccuracy = d2;
    }

    public double getDegreesOfFreedom() {
        return this.gamma.getShape() * 2.0;
    }

    @Override
    public double density(double d) {
        return this.gamma.density(d);
    }

    @Override
    public double logDensity(double d) {
        return this.gamma.logDensity(d);
    }

    @Override
    public double cumulativeProbability(double d) {
        return this.gamma.cumulativeProbability(d);
    }

    @Override
    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    @Override
    public double getNumericalMean() {
        return this.getDegreesOfFreedom();
    }

    @Override
    public double getNumericalVariance() {
        return 2.0 * this.getDegreesOfFreedom();
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    @Override
    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

