/*
 * Decompiled with CFR 0.152.
 */
package infodynamics.utils.commonsmath3.distribution;

import infodynamics.utils.commonsmath3.distribution.AbstractIntegerDistribution;
import infodynamics.utils.commonsmath3.distribution.ExponentialDistribution;
import infodynamics.utils.commonsmath3.distribution.NormalDistribution;
import infodynamics.utils.commonsmath3.distribution.SaddlePointExpansion;
import infodynamics.utils.commonsmath3.exception.NotStrictlyPositiveException;
import infodynamics.utils.commonsmath3.exception.util.Localizable;
import infodynamics.utils.commonsmath3.exception.util.LocalizedFormats;
import infodynamics.utils.commonsmath3.random.RandomGenerator;
import infodynamics.utils.commonsmath3.random.Well19937c;
import infodynamics.utils.commonsmath3.special.Gamma;
import infodynamics.utils.commonsmath3.util.CombinatoricsUtils;
import infodynamics.utils.commonsmath3.util.FastMath;

public class PoissonDistribution
extends AbstractIntegerDistribution {
    public static final int DEFAULT_MAX_ITERATIONS = 10000000;
    public static final double DEFAULT_EPSILON = 1.0E-12;
    private static final long serialVersionUID = -3349935121172596109L;
    private final NormalDistribution normal;
    private final ExponentialDistribution exponential;
    private final double mean;
    private final int maxIterations;
    private final double epsilon;

    public PoissonDistribution(double d) throws NotStrictlyPositiveException {
        this(d, 1.0E-12, 10000000);
    }

    public PoissonDistribution(double d, double d2, int n) throws NotStrictlyPositiveException {
        this(new Well19937c(), d, d2, n);
    }

    public PoissonDistribution(RandomGenerator randomGenerator, double d, double d2, int n) throws NotStrictlyPositiveException {
        super(randomGenerator);
        if (d <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.MEAN, d);
        }
        this.mean = d;
        this.epsilon = d2;
        this.maxIterations = n;
        this.normal = new NormalDistribution(randomGenerator, d, FastMath.sqrt(d), 1.0E-9);
        this.exponential = new ExponentialDistribution(randomGenerator, 1.0, 1.0E-9);
    }

    public PoissonDistribution(double d, double d2) throws NotStrictlyPositiveException {
        this(d, d2, 10000000);
    }

    public PoissonDistribution(double d, int n) {
        this(d, 1.0E-12, n);
    }

    public double getMean() {
        return this.mean;
    }

    @Override
    public double probability(int n) {
        double d = this.logProbability(n);
        return d == Double.NEGATIVE_INFINITY ? 0.0 : FastMath.exp(d);
    }

    @Override
    public double logProbability(int n) {
        double d = n < 0 || n == Integer.MAX_VALUE ? Double.NEGATIVE_INFINITY : (n == 0 ? -this.mean : -SaddlePointExpansion.getStirlingError(n) - SaddlePointExpansion.getDeviancePart(n, this.mean) - 0.5 * FastMath.log(Math.PI * 2) - 0.5 * FastMath.log(n));
        return d;
    }

    @Override
    public double cumulativeProbability(int n) {
        if (n < 0) {
            return 0.0;
        }
        if (n == Integer.MAX_VALUE) {
            return 1.0;
        }
        return Gamma.regularizedGammaQ((double)n + 1.0, this.mean, this.epsilon, this.maxIterations);
    }

    public double normalApproximateProbability(int n) {
        return this.normal.cumulativeProbability((double)n + 0.5);
    }

    @Override
    public double getNumericalMean() {
        return this.getMean();
    }

    @Override
    public double getNumericalVariance() {
        return this.getMean();
    }

    @Override
    public int getSupportLowerBound() {
        return 0;
    }

    @Override
    public int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public int sample() {
        return (int)FastMath.min(this.nextPoisson(this.mean), Integer.MAX_VALUE);
    }

    private long nextPoisson(double d) {
        double d2;
        long l;
        block9: {
            if (d < 40.0) {
                double d3 = FastMath.exp(-d);
                long l2 = 0L;
                double d4 = 1.0;
                double d5 = 1.0;
                while ((double)l2 < 1000.0 * d) {
                    d5 = this.random.nextDouble();
                    if ((d4 *= d5) >= d3) {
                        ++l2;
                        continue;
                    }
                    return l2;
                }
                return l2;
            }
            double d6 = FastMath.floor(d);
            double d7 = d - d6;
            double d8 = FastMath.log(d6);
            double d9 = CombinatoricsUtils.factorialLog((int)d6);
            l = d7 < Double.MIN_VALUE ? 0L : this.nextPoisson(d7);
            double d10 = FastMath.sqrt(d6 * FastMath.log(32.0 * d6 / Math.PI + 1.0));
            double d11 = d10 / 2.0;
            double d12 = 2.0 * d6 + d10;
            double d13 = FastMath.sqrt(Math.PI * d12) * FastMath.exp(1.0 / (8.0 * d6));
            double d14 = d12 / d10 * FastMath.exp(-d10 * (1.0 + d10) / d12);
            double d15 = d13 + d14 + 1.0;
            double d16 = d13 / d15;
            double d17 = d14 / d15;
            double d18 = 1.0 / (8.0 * d6);
            double d19 = 0.0;
            d2 = 0.0;
            double d20 = 0.0;
            boolean bl = false;
            double d21 = 0.0;
            double d22 = 0.0;
            double d23 = 0.0;
            while (true) {
                double d24;
                if ((d24 = this.random.nextDouble()) <= d16) {
                    double d25 = this.random.nextGaussian();
                    d19 = d25 * FastMath.sqrt(d6 + d11) - 0.5;
                    if (d19 > d10 || d19 < -d6) continue;
                    d2 = d19 < 0.0 ? FastMath.floor(d19) : FastMath.ceil(d19);
                    double d26 = this.exponential.sample();
                    d20 = -d26 - d25 * d25 / 2.0 + d18;
                } else {
                    if (d24 > d16 + d17) {
                        d2 = d6;
                        break block9;
                    }
                    d19 = d10 + d12 / d10 * this.exponential.sample();
                    d2 = FastMath.ceil(d19);
                    d20 = -this.exponential.sample() - d10 * (d19 + 1.0) / d12;
                }
                bl = d19 < 0.0;
                d21 = d2 * (d2 + 1.0) / (2.0 * d6);
                if (d20 < -d21 && !bl) {
                    d2 = d6 + d2;
                    break block9;
                }
                d22 = d21 * ((2.0 * d2 + 1.0) / (6.0 * d6) - 1.0);
                d23 = d22 - d21 * d21 / (3.0 * (d6 + (double)bl * (d2 + 1.0)));
                if (d20 < d23) {
                    d2 = d6 + d2;
                    break block9;
                }
                if (!(d20 > d22) && d20 < d2 * d8 - CombinatoricsUtils.factorialLog((int)(d2 + d6)) + d9) break;
            }
            d2 = d6 + d2;
        }
        return l + (long)d2;
    }
}

